# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterPlacementGroupArgs', 'ClusterPlacementGroup']

@pulumi.input_type
class ClusterPlacementGroupArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[builtins.str],
                 cluster_placement_group_type: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 description: pulumi.Input[builtins.str],
                 capabilities: Optional[pulumi.Input['ClusterPlacementGroupCapabilitiesArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 placement_instruction: Optional[pulumi.Input['ClusterPlacementGroupPlacementInstructionArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ClusterPlacementGroup resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain where you want to create the cluster placement group.
        :param pulumi.Input[builtins.str] cluster_placement_group_type: ClusterPlacementGroup Identifier.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the cluster placement group.
        :param pulumi.Input[builtins.str] description: (Updatable) A description of the cluster placement group.
        :param pulumi.Input['ClusterPlacementGroupCapabilitiesArgs'] capabilities: A list of resources that you can create in a cluster placement group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] name: The friendly name of the cluster placement group.
        :param pulumi.Input[builtins.bool] opc_dry_run: When set to `true`, the request performs validation on the submitted data without modifying configuration item details.
        :param pulumi.Input['ClusterPlacementGroupPlacementInstructionArgs'] placement_instruction: Details that inform cluster placement group provisioning.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Cluster Placement Group. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "cluster_placement_group_type", cluster_placement_group_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "description", description)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if placement_instruction is not None:
            pulumi.set(__self__, "placement_instruction", placement_instruction)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[builtins.str]:
        """
        The availability domain where you want to create the cluster placement group.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupType")
    def cluster_placement_group_type(self) -> pulumi.Input[builtins.str]:
        """
        ClusterPlacementGroup Identifier.
        """
        return pulumi.get(self, "cluster_placement_group_type")

    @cluster_placement_group_type.setter
    def cluster_placement_group_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cluster_placement_group_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the cluster placement group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A description of the cluster placement group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['ClusterPlacementGroupCapabilitiesArgs']]:
        """
        A list of resources that you can create in a cluster placement group.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['ClusterPlacementGroupCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The friendly name of the cluster placement group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to `true`, the request performs validation on the submitted data without modifying configuration item details.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "opc_dry_run", value)

    @property
    @pulumi.getter(name="placementInstruction")
    def placement_instruction(self) -> Optional[pulumi.Input['ClusterPlacementGroupPlacementInstructionArgs']]:
        """
        Details that inform cluster placement group provisioning.
        """
        return pulumi.get(self, "placement_instruction")

    @placement_instruction.setter
    def placement_instruction(self, value: Optional[pulumi.Input['ClusterPlacementGroupPlacementInstructionArgs']]):
        pulumi.set(self, "placement_instruction", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the Cluster Placement Group. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _ClusterPlacementGroupState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 capabilities: Optional[pulumi.Input['ClusterPlacementGroupCapabilitiesArgs']] = None,
                 cluster_placement_group_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 placement_instruction: Optional[pulumi.Input['ClusterPlacementGroupPlacementInstructionArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ClusterPlacementGroup resources.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain where you want to create the cluster placement group.
        :param pulumi.Input['ClusterPlacementGroupCapabilitiesArgs'] capabilities: A list of resources that you can create in a cluster placement group.
        :param pulumi.Input[builtins.str] cluster_placement_group_type: ClusterPlacementGroup Identifier.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the cluster placement group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A description of the cluster placement group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.
        :param pulumi.Input[builtins.str] name: The friendly name of the cluster placement group.
        :param pulumi.Input[builtins.bool] opc_dry_run: When set to `true`, the request performs validation on the submitted data without modifying configuration item details.
        :param pulumi.Input['ClusterPlacementGroupPlacementInstructionArgs'] placement_instruction: Details that inform cluster placement group provisioning.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Cluster Placement Group. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the cluster placement group was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[builtins.str] time_updated: The time the cluster placement group was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if capabilities is not None:
            pulumi.set(__self__, "capabilities", capabilities)
        if cluster_placement_group_type is not None:
            pulumi.set(__self__, "cluster_placement_group_type", cluster_placement_group_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if opc_dry_run is not None:
            pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        if placement_instruction is not None:
            pulumi.set(__self__, "placement_instruction", placement_instruction)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain where you want to create the cluster placement group.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter
    def capabilities(self) -> Optional[pulumi.Input['ClusterPlacementGroupCapabilitiesArgs']]:
        """
        A list of resources that you can create in a cluster placement group.
        """
        return pulumi.get(self, "capabilities")

    @capabilities.setter
    def capabilities(self, value: Optional[pulumi.Input['ClusterPlacementGroupCapabilitiesArgs']]):
        pulumi.set(self, "capabilities", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupType")
    def cluster_placement_group_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ClusterPlacementGroup Identifier.
        """
        return pulumi.get(self, "cluster_placement_group_type")

    @cluster_placement_group_type.setter
    def cluster_placement_group_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the cluster placement group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A description of the cluster placement group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The friendly name of the cluster placement group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        When set to `true`, the request performs validation on the submitted data without modifying configuration item details.
        """
        return pulumi.get(self, "opc_dry_run")

    @opc_dry_run.setter
    def opc_dry_run(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "opc_dry_run", value)

    @property
    @pulumi.getter(name="placementInstruction")
    def placement_instruction(self) -> Optional[pulumi.Input['ClusterPlacementGroupPlacementInstructionArgs']]:
        """
        Details that inform cluster placement group provisioning.
        """
        return pulumi.get(self, "placement_instruction")

    @placement_instruction.setter
    def placement_instruction(self, value: Optional[pulumi.Input['ClusterPlacementGroupPlacementInstructionArgs']]):
        pulumi.set(self, "placement_instruction", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the Cluster Placement Group. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the cluster placement group was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the cluster placement group was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class ClusterPlacementGroup(pulumi.CustomResource):

    pulumi_type = "oci:ClusterPlacementGroups/clusterPlacementGroup:ClusterPlacementGroup"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 capabilities: Optional[pulumi.Input[Union['ClusterPlacementGroupCapabilitiesArgs', 'ClusterPlacementGroupCapabilitiesArgsDict']]] = None,
                 cluster_placement_group_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 placement_instruction: Optional[pulumi.Input[Union['ClusterPlacementGroupPlacementInstructionArgs', 'ClusterPlacementGroupPlacementInstructionArgsDict']]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Cluster Placement Group resource in Oracle Cloud Infrastructure Cluster Placement Groups service.

        Creates a new cluster placement group in the specified compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cluster_placement_group = oci.cluster_placement_groups.ClusterPlacementGroup("test_cluster_placement_group",
            availability_domain=cluster_placement_group_availability_domain,
            cluster_placement_group_type=cluster_placement_group_cluster_placement_group_type,
            compartment_id=compartment_id,
            description=cluster_placement_group_description,
            name=cluster_placement_group_name,
            capabilities={
                "items": [{
                    "name": cluster_placement_group_capabilities_items_name,
                    "service": cluster_placement_group_capabilities_items_service,
                }],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            opc_dry_run=cluster_placement_group_opc_dry_run,
            placement_instruction={
                "type": cluster_placement_group_placement_instruction_type,
                "value": cluster_placement_group_placement_instruction_value,
            })
        ```

        ## Import

        ClusterPlacementGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ClusterPlacementGroups/clusterPlacementGroup:ClusterPlacementGroup test_cluster_placement_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain where you want to create the cluster placement group.
        :param pulumi.Input[Union['ClusterPlacementGroupCapabilitiesArgs', 'ClusterPlacementGroupCapabilitiesArgsDict']] capabilities: A list of resources that you can create in a cluster placement group.
        :param pulumi.Input[builtins.str] cluster_placement_group_type: ClusterPlacementGroup Identifier.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the cluster placement group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A description of the cluster placement group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] name: The friendly name of the cluster placement group.
        :param pulumi.Input[builtins.bool] opc_dry_run: When set to `true`, the request performs validation on the submitted data without modifying configuration item details.
        :param pulumi.Input[Union['ClusterPlacementGroupPlacementInstructionArgs', 'ClusterPlacementGroupPlacementInstructionArgsDict']] placement_instruction: Details that inform cluster placement group provisioning.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Cluster Placement Group. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterPlacementGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cluster Placement Group resource in Oracle Cloud Infrastructure Cluster Placement Groups service.

        Creates a new cluster placement group in the specified compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cluster_placement_group = oci.cluster_placement_groups.ClusterPlacementGroup("test_cluster_placement_group",
            availability_domain=cluster_placement_group_availability_domain,
            cluster_placement_group_type=cluster_placement_group_cluster_placement_group_type,
            compartment_id=compartment_id,
            description=cluster_placement_group_description,
            name=cluster_placement_group_name,
            capabilities={
                "items": [{
                    "name": cluster_placement_group_capabilities_items_name,
                    "service": cluster_placement_group_capabilities_items_service,
                }],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            opc_dry_run=cluster_placement_group_opc_dry_run,
            placement_instruction={
                "type": cluster_placement_group_placement_instruction_type,
                "value": cluster_placement_group_placement_instruction_value,
            })
        ```

        ## Import

        ClusterPlacementGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ClusterPlacementGroups/clusterPlacementGroup:ClusterPlacementGroup test_cluster_placement_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param ClusterPlacementGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterPlacementGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 capabilities: Optional[pulumi.Input[Union['ClusterPlacementGroupCapabilitiesArgs', 'ClusterPlacementGroupCapabilitiesArgsDict']]] = None,
                 cluster_placement_group_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
                 placement_instruction: Optional[pulumi.Input[Union['ClusterPlacementGroupPlacementInstructionArgs', 'ClusterPlacementGroupPlacementInstructionArgsDict']]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterPlacementGroupArgs.__new__(ClusterPlacementGroupArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["capabilities"] = capabilities
            if cluster_placement_group_type is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_placement_group_type'")
            __props__.__dict__["cluster_placement_group_type"] = cluster_placement_group_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["name"] = name
            __props__.__dict__["opc_dry_run"] = opc_dry_run
            __props__.__dict__["placement_instruction"] = placement_instruction
            __props__.__dict__["state"] = state
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(ClusterPlacementGroup, __self__).__init__(
            'oci:ClusterPlacementGroups/clusterPlacementGroup:ClusterPlacementGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            capabilities: Optional[pulumi.Input[Union['ClusterPlacementGroupCapabilitiesArgs', 'ClusterPlacementGroupCapabilitiesArgsDict']]] = None,
            cluster_placement_group_type: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            opc_dry_run: Optional[pulumi.Input[builtins.bool]] = None,
            placement_instruction: Optional[pulumi.Input[Union['ClusterPlacementGroupPlacementInstructionArgs', 'ClusterPlacementGroupPlacementInstructionArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'ClusterPlacementGroup':
        """
        Get an existing ClusterPlacementGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain where you want to create the cluster placement group.
        :param pulumi.Input[Union['ClusterPlacementGroupCapabilitiesArgs', 'ClusterPlacementGroupCapabilitiesArgsDict']] capabilities: A list of resources that you can create in a cluster placement group.
        :param pulumi.Input[builtins.str] cluster_placement_group_type: ClusterPlacementGroup Identifier.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the cluster placement group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A description of the cluster placement group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.
        :param pulumi.Input[builtins.str] name: The friendly name of the cluster placement group.
        :param pulumi.Input[builtins.bool] opc_dry_run: When set to `true`, the request performs validation on the submitted data without modifying configuration item details.
        :param pulumi.Input[Union['ClusterPlacementGroupPlacementInstructionArgs', 'ClusterPlacementGroupPlacementInstructionArgsDict']] placement_instruction: Details that inform cluster placement group provisioning.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the Cluster Placement Group. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the cluster placement group was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[builtins.str] time_updated: The time the cluster placement group was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterPlacementGroupState.__new__(_ClusterPlacementGroupState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["capabilities"] = capabilities
        __props__.__dict__["cluster_placement_group_type"] = cluster_placement_group_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["name"] = name
        __props__.__dict__["opc_dry_run"] = opc_dry_run
        __props__.__dict__["placement_instruction"] = placement_instruction
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return ClusterPlacementGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The availability domain where you want to create the cluster placement group.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def capabilities(self) -> pulumi.Output['outputs.ClusterPlacementGroupCapabilities']:
        """
        A list of resources that you can create in a cluster placement group.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="clusterPlacementGroupType")
    def cluster_placement_group_type(self) -> pulumi.Output[builtins.str]:
        """
        ClusterPlacementGroup Identifier.
        """
        return pulumi.get(self, "cluster_placement_group_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want to create the cluster placement group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A description of the cluster placement group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, lifecycle details for a resource in a Failed state might include information to act on.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The friendly name of the cluster placement group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> pulumi.Output[builtins.bool]:
        """
        When set to `true`, the request performs validation on the submitted data without modifying configuration item details.
        """
        return pulumi.get(self, "opc_dry_run")

    @property
    @pulumi.getter(name="placementInstruction")
    def placement_instruction(self) -> pulumi.Output['outputs.ClusterPlacementGroupPlacementInstruction']:
        """
        Details that inform cluster placement group provisioning.
        """
        return pulumi.get(self, "placement_instruction")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The target state for the Cluster Placement Group. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the cluster placement group was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the cluster placement group was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

