# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AtCustomerCccInfrastructureArgs', 'AtCustomerCccInfrastructure']

@pulumi.input_type
class AtCustomerCccInfrastructureArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 subnet_id: pulumi.Input[builtins.str],
                 ccc_upgrade_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_details: Optional[pulumi.Input[builtins.str]] = None,
                 connection_state: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a AtCustomerCccInfrastructure resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the infrastructure.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name that will be used to display the Compute Cloud@Customer infrastructure in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) Identifier for network subnet that will be used to communicate with Compute Cloud@Customer infrastructure.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] ccc_upgrade_schedule_id: (Updatable) Schedule used for upgrades. If no schedule is associated with the infrastructure, it can be upgraded at any time.
        :param pulumi.Input[builtins.str] connection_details: (Updatable) A message describing the current connection state in more detail.
        :param pulumi.Input[builtins.str] connection_state: (Updatable) The current connection state of the Compute Cloud@Customer infrastructure. This value will default to REJECT if the value is not provided. The only valid value at creation time is REJECT.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ccc_upgrade_schedule_id is not None:
            pulumi.set(__self__, "ccc_upgrade_schedule_id", ccc_upgrade_schedule_id)
        if connection_details is not None:
            pulumi.set(__self__, "connection_details", connection_details)
        if connection_state is not None:
            pulumi.set(__self__, "connection_state", connection_state)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the infrastructure.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The name that will be used to display the Compute Cloud@Customer infrastructure in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Identifier for network subnet that will be used to communicate with Compute Cloud@Customer infrastructure.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="cccUpgradeScheduleId")
    def ccc_upgrade_schedule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Schedule used for upgrades. If no schedule is associated with the infrastructure, it can be upgraded at any time.
        """
        return pulumi.get(self, "ccc_upgrade_schedule_id")

    @ccc_upgrade_schedule_id.setter
    def ccc_upgrade_schedule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ccc_upgrade_schedule_id", value)

    @property
    @pulumi.getter(name="connectionDetails")
    def connection_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A message describing the current connection state in more detail.
        """
        return pulumi.get(self, "connection_details")

    @connection_details.setter
    def connection_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_details", value)

    @property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The current connection state of the Compute Cloud@Customer infrastructure. This value will default to REJECT if the value is not provided. The only valid value at creation time is REJECT.
        """
        return pulumi.get(self, "connection_state")

    @connection_state.setter
    def connection_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_state", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AtCustomerCccInfrastructureState:
    def __init__(__self__, *,
                 ccc_upgrade_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_details: Optional[pulumi.Input[builtins.str]] = None,
                 connection_state: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 infrastructure_inventories: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureInventoryArgs']]]] = None,
                 infrastructure_network_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs']]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 provisioning_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
                 provisioning_pin: Optional[pulumi.Input[builtins.str]] = None,
                 short_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_informations: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureUpgradeInformationArgs']]]] = None):
        """
        Input properties used for looking up and filtering AtCustomerCccInfrastructure resources.
        :param pulumi.Input[builtins.str] ccc_upgrade_schedule_id: (Updatable) Schedule used for upgrades. If no schedule is associated with the infrastructure, it can be upgraded at any time.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the infrastructure.
        :param pulumi.Input[builtins.str] connection_details: (Updatable) A message describing the current connection state in more detail.
        :param pulumi.Input[builtins.str] connection_state: (Updatable) The current connection state of the Compute Cloud@Customer infrastructure. This value will default to REJECT if the value is not provided. The only valid value at creation time is REJECT.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name that will be used to display the Compute Cloud@Customer infrastructure in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureInventoryArgs']]] infrastructure_inventories: Inventory for a Compute Cloud@Customer infrastructure. This information cannot be updated and is from the infrastructure. The information will only be available after the connectionState is transitioned to CONNECTED.
        :param pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs']]] infrastructure_network_configurations: Configuration information for the Compute Cloud@Customer infrastructure. This  network configuration information cannot be updated and is retrieved from the data center. The information will only be available after the connectionState is transitioned to CONNECTED.
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current lifecycle state in more detail. For example, this can be used to provide actionable information for a resource that is in a Failed state.
        :param pulumi.Input[builtins.str] provisioning_fingerprint: Fingerprint of a Compute Cloud@Customer infrastructure in a data center generated during the initial connection to this resource. The fingerprint should be verified by the administrator when changing the connectionState from REQUEST to READY.
        :param pulumi.Input[builtins.str] provisioning_pin: Code that is required for service personnel to connect a Compute Cloud@Customer infrastructure in a data center to this resource. This code will only be available when the connectionState is REJECT (usually at create time of the Compute Cloud@Customer infrastructure).
        :param pulumi.Input[builtins.str] short_name: The Compute Cloud@Customer infrastructure short name. This cannot be changed once created. The short name is used to refer to the infrastructure in several contexts and is unique.
        :param pulumi.Input[builtins.str] state: The current state of the Compute Cloud@Customer infrastructure.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) Identifier for network subnet that will be used to communicate with Compute Cloud@Customer infrastructure.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: Compute Cloud@Customer infrastructure creation date and time, using an RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: Compute Cloud@Customer infrastructure updated date and time, using an RFC3339 formatted datetime string.
        :param pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureUpgradeInformationArgs']]] upgrade_informations: Upgrade information that relates to a Compute Cloud@Customer infrastructure. This information cannot be updated.
        """
        if ccc_upgrade_schedule_id is not None:
            pulumi.set(__self__, "ccc_upgrade_schedule_id", ccc_upgrade_schedule_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_details is not None:
            pulumi.set(__self__, "connection_details", connection_details)
        if connection_state is not None:
            pulumi.set(__self__, "connection_state", connection_state)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if infrastructure_inventories is not None:
            pulumi.set(__self__, "infrastructure_inventories", infrastructure_inventories)
        if infrastructure_network_configurations is not None:
            pulumi.set(__self__, "infrastructure_network_configurations", infrastructure_network_configurations)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if provisioning_fingerprint is not None:
            pulumi.set(__self__, "provisioning_fingerprint", provisioning_fingerprint)
        if provisioning_pin is not None:
            pulumi.set(__self__, "provisioning_pin", provisioning_pin)
        if short_name is not None:
            pulumi.set(__self__, "short_name", short_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if upgrade_informations is not None:
            pulumi.set(__self__, "upgrade_informations", upgrade_informations)

    @property
    @pulumi.getter(name="cccUpgradeScheduleId")
    def ccc_upgrade_schedule_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Schedule used for upgrades. If no schedule is associated with the infrastructure, it can be upgraded at any time.
        """
        return pulumi.get(self, "ccc_upgrade_schedule_id")

    @ccc_upgrade_schedule_id.setter
    def ccc_upgrade_schedule_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ccc_upgrade_schedule_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the infrastructure.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionDetails")
    def connection_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A message describing the current connection state in more detail.
        """
        return pulumi.get(self, "connection_details")

    @connection_details.setter
    def connection_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_details", value)

    @property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The current connection state of the Compute Cloud@Customer infrastructure. This value will default to REJECT if the value is not provided. The only valid value at creation time is REJECT.
        """
        return pulumi.get(self, "connection_state")

    @connection_state.setter
    def connection_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_state", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name that will be used to display the Compute Cloud@Customer infrastructure in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="infrastructureInventories")
    def infrastructure_inventories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureInventoryArgs']]]]:
        """
        Inventory for a Compute Cloud@Customer infrastructure. This information cannot be updated and is from the infrastructure. The information will only be available after the connectionState is transitioned to CONNECTED.
        """
        return pulumi.get(self, "infrastructure_inventories")

    @infrastructure_inventories.setter
    def infrastructure_inventories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureInventoryArgs']]]]):
        pulumi.set(self, "infrastructure_inventories", value)

    @property
    @pulumi.getter(name="infrastructureNetworkConfigurations")
    def infrastructure_network_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs']]]]:
        """
        Configuration information for the Compute Cloud@Customer infrastructure. This  network configuration information cannot be updated and is retrieved from the data center. The information will only be available after the connectionState is transitioned to CONNECTED.
        """
        return pulumi.get(self, "infrastructure_network_configurations")

    @infrastructure_network_configurations.setter
    def infrastructure_network_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs']]]]):
        pulumi.set(self, "infrastructure_network_configurations", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current lifecycle state in more detail. For example, this can be used to provide actionable information for a resource that is in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="provisioningFingerprint")
    def provisioning_fingerprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Fingerprint of a Compute Cloud@Customer infrastructure in a data center generated during the initial connection to this resource. The fingerprint should be verified by the administrator when changing the connectionState from REQUEST to READY.
        """
        return pulumi.get(self, "provisioning_fingerprint")

    @provisioning_fingerprint.setter
    def provisioning_fingerprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioning_fingerprint", value)

    @property
    @pulumi.getter(name="provisioningPin")
    def provisioning_pin(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Code that is required for service personnel to connect a Compute Cloud@Customer infrastructure in a data center to this resource. This code will only be available when the connectionState is REJECT (usually at create time of the Compute Cloud@Customer infrastructure).
        """
        return pulumi.get(self, "provisioning_pin")

    @provisioning_pin.setter
    def provisioning_pin(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "provisioning_pin", value)

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Compute Cloud@Customer infrastructure short name. This cannot be changed once created. The short name is used to refer to the infrastructure in several contexts and is unique.
        """
        return pulumi.get(self, "short_name")

    @short_name.setter
    def short_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "short_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Compute Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier for network subnet that will be used to communicate with Compute Cloud@Customer infrastructure.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Compute Cloud@Customer infrastructure creation date and time, using an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Compute Cloud@Customer infrastructure updated date and time, using an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="upgradeInformations")
    def upgrade_informations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureUpgradeInformationArgs']]]]:
        """
        Upgrade information that relates to a Compute Cloud@Customer infrastructure. This information cannot be updated.
        """
        return pulumi.get(self, "upgrade_informations")

    @upgrade_informations.setter
    def upgrade_informations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AtCustomerCccInfrastructureUpgradeInformationArgs']]]]):
        pulumi.set(self, "upgrade_informations", value)


class AtCustomerCccInfrastructure(pulumi.CustomResource):

    pulumi_type = "oci:ComputeCloud/atCustomerCccInfrastructure:AtCustomerCccInfrastructure"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ccc_upgrade_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_details: Optional[pulumi.Input[builtins.str]] = None,
                 connection_state: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Ccc Infrastructure resource in Oracle Cloud Infrastructure Compute Cloud At Customer service.

        Creates a Compute Cloud@Customer infrastructure. Once created, Oracle Services
        must connect the rack in the data center to this Oracle Cloud Infrastructure resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ccc_infrastructure = oci.compute_cloud.AtCustomerCccInfrastructure("test_ccc_infrastructure",
            compartment_id=compartment_id,
            display_name=ccc_infrastructure_display_name,
            subnet_id=test_subnet["id"],
            ccc_upgrade_schedule_id=test_ccc_upgrade_schedule["id"],
            connection_details=ccc_infrastructure_connection_details,
            connection_state=ccc_infrastructure_connection_state,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=ccc_infrastructure_description,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        CccInfrastructures can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ComputeCloud/atCustomerCccInfrastructure:AtCustomerCccInfrastructure test_ccc_infrastructure "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ccc_upgrade_schedule_id: (Updatable) Schedule used for upgrades. If no schedule is associated with the infrastructure, it can be upgraded at any time.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the infrastructure.
        :param pulumi.Input[builtins.str] connection_details: (Updatable) A message describing the current connection state in more detail.
        :param pulumi.Input[builtins.str] connection_state: (Updatable) The current connection state of the Compute Cloud@Customer infrastructure. This value will default to REJECT if the value is not provided. The only valid value at creation time is REJECT.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name that will be used to display the Compute Cloud@Customer infrastructure in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) Identifier for network subnet that will be used to communicate with Compute Cloud@Customer infrastructure.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AtCustomerCccInfrastructureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Ccc Infrastructure resource in Oracle Cloud Infrastructure Compute Cloud At Customer service.

        Creates a Compute Cloud@Customer infrastructure. Once created, Oracle Services
        must connect the rack in the data center to this Oracle Cloud Infrastructure resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ccc_infrastructure = oci.compute_cloud.AtCustomerCccInfrastructure("test_ccc_infrastructure",
            compartment_id=compartment_id,
            display_name=ccc_infrastructure_display_name,
            subnet_id=test_subnet["id"],
            ccc_upgrade_schedule_id=test_ccc_upgrade_schedule["id"],
            connection_details=ccc_infrastructure_connection_details,
            connection_state=ccc_infrastructure_connection_state,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=ccc_infrastructure_description,
            freeform_tags={
                "bar-key": "value",
            })
        ```

        ## Import

        CccInfrastructures can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ComputeCloud/atCustomerCccInfrastructure:AtCustomerCccInfrastructure test_ccc_infrastructure "id"
        ```

        :param str resource_name: The name of the resource.
        :param AtCustomerCccInfrastructureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AtCustomerCccInfrastructureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ccc_upgrade_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_details: Optional[pulumi.Input[builtins.str]] = None,
                 connection_state: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AtCustomerCccInfrastructureArgs.__new__(AtCustomerCccInfrastructureArgs)

            __props__.__dict__["ccc_upgrade_schedule_id"] = ccc_upgrade_schedule_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connection_details"] = connection_details
            __props__.__dict__["connection_state"] = connection_state
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["infrastructure_inventories"] = None
            __props__.__dict__["infrastructure_network_configurations"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["provisioning_fingerprint"] = None
            __props__.__dict__["provisioning_pin"] = None
            __props__.__dict__["short_name"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["upgrade_informations"] = None
        super(AtCustomerCccInfrastructure, __self__).__init__(
            'oci:ComputeCloud/atCustomerCccInfrastructure:AtCustomerCccInfrastructure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ccc_upgrade_schedule_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            connection_details: Optional[pulumi.Input[builtins.str]] = None,
            connection_state: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            infrastructure_inventories: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AtCustomerCccInfrastructureInfrastructureInventoryArgs', 'AtCustomerCccInfrastructureInfrastructureInventoryArgsDict']]]]] = None,
            infrastructure_network_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs', 'AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgsDict']]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            provisioning_fingerprint: Optional[pulumi.Input[builtins.str]] = None,
            provisioning_pin: Optional[pulumi.Input[builtins.str]] = None,
            short_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            upgrade_informations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AtCustomerCccInfrastructureUpgradeInformationArgs', 'AtCustomerCccInfrastructureUpgradeInformationArgsDict']]]]] = None) -> 'AtCustomerCccInfrastructure':
        """
        Get an existing AtCustomerCccInfrastructure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] ccc_upgrade_schedule_id: (Updatable) Schedule used for upgrades. If no schedule is associated with the infrastructure, it can be upgraded at any time.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the infrastructure.
        :param pulumi.Input[builtins.str] connection_details: (Updatable) A message describing the current connection state in more detail.
        :param pulumi.Input[builtins.str] connection_state: (Updatable) The current connection state of the Compute Cloud@Customer infrastructure. This value will default to REJECT if the value is not provided. The only valid value at creation time is REJECT.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The name that will be used to display the Compute Cloud@Customer infrastructure in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['AtCustomerCccInfrastructureInfrastructureInventoryArgs', 'AtCustomerCccInfrastructureInfrastructureInventoryArgsDict']]]] infrastructure_inventories: Inventory for a Compute Cloud@Customer infrastructure. This information cannot be updated and is from the infrastructure. The information will only be available after the connectionState is transitioned to CONNECTED.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgs', 'AtCustomerCccInfrastructureInfrastructureNetworkConfigurationArgsDict']]]] infrastructure_network_configurations: Configuration information for the Compute Cloud@Customer infrastructure. This  network configuration information cannot be updated and is retrieved from the data center. The information will only be available after the connectionState is transitioned to CONNECTED.
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current lifecycle state in more detail. For example, this can be used to provide actionable information for a resource that is in a Failed state.
        :param pulumi.Input[builtins.str] provisioning_fingerprint: Fingerprint of a Compute Cloud@Customer infrastructure in a data center generated during the initial connection to this resource. The fingerprint should be verified by the administrator when changing the connectionState from REQUEST to READY.
        :param pulumi.Input[builtins.str] provisioning_pin: Code that is required for service personnel to connect a Compute Cloud@Customer infrastructure in a data center to this resource. This code will only be available when the connectionState is REJECT (usually at create time of the Compute Cloud@Customer infrastructure).
        :param pulumi.Input[builtins.str] short_name: The Compute Cloud@Customer infrastructure short name. This cannot be changed once created. The short name is used to refer to the infrastructure in several contexts and is unique.
        :param pulumi.Input[builtins.str] state: The current state of the Compute Cloud@Customer infrastructure.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) Identifier for network subnet that will be used to communicate with Compute Cloud@Customer infrastructure.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: Compute Cloud@Customer infrastructure creation date and time, using an RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: Compute Cloud@Customer infrastructure updated date and time, using an RFC3339 formatted datetime string.
        :param pulumi.Input[Sequence[pulumi.Input[Union['AtCustomerCccInfrastructureUpgradeInformationArgs', 'AtCustomerCccInfrastructureUpgradeInformationArgsDict']]]] upgrade_informations: Upgrade information that relates to a Compute Cloud@Customer infrastructure. This information cannot be updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AtCustomerCccInfrastructureState.__new__(_AtCustomerCccInfrastructureState)

        __props__.__dict__["ccc_upgrade_schedule_id"] = ccc_upgrade_schedule_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_details"] = connection_details
        __props__.__dict__["connection_state"] = connection_state
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["infrastructure_inventories"] = infrastructure_inventories
        __props__.__dict__["infrastructure_network_configurations"] = infrastructure_network_configurations
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["provisioning_fingerprint"] = provisioning_fingerprint
        __props__.__dict__["provisioning_pin"] = provisioning_pin
        __props__.__dict__["short_name"] = short_name
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["upgrade_informations"] = upgrade_informations
        return AtCustomerCccInfrastructure(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cccUpgradeScheduleId")
    def ccc_upgrade_schedule_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Schedule used for upgrades. If no schedule is associated with the infrastructure, it can be upgraded at any time.
        """
        return pulumi.get(self, "ccc_upgrade_schedule_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with the infrastructure.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionDetails")
    def connection_details(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A message describing the current connection state in more detail.
        """
        return pulumi.get(self, "connection_details")

    @property
    @pulumi.getter(name="connectionState")
    def connection_state(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The current connection state of the Compute Cloud@Customer infrastructure. This value will default to REJECT if the value is not provided. The only valid value at creation time is REJECT.
        """
        return pulumi.get(self, "connection_state")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A mutable client-meaningful text description of the Compute Cloud@Customer infrastructure. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The name that will be used to display the Compute Cloud@Customer infrastructure in the Oracle Cloud Infrastructure console. Does not have to be unique and can be changed. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="infrastructureInventories")
    def infrastructure_inventories(self) -> pulumi.Output[Sequence['outputs.AtCustomerCccInfrastructureInfrastructureInventory']]:
        """
        Inventory for a Compute Cloud@Customer infrastructure. This information cannot be updated and is from the infrastructure. The information will only be available after the connectionState is transitioned to CONNECTED.
        """
        return pulumi.get(self, "infrastructure_inventories")

    @property
    @pulumi.getter(name="infrastructureNetworkConfigurations")
    def infrastructure_network_configurations(self) -> pulumi.Output[Sequence['outputs.AtCustomerCccInfrastructureInfrastructureNetworkConfiguration']]:
        """
        Configuration information for the Compute Cloud@Customer infrastructure. This  network configuration information cannot be updated and is retrieved from the data center. The information will only be available after the connectionState is transitioned to CONNECTED.
        """
        return pulumi.get(self, "infrastructure_network_configurations")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current lifecycle state in more detail. For example, this can be used to provide actionable information for a resource that is in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="provisioningFingerprint")
    def provisioning_fingerprint(self) -> pulumi.Output[builtins.str]:
        """
        Fingerprint of a Compute Cloud@Customer infrastructure in a data center generated during the initial connection to this resource. The fingerprint should be verified by the administrator when changing the connectionState from REQUEST to READY.
        """
        return pulumi.get(self, "provisioning_fingerprint")

    @property
    @pulumi.getter(name="provisioningPin")
    def provisioning_pin(self) -> pulumi.Output[builtins.str]:
        """
        Code that is required for service personnel to connect a Compute Cloud@Customer infrastructure in a data center to this resource. This code will only be available when the connectionState is REJECT (usually at create time of the Compute Cloud@Customer infrastructure).
        """
        return pulumi.get(self, "provisioning_pin")

    @property
    @pulumi.getter(name="shortName")
    def short_name(self) -> pulumi.Output[builtins.str]:
        """
        The Compute Cloud@Customer infrastructure short name. This cannot be changed once created. The short name is used to refer to the infrastructure in several contexts and is unique.
        """
        return pulumi.get(self, "short_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Compute Cloud@Customer infrastructure.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Identifier for network subnet that will be used to communicate with Compute Cloud@Customer infrastructure.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        Compute Cloud@Customer infrastructure creation date and time, using an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        Compute Cloud@Customer infrastructure updated date and time, using an RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeInformations")
    def upgrade_informations(self) -> pulumi.Output[Sequence['outputs.AtCustomerCccInfrastructureUpgradeInformation']]:
        """
        Upgrade information that relates to a Compute Cloud@Customer infrastructure. This information cannot be updated.
        """
        return pulumi.get(self, "upgrade_informations")

