# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DrgRouteDistributionStatementArgs', 'DrgRouteDistributionStatement']

@pulumi.input_type
class DrgRouteDistributionStatementArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[builtins.str],
                 drg_route_distribution_id: pulumi.Input[builtins.str],
                 match_criteria: pulumi.Input['DrgRouteDistributionStatementMatchCriteriaArgs'],
                 priority: pulumi.Input[builtins.int]):
        """
        The set of arguments for constructing a DrgRouteDistributionStatement resource.
        :param pulumi.Input[builtins.str] action: Accept: import/export the route "as is"
        :param pulumi.Input[builtins.str] drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
        :param pulumi.Input['DrgRouteDistributionStatementMatchCriteriaArgs'] match_criteria: (Updatable) The action is applied only if all of the match criteria are met. MATCH_ALL match type implies any input is considered a match.
        :param pulumi.Input[builtins.int] priority: (Updatable) This field is used to specify the priority of each statement in a route distribution. The priority will be represented as a number between 0 and 65535 where a lower number indicates a higher priority. When a route is processed, statements are applied in the order defined by their priority. The first matching rule dictates the action that will be taken on the route. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "drg_route_distribution_id", drg_route_distribution_id)
        pulumi.set(__self__, "match_criteria", match_criteria)
        pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[builtins.str]:
        """
        Accept: import/export the route "as is"
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="drgRouteDistributionId")
    def drg_route_distribution_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
        """
        return pulumi.get(self, "drg_route_distribution_id")

    @drg_route_distribution_id.setter
    def drg_route_distribution_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "drg_route_distribution_id", value)

    @property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> pulumi.Input['DrgRouteDistributionStatementMatchCriteriaArgs']:
        """
        (Updatable) The action is applied only if all of the match criteria are met. MATCH_ALL match type implies any input is considered a match.
        """
        return pulumi.get(self, "match_criteria")

    @match_criteria.setter
    def match_criteria(self, value: pulumi.Input['DrgRouteDistributionStatementMatchCriteriaArgs']):
        pulumi.set(self, "match_criteria", value)

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) This field is used to specify the priority of each statement in a route distribution. The priority will be represented as a number between 0 and 65535 where a lower number indicates a higher priority. When a route is processed, statements are applied in the order defined by their priority. The first matching rule dictates the action that will be taken on the route. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "priority", value)


@pulumi.input_type
class _DrgRouteDistributionStatementState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 match_criteria: Optional[pulumi.Input['DrgRouteDistributionStatementMatchCriteriaArgs']] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering DrgRouteDistributionStatement resources.
        :param pulumi.Input[builtins.str] action: Accept: import/export the route "as is"
        :param pulumi.Input[builtins.str] drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
        :param pulumi.Input['DrgRouteDistributionStatementMatchCriteriaArgs'] match_criteria: (Updatable) The action is applied only if all of the match criteria are met. MATCH_ALL match type implies any input is considered a match.
        :param pulumi.Input[builtins.int] priority: (Updatable) This field is used to specify the priority of each statement in a route distribution. The priority will be represented as a number between 0 and 65535 where a lower number indicates a higher priority. When a route is processed, statements are applied in the order defined by their priority. The first matching rule dictates the action that will be taken on the route. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if drg_route_distribution_id is not None:
            pulumi.set(__self__, "drg_route_distribution_id", drg_route_distribution_id)
        if match_criteria is not None:
            pulumi.set(__self__, "match_criteria", match_criteria)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Accept: import/export the route "as is"
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="drgRouteDistributionId")
    def drg_route_distribution_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
        """
        return pulumi.get(self, "drg_route_distribution_id")

    @drg_route_distribution_id.setter
    def drg_route_distribution_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "drg_route_distribution_id", value)

    @property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> Optional[pulumi.Input['DrgRouteDistributionStatementMatchCriteriaArgs']]:
        """
        (Updatable) The action is applied only if all of the match criteria are met. MATCH_ALL match type implies any input is considered a match.
        """
        return pulumi.get(self, "match_criteria")

    @match_criteria.setter
    def match_criteria(self, value: Optional[pulumi.Input['DrgRouteDistributionStatementMatchCriteriaArgs']]):
        pulumi.set(self, "match_criteria", value)

    @property
    @pulumi.getter
    def priority(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) This field is used to specify the priority of each statement in a route distribution. The priority will be represented as a number between 0 and 65535 where a lower number indicates a higher priority. When a route is processed, statements are applied in the order defined by their priority. The first matching rule dictates the action that will be taken on the route. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "priority")

    @priority.setter
    def priority(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "priority", value)


class DrgRouteDistributionStatement(pulumi.CustomResource):

    pulumi_type = "oci:Core/drgRouteDistributionStatement:DrgRouteDistributionStatement"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 match_criteria: Optional[pulumi.Input[Union['DrgRouteDistributionStatementMatchCriteriaArgs', 'DrgRouteDistributionStatementMatchCriteriaArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Drg Route Distribution Statement resource in Oracle Cloud Infrastructure Core service.

        Adds one route distribution statement to the specified route distribution.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_drg_route_distribution_statement = oci.core.DrgRouteDistributionStatement("test_drg_route_distribution_statement",
            drg_route_distribution_id=test_drg_route_distribution["id"],
            action=drg_route_distribution_statement_statements_action,
            match_criteria={
                "match_type": drg_route_distribution_statement_statements_match_criteria_match_type,
                "attachment_type": drg_route_distribution_statement_statements_match_criteria_attachment_type,
                "drg_attachment_id": test_drg_attachment["id"],
            },
            priority=drg_route_distribution_statement_statements_priority)
        ```

        ## Import

        DrgRouteDistributionStatement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/drgRouteDistributionStatement:DrgRouteDistributionStatement test_drg_route_distribution_statement "drgRouteDistributions/{drgRouteDistributionId}/statements/{id}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Accept: import/export the route "as is"
        :param pulumi.Input[builtins.str] drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
        :param pulumi.Input[Union['DrgRouteDistributionStatementMatchCriteriaArgs', 'DrgRouteDistributionStatementMatchCriteriaArgsDict']] match_criteria: (Updatable) The action is applied only if all of the match criteria are met. MATCH_ALL match type implies any input is considered a match.
        :param pulumi.Input[builtins.int] priority: (Updatable) This field is used to specify the priority of each statement in a route distribution. The priority will be represented as a number between 0 and 65535 where a lower number indicates a higher priority. When a route is processed, statements are applied in the order defined by their priority. The first matching rule dictates the action that will be taken on the route. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DrgRouteDistributionStatementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Drg Route Distribution Statement resource in Oracle Cloud Infrastructure Core service.

        Adds one route distribution statement to the specified route distribution.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_drg_route_distribution_statement = oci.core.DrgRouteDistributionStatement("test_drg_route_distribution_statement",
            drg_route_distribution_id=test_drg_route_distribution["id"],
            action=drg_route_distribution_statement_statements_action,
            match_criteria={
                "match_type": drg_route_distribution_statement_statements_match_criteria_match_type,
                "attachment_type": drg_route_distribution_statement_statements_match_criteria_attachment_type,
                "drg_attachment_id": test_drg_attachment["id"],
            },
            priority=drg_route_distribution_statement_statements_priority)
        ```

        ## Import

        DrgRouteDistributionStatement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/drgRouteDistributionStatement:DrgRouteDistributionStatement test_drg_route_distribution_statement "drgRouteDistributions/{drgRouteDistributionId}/statements/{id}"
        ```

        :param str resource_name: The name of the resource.
        :param DrgRouteDistributionStatementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DrgRouteDistributionStatementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[builtins.str]] = None,
                 drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
                 match_criteria: Optional[pulumi.Input[Union['DrgRouteDistributionStatementMatchCriteriaArgs', 'DrgRouteDistributionStatementMatchCriteriaArgsDict']]] = None,
                 priority: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DrgRouteDistributionStatementArgs.__new__(DrgRouteDistributionStatementArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if drg_route_distribution_id is None and not opts.urn:
                raise TypeError("Missing required property 'drg_route_distribution_id'")
            __props__.__dict__["drg_route_distribution_id"] = drg_route_distribution_id
            if match_criteria is None and not opts.urn:
                raise TypeError("Missing required property 'match_criteria'")
            __props__.__dict__["match_criteria"] = match_criteria
            if priority is None and not opts.urn:
                raise TypeError("Missing required property 'priority'")
            __props__.__dict__["priority"] = priority
        super(DrgRouteDistributionStatement, __self__).__init__(
            'oci:Core/drgRouteDistributionStatement:DrgRouteDistributionStatement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[builtins.str]] = None,
            drg_route_distribution_id: Optional[pulumi.Input[builtins.str]] = None,
            match_criteria: Optional[pulumi.Input[Union['DrgRouteDistributionStatementMatchCriteriaArgs', 'DrgRouteDistributionStatementMatchCriteriaArgsDict']]] = None,
            priority: Optional[pulumi.Input[builtins.int]] = None) -> 'DrgRouteDistributionStatement':
        """
        Get an existing DrgRouteDistributionStatement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] action: Accept: import/export the route "as is"
        :param pulumi.Input[builtins.str] drg_route_distribution_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
        :param pulumi.Input[Union['DrgRouteDistributionStatementMatchCriteriaArgs', 'DrgRouteDistributionStatementMatchCriteriaArgsDict']] match_criteria: (Updatable) The action is applied only if all of the match criteria are met. MATCH_ALL match type implies any input is considered a match.
        :param pulumi.Input[builtins.int] priority: (Updatable) This field is used to specify the priority of each statement in a route distribution. The priority will be represented as a number between 0 and 65535 where a lower number indicates a higher priority. When a route is processed, statements are applied in the order defined by their priority. The first matching rule dictates the action that will be taken on the route. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DrgRouteDistributionStatementState.__new__(_DrgRouteDistributionStatementState)

        __props__.__dict__["action"] = action
        __props__.__dict__["drg_route_distribution_id"] = drg_route_distribution_id
        __props__.__dict__["match_criteria"] = match_criteria
        __props__.__dict__["priority"] = priority
        return DrgRouteDistributionStatement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[builtins.str]:
        """
        Accept: import/export the route "as is"
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="drgRouteDistributionId")
    def drg_route_distribution_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the route distribution.
        """
        return pulumi.get(self, "drg_route_distribution_id")

    @property
    @pulumi.getter(name="matchCriteria")
    def match_criteria(self) -> pulumi.Output['outputs.DrgRouteDistributionStatementMatchCriteria']:
        """
        (Updatable) The action is applied only if all of the match criteria are met. MATCH_ALL match type implies any input is considered a match.
        """
        return pulumi.get(self, "match_criteria")

    @property
    @pulumi.getter
    def priority(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) This field is used to specify the priority of each statement in a route distribution. The priority will be represented as a number between 0 and 65535 where a lower number indicates a higher priority. When a route is processed, statements are applied in the order defined by their priority. The first matching rule dictates the action that will be taken on the route. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "priority")

