# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 agent_config: Optional[pulumi.Input['InstanceAgentConfigArgs']] = None,
                 async_: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_config: Optional[pulumi.Input['InstanceAvailabilityConfigArgs']] = None,
                 capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_vnic_details: Optional[pulumi.Input['InstanceCreateVnicDetailsArgs']] = None,
                 dedicated_vm_host_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 extended_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fault_domain: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname_label: Optional[pulumi.Input[builtins.str]] = None,
                 image: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_options: Optional[pulumi.Input['InstanceInstanceOptionsArgs']] = None,
                 ipxe_script: Optional[pulumi.Input[builtins.str]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 launch_options: Optional[pulumi.Input['InstanceLaunchOptionsArgs']] = None,
                 launch_volume_attachments: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLaunchVolumeAttachmentArgs']]]] = None,
                 licensing_configs: Optional[pulumi.Input['InstanceLicensingConfigsArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 platform_config: Optional[pulumi.Input['InstancePlatformConfigArgs']] = None,
                 preemptible_instance_config: Optional[pulumi.Input['InstancePreemptibleInstanceConfigArgs']] = None,
                 preserve_boot_volume: Optional[pulumi.Input[builtins.bool]] = None,
                 preserve_data_volumes_created_at_launch: Optional[pulumi.Input[builtins.bool]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 shape_config: Optional[pulumi.Input['InstanceShapeConfigArgs']] = None,
                 source_details: Optional[pulumi.Input['InstanceSourceDetailsArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 update_operation_constraint: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the instance.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input['InstanceAgentConfigArgs'] agent_config: (Updatable) Configuration options for the Oracle Cloud Agent software running on the instance.
        :param pulumi.Input['InstanceAvailabilityConfigArgs'] availability_config: (Updatable) Options for VM migration during infrastructure maintenance events and for defining the availability of a VM instance after a maintenance event that impacts the underlying hardware.
        :param pulumi.Input[builtins.str] capacity_reservation_id: (Updatable) The OCID of the compute capacity reservation this instance is launched under. You can opt out of all default reservations by specifying an empty string as input for this field. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The OCID of the cluster placement group of the instance.
        :param pulumi.Input[builtins.str] compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) that the instance will be created in.
        :param pulumi.Input['InstanceCreateVnicDetailsArgs'] create_vnic_details: (Updatable) Contains properties for a VNIC. You use this object when creating the primary VNIC during instance launch or when creating a secondary VNIC. For more information about VNICs, see [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).
        :param pulumi.Input[builtins.str] dedicated_vm_host_id: (Updatable) The OCID of the dedicated virtual machine host to place the instance on.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] fault_domain: (Updatable) A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.
               
               If you do not specify the fault domain, the system selects one for you.
               
               To get a list of fault domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] hostname_label: Deprecated. Instead use `hostnameLabel` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). If you provide both, the values must match.
        :param pulumi.Input[builtins.str] image: Deprecated. Use `sourceDetails` with [InstanceSourceViaImageDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/InstanceSourceViaImageDetails) source type instead. If you specify values for both, the values must match.
        :param pulumi.Input[builtins.str] instance_configuration_id: The OCID of the Instance Configuration containing instance launch details. Any other fields supplied in this instance launch request will override the details stored in the Instance Configuration for this instance launch.
        :param pulumi.Input['InstanceInstanceOptionsArgs'] instance_options: (Updatable) Optional mutable instance options
        :param pulumi.Input[builtins.str] ipxe_script: This is an advanced option.
               
               When a bare metal or virtual machine instance boots, the iPXE firmware that runs on the instance is configured to run an iPXE script to continue the boot process.
               
               If you want more control over the boot process, you can provide your own custom iPXE script that will run when the instance boots. Be aware that the same iPXE script will run every time an instance boots, not only after the initial LaunchInstance call.
               
               The default iPXE script connects to the instance's local boot volume over iSCSI and performs a network boot. If you use a custom iPXE script and want to network-boot from the instance's local boot volume over iSCSI the same way as the default iPXE script, use the following iSCSI IP address: 169.254.0.2, and boot volume IQN: iqn.2015-02.oracle.boot.
               
               If your instance boot volume attachment type is paravirtualized, the boot volume is attached to the instance through virtio-scsi and no iPXE script is used. If your instance boot volume attachment type is paravirtualized and you use custom iPXE to network boot into your instance, the primary boot volume is attached as a data volume through virtio-scsi drive.
               
               For more information about the Bring Your Own Image feature of Oracle Cloud Infrastructure, see [Bring Your Own Image](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bringyourownimage.htm).
               
               For more information about iPXE, see http://ipxe.org.
        :param pulumi.Input[builtins.bool] is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false. Use this field only during create. To update use `is_pv_encryption_in_transit_enabled` under `launch_options` instead.
        :param pulumi.Input['InstanceLaunchOptionsArgs'] launch_options: (Updatable) Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceLaunchVolumeAttachmentArgs']]] launch_volume_attachments: Volume attachments to create as part of the launch instance operation.
               
               **Note:** This property is used for initial instance provisioning only. Updates to this property will not be supported. To update volume attachments, user should use `Core.VolumeAttachment`. To update volume details, user should use `Core.Volume`
        :param pulumi.Input['InstanceLicensingConfigsArgs'] licensing_configs: (Updatable) List of licensing configurations associated with target launch values.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: (Updatable) Custom metadata key/value pairs that you provide, such as the SSH public key required to connect to the instance.
               
               A metadata service runs on every launched instance. The service is an HTTP endpoint listening on 169.254.169.254. You can use the service to:
               * Provide information to [Cloud-Init](https://cloudinit.readthedocs.org/en/latest/) to be used for various system initialization tasks.
               * Get information about the instance, including the custom metadata that you provide when you launch the instance.
               
               **Providing Cloud-Init Metadata**
               
               You can use the following metadata key names to provide information to Cloud-Init:
               
               **"ssh_authorized_keys"** - Provide one or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on the instance. Use a newline character to separate multiple keys. The SSH keys must be in the format necessary for the `authorized_keys` file, as shown in the example below.
               
               **"user_data"** - Provide your own base64-encoded data to be used by Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For information about how to take advantage of user data, see the [Cloud-Init Documentation](http://cloudinit.readthedocs.org/en/latest/topics/format.html).
               
               **Metadata Example**
               
               ```
               "metadata" : { "quake_bot_level" : "Severe", "ssh_authorized_keys" : "ssh-rsa <your_public_SSH_key>== rsa-key-20160227", "user_data" : "<your_public_SSH_key>==" }
               ```
               
               **Getting Metadata on the Instance**
               
               To get information about your instance, connect to the instance using SSH and issue any of the following GET requests:
               
               ```
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/<any-key-name>
               ```
               
               You'll get back a response that includes all the instance information; only the metadata information; or the metadata information for the specified key name, respectively.
               
               The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of 32,000 bytes.
               
               **Note:** Both the 'user_data' and 'ssh_authorized_keys' fields cannot be changed after an instance has launched. Any request which updates, removes, or adds either of these fields will be rejected. You must provide the same values for 'user_data' and 'ssh_authorized_keys' that already exist on the instance.
        :param pulumi.Input['InstancePlatformConfigArgs'] platform_config: (Updatable only for VM's) The platform configuration requested for the instance.
               
               If you provide the parameter, the instance is created with the platform configuration that you specify. For any values that you omit, the instance uses the default configuration values for the `shape` that you specify. If you don't provide the parameter, the default values for the `shape` are used.
               
               Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
               
               For more information about shielded instances, see [Shielded Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/shielded-instances.htm).
               
               For more information about BIOS settings for bare metal instances, see [BIOS Settings for Bare Metal Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bios-settings.htm).
        :param pulumi.Input['InstancePreemptibleInstanceConfigArgs'] preemptible_instance_config: Configuration options for preemptible instances.
        :param pulumi.Input[builtins.bool] preserve_boot_volume: (Optional) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] security_attributes: (Updatable) [Security attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes) are labels for a resource that can be referenced in a [Zero Trust Packet Routing](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm) (ZPR) policy to control access to ZPR-supported resources.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
        :param pulumi.Input[builtins.str] shape: (Updatable) The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.
               
               You can enumerate all available shapes by calling [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Shape/ListShapes).
        :param pulumi.Input['InstanceShapeConfigArgs'] shape_config: (Updatable) The shape configuration requested for the instance.
               
               If the parameter is provided, the instance is created with the resources that you specify. If some properties are missing or the entire parameter is not provided, the instance is created with the default configuration values for the `shape` that you specify.
               
               Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
        :param pulumi.Input['InstanceSourceDetailsArgs'] source_details: (Updatable)
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the instance. Could be set to RUNNING or STOPPED.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] subnet_id: Deprecated. Instead use `subnetId` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). At least one of them is required; if you provide both, the values must match.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if agent_config is not None:
            pulumi.set(__self__, "agent_config", agent_config)
        if async_ is not None:
            pulumi.set(__self__, "async_", async_)
        if availability_config is not None:
            pulumi.set(__self__, "availability_config", availability_config)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compute_cluster_id is not None:
            pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if create_vnic_details is not None:
            pulumi.set(__self__, "create_vnic_details", create_vnic_details)
        if dedicated_vm_host_id is not None:
            pulumi.set(__self__, "dedicated_vm_host_id", dedicated_vm_host_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extended_metadata is not None:
            pulumi.set(__self__, "extended_metadata", extended_metadata)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            warnings.warn("""The 'hostname_label' field has been deprecated. Please use 'hostname_label under create_vnic_details' instead.""", DeprecationWarning)
            pulumi.log.warn("""hostname_label is deprecated: The 'hostname_label' field has been deprecated. Please use 'hostname_label under create_vnic_details' instead.""")
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if image is not None:
            warnings.warn("""The 'image' field has been deprecated. Please use 'source_details' instead. If both fields are specified, then 'source_details' will be used.""", DeprecationWarning)
            pulumi.log.warn("""image is deprecated: The 'image' field has been deprecated. Please use 'source_details' instead. If both fields are specified, then 'source_details' will be used.""")
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_options is not None:
            pulumi.set(__self__, "instance_options", instance_options)
        if ipxe_script is not None:
            pulumi.set(__self__, "ipxe_script", ipxe_script)
        if is_pv_encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        if launch_options is not None:
            pulumi.set(__self__, "launch_options", launch_options)
        if launch_volume_attachments is not None:
            pulumi.set(__self__, "launch_volume_attachments", launch_volume_attachments)
        if licensing_configs is not None:
            pulumi.set(__self__, "licensing_configs", licensing_configs)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if platform_config is not None:
            pulumi.set(__self__, "platform_config", platform_config)
        if preemptible_instance_config is not None:
            pulumi.set(__self__, "preemptible_instance_config", preemptible_instance_config)
        if preserve_boot_volume is not None:
            pulumi.set(__self__, "preserve_boot_volume", preserve_boot_volume)
        if preserve_data_volumes_created_at_launch is not None:
            pulumi.set(__self__, "preserve_data_volumes_created_at_launch", preserve_data_volumes_created_at_launch)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            warnings.warn("""The 'subnet_id' field has been deprecated. Please use 'subnet_id under create_vnic_details' instead.""", DeprecationWarning)
            pulumi.log.warn("""subnet_id is deprecated: The 'subnet_id' field has been deprecated. Please use 'subnet_id under create_vnic_details' instead.""")
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if update_operation_constraint is not None:
            pulumi.set(__self__, "update_operation_constraint", update_operation_constraint)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[builtins.str]:
        """
        The availability domain of the instance.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="agentConfig")
    def agent_config(self) -> Optional[pulumi.Input['InstanceAgentConfigArgs']]:
        """
        (Updatable) Configuration options for the Oracle Cloud Agent software running on the instance.
        """
        return pulumi.get(self, "agent_config")

    @agent_config.setter
    def agent_config(self, value: Optional[pulumi.Input['InstanceAgentConfigArgs']]):
        pulumi.set(self, "agent_config", value)

    @property
    @pulumi.getter(name="async")
    def async_(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "async_")

    @async_.setter
    def async_(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "async_", value)

    @property
    @pulumi.getter(name="availabilityConfig")
    def availability_config(self) -> Optional[pulumi.Input['InstanceAvailabilityConfigArgs']]:
        """
        (Updatable) Options for VM migration during infrastructure maintenance events and for defining the availability of a VM instance after a maintenance event that impacts the underlying hardware.
        """
        return pulumi.get(self, "availability_config")

    @availability_config.setter
    def availability_config(self, value: Optional[pulumi.Input['InstanceAvailabilityConfigArgs']]):
        pulumi.set(self, "availability_config", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compute capacity reservation this instance is launched under. You can opt out of all default reservations by specifying an empty string as input for this field. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cluster placement group of the instance.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) that the instance will be created in.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_cluster_id", value)

    @property
    @pulumi.getter(name="createVnicDetails")
    def create_vnic_details(self) -> Optional[pulumi.Input['InstanceCreateVnicDetailsArgs']]:
        """
        (Updatable) Contains properties for a VNIC. You use this object when creating the primary VNIC during instance launch or when creating a secondary VNIC. For more information about VNICs, see [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).
        """
        return pulumi.get(self, "create_vnic_details")

    @create_vnic_details.setter
    def create_vnic_details(self, value: Optional[pulumi.Input['InstanceCreateVnicDetailsArgs']]):
        pulumi.set(self, "create_vnic_details", value)

    @property
    @pulumi.getter(name="dedicatedVmHostId")
    def dedicated_vm_host_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the dedicated virtual machine host to place the instance on.
        """
        return pulumi.get(self, "dedicated_vm_host_id")

    @dedicated_vm_host_id.setter
    def dedicated_vm_host_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dedicated_vm_host_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "extended_metadata")

    @extended_metadata.setter
    def extended_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "extended_metadata", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.

        If you do not specify the fault domain, the system selects one for you.

        To get a list of fault domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostnameLabel")
    @_utilities.deprecated("""The 'hostname_label' field has been deprecated. Please use 'hostname_label under create_vnic_details' instead.""")
    def hostname_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated. Instead use `hostnameLabel` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). If you provide both, the values must match.
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname_label", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'image' field has been deprecated. Please use 'source_details' instead. If both fields are specified, then 'source_details' will be used.""")
    def image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated. Use `sourceDetails` with [InstanceSourceViaImageDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/InstanceSourceViaImageDetails) source type instead. If you specify values for both, the values must match.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Instance Configuration containing instance launch details. Any other fields supplied in this instance launch request will override the details stored in the Instance Configuration for this instance launch.
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="instanceOptions")
    def instance_options(self) -> Optional[pulumi.Input['InstanceInstanceOptionsArgs']]:
        """
        (Updatable) Optional mutable instance options
        """
        return pulumi.get(self, "instance_options")

    @instance_options.setter
    def instance_options(self, value: Optional[pulumi.Input['InstanceInstanceOptionsArgs']]):
        pulumi.set(self, "instance_options", value)

    @property
    @pulumi.getter(name="ipxeScript")
    def ipxe_script(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is an advanced option.

        When a bare metal or virtual machine instance boots, the iPXE firmware that runs on the instance is configured to run an iPXE script to continue the boot process.

        If you want more control over the boot process, you can provide your own custom iPXE script that will run when the instance boots. Be aware that the same iPXE script will run every time an instance boots, not only after the initial LaunchInstance call.

        The default iPXE script connects to the instance's local boot volume over iSCSI and performs a network boot. If you use a custom iPXE script and want to network-boot from the instance's local boot volume over iSCSI the same way as the default iPXE script, use the following iSCSI IP address: 169.254.0.2, and boot volume IQN: iqn.2015-02.oracle.boot.

        If your instance boot volume attachment type is paravirtualized, the boot volume is attached to the instance through virtio-scsi and no iPXE script is used. If your instance boot volume attachment type is paravirtualized and you use custom iPXE to network boot into your instance, the primary boot volume is attached as a data volume through virtio-scsi drive.

        For more information about the Bring Your Own Image feature of Oracle Cloud Infrastructure, see [Bring Your Own Image](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bringyourownimage.htm).

        For more information about iPXE, see http://ipxe.org.
        """
        return pulumi.get(self, "ipxe_script")

    @ipxe_script.setter
    def ipxe_script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipxe_script", value)

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false. Use this field only during create. To update use `is_pv_encryption_in_transit_enabled` under `launch_options` instead.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @is_pv_encryption_in_transit_enabled.setter
    def is_pv_encryption_in_transit_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_pv_encryption_in_transit_enabled", value)

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> Optional[pulumi.Input['InstanceLaunchOptionsArgs']]:
        """
        (Updatable) Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        """
        return pulumi.get(self, "launch_options")

    @launch_options.setter
    def launch_options(self, value: Optional[pulumi.Input['InstanceLaunchOptionsArgs']]):
        pulumi.set(self, "launch_options", value)

    @property
    @pulumi.getter(name="launchVolumeAttachments")
    def launch_volume_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLaunchVolumeAttachmentArgs']]]]:
        """
        Volume attachments to create as part of the launch instance operation.

        **Note:** This property is used for initial instance provisioning only. Updates to this property will not be supported. To update volume attachments, user should use `Core.VolumeAttachment`. To update volume details, user should use `Core.Volume`
        """
        return pulumi.get(self, "launch_volume_attachments")

    @launch_volume_attachments.setter
    def launch_volume_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLaunchVolumeAttachmentArgs']]]]):
        pulumi.set(self, "launch_volume_attachments", value)

    @property
    @pulumi.getter(name="licensingConfigs")
    def licensing_configs(self) -> Optional[pulumi.Input['InstanceLicensingConfigsArgs']]:
        """
        (Updatable) List of licensing configurations associated with target launch values.
        """
        return pulumi.get(self, "licensing_configs")

    @licensing_configs.setter
    def licensing_configs(self, value: Optional[pulumi.Input['InstanceLicensingConfigsArgs']]):
        pulumi.set(self, "licensing_configs", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Custom metadata key/value pairs that you provide, such as the SSH public key required to connect to the instance.

        A metadata service runs on every launched instance. The service is an HTTP endpoint listening on 169.254.169.254. You can use the service to:
        * Provide information to [Cloud-Init](https://cloudinit.readthedocs.org/en/latest/) to be used for various system initialization tasks.
        * Get information about the instance, including the custom metadata that you provide when you launch the instance.

        **Providing Cloud-Init Metadata**

        You can use the following metadata key names to provide information to Cloud-Init:

        **"ssh_authorized_keys"** - Provide one or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on the instance. Use a newline character to separate multiple keys. The SSH keys must be in the format necessary for the `authorized_keys` file, as shown in the example below.

        **"user_data"** - Provide your own base64-encoded data to be used by Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For information about how to take advantage of user data, see the [Cloud-Init Documentation](http://cloudinit.readthedocs.org/en/latest/topics/format.html).

        **Metadata Example**

        ```
        "metadata" : { "quake_bot_level" : "Severe", "ssh_authorized_keys" : "ssh-rsa <your_public_SSH_key>== rsa-key-20160227", "user_data" : "<your_public_SSH_key>==" }
        ```

        **Getting Metadata on the Instance**

        To get information about your instance, connect to the instance using SSH and issue any of the following GET requests:

        ```
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/<any-key-name>
        ```

        You'll get back a response that includes all the instance information; only the metadata information; or the metadata information for the specified key name, respectively.

        The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of 32,000 bytes.

        **Note:** Both the 'user_data' and 'ssh_authorized_keys' fields cannot be changed after an instance has launched. Any request which updates, removes, or adds either of these fields will be rejected. You must provide the same values for 'user_data' and 'ssh_authorized_keys' that already exist on the instance.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="platformConfig")
    def platform_config(self) -> Optional[pulumi.Input['InstancePlatformConfigArgs']]:
        """
        (Updatable only for VM's) The platform configuration requested for the instance.

        If you provide the parameter, the instance is created with the platform configuration that you specify. For any values that you omit, the instance uses the default configuration values for the `shape` that you specify. If you don't provide the parameter, the default values for the `shape` are used.

        Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.

        For more information about shielded instances, see [Shielded Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/shielded-instances.htm).

        For more information about BIOS settings for bare metal instances, see [BIOS Settings for Bare Metal Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bios-settings.htm).
        """
        return pulumi.get(self, "platform_config")

    @platform_config.setter
    def platform_config(self, value: Optional[pulumi.Input['InstancePlatformConfigArgs']]):
        pulumi.set(self, "platform_config", value)

    @property
    @pulumi.getter(name="preemptibleInstanceConfig")
    def preemptible_instance_config(self) -> Optional[pulumi.Input['InstancePreemptibleInstanceConfigArgs']]:
        """
        Configuration options for preemptible instances.
        """
        return pulumi.get(self, "preemptible_instance_config")

    @preemptible_instance_config.setter
    def preemptible_instance_config(self, value: Optional[pulumi.Input['InstancePreemptibleInstanceConfigArgs']]):
        pulumi.set(self, "preemptible_instance_config", value)

    @property
    @pulumi.getter(name="preserveBootVolume")
    def preserve_boot_volume(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Optional) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "preserve_boot_volume")

    @preserve_boot_volume.setter
    def preserve_boot_volume(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preserve_boot_volume", value)

    @property
    @pulumi.getter(name="preserveDataVolumesCreatedAtLaunch")
    def preserve_data_volumes_created_at_launch(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "preserve_data_volumes_created_at_launch")

    @preserve_data_volumes_created_at_launch.setter
    def preserve_data_volumes_created_at_launch(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preserve_data_volumes_created_at_launch", value)

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) [Security attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes) are labels for a resource that can be referenced in a [Zero Trust Packet Routing](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm) (ZPR) policy to control access to ZPR-supported resources.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_attributes", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.

        You can enumerate all available shapes by calling [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Shape/ListShapes).
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional[pulumi.Input['InstanceShapeConfigArgs']]:
        """
        (Updatable) The shape configuration requested for the instance.

        If the parameter is provided, the instance is created with the resources that you specify. If some properties are missing or the entire parameter is not provided, the instance is created with the default configuration values for the `shape` that you specify.

        Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
        """
        return pulumi.get(self, "shape_config")

    @shape_config.setter
    def shape_config(self, value: Optional[pulumi.Input['InstanceShapeConfigArgs']]):
        pulumi.set(self, "shape_config", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['InstanceSourceDetailsArgs']]:
        """
        (Updatable)
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['InstanceSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the instance. Could be set to RUNNING or STOPPED.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    @_utilities.deprecated("""The 'subnet_id' field has been deprecated. Please use 'subnet_id under create_vnic_details' instead.""")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated. Instead use `subnetId` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). At least one of them is required; if you provide both, the values must match.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="updateOperationConstraint")
    def update_operation_constraint(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "update_operation_constraint")

    @update_operation_constraint.setter
    def update_operation_constraint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_operation_constraint", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 agent_config: Optional[pulumi.Input['InstanceAgentConfigArgs']] = None,
                 async_: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_config: Optional[pulumi.Input['InstanceAvailabilityConfigArgs']] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 boot_volume_id: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_vnic_details: Optional[pulumi.Input['InstanceCreateVnicDetailsArgs']] = None,
                 dedicated_vm_host_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 extended_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fault_domain: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname_label: Optional[pulumi.Input[builtins.str]] = None,
                 image: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_options: Optional[pulumi.Input['InstanceInstanceOptionsArgs']] = None,
                 ipxe_script: Optional[pulumi.Input[builtins.str]] = None,
                 is_cross_numa_node: Optional[pulumi.Input[builtins.bool]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 launch_mode: Optional[pulumi.Input[builtins.str]] = None,
                 launch_options: Optional[pulumi.Input['InstanceLaunchOptionsArgs']] = None,
                 launch_volume_attachments: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLaunchVolumeAttachmentArgs']]]] = None,
                 licensing_configs: Optional[pulumi.Input['InstanceLicensingConfigsArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 platform_config: Optional[pulumi.Input['InstancePlatformConfigArgs']] = None,
                 preemptible_instance_config: Optional[pulumi.Input['InstancePreemptibleInstanceConfigArgs']] = None,
                 preserve_boot_volume: Optional[pulumi.Input[builtins.bool]] = None,
                 preserve_data_volumes_created_at_launch: Optional[pulumi.Input[builtins.bool]] = None,
                 private_ip: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 security_attributes_state: Optional[pulumi.Input[builtins.str]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 shape_config: Optional[pulumi.Input['InstanceShapeConfigArgs']] = None,
                 source_details: Optional[pulumi.Input['InstanceSourceDetailsArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_maintenance_reboot_due: Optional[pulumi.Input[builtins.str]] = None,
                 update_operation_constraint: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input['InstanceAgentConfigArgs'] agent_config: (Updatable) Configuration options for the Oracle Cloud Agent software running on the instance.
        :param pulumi.Input['InstanceAvailabilityConfigArgs'] availability_config: (Updatable) Options for VM migration during infrastructure maintenance events and for defining the availability of a VM instance after a maintenance event that impacts the underlying hardware.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the instance.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] boot_volume_id: The OCID of the attached boot volume. If the `source_type` is `bootVolume`, this will be the same OCID as the `source_id`.
        :param pulumi.Input[builtins.str] capacity_reservation_id: (Updatable) The OCID of the compute capacity reservation this instance is launched under. You can opt out of all default reservations by specifying an empty string as input for this field. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The OCID of the cluster placement group of the instance.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) that the instance will be created in.
        :param pulumi.Input['InstanceCreateVnicDetailsArgs'] create_vnic_details: (Updatable) Contains properties for a VNIC. You use this object when creating the primary VNIC during instance launch or when creating a secondary VNIC. For more information about VNICs, see [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).
        :param pulumi.Input[builtins.str] dedicated_vm_host_id: (Updatable) The OCID of the dedicated virtual machine host to place the instance on.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] fault_domain: (Updatable) A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.
               
               If you do not specify the fault domain, the system selects one for you.
               
               To get a list of fault domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] hostname_label: Deprecated. Instead use `hostnameLabel` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). If you provide both, the values must match.
        :param pulumi.Input[builtins.str] image: Deprecated. Use `sourceDetails` with [InstanceSourceViaImageDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/InstanceSourceViaImageDetails) source type instead. If you specify values for both, the values must match.
        :param pulumi.Input[builtins.str] instance_configuration_id: The OCID of the Instance Configuration containing instance launch details. Any other fields supplied in this instance launch request will override the details stored in the Instance Configuration for this instance launch.
        :param pulumi.Input['InstanceInstanceOptionsArgs'] instance_options: (Updatable) Optional mutable instance options
        :param pulumi.Input[builtins.str] ipxe_script: This is an advanced option.
               
               When a bare metal or virtual machine instance boots, the iPXE firmware that runs on the instance is configured to run an iPXE script to continue the boot process.
               
               If you want more control over the boot process, you can provide your own custom iPXE script that will run when the instance boots. Be aware that the same iPXE script will run every time an instance boots, not only after the initial LaunchInstance call.
               
               The default iPXE script connects to the instance's local boot volume over iSCSI and performs a network boot. If you use a custom iPXE script and want to network-boot from the instance's local boot volume over iSCSI the same way as the default iPXE script, use the following iSCSI IP address: 169.254.0.2, and boot volume IQN: iqn.2015-02.oracle.boot.
               
               If your instance boot volume attachment type is paravirtualized, the boot volume is attached to the instance through virtio-scsi and no iPXE script is used. If your instance boot volume attachment type is paravirtualized and you use custom iPXE to network boot into your instance, the primary boot volume is attached as a data volume through virtio-scsi drive.
               
               For more information about the Bring Your Own Image feature of Oracle Cloud Infrastructure, see [Bring Your Own Image](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bringyourownimage.htm).
               
               For more information about iPXE, see http://ipxe.org.
        :param pulumi.Input[builtins.bool] is_cross_numa_node: Whether the instance’s OCPUs and memory are distributed across multiple NUMA nodes.
        :param pulumi.Input[builtins.bool] is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false. Use this field only during create. To update use `is_pv_encryption_in_transit_enabled` under `launch_options` instead.
        :param pulumi.Input[builtins.str] launch_mode: Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
               * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
               * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
               * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
               * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.
        :param pulumi.Input['InstanceLaunchOptionsArgs'] launch_options: (Updatable) Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceLaunchVolumeAttachmentArgs']]] launch_volume_attachments: Volume attachments to create as part of the launch instance operation.
               
               **Note:** This property is used for initial instance provisioning only. Updates to this property will not be supported. To update volume attachments, user should use `Core.VolumeAttachment`. To update volume details, user should use `Core.Volume`
        :param pulumi.Input['InstanceLicensingConfigsArgs'] licensing_configs: (Updatable) List of licensing configurations associated with target launch values.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: (Updatable) Custom metadata key/value pairs that you provide, such as the SSH public key required to connect to the instance.
               
               A metadata service runs on every launched instance. The service is an HTTP endpoint listening on 169.254.169.254. You can use the service to:
               * Provide information to [Cloud-Init](https://cloudinit.readthedocs.org/en/latest/) to be used for various system initialization tasks.
               * Get information about the instance, including the custom metadata that you provide when you launch the instance.
               
               **Providing Cloud-Init Metadata**
               
               You can use the following metadata key names to provide information to Cloud-Init:
               
               **"ssh_authorized_keys"** - Provide one or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on the instance. Use a newline character to separate multiple keys. The SSH keys must be in the format necessary for the `authorized_keys` file, as shown in the example below.
               
               **"user_data"** - Provide your own base64-encoded data to be used by Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For information about how to take advantage of user data, see the [Cloud-Init Documentation](http://cloudinit.readthedocs.org/en/latest/topics/format.html).
               
               **Metadata Example**
               
               ```
               "metadata" : { "quake_bot_level" : "Severe", "ssh_authorized_keys" : "ssh-rsa <your_public_SSH_key>== rsa-key-20160227", "user_data" : "<your_public_SSH_key>==" }
               ```
               
               **Getting Metadata on the Instance**
               
               To get information about your instance, connect to the instance using SSH and issue any of the following GET requests:
               
               ```
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/<any-key-name>
               ```
               
               You'll get back a response that includes all the instance information; only the metadata information; or the metadata information for the specified key name, respectively.
               
               The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of 32,000 bytes.
               
               **Note:** Both the 'user_data' and 'ssh_authorized_keys' fields cannot be changed after an instance has launched. Any request which updates, removes, or adds either of these fields will be rejected. You must provide the same values for 'user_data' and 'ssh_authorized_keys' that already exist on the instance.
        :param pulumi.Input['InstancePlatformConfigArgs'] platform_config: (Updatable only for VM's) The platform configuration requested for the instance.
               
               If you provide the parameter, the instance is created with the platform configuration that you specify. For any values that you omit, the instance uses the default configuration values for the `shape` that you specify. If you don't provide the parameter, the default values for the `shape` are used.
               
               Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
               
               For more information about shielded instances, see [Shielded Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/shielded-instances.htm).
               
               For more information about BIOS settings for bare metal instances, see [BIOS Settings for Bare Metal Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bios-settings.htm).
        :param pulumi.Input['InstancePreemptibleInstanceConfigArgs'] preemptible_instance_config: Configuration options for preemptible instances.
        :param pulumi.Input[builtins.bool] preserve_boot_volume: (Optional) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        :param pulumi.Input[builtins.str] private_ip: The private IP address of instance VNIC. To set the private IP address, use the `private_ip` argument in create_vnic_details.
        :param pulumi.Input[builtins.str] public_ip: The public IP address of instance VNIC (if enabled).
        :param pulumi.Input[builtins.str] region: The region that contains the availability domain the instance is running in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] security_attributes: (Updatable) [Security attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes) are labels for a resource that can be referenced in a [Zero Trust Packet Routing](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm) (ZPR) policy to control access to ZPR-supported resources.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
        :param pulumi.Input[builtins.str] security_attributes_state: The lifecycle state of the `securityAttributes`
        :param pulumi.Input[builtins.str] shape: (Updatable) The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.
               
               You can enumerate all available shapes by calling [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Shape/ListShapes).
        :param pulumi.Input['InstanceShapeConfigArgs'] shape_config: (Updatable) The shape configuration requested for the instance.
               
               If the parameter is provided, the instance is created with the resources that you specify. If some properties are missing or the entire parameter is not provided, the instance is created with the default configuration values for the `shape` that you specify.
               
               Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
        :param pulumi.Input['InstanceSourceDetailsArgs'] source_details: (Updatable)
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the instance. Could be set to RUNNING or STOPPED.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] subnet_id: Deprecated. Instead use `subnetId` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). At least one of them is required; if you provide both, the values must match.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the instance was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_maintenance_reboot_due: The date and time the instance is expected to be stopped / started,  in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). After that time if instance hasn't been rebooted, Oracle will reboot the instance within 24 hours of the due time. Regardless of how the instance was stopped, the flag will be reset to empty as soon as instance reaches Stopped state. Example: `2018-05-25T21:10:29.600Z`
        """
        if agent_config is not None:
            pulumi.set(__self__, "agent_config", agent_config)
        if async_ is not None:
            pulumi.set(__self__, "async_", async_)
        if availability_config is not None:
            pulumi.set(__self__, "availability_config", availability_config)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if boot_volume_id is not None:
            pulumi.set(__self__, "boot_volume_id", boot_volume_id)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_cluster_id is not None:
            pulumi.set(__self__, "compute_cluster_id", compute_cluster_id)
        if create_vnic_details is not None:
            pulumi.set(__self__, "create_vnic_details", create_vnic_details)
        if dedicated_vm_host_id is not None:
            pulumi.set(__self__, "dedicated_vm_host_id", dedicated_vm_host_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if extended_metadata is not None:
            pulumi.set(__self__, "extended_metadata", extended_metadata)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            warnings.warn("""The 'hostname_label' field has been deprecated. Please use 'hostname_label under create_vnic_details' instead.""", DeprecationWarning)
            pulumi.log.warn("""hostname_label is deprecated: The 'hostname_label' field has been deprecated. Please use 'hostname_label under create_vnic_details' instead.""")
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if image is not None:
            warnings.warn("""The 'image' field has been deprecated. Please use 'source_details' instead. If both fields are specified, then 'source_details' will be used.""", DeprecationWarning)
            pulumi.log.warn("""image is deprecated: The 'image' field has been deprecated. Please use 'source_details' instead. If both fields are specified, then 'source_details' will be used.""")
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_options is not None:
            pulumi.set(__self__, "instance_options", instance_options)
        if ipxe_script is not None:
            pulumi.set(__self__, "ipxe_script", ipxe_script)
        if is_cross_numa_node is not None:
            pulumi.set(__self__, "is_cross_numa_node", is_cross_numa_node)
        if is_pv_encryption_in_transit_enabled is not None:
            pulumi.set(__self__, "is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        if launch_mode is not None:
            pulumi.set(__self__, "launch_mode", launch_mode)
        if launch_options is not None:
            pulumi.set(__self__, "launch_options", launch_options)
        if launch_volume_attachments is not None:
            pulumi.set(__self__, "launch_volume_attachments", launch_volume_attachments)
        if licensing_configs is not None:
            pulumi.set(__self__, "licensing_configs", licensing_configs)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if platform_config is not None:
            pulumi.set(__self__, "platform_config", platform_config)
        if preemptible_instance_config is not None:
            pulumi.set(__self__, "preemptible_instance_config", preemptible_instance_config)
        if preserve_boot_volume is not None:
            pulumi.set(__self__, "preserve_boot_volume", preserve_boot_volume)
        if preserve_data_volumes_created_at_launch is not None:
            pulumi.set(__self__, "preserve_data_volumes_created_at_launch", preserve_data_volumes_created_at_launch)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_attributes is not None:
            pulumi.set(__self__, "security_attributes", security_attributes)
        if security_attributes_state is not None:
            pulumi.set(__self__, "security_attributes_state", security_attributes_state)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if shape_config is not None:
            pulumi.set(__self__, "shape_config", shape_config)
        if source_details is not None:
            pulumi.set(__self__, "source_details", source_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            warnings.warn("""The 'subnet_id' field has been deprecated. Please use 'subnet_id under create_vnic_details' instead.""", DeprecationWarning)
            pulumi.log.warn("""subnet_id is deprecated: The 'subnet_id' field has been deprecated. Please use 'subnet_id under create_vnic_details' instead.""")
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_maintenance_reboot_due is not None:
            pulumi.set(__self__, "time_maintenance_reboot_due", time_maintenance_reboot_due)
        if update_operation_constraint is not None:
            pulumi.set(__self__, "update_operation_constraint", update_operation_constraint)

    @property
    @pulumi.getter(name="agentConfig")
    def agent_config(self) -> Optional[pulumi.Input['InstanceAgentConfigArgs']]:
        """
        (Updatable) Configuration options for the Oracle Cloud Agent software running on the instance.
        """
        return pulumi.get(self, "agent_config")

    @agent_config.setter
    def agent_config(self, value: Optional[pulumi.Input['InstanceAgentConfigArgs']]):
        pulumi.set(self, "agent_config", value)

    @property
    @pulumi.getter(name="async")
    def async_(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "async_")

    @async_.setter
    def async_(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "async_", value)

    @property
    @pulumi.getter(name="availabilityConfig")
    def availability_config(self) -> Optional[pulumi.Input['InstanceAvailabilityConfigArgs']]:
        """
        (Updatable) Options for VM migration during infrastructure maintenance events and for defining the availability of a VM instance after a maintenance event that impacts the underlying hardware.
        """
        return pulumi.get(self, "availability_config")

    @availability_config.setter
    def availability_config(self, value: Optional[pulumi.Input['InstanceAvailabilityConfigArgs']]):
        pulumi.set(self, "availability_config", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain of the instance.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="bootVolumeId")
    def boot_volume_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the attached boot volume. If the `source_type` is `bootVolume`, this will be the same OCID as the `source_id`.
        """
        return pulumi.get(self, "boot_volume_id")

    @boot_volume_id.setter
    def boot_volume_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "boot_volume_id", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compute capacity reservation this instance is launched under. You can opt out of all default reservations by specifying an empty string as input for this field. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the cluster placement group of the instance.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) that the instance will be created in.
        """
        return pulumi.get(self, "compute_cluster_id")

    @compute_cluster_id.setter
    def compute_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_cluster_id", value)

    @property
    @pulumi.getter(name="createVnicDetails")
    def create_vnic_details(self) -> Optional[pulumi.Input['InstanceCreateVnicDetailsArgs']]:
        """
        (Updatable) Contains properties for a VNIC. You use this object when creating the primary VNIC during instance launch or when creating a secondary VNIC. For more information about VNICs, see [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).
        """
        return pulumi.get(self, "create_vnic_details")

    @create_vnic_details.setter
    def create_vnic_details(self, value: Optional[pulumi.Input['InstanceCreateVnicDetailsArgs']]):
        pulumi.set(self, "create_vnic_details", value)

    @property
    @pulumi.getter(name="dedicatedVmHostId")
    def dedicated_vm_host_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the dedicated virtual machine host to place the instance on.
        """
        return pulumi.get(self, "dedicated_vm_host_id")

    @dedicated_vm_host_id.setter
    def dedicated_vm_host_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dedicated_vm_host_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "extended_metadata")

    @extended_metadata.setter
    def extended_metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "extended_metadata", value)

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.

        If you do not specify the fault domain, the system selects one for you.

        To get a list of fault domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostnameLabel")
    @_utilities.deprecated("""The 'hostname_label' field has been deprecated. Please use 'hostname_label under create_vnic_details' instead.""")
    def hostname_label(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated. Instead use `hostnameLabel` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). If you provide both, the values must match.
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "hostname_label", value)

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'image' field has been deprecated. Please use 'source_details' instead. If both fields are specified, then 'source_details' will be used.""")
    def image(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated. Use `sourceDetails` with [InstanceSourceViaImageDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/InstanceSourceViaImageDetails) source type instead. If you specify values for both, the values must match.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Instance Configuration containing instance launch details. Any other fields supplied in this instance launch request will override the details stored in the Instance Configuration for this instance launch.
        """
        return pulumi.get(self, "instance_configuration_id")

    @instance_configuration_id.setter
    def instance_configuration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_configuration_id", value)

    @property
    @pulumi.getter(name="instanceOptions")
    def instance_options(self) -> Optional[pulumi.Input['InstanceInstanceOptionsArgs']]:
        """
        (Updatable) Optional mutable instance options
        """
        return pulumi.get(self, "instance_options")

    @instance_options.setter
    def instance_options(self, value: Optional[pulumi.Input['InstanceInstanceOptionsArgs']]):
        pulumi.set(self, "instance_options", value)

    @property
    @pulumi.getter(name="ipxeScript")
    def ipxe_script(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        This is an advanced option.

        When a bare metal or virtual machine instance boots, the iPXE firmware that runs on the instance is configured to run an iPXE script to continue the boot process.

        If you want more control over the boot process, you can provide your own custom iPXE script that will run when the instance boots. Be aware that the same iPXE script will run every time an instance boots, not only after the initial LaunchInstance call.

        The default iPXE script connects to the instance's local boot volume over iSCSI and performs a network boot. If you use a custom iPXE script and want to network-boot from the instance's local boot volume over iSCSI the same way as the default iPXE script, use the following iSCSI IP address: 169.254.0.2, and boot volume IQN: iqn.2015-02.oracle.boot.

        If your instance boot volume attachment type is paravirtualized, the boot volume is attached to the instance through virtio-scsi and no iPXE script is used. If your instance boot volume attachment type is paravirtualized and you use custom iPXE to network boot into your instance, the primary boot volume is attached as a data volume through virtio-scsi drive.

        For more information about the Bring Your Own Image feature of Oracle Cloud Infrastructure, see [Bring Your Own Image](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bringyourownimage.htm).

        For more information about iPXE, see http://ipxe.org.
        """
        return pulumi.get(self, "ipxe_script")

    @ipxe_script.setter
    def ipxe_script(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ipxe_script", value)

    @property
    @pulumi.getter(name="isCrossNumaNode")
    def is_cross_numa_node(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the instance’s OCPUs and memory are distributed across multiple NUMA nodes.
        """
        return pulumi.get(self, "is_cross_numa_node")

    @is_cross_numa_node.setter
    def is_cross_numa_node(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_cross_numa_node", value)

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false. Use this field only during create. To update use `is_pv_encryption_in_transit_enabled` under `launch_options` instead.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @is_pv_encryption_in_transit_enabled.setter
    def is_pv_encryption_in_transit_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_pv_encryption_in_transit_enabled", value)

    @property
    @pulumi.getter(name="launchMode")
    def launch_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
        * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
        * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
        * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
        * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.
        """
        return pulumi.get(self, "launch_mode")

    @launch_mode.setter
    def launch_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "launch_mode", value)

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> Optional[pulumi.Input['InstanceLaunchOptionsArgs']]:
        """
        (Updatable) Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        """
        return pulumi.get(self, "launch_options")

    @launch_options.setter
    def launch_options(self, value: Optional[pulumi.Input['InstanceLaunchOptionsArgs']]):
        pulumi.set(self, "launch_options", value)

    @property
    @pulumi.getter(name="launchVolumeAttachments")
    def launch_volume_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLaunchVolumeAttachmentArgs']]]]:
        """
        Volume attachments to create as part of the launch instance operation.

        **Note:** This property is used for initial instance provisioning only. Updates to this property will not be supported. To update volume attachments, user should use `Core.VolumeAttachment`. To update volume details, user should use `Core.Volume`
        """
        return pulumi.get(self, "launch_volume_attachments")

    @launch_volume_attachments.setter
    def launch_volume_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceLaunchVolumeAttachmentArgs']]]]):
        pulumi.set(self, "launch_volume_attachments", value)

    @property
    @pulumi.getter(name="licensingConfigs")
    def licensing_configs(self) -> Optional[pulumi.Input['InstanceLicensingConfigsArgs']]:
        """
        (Updatable) List of licensing configurations associated with target launch values.
        """
        return pulumi.get(self, "licensing_configs")

    @licensing_configs.setter
    def licensing_configs(self, value: Optional[pulumi.Input['InstanceLicensingConfigsArgs']]):
        pulumi.set(self, "licensing_configs", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Custom metadata key/value pairs that you provide, such as the SSH public key required to connect to the instance.

        A metadata service runs on every launched instance. The service is an HTTP endpoint listening on 169.254.169.254. You can use the service to:
        * Provide information to [Cloud-Init](https://cloudinit.readthedocs.org/en/latest/) to be used for various system initialization tasks.
        * Get information about the instance, including the custom metadata that you provide when you launch the instance.

        **Providing Cloud-Init Metadata**

        You can use the following metadata key names to provide information to Cloud-Init:

        **"ssh_authorized_keys"** - Provide one or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on the instance. Use a newline character to separate multiple keys. The SSH keys must be in the format necessary for the `authorized_keys` file, as shown in the example below.

        **"user_data"** - Provide your own base64-encoded data to be used by Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For information about how to take advantage of user data, see the [Cloud-Init Documentation](http://cloudinit.readthedocs.org/en/latest/topics/format.html).

        **Metadata Example**

        ```
        "metadata" : { "quake_bot_level" : "Severe", "ssh_authorized_keys" : "ssh-rsa <your_public_SSH_key>== rsa-key-20160227", "user_data" : "<your_public_SSH_key>==" }
        ```

        **Getting Metadata on the Instance**

        To get information about your instance, connect to the instance using SSH and issue any of the following GET requests:

        ```
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/<any-key-name>
        ```

        You'll get back a response that includes all the instance information; only the metadata information; or the metadata information for the specified key name, respectively.

        The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of 32,000 bytes.

        **Note:** Both the 'user_data' and 'ssh_authorized_keys' fields cannot be changed after an instance has launched. Any request which updates, removes, or adds either of these fields will be rejected. You must provide the same values for 'user_data' and 'ssh_authorized_keys' that already exist on the instance.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="platformConfig")
    def platform_config(self) -> Optional[pulumi.Input['InstancePlatformConfigArgs']]:
        """
        (Updatable only for VM's) The platform configuration requested for the instance.

        If you provide the parameter, the instance is created with the platform configuration that you specify. For any values that you omit, the instance uses the default configuration values for the `shape` that you specify. If you don't provide the parameter, the default values for the `shape` are used.

        Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.

        For more information about shielded instances, see [Shielded Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/shielded-instances.htm).

        For more information about BIOS settings for bare metal instances, see [BIOS Settings for Bare Metal Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bios-settings.htm).
        """
        return pulumi.get(self, "platform_config")

    @platform_config.setter
    def platform_config(self, value: Optional[pulumi.Input['InstancePlatformConfigArgs']]):
        pulumi.set(self, "platform_config", value)

    @property
    @pulumi.getter(name="preemptibleInstanceConfig")
    def preemptible_instance_config(self) -> Optional[pulumi.Input['InstancePreemptibleInstanceConfigArgs']]:
        """
        Configuration options for preemptible instances.
        """
        return pulumi.get(self, "preemptible_instance_config")

    @preemptible_instance_config.setter
    def preemptible_instance_config(self, value: Optional[pulumi.Input['InstancePreemptibleInstanceConfigArgs']]):
        pulumi.set(self, "preemptible_instance_config", value)

    @property
    @pulumi.getter(name="preserveBootVolume")
    def preserve_boot_volume(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Optional) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "preserve_boot_volume")

    @preserve_boot_volume.setter
    def preserve_boot_volume(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preserve_boot_volume", value)

    @property
    @pulumi.getter(name="preserveDataVolumesCreatedAtLaunch")
    def preserve_data_volumes_created_at_launch(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "preserve_data_volumes_created_at_launch")

    @preserve_data_volumes_created_at_launch.setter
    def preserve_data_volumes_created_at_launch(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "preserve_data_volumes_created_at_launch", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The private IP address of instance VNIC. To set the private IP address, use the `private_ip` argument in create_vnic_details.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The public IP address of instance VNIC (if enabled).
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The region that contains the availability domain the instance is running in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) [Security attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes) are labels for a resource that can be referenced in a [Zero Trust Packet Routing](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm) (ZPR) policy to control access to ZPR-supported resources.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
        """
        return pulumi.get(self, "security_attributes")

    @security_attributes.setter
    def security_attributes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "security_attributes", value)

    @property
    @pulumi.getter(name="securityAttributesState")
    def security_attributes_state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lifecycle state of the `securityAttributes`
        """
        return pulumi.get(self, "security_attributes_state")

    @security_attributes_state.setter
    def security_attributes_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_attributes_state", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.

        You can enumerate all available shapes by calling [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Shape/ListShapes).
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> Optional[pulumi.Input['InstanceShapeConfigArgs']]:
        """
        (Updatable) The shape configuration requested for the instance.

        If the parameter is provided, the instance is created with the resources that you specify. If some properties are missing or the entire parameter is not provided, the instance is created with the default configuration values for the `shape` that you specify.

        Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
        """
        return pulumi.get(self, "shape_config")

    @shape_config.setter
    def shape_config(self, value: Optional[pulumi.Input['InstanceShapeConfigArgs']]):
        pulumi.set(self, "shape_config", value)

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> Optional[pulumi.Input['InstanceSourceDetailsArgs']]:
        """
        (Updatable)
        """
        return pulumi.get(self, "source_details")

    @source_details.setter
    def source_details(self, value: Optional[pulumi.Input['InstanceSourceDetailsArgs']]):
        pulumi.set(self, "source_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the instance. Could be set to RUNNING or STOPPED.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    @_utilities.deprecated("""The 'subnet_id' field has been deprecated. Please use 'subnet_id under create_vnic_details' instead.""")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Deprecated. Instead use `subnetId` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). At least one of them is required; if you provide both, the values must match.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the instance was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeMaintenanceRebootDue")
    def time_maintenance_reboot_due(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the instance is expected to be stopped / started,  in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). After that time if instance hasn't been rebooted, Oracle will reboot the instance within 24 hours of the due time. Regardless of how the instance was stopped, the flag will be reset to empty as soon as instance reaches Stopped state. Example: `2018-05-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_maintenance_reboot_due")

    @time_maintenance_reboot_due.setter
    def time_maintenance_reboot_due(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_maintenance_reboot_due", value)

    @property
    @pulumi.getter(name="updateOperationConstraint")
    def update_operation_constraint(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "update_operation_constraint")

    @update_operation_constraint.setter
    def update_operation_constraint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "update_operation_constraint", value)


class Instance(pulumi.CustomResource):

    pulumi_type = "oci:Core/instance:Instance"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_config: Optional[pulumi.Input[Union['InstanceAgentConfigArgs', 'InstanceAgentConfigArgsDict']]] = None,
                 async_: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_config: Optional[pulumi.Input[Union['InstanceAvailabilityConfigArgs', 'InstanceAvailabilityConfigArgsDict']]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_vnic_details: Optional[pulumi.Input[Union['InstanceCreateVnicDetailsArgs', 'InstanceCreateVnicDetailsArgsDict']]] = None,
                 dedicated_vm_host_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 extended_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fault_domain: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname_label: Optional[pulumi.Input[builtins.str]] = None,
                 image: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_options: Optional[pulumi.Input[Union['InstanceInstanceOptionsArgs', 'InstanceInstanceOptionsArgsDict']]] = None,
                 ipxe_script: Optional[pulumi.Input[builtins.str]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 launch_options: Optional[pulumi.Input[Union['InstanceLaunchOptionsArgs', 'InstanceLaunchOptionsArgsDict']]] = None,
                 launch_volume_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLaunchVolumeAttachmentArgs', 'InstanceLaunchVolumeAttachmentArgsDict']]]]] = None,
                 licensing_configs: Optional[pulumi.Input[Union['InstanceLicensingConfigsArgs', 'InstanceLicensingConfigsArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 platform_config: Optional[pulumi.Input[Union['InstancePlatformConfigArgs', 'InstancePlatformConfigArgsDict']]] = None,
                 preemptible_instance_config: Optional[pulumi.Input[Union['InstancePreemptibleInstanceConfigArgs', 'InstancePreemptibleInstanceConfigArgsDict']]] = None,
                 preserve_boot_volume: Optional[pulumi.Input[builtins.bool]] = None,
                 preserve_data_volumes_created_at_launch: Optional[pulumi.Input[builtins.bool]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 shape_config: Optional[pulumi.Input[Union['InstanceShapeConfigArgs', 'InstanceShapeConfigArgsDict']]] = None,
                 source_details: Optional[pulumi.Input[Union['InstanceSourceDetailsArgs', 'InstanceSourceDetailsArgsDict']]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 update_operation_constraint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Instance resource in Oracle Cloud Infrastructure Core service.

        Creates a new instance in the specified compartment and the specified availability domain.
        For general information about instances, see
        [Overview of the Compute Service](https://docs.cloud.oracle.com/iaas/Content/Compute/Concepts/computeoverview.htm).

        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about availability domains, see
        [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the `ListAvailabilityDomains` operation
        in the Identity and Access Management Service API.

        All Oracle Cloud Infrastructure resources, including instances, get an Oracle-assigned,
        unique ID called an Oracle Cloud Identifier (OCID).
        When you create a resource, you can find its OCID in the response. You can
        also retrieve a resource's OCID by using a List API operation
        on that resource type, or by viewing the resource in the Console.

        To launch an instance using an image or a boot volume use the `sourceDetails` parameter in [LaunchInstanceDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/LaunchInstanceDetails).

        When you launch an instance, it is automatically attached to a virtual
        network interface card (VNIC), called the *primary VNIC*. The VNIC
        has a private IP address from the subnet's CIDR. You can either assign a
        private IP address of your choice or let Oracle automatically assign one.
        You can choose whether the instance has a public IP address. To retrieve the
        addresses, use the [ListVnicAttachments](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VnicAttachment/ListVnicAttachments)
        operation to get the VNIC ID for the instance, and then call
        [GetVnic](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Vnic/GetVnic) with the VNIC ID.

        You can later add secondary VNICs to an instance. For more information, see
        [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).

        To launch an instance from a Marketplace image listing, you must provide the image ID of the
        listing resource version that you want, but you also must subscribe to the listing before you try
        to launch the instance. To subscribe to the listing, use the [GetAppCatalogListingAgreements](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements/GetAppCatalogListingAgreements)
        operation to get the signature for the terms of use agreement for the desired listing resource version.
        Then, call [CreateAppCatalogSubscription](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/AppCatalogSubscription/CreateAppCatalogSubscription)
        with the signature. To get the image ID for the LaunchInstance operation, call
        [GetAppCatalogListingResourceVersion](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersion/GetAppCatalogListingResourceVersion).

        When launching an instance, you may provide the `securityAttributes` parameter in
        [LaunchInstanceDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/LaunchInstanceDetails) to manage security attributes via the instance,
        or in the embedded [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/) to manage security attributes
        via the VNIC directly, but not both.  Providing `securityAttributes` in both locations will return a
        400 Bad Request response.

        To determine whether capacity is available for a specific shape before you create an instance,
        use the [CreateComputeCapacityReport](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ComputeCapacityReport/CreateComputeCapacityReport)
        operation.

        ## Import

        Instances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instance:Instance test_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAgentConfigArgs', 'InstanceAgentConfigArgsDict']] agent_config: (Updatable) Configuration options for the Oracle Cloud Agent software running on the instance.
        :param pulumi.Input[Union['InstanceAvailabilityConfigArgs', 'InstanceAvailabilityConfigArgsDict']] availability_config: (Updatable) Options for VM migration during infrastructure maintenance events and for defining the availability of a VM instance after a maintenance event that impacts the underlying hardware.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the instance.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] capacity_reservation_id: (Updatable) The OCID of the compute capacity reservation this instance is launched under. You can opt out of all default reservations by specifying an empty string as input for this field. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The OCID of the cluster placement group of the instance.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) that the instance will be created in.
        :param pulumi.Input[Union['InstanceCreateVnicDetailsArgs', 'InstanceCreateVnicDetailsArgsDict']] create_vnic_details: (Updatable) Contains properties for a VNIC. You use this object when creating the primary VNIC during instance launch or when creating a secondary VNIC. For more information about VNICs, see [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).
        :param pulumi.Input[builtins.str] dedicated_vm_host_id: (Updatable) The OCID of the dedicated virtual machine host to place the instance on.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] fault_domain: (Updatable) A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.
               
               If you do not specify the fault domain, the system selects one for you.
               
               To get a list of fault domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] hostname_label: Deprecated. Instead use `hostnameLabel` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). If you provide both, the values must match.
        :param pulumi.Input[builtins.str] image: Deprecated. Use `sourceDetails` with [InstanceSourceViaImageDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/InstanceSourceViaImageDetails) source type instead. If you specify values for both, the values must match.
        :param pulumi.Input[builtins.str] instance_configuration_id: The OCID of the Instance Configuration containing instance launch details. Any other fields supplied in this instance launch request will override the details stored in the Instance Configuration for this instance launch.
        :param pulumi.Input[Union['InstanceInstanceOptionsArgs', 'InstanceInstanceOptionsArgsDict']] instance_options: (Updatable) Optional mutable instance options
        :param pulumi.Input[builtins.str] ipxe_script: This is an advanced option.
               
               When a bare metal or virtual machine instance boots, the iPXE firmware that runs on the instance is configured to run an iPXE script to continue the boot process.
               
               If you want more control over the boot process, you can provide your own custom iPXE script that will run when the instance boots. Be aware that the same iPXE script will run every time an instance boots, not only after the initial LaunchInstance call.
               
               The default iPXE script connects to the instance's local boot volume over iSCSI and performs a network boot. If you use a custom iPXE script and want to network-boot from the instance's local boot volume over iSCSI the same way as the default iPXE script, use the following iSCSI IP address: 169.254.0.2, and boot volume IQN: iqn.2015-02.oracle.boot.
               
               If your instance boot volume attachment type is paravirtualized, the boot volume is attached to the instance through virtio-scsi and no iPXE script is used. If your instance boot volume attachment type is paravirtualized and you use custom iPXE to network boot into your instance, the primary boot volume is attached as a data volume through virtio-scsi drive.
               
               For more information about the Bring Your Own Image feature of Oracle Cloud Infrastructure, see [Bring Your Own Image](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bringyourownimage.htm).
               
               For more information about iPXE, see http://ipxe.org.
        :param pulumi.Input[builtins.bool] is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false. Use this field only during create. To update use `is_pv_encryption_in_transit_enabled` under `launch_options` instead.
        :param pulumi.Input[Union['InstanceLaunchOptionsArgs', 'InstanceLaunchOptionsArgsDict']] launch_options: (Updatable) Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceLaunchVolumeAttachmentArgs', 'InstanceLaunchVolumeAttachmentArgsDict']]]] launch_volume_attachments: Volume attachments to create as part of the launch instance operation.
               
               **Note:** This property is used for initial instance provisioning only. Updates to this property will not be supported. To update volume attachments, user should use `Core.VolumeAttachment`. To update volume details, user should use `Core.Volume`
        :param pulumi.Input[Union['InstanceLicensingConfigsArgs', 'InstanceLicensingConfigsArgsDict']] licensing_configs: (Updatable) List of licensing configurations associated with target launch values.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: (Updatable) Custom metadata key/value pairs that you provide, such as the SSH public key required to connect to the instance.
               
               A metadata service runs on every launched instance. The service is an HTTP endpoint listening on 169.254.169.254. You can use the service to:
               * Provide information to [Cloud-Init](https://cloudinit.readthedocs.org/en/latest/) to be used for various system initialization tasks.
               * Get information about the instance, including the custom metadata that you provide when you launch the instance.
               
               **Providing Cloud-Init Metadata**
               
               You can use the following metadata key names to provide information to Cloud-Init:
               
               **"ssh_authorized_keys"** - Provide one or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on the instance. Use a newline character to separate multiple keys. The SSH keys must be in the format necessary for the `authorized_keys` file, as shown in the example below.
               
               **"user_data"** - Provide your own base64-encoded data to be used by Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For information about how to take advantage of user data, see the [Cloud-Init Documentation](http://cloudinit.readthedocs.org/en/latest/topics/format.html).
               
               **Metadata Example**
               
               ```
               "metadata" : { "quake_bot_level" : "Severe", "ssh_authorized_keys" : "ssh-rsa <your_public_SSH_key>== rsa-key-20160227", "user_data" : "<your_public_SSH_key>==" }
               ```
               
               **Getting Metadata on the Instance**
               
               To get information about your instance, connect to the instance using SSH and issue any of the following GET requests:
               
               ```
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/<any-key-name>
               ```
               
               You'll get back a response that includes all the instance information; only the metadata information; or the metadata information for the specified key name, respectively.
               
               The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of 32,000 bytes.
               
               **Note:** Both the 'user_data' and 'ssh_authorized_keys' fields cannot be changed after an instance has launched. Any request which updates, removes, or adds either of these fields will be rejected. You must provide the same values for 'user_data' and 'ssh_authorized_keys' that already exist on the instance.
        :param pulumi.Input[Union['InstancePlatformConfigArgs', 'InstancePlatformConfigArgsDict']] platform_config: (Updatable only for VM's) The platform configuration requested for the instance.
               
               If you provide the parameter, the instance is created with the platform configuration that you specify. For any values that you omit, the instance uses the default configuration values for the `shape` that you specify. If you don't provide the parameter, the default values for the `shape` are used.
               
               Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
               
               For more information about shielded instances, see [Shielded Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/shielded-instances.htm).
               
               For more information about BIOS settings for bare metal instances, see [BIOS Settings for Bare Metal Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bios-settings.htm).
        :param pulumi.Input[Union['InstancePreemptibleInstanceConfigArgs', 'InstancePreemptibleInstanceConfigArgsDict']] preemptible_instance_config: Configuration options for preemptible instances.
        :param pulumi.Input[builtins.bool] preserve_boot_volume: (Optional) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] security_attributes: (Updatable) [Security attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes) are labels for a resource that can be referenced in a [Zero Trust Packet Routing](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm) (ZPR) policy to control access to ZPR-supported resources.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
        :param pulumi.Input[builtins.str] shape: (Updatable) The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.
               
               You can enumerate all available shapes by calling [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Shape/ListShapes).
        :param pulumi.Input[Union['InstanceShapeConfigArgs', 'InstanceShapeConfigArgsDict']] shape_config: (Updatable) The shape configuration requested for the instance.
               
               If the parameter is provided, the instance is created with the resources that you specify. If some properties are missing or the entire parameter is not provided, the instance is created with the default configuration values for the `shape` that you specify.
               
               Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
        :param pulumi.Input[Union['InstanceSourceDetailsArgs', 'InstanceSourceDetailsArgsDict']] source_details: (Updatable)
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the instance. Could be set to RUNNING or STOPPED.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] subnet_id: Deprecated. Instead use `subnetId` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). At least one of them is required; if you provide both, the values must match.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Instance resource in Oracle Cloud Infrastructure Core service.

        Creates a new instance in the specified compartment and the specified availability domain.
        For general information about instances, see
        [Overview of the Compute Service](https://docs.cloud.oracle.com/iaas/Content/Compute/Concepts/computeoverview.htm).

        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about availability domains, see
        [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the `ListAvailabilityDomains` operation
        in the Identity and Access Management Service API.

        All Oracle Cloud Infrastructure resources, including instances, get an Oracle-assigned,
        unique ID called an Oracle Cloud Identifier (OCID).
        When you create a resource, you can find its OCID in the response. You can
        also retrieve a resource's OCID by using a List API operation
        on that resource type, or by viewing the resource in the Console.

        To launch an instance using an image or a boot volume use the `sourceDetails` parameter in [LaunchInstanceDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/LaunchInstanceDetails).

        When you launch an instance, it is automatically attached to a virtual
        network interface card (VNIC), called the *primary VNIC*. The VNIC
        has a private IP address from the subnet's CIDR. You can either assign a
        private IP address of your choice or let Oracle automatically assign one.
        You can choose whether the instance has a public IP address. To retrieve the
        addresses, use the [ListVnicAttachments](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/VnicAttachment/ListVnicAttachments)
        operation to get the VNIC ID for the instance, and then call
        [GetVnic](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Vnic/GetVnic) with the VNIC ID.

        You can later add secondary VNICs to an instance. For more information, see
        [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).

        To launch an instance from a Marketplace image listing, you must provide the image ID of the
        listing resource version that you want, but you also must subscribe to the listing before you try
        to launch the instance. To subscribe to the listing, use the [GetAppCatalogListingAgreements](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements/GetAppCatalogListingAgreements)
        operation to get the signature for the terms of use agreement for the desired listing resource version.
        Then, call [CreateAppCatalogSubscription](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/AppCatalogSubscription/CreateAppCatalogSubscription)
        with the signature. To get the image ID for the LaunchInstance operation, call
        [GetAppCatalogListingResourceVersion](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersion/GetAppCatalogListingResourceVersion).

        When launching an instance, you may provide the `securityAttributes` parameter in
        [LaunchInstanceDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/LaunchInstanceDetails) to manage security attributes via the instance,
        or in the embedded [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/) to manage security attributes
        via the VNIC directly, but not both.  Providing `securityAttributes` in both locations will return a
        400 Bad Request response.

        To determine whether capacity is available for a specific shape before you create an instance,
        use the [CreateComputeCapacityReport](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ComputeCapacityReport/CreateComputeCapacityReport)
        operation.

        ## Import

        Instances can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/instance:Instance test_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_config: Optional[pulumi.Input[Union['InstanceAgentConfigArgs', 'InstanceAgentConfigArgsDict']]] = None,
                 async_: Optional[pulumi.Input[builtins.bool]] = None,
                 availability_config: Optional[pulumi.Input[Union['InstanceAvailabilityConfigArgs', 'InstanceAvailabilityConfigArgsDict']]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 create_vnic_details: Optional[pulumi.Input[Union['InstanceCreateVnicDetailsArgs', 'InstanceCreateVnicDetailsArgsDict']]] = None,
                 dedicated_vm_host_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 extended_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 fault_domain: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 hostname_label: Optional[pulumi.Input[builtins.str]] = None,
                 image: Optional[pulumi.Input[builtins.str]] = None,
                 instance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
                 instance_options: Optional[pulumi.Input[Union['InstanceInstanceOptionsArgs', 'InstanceInstanceOptionsArgsDict']]] = None,
                 ipxe_script: Optional[pulumi.Input[builtins.str]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 launch_options: Optional[pulumi.Input[Union['InstanceLaunchOptionsArgs', 'InstanceLaunchOptionsArgsDict']]] = None,
                 launch_volume_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLaunchVolumeAttachmentArgs', 'InstanceLaunchVolumeAttachmentArgsDict']]]]] = None,
                 licensing_configs: Optional[pulumi.Input[Union['InstanceLicensingConfigsArgs', 'InstanceLicensingConfigsArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 platform_config: Optional[pulumi.Input[Union['InstancePlatformConfigArgs', 'InstancePlatformConfigArgsDict']]] = None,
                 preemptible_instance_config: Optional[pulumi.Input[Union['InstancePreemptibleInstanceConfigArgs', 'InstancePreemptibleInstanceConfigArgsDict']]] = None,
                 preserve_boot_volume: Optional[pulumi.Input[builtins.bool]] = None,
                 preserve_data_volumes_created_at_launch: Optional[pulumi.Input[builtins.bool]] = None,
                 security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 shape: Optional[pulumi.Input[builtins.str]] = None,
                 shape_config: Optional[pulumi.Input[Union['InstanceShapeConfigArgs', 'InstanceShapeConfigArgsDict']]] = None,
                 source_details: Optional[pulumi.Input[Union['InstanceSourceDetailsArgs', 'InstanceSourceDetailsArgsDict']]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 update_operation_constraint: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["agent_config"] = agent_config
            __props__.__dict__["async_"] = async_
            __props__.__dict__["availability_config"] = availability_config
            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
            __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_cluster_id"] = compute_cluster_id
            __props__.__dict__["create_vnic_details"] = create_vnic_details
            __props__.__dict__["dedicated_vm_host_id"] = dedicated_vm_host_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["extended_metadata"] = extended_metadata
            __props__.__dict__["fault_domain"] = fault_domain
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["hostname_label"] = hostname_label
            __props__.__dict__["image"] = image
            __props__.__dict__["instance_configuration_id"] = instance_configuration_id
            __props__.__dict__["instance_options"] = instance_options
            __props__.__dict__["ipxe_script"] = ipxe_script
            __props__.__dict__["is_pv_encryption_in_transit_enabled"] = is_pv_encryption_in_transit_enabled
            __props__.__dict__["launch_options"] = launch_options
            __props__.__dict__["launch_volume_attachments"] = launch_volume_attachments
            __props__.__dict__["licensing_configs"] = licensing_configs
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["platform_config"] = platform_config
            __props__.__dict__["preemptible_instance_config"] = preemptible_instance_config
            __props__.__dict__["preserve_boot_volume"] = preserve_boot_volume
            __props__.__dict__["preserve_data_volumes_created_at_launch"] = preserve_data_volumes_created_at_launch
            __props__.__dict__["security_attributes"] = security_attributes
            __props__.__dict__["shape"] = shape
            __props__.__dict__["shape_config"] = shape_config
            __props__.__dict__["source_details"] = source_details
            __props__.__dict__["state"] = state
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["update_operation_constraint"] = update_operation_constraint
            __props__.__dict__["boot_volume_id"] = None
            __props__.__dict__["is_cross_numa_node"] = None
            __props__.__dict__["launch_mode"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["security_attributes_state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_maintenance_reboot_due"] = None
        super(Instance, __self__).__init__(
            'oci:Core/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_config: Optional[pulumi.Input[Union['InstanceAgentConfigArgs', 'InstanceAgentConfigArgsDict']]] = None,
            async_: Optional[pulumi.Input[builtins.bool]] = None,
            availability_config: Optional[pulumi.Input[Union['InstanceAvailabilityConfigArgs', 'InstanceAvailabilityConfigArgsDict']]] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            boot_volume_id: Optional[pulumi.Input[builtins.str]] = None,
            capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
            cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            compute_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
            create_vnic_details: Optional[pulumi.Input[Union['InstanceCreateVnicDetailsArgs', 'InstanceCreateVnicDetailsArgsDict']]] = None,
            dedicated_vm_host_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            extended_metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            fault_domain: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            hostname_label: Optional[pulumi.Input[builtins.str]] = None,
            image: Optional[pulumi.Input[builtins.str]] = None,
            instance_configuration_id: Optional[pulumi.Input[builtins.str]] = None,
            instance_options: Optional[pulumi.Input[Union['InstanceInstanceOptionsArgs', 'InstanceInstanceOptionsArgsDict']]] = None,
            ipxe_script: Optional[pulumi.Input[builtins.str]] = None,
            is_cross_numa_node: Optional[pulumi.Input[builtins.bool]] = None,
            is_pv_encryption_in_transit_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            launch_mode: Optional[pulumi.Input[builtins.str]] = None,
            launch_options: Optional[pulumi.Input[Union['InstanceLaunchOptionsArgs', 'InstanceLaunchOptionsArgsDict']]] = None,
            launch_volume_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceLaunchVolumeAttachmentArgs', 'InstanceLaunchVolumeAttachmentArgsDict']]]]] = None,
            licensing_configs: Optional[pulumi.Input[Union['InstanceLicensingConfigsArgs', 'InstanceLicensingConfigsArgsDict']]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            platform_config: Optional[pulumi.Input[Union['InstancePlatformConfigArgs', 'InstancePlatformConfigArgsDict']]] = None,
            preemptible_instance_config: Optional[pulumi.Input[Union['InstancePreemptibleInstanceConfigArgs', 'InstancePreemptibleInstanceConfigArgsDict']]] = None,
            preserve_boot_volume: Optional[pulumi.Input[builtins.bool]] = None,
            preserve_data_volumes_created_at_launch: Optional[pulumi.Input[builtins.bool]] = None,
            private_ip: Optional[pulumi.Input[builtins.str]] = None,
            public_ip: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            security_attributes: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            security_attributes_state: Optional[pulumi.Input[builtins.str]] = None,
            shape: Optional[pulumi.Input[builtins.str]] = None,
            shape_config: Optional[pulumi.Input[Union['InstanceShapeConfigArgs', 'InstanceShapeConfigArgsDict']]] = None,
            source_details: Optional[pulumi.Input[Union['InstanceSourceDetailsArgs', 'InstanceSourceDetailsArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_maintenance_reboot_due: Optional[pulumi.Input[builtins.str]] = None,
            update_operation_constraint: Optional[pulumi.Input[builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['InstanceAgentConfigArgs', 'InstanceAgentConfigArgsDict']] agent_config: (Updatable) Configuration options for the Oracle Cloud Agent software running on the instance.
        :param pulumi.Input[Union['InstanceAvailabilityConfigArgs', 'InstanceAvailabilityConfigArgsDict']] availability_config: (Updatable) Options for VM migration during infrastructure maintenance events and for defining the availability of a VM instance after a maintenance event that impacts the underlying hardware.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain of the instance.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] boot_volume_id: The OCID of the attached boot volume. If the `source_type` is `bootVolume`, this will be the same OCID as the `source_id`.
        :param pulumi.Input[builtins.str] capacity_reservation_id: (Updatable) The OCID of the compute capacity reservation this instance is launched under. You can opt out of all default reservations by specifying an empty string as input for this field. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The OCID of the cluster placement group of the instance.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] compute_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) that the instance will be created in.
        :param pulumi.Input[Union['InstanceCreateVnicDetailsArgs', 'InstanceCreateVnicDetailsArgsDict']] create_vnic_details: (Updatable) Contains properties for a VNIC. You use this object when creating the primary VNIC during instance launch or when creating a secondary VNIC. For more information about VNICs, see [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).
        :param pulumi.Input[builtins.str] dedicated_vm_host_id: (Updatable) The OCID of the dedicated virtual machine host to place the instance on.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] fault_domain: (Updatable) A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.
               
               If you do not specify the fault domain, the system selects one for you.
               
               To get a list of fault domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] hostname_label: Deprecated. Instead use `hostnameLabel` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). If you provide both, the values must match.
        :param pulumi.Input[builtins.str] image: Deprecated. Use `sourceDetails` with [InstanceSourceViaImageDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/InstanceSourceViaImageDetails) source type instead. If you specify values for both, the values must match.
        :param pulumi.Input[builtins.str] instance_configuration_id: The OCID of the Instance Configuration containing instance launch details. Any other fields supplied in this instance launch request will override the details stored in the Instance Configuration for this instance launch.
        :param pulumi.Input[Union['InstanceInstanceOptionsArgs', 'InstanceInstanceOptionsArgsDict']] instance_options: (Updatable) Optional mutable instance options
        :param pulumi.Input[builtins.str] ipxe_script: This is an advanced option.
               
               When a bare metal or virtual machine instance boots, the iPXE firmware that runs on the instance is configured to run an iPXE script to continue the boot process.
               
               If you want more control over the boot process, you can provide your own custom iPXE script that will run when the instance boots. Be aware that the same iPXE script will run every time an instance boots, not only after the initial LaunchInstance call.
               
               The default iPXE script connects to the instance's local boot volume over iSCSI and performs a network boot. If you use a custom iPXE script and want to network-boot from the instance's local boot volume over iSCSI the same way as the default iPXE script, use the following iSCSI IP address: 169.254.0.2, and boot volume IQN: iqn.2015-02.oracle.boot.
               
               If your instance boot volume attachment type is paravirtualized, the boot volume is attached to the instance through virtio-scsi and no iPXE script is used. If your instance boot volume attachment type is paravirtualized and you use custom iPXE to network boot into your instance, the primary boot volume is attached as a data volume through virtio-scsi drive.
               
               For more information about the Bring Your Own Image feature of Oracle Cloud Infrastructure, see [Bring Your Own Image](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bringyourownimage.htm).
               
               For more information about iPXE, see http://ipxe.org.
        :param pulumi.Input[builtins.bool] is_cross_numa_node: Whether the instance’s OCPUs and memory are distributed across multiple NUMA nodes.
        :param pulumi.Input[builtins.bool] is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false. Use this field only during create. To update use `is_pv_encryption_in_transit_enabled` under `launch_options` instead.
        :param pulumi.Input[builtins.str] launch_mode: Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
               * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
               * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
               * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
               * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.
        :param pulumi.Input[Union['InstanceLaunchOptionsArgs', 'InstanceLaunchOptionsArgsDict']] launch_options: (Updatable) Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceLaunchVolumeAttachmentArgs', 'InstanceLaunchVolumeAttachmentArgsDict']]]] launch_volume_attachments: Volume attachments to create as part of the launch instance operation.
               
               **Note:** This property is used for initial instance provisioning only. Updates to this property will not be supported. To update volume attachments, user should use `Core.VolumeAttachment`. To update volume details, user should use `Core.Volume`
        :param pulumi.Input[Union['InstanceLicensingConfigsArgs', 'InstanceLicensingConfigsArgsDict']] licensing_configs: (Updatable) List of licensing configurations associated with target launch values.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] metadata: (Updatable) Custom metadata key/value pairs that you provide, such as the SSH public key required to connect to the instance.
               
               A metadata service runs on every launched instance. The service is an HTTP endpoint listening on 169.254.169.254. You can use the service to:
               * Provide information to [Cloud-Init](https://cloudinit.readthedocs.org/en/latest/) to be used for various system initialization tasks.
               * Get information about the instance, including the custom metadata that you provide when you launch the instance.
               
               **Providing Cloud-Init Metadata**
               
               You can use the following metadata key names to provide information to Cloud-Init:
               
               **"ssh_authorized_keys"** - Provide one or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on the instance. Use a newline character to separate multiple keys. The SSH keys must be in the format necessary for the `authorized_keys` file, as shown in the example below.
               
               **"user_data"** - Provide your own base64-encoded data to be used by Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For information about how to take advantage of user data, see the [Cloud-Init Documentation](http://cloudinit.readthedocs.org/en/latest/topics/format.html).
               
               **Metadata Example**
               
               ```
               "metadata" : { "quake_bot_level" : "Severe", "ssh_authorized_keys" : "ssh-rsa <your_public_SSH_key>== rsa-key-20160227", "user_data" : "<your_public_SSH_key>==" }
               ```
               
               **Getting Metadata on the Instance**
               
               To get information about your instance, connect to the instance using SSH and issue any of the following GET requests:
               
               ```
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/
               curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/<any-key-name>
               ```
               
               You'll get back a response that includes all the instance information; only the metadata information; or the metadata information for the specified key name, respectively.
               
               The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of 32,000 bytes.
               
               **Note:** Both the 'user_data' and 'ssh_authorized_keys' fields cannot be changed after an instance has launched. Any request which updates, removes, or adds either of these fields will be rejected. You must provide the same values for 'user_data' and 'ssh_authorized_keys' that already exist on the instance.
        :param pulumi.Input[Union['InstancePlatformConfigArgs', 'InstancePlatformConfigArgsDict']] platform_config: (Updatable only for VM's) The platform configuration requested for the instance.
               
               If you provide the parameter, the instance is created with the platform configuration that you specify. For any values that you omit, the instance uses the default configuration values for the `shape` that you specify. If you don't provide the parameter, the default values for the `shape` are used.
               
               Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
               
               For more information about shielded instances, see [Shielded Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/shielded-instances.htm).
               
               For more information about BIOS settings for bare metal instances, see [BIOS Settings for Bare Metal Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bios-settings.htm).
        :param pulumi.Input[Union['InstancePreemptibleInstanceConfigArgs', 'InstancePreemptibleInstanceConfigArgsDict']] preemptible_instance_config: Configuration options for preemptible instances.
        :param pulumi.Input[builtins.bool] preserve_boot_volume: (Optional) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        :param pulumi.Input[builtins.str] private_ip: The private IP address of instance VNIC. To set the private IP address, use the `private_ip` argument in create_vnic_details.
        :param pulumi.Input[builtins.str] public_ip: The public IP address of instance VNIC (if enabled).
        :param pulumi.Input[builtins.str] region: The region that contains the availability domain the instance is running in.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] security_attributes: (Updatable) [Security attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes) are labels for a resource that can be referenced in a [Zero Trust Packet Routing](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm) (ZPR) policy to control access to ZPR-supported resources.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
        :param pulumi.Input[builtins.str] security_attributes_state: The lifecycle state of the `securityAttributes`
        :param pulumi.Input[builtins.str] shape: (Updatable) The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.
               
               You can enumerate all available shapes by calling [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Shape/ListShapes).
        :param pulumi.Input[Union['InstanceShapeConfigArgs', 'InstanceShapeConfigArgsDict']] shape_config: (Updatable) The shape configuration requested for the instance.
               
               If the parameter is provided, the instance is created with the resources that you specify. If some properties are missing or the entire parameter is not provided, the instance is created with the default configuration values for the `shape` that you specify.
               
               Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
        :param pulumi.Input[Union['InstanceSourceDetailsArgs', 'InstanceSourceDetailsArgsDict']] source_details: (Updatable)
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the instance. Could be set to RUNNING or STOPPED.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] subnet_id: Deprecated. Instead use `subnetId` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). At least one of them is required; if you provide both, the values must match.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] time_created: The date and time the instance was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_maintenance_reboot_due: The date and time the instance is expected to be stopped / started,  in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). After that time if instance hasn't been rebooted, Oracle will reboot the instance within 24 hours of the due time. Regardless of how the instance was stopped, the flag will be reset to empty as soon as instance reaches Stopped state. Example: `2018-05-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["agent_config"] = agent_config
        __props__.__dict__["async_"] = async_
        __props__.__dict__["availability_config"] = availability_config
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["boot_volume_id"] = boot_volume_id
        __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
        __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_cluster_id"] = compute_cluster_id
        __props__.__dict__["create_vnic_details"] = create_vnic_details
        __props__.__dict__["dedicated_vm_host_id"] = dedicated_vm_host_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["extended_metadata"] = extended_metadata
        __props__.__dict__["fault_domain"] = fault_domain
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname_label"] = hostname_label
        __props__.__dict__["image"] = image
        __props__.__dict__["instance_configuration_id"] = instance_configuration_id
        __props__.__dict__["instance_options"] = instance_options
        __props__.__dict__["ipxe_script"] = ipxe_script
        __props__.__dict__["is_cross_numa_node"] = is_cross_numa_node
        __props__.__dict__["is_pv_encryption_in_transit_enabled"] = is_pv_encryption_in_transit_enabled
        __props__.__dict__["launch_mode"] = launch_mode
        __props__.__dict__["launch_options"] = launch_options
        __props__.__dict__["launch_volume_attachments"] = launch_volume_attachments
        __props__.__dict__["licensing_configs"] = licensing_configs
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["platform_config"] = platform_config
        __props__.__dict__["preemptible_instance_config"] = preemptible_instance_config
        __props__.__dict__["preserve_boot_volume"] = preserve_boot_volume
        __props__.__dict__["preserve_data_volumes_created_at_launch"] = preserve_data_volumes_created_at_launch
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["security_attributes"] = security_attributes
        __props__.__dict__["security_attributes_state"] = security_attributes_state
        __props__.__dict__["shape"] = shape
        __props__.__dict__["shape_config"] = shape_config
        __props__.__dict__["source_details"] = source_details
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_maintenance_reboot_due"] = time_maintenance_reboot_due
        __props__.__dict__["update_operation_constraint"] = update_operation_constraint
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="agentConfig")
    def agent_config(self) -> pulumi.Output['outputs.InstanceAgentConfig']:
        """
        (Updatable) Configuration options for the Oracle Cloud Agent software running on the instance.
        """
        return pulumi.get(self, "agent_config")

    @property
    @pulumi.getter(name="async")
    def async_(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "async_")

    @property
    @pulumi.getter(name="availabilityConfig")
    def availability_config(self) -> pulumi.Output['outputs.InstanceAvailabilityConfig']:
        """
        (Updatable) Options for VM migration during infrastructure maintenance events and for defining the availability of a VM instance after a maintenance event that impacts the underlying hardware.
        """
        return pulumi.get(self, "availability_config")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The availability domain of the instance.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="bootVolumeId")
    def boot_volume_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the attached boot volume. If the `source_type` is `bootVolume`, this will be the same OCID as the `source_id`.
        """
        return pulumi.get(self, "boot_volume_id")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compute capacity reservation this instance is launched under. You can opt out of all default reservations by specifying an empty string as input for this field. For more information, see [Capacity Reservations](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/reserve-capacity.htm#default).
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The OCID of the cluster placement group of the instance.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeClusterId")
    def compute_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [compute cluster](https://docs.cloud.oracle.com/iaas/Content/Compute/Tasks/compute-clusters.htm) that the instance will be created in.
        """
        return pulumi.get(self, "compute_cluster_id")

    @property
    @pulumi.getter(name="createVnicDetails")
    def create_vnic_details(self) -> pulumi.Output['outputs.InstanceCreateVnicDetails']:
        """
        (Updatable) Contains properties for a VNIC. You use this object when creating the primary VNIC during instance launch or when creating a secondary VNIC. For more information about VNICs, see [Virtual Network Interface Cards (VNICs)](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/managingVNICs.htm).
        """
        return pulumi.get(self, "create_vnic_details")

    @property
    @pulumi.getter(name="dedicatedVmHostId")
    def dedicated_vm_host_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the dedicated virtual machine host to place the instance on.
        """
        return pulumi.get(self, "dedicated_vm_host_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="extendedMetadata")
    def extended_metadata(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "extended_metadata")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A fault domain is a grouping of hardware and infrastructure within an availability domain. Each availability domain contains three fault domains. Fault domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or Compute hardware maintenance that affects one fault domain does not affect instances in other fault domains.

        If you do not specify the fault domain, the system selects one for you.

        To get a list of fault domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/20160918/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostnameLabel")
    @_utilities.deprecated("""The 'hostname_label' field has been deprecated. Please use 'hostname_label under create_vnic_details' instead.""")
    def hostname_label(self) -> pulumi.Output[builtins.str]:
        """
        Deprecated. Instead use `hostnameLabel` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). If you provide both, the values must match.
        """
        return pulumi.get(self, "hostname_label")

    @property
    @pulumi.getter
    @_utilities.deprecated("""The 'image' field has been deprecated. Please use 'source_details' instead. If both fields are specified, then 'source_details' will be used.""")
    def image(self) -> pulumi.Output[builtins.str]:
        """
        Deprecated. Use `sourceDetails` with [InstanceSourceViaImageDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/requests/InstanceSourceViaImageDetails) source type instead. If you specify values for both, the values must match.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the Instance Configuration containing instance launch details. Any other fields supplied in this instance launch request will override the details stored in the Instance Configuration for this instance launch.
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceOptions")
    def instance_options(self) -> pulumi.Output['outputs.InstanceInstanceOptions']:
        """
        (Updatable) Optional mutable instance options
        """
        return pulumi.get(self, "instance_options")

    @property
    @pulumi.getter(name="ipxeScript")
    def ipxe_script(self) -> pulumi.Output[builtins.str]:
        """
        This is an advanced option.

        When a bare metal or virtual machine instance boots, the iPXE firmware that runs on the instance is configured to run an iPXE script to continue the boot process.

        If you want more control over the boot process, you can provide your own custom iPXE script that will run when the instance boots. Be aware that the same iPXE script will run every time an instance boots, not only after the initial LaunchInstance call.

        The default iPXE script connects to the instance's local boot volume over iSCSI and performs a network boot. If you use a custom iPXE script and want to network-boot from the instance's local boot volume over iSCSI the same way as the default iPXE script, use the following iSCSI IP address: 169.254.0.2, and boot volume IQN: iqn.2015-02.oracle.boot.

        If your instance boot volume attachment type is paravirtualized, the boot volume is attached to the instance through virtio-scsi and no iPXE script is used. If your instance boot volume attachment type is paravirtualized and you use custom iPXE to network boot into your instance, the primary boot volume is attached as a data volume through virtio-scsi drive.

        For more information about the Bring Your Own Image feature of Oracle Cloud Infrastructure, see [Bring Your Own Image](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bringyourownimage.htm).

        For more information about iPXE, see http://ipxe.org.
        """
        return pulumi.get(self, "ipxe_script")

    @property
    @pulumi.getter(name="isCrossNumaNode")
    def is_cross_numa_node(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the instance’s OCPUs and memory are distributed across multiple NUMA nodes.
        """
        return pulumi.get(self, "is_cross_numa_node")

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. The default value is false. Use this field only during create. To update use `is_pv_encryption_in_transit_enabled` under `launch_options` instead.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @property
    @pulumi.getter(name="launchMode")
    def launch_mode(self) -> pulumi.Output[builtins.str]:
        """
        Specifies the configuration mode for launching virtual machine (VM) instances. The configuration modes are:
        * `NATIVE` - VM instances launch with iSCSI boot and VFIO devices. The default value for platform images.
        * `EMULATED` - VM instances launch with emulated devices, such as the E1000 network driver and emulated SCSI disk controller.
        * `PARAVIRTUALIZED` - VM instances launch with paravirtualized devices using VirtIO drivers.
        * `CUSTOM` - VM instances launch with custom configuration settings specified in the `LaunchOptions` parameter.
        """
        return pulumi.get(self, "launch_mode")

    @property
    @pulumi.getter(name="launchOptions")
    def launch_options(self) -> pulumi.Output['outputs.InstanceLaunchOptions']:
        """
        (Updatable) Options for tuning the compatibility and performance of VM shapes. The values that you specify override any default values.
        """
        return pulumi.get(self, "launch_options")

    @property
    @pulumi.getter(name="launchVolumeAttachments")
    def launch_volume_attachments(self) -> pulumi.Output[Sequence['outputs.InstanceLaunchVolumeAttachment']]:
        """
        Volume attachments to create as part of the launch instance operation.

        **Note:** This property is used for initial instance provisioning only. Updates to this property will not be supported. To update volume attachments, user should use `Core.VolumeAttachment`. To update volume details, user should use `Core.Volume`
        """
        return pulumi.get(self, "launch_volume_attachments")

    @property
    @pulumi.getter(name="licensingConfigs")
    def licensing_configs(self) -> pulumi.Output['outputs.InstanceLicensingConfigs']:
        """
        (Updatable) List of licensing configurations associated with target launch values.
        """
        return pulumi.get(self, "licensing_configs")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Custom metadata key/value pairs that you provide, such as the SSH public key required to connect to the instance.

        A metadata service runs on every launched instance. The service is an HTTP endpoint listening on 169.254.169.254. You can use the service to:
        * Provide information to [Cloud-Init](https://cloudinit.readthedocs.org/en/latest/) to be used for various system initialization tasks.
        * Get information about the instance, including the custom metadata that you provide when you launch the instance.

        **Providing Cloud-Init Metadata**

        You can use the following metadata key names to provide information to Cloud-Init:

        **"ssh_authorized_keys"** - Provide one or more public SSH keys to be included in the `~/.ssh/authorized_keys` file for the default user on the instance. Use a newline character to separate multiple keys. The SSH keys must be in the format necessary for the `authorized_keys` file, as shown in the example below.

        **"user_data"** - Provide your own base64-encoded data to be used by Cloud-Init to run custom scripts or provide custom Cloud-Init configuration. For information about how to take advantage of user data, see the [Cloud-Init Documentation](http://cloudinit.readthedocs.org/en/latest/topics/format.html).

        **Metadata Example**

        ```
        "metadata" : { "quake_bot_level" : "Severe", "ssh_authorized_keys" : "ssh-rsa <your_public_SSH_key>== rsa-key-20160227", "user_data" : "<your_public_SSH_key>==" }
        ```

        **Getting Metadata on the Instance**

        To get information about your instance, connect to the instance using SSH and issue any of the following GET requests:

        ```
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/
        curl -H "Authorization: Bearer Oracle" http://169.254.169.254/opc/v2/instance/metadata/<any-key-name>
        ```

        You'll get back a response that includes all the instance information; only the metadata information; or the metadata information for the specified key name, respectively.

        The combined size of the `metadata` and `extendedMetadata` objects can be a maximum of 32,000 bytes.

        **Note:** Both the 'user_data' and 'ssh_authorized_keys' fields cannot be changed after an instance has launched. Any request which updates, removes, or adds either of these fields will be rejected. You must provide the same values for 'user_data' and 'ssh_authorized_keys' that already exist on the instance.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="platformConfig")
    def platform_config(self) -> pulumi.Output['outputs.InstancePlatformConfig']:
        """
        (Updatable only for VM's) The platform configuration requested for the instance.

        If you provide the parameter, the instance is created with the platform configuration that you specify. For any values that you omit, the instance uses the default configuration values for the `shape` that you specify. If you don't provide the parameter, the default values for the `shape` are used.

        Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.

        For more information about shielded instances, see [Shielded Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/shielded-instances.htm).

        For more information about BIOS settings for bare metal instances, see [BIOS Settings for Bare Metal Instances](https://docs.cloud.oracle.com/iaas/Content/Compute/References/bios-settings.htm).
        """
        return pulumi.get(self, "platform_config")

    @property
    @pulumi.getter(name="preemptibleInstanceConfig")
    def preemptible_instance_config(self) -> pulumi.Output['outputs.InstancePreemptibleInstanceConfig']:
        """
        Configuration options for preemptible instances.
        """
        return pulumi.get(self, "preemptible_instance_config")

    @property
    @pulumi.getter(name="preserveBootVolume")
    def preserve_boot_volume(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        (Optional) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "preserve_boot_volume")

    @property
    @pulumi.getter(name="preserveDataVolumesCreatedAtLaunch")
    def preserve_data_volumes_created_at_launch(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "preserve_data_volumes_created_at_launch")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[builtins.str]:
        """
        The private IP address of instance VNIC. To set the private IP address, use the `private_ip` argument in create_vnic_details.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[builtins.str]:
        """
        The public IP address of instance VNIC (if enabled).
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        The region that contains the availability domain the instance is running in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityAttributes")
    def security_attributes(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) [Security attributes](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/zpr-artifacts.htm#security-attributes) are labels for a resource that can be referenced in a [Zero Trust Packet Routing](https://docs.cloud.oracle.com/iaas/Content/zero-trust-packet-routing/overview.htm) (ZPR) policy to control access to ZPR-supported resources.  Example: `{"Oracle-DataSecurity-ZPR.MaxEgressCount.value": "42", "Oracle-DataSecurity-ZPR.MaxEgressCount.mode": "audit"}`
        """
        return pulumi.get(self, "security_attributes")

    @property
    @pulumi.getter(name="securityAttributesState")
    def security_attributes_state(self) -> pulumi.Output[builtins.str]:
        """
        The lifecycle state of the `securityAttributes`
        """
        return pulumi.get(self, "security_attributes_state")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The shape of an instance. The shape determines the number of CPUs, amount of memory, and other resources allocated to the instance.

        You can enumerate all available shapes by calling [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Shape/ListShapes).
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeConfig")
    def shape_config(self) -> pulumi.Output['outputs.InstanceShapeConfig']:
        """
        (Updatable) The shape configuration requested for the instance.

        If the parameter is provided, the instance is created with the resources that you specify. If some properties are missing or the entire parameter is not provided, the instance is created with the default configuration values for the `shape` that you specify.

        Each shape only supports certain configurable values. If the values that you provide are not valid for the specified `shape`, an error is returned.
        """
        return pulumi.get(self, "shape_config")

    @property
    @pulumi.getter(name="sourceDetails")
    def source_details(self) -> pulumi.Output['outputs.InstanceSourceDetails']:
        """
        (Updatable)
        """
        return pulumi.get(self, "source_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The target state for the instance. Could be set to RUNNING or STOPPED.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    @_utilities.deprecated("""The 'subnet_id' field has been deprecated. Please use 'subnet_id under create_vnic_details' instead.""")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        Deprecated. Instead use `subnetId` in [CreateVnicDetails](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/CreateVnicDetails/). At least one of them is required; if you provide both, the values must match.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the instance was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeMaintenanceRebootDue")
    def time_maintenance_reboot_due(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the instance is expected to be stopped / started,  in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). After that time if instance hasn't been rebooted, Oracle will reboot the instance within 24 hours of the due time. Regardless of how the instance was stopped, the flag will be reset to empty as soon as instance reaches Stopped state. Example: `2018-05-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_maintenance_reboot_due")

    @property
    @pulumi.getter(name="updateOperationConstraint")
    def update_operation_constraint(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "update_operation_constraint")

