# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IpsecArgs', 'Ipsec']

@pulumi.input_type
class IpsecArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 cpe_id: pulumi.Input[builtins.str],
                 drg_id: pulumi.Input[builtins.str],
                 static_routes: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 cpe_local_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_local_identifier_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tunnel_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecTunnelConfigurationArgs']]]] = None):
        """
        The set of arguments for constructing a Ipsec resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the IPSec connection.
        :param pulumi.Input[builtins.str] cpe_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] static_routes: (Updatable) Static routes to the CPE. A static route's CIDR must not be a multicast address or class E address.
               
               Used for routing a given IPSec tunnel's traffic only if the tunnel is using static routing. If you configure at least one tunnel to use static routing, then you must provide at least one valid static route. If you configure both tunnels to use BGP dynamic routing, you can provide an empty list for the static routes on update. For more information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).
               
               Example: `10.0.1.0/24`
        :param pulumi.Input[builtins.str] cpe_local_identifier: (Updatable) Your identifier for your CPE device. Can be either an IP address or a hostname (specifically, the fully qualified domain name (FQDN)). The type of identifier you provide here must correspond to the value for `cpeLocalIdentifierType`.
               
               If you don't provide a value, the `ipAddress` attribute for the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object specified by `cpeId` is used as the `cpeLocalIdentifier`.
               
               For information about why you'd provide this value, see [If Your CPE Is Behind a NAT Device](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm#nat).
               
               Example IP address: `10.0.3.3`
               
               Example hostname: `cpe.example.com`
        :param pulumi.Input[builtins.str] cpe_local_identifier_type: (Updatable) The type of identifier for your CPE device. The value you provide here must correspond to the value for `cpeLocalIdentifier`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['IpsecTunnelConfigurationArgs']]] tunnel_configurations: (Non-updatable) Tunnel configuration for private ipsec connection over fastconnect.
               
               Example: `
               tunnel_configuration {
               oracle_tunnel_ip = "10.1.5.5"
               associated_virtual_circuits = [oci_core_virtual_circuit.test_ipsec_over_fc_virtual_circuit.id]
               drg_route_table_id = oci_core_drg_route_table.test_drg_ipsec_over_fc_route_table.id
               }`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "cpe_id", cpe_id)
        pulumi.set(__self__, "drg_id", drg_id)
        pulumi.set(__self__, "static_routes", static_routes)
        if cpe_local_identifier is not None:
            pulumi.set(__self__, "cpe_local_identifier", cpe_local_identifier)
        if cpe_local_identifier_type is not None:
            pulumi.set(__self__, "cpe_local_identifier_type", cpe_local_identifier_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if tunnel_configurations is not None:
            pulumi.set(__self__, "tunnel_configurations", tunnel_configurations)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the IPSec connection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpeId")
    def cpe_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.
        """
        return pulumi.get(self, "cpe_id")

    @cpe_id.setter
    def cpe_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cpe_id", value)

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @drg_id.setter
    def drg_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "drg_id", value)

    @property
    @pulumi.getter(name="staticRoutes")
    def static_routes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) Static routes to the CPE. A static route's CIDR must not be a multicast address or class E address.

        Used for routing a given IPSec tunnel's traffic only if the tunnel is using static routing. If you configure at least one tunnel to use static routing, then you must provide at least one valid static route. If you configure both tunnels to use BGP dynamic routing, you can provide an empty list for the static routes on update. For more information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).

        Example: `10.0.1.0/24`
        """
        return pulumi.get(self, "static_routes")

    @static_routes.setter
    def static_routes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "static_routes", value)

    @property
    @pulumi.getter(name="cpeLocalIdentifier")
    def cpe_local_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Your identifier for your CPE device. Can be either an IP address or a hostname (specifically, the fully qualified domain name (FQDN)). The type of identifier you provide here must correspond to the value for `cpeLocalIdentifierType`.

        If you don't provide a value, the `ipAddress` attribute for the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object specified by `cpeId` is used as the `cpeLocalIdentifier`.

        For information about why you'd provide this value, see [If Your CPE Is Behind a NAT Device](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm#nat).

        Example IP address: `10.0.3.3`

        Example hostname: `cpe.example.com`
        """
        return pulumi.get(self, "cpe_local_identifier")

    @cpe_local_identifier.setter
    def cpe_local_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpe_local_identifier", value)

    @property
    @pulumi.getter(name="cpeLocalIdentifierType")
    def cpe_local_identifier_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of identifier for your CPE device. The value you provide here must correspond to the value for `cpeLocalIdentifier`.
        """
        return pulumi.get(self, "cpe_local_identifier_type")

    @cpe_local_identifier_type.setter
    def cpe_local_identifier_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpe_local_identifier_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="tunnelConfigurations")
    def tunnel_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpsecTunnelConfigurationArgs']]]]:
        """
        (Non-updatable) Tunnel configuration for private ipsec connection over fastconnect.

        Example: `
        tunnel_configuration {
        oracle_tunnel_ip = "10.1.5.5"
        associated_virtual_circuits = [oci_core_virtual_circuit.test_ipsec_over_fc_virtual_circuit.id]
        drg_route_table_id = oci_core_drg_route_table.test_drg_ipsec_over_fc_route_table.id
        }`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tunnel_configurations")

    @tunnel_configurations.setter
    def tunnel_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecTunnelConfigurationArgs']]]]):
        pulumi.set(self, "tunnel_configurations", value)


@pulumi.input_type
class _IpsecState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_id: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_local_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_local_identifier_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 transport_type: Optional[pulumi.Input[builtins.str]] = None,
                 tunnel_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecTunnelConfigurationArgs']]]] = None):
        """
        Input properties used for looking up and filtering Ipsec resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the IPSec connection.
        :param pulumi.Input[builtins.str] cpe_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.
        :param pulumi.Input[builtins.str] cpe_local_identifier: (Updatable) Your identifier for your CPE device. Can be either an IP address or a hostname (specifically, the fully qualified domain name (FQDN)). The type of identifier you provide here must correspond to the value for `cpeLocalIdentifierType`.
               
               If you don't provide a value, the `ipAddress` attribute for the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object specified by `cpeId` is used as the `cpeLocalIdentifier`.
               
               For information about why you'd provide this value, see [If Your CPE Is Behind a NAT Device](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm#nat).
               
               Example IP address: `10.0.3.3`
               
               Example hostname: `cpe.example.com`
        :param pulumi.Input[builtins.str] cpe_local_identifier_type: (Updatable) The type of identifier for your CPE device. The value you provide here must correspond to the value for `cpeLocalIdentifier`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] state: The IPSec connection's current state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] static_routes: (Updatable) Static routes to the CPE. A static route's CIDR must not be a multicast address or class E address.
               
               Used for routing a given IPSec tunnel's traffic only if the tunnel is using static routing. If you configure at least one tunnel to use static routing, then you must provide at least one valid static route. If you configure both tunnels to use BGP dynamic routing, you can provide an empty list for the static routes on update. For more information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).
               
               Example: `10.0.1.0/24`
        :param pulumi.Input[builtins.str] time_created: The date and time the IPSec connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] transport_type: The transport type used for the IPSec connection.
        :param pulumi.Input[Sequence[pulumi.Input['IpsecTunnelConfigurationArgs']]] tunnel_configurations: (Non-updatable) Tunnel configuration for private ipsec connection over fastconnect.
               
               Example: `
               tunnel_configuration {
               oracle_tunnel_ip = "10.1.5.5"
               associated_virtual_circuits = [oci_core_virtual_circuit.test_ipsec_over_fc_virtual_circuit.id]
               drg_route_table_id = oci_core_drg_route_table.test_drg_ipsec_over_fc_route_table.id
               }`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cpe_id is not None:
            pulumi.set(__self__, "cpe_id", cpe_id)
        if cpe_local_identifier is not None:
            pulumi.set(__self__, "cpe_local_identifier", cpe_local_identifier)
        if cpe_local_identifier_type is not None:
            pulumi.set(__self__, "cpe_local_identifier_type", cpe_local_identifier_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if drg_id is not None:
            pulumi.set(__self__, "drg_id", drg_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if static_routes is not None:
            pulumi.set(__self__, "static_routes", static_routes)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if transport_type is not None:
            pulumi.set(__self__, "transport_type", transport_type)
        if tunnel_configurations is not None:
            pulumi.set(__self__, "tunnel_configurations", tunnel_configurations)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the IPSec connection.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpeId")
    def cpe_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.
        """
        return pulumi.get(self, "cpe_id")

    @cpe_id.setter
    def cpe_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpe_id", value)

    @property
    @pulumi.getter(name="cpeLocalIdentifier")
    def cpe_local_identifier(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Your identifier for your CPE device. Can be either an IP address or a hostname (specifically, the fully qualified domain name (FQDN)). The type of identifier you provide here must correspond to the value for `cpeLocalIdentifierType`.

        If you don't provide a value, the `ipAddress` attribute for the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object specified by `cpeId` is used as the `cpeLocalIdentifier`.

        For information about why you'd provide this value, see [If Your CPE Is Behind a NAT Device](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm#nat).

        Example IP address: `10.0.3.3`

        Example hostname: `cpe.example.com`
        """
        return pulumi.get(self, "cpe_local_identifier")

    @cpe_local_identifier.setter
    def cpe_local_identifier(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpe_local_identifier", value)

    @property
    @pulumi.getter(name="cpeLocalIdentifierType")
    def cpe_local_identifier_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The type of identifier for your CPE device. The value you provide here must correspond to the value for `cpeLocalIdentifier`.
        """
        return pulumi.get(self, "cpe_local_identifier_type")

    @cpe_local_identifier_type.setter
    def cpe_local_identifier_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cpe_local_identifier_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @drg_id.setter
    def drg_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "drg_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The IPSec connection's current state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="staticRoutes")
    def static_routes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Static routes to the CPE. A static route's CIDR must not be a multicast address or class E address.

        Used for routing a given IPSec tunnel's traffic only if the tunnel is using static routing. If you configure at least one tunnel to use static routing, then you must provide at least one valid static route. If you configure both tunnels to use BGP dynamic routing, you can provide an empty list for the static routes on update. For more information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).

        Example: `10.0.1.0/24`
        """
        return pulumi.get(self, "static_routes")

    @static_routes.setter
    def static_routes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "static_routes", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the IPSec connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The transport type used for the IPSec connection.
        """
        return pulumi.get(self, "transport_type")

    @transport_type.setter
    def transport_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "transport_type", value)

    @property
    @pulumi.getter(name="tunnelConfigurations")
    def tunnel_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IpsecTunnelConfigurationArgs']]]]:
        """
        (Non-updatable) Tunnel configuration for private ipsec connection over fastconnect.

        Example: `
        tunnel_configuration {
        oracle_tunnel_ip = "10.1.5.5"
        associated_virtual_circuits = [oci_core_virtual_circuit.test_ipsec_over_fc_virtual_circuit.id]
        drg_route_table_id = oci_core_drg_route_table.test_drg_ipsec_over_fc_route_table.id
        }`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tunnel_configurations")

    @tunnel_configurations.setter
    def tunnel_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IpsecTunnelConfigurationArgs']]]]):
        pulumi.set(self, "tunnel_configurations", value)


class Ipsec(pulumi.CustomResource):

    pulumi_type = "oci:Core/ipsec:Ipsec"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_id: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_local_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_local_identifier_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpsecTunnelConfigurationArgs', 'IpsecTunnelConfigurationArgsDict']]]]] = None,
                 __props__=None):
        """
        This resource provides the Ip Sec Connection resource in Oracle Cloud Infrastructure Core service.

        Creates a new IPSec connection between the specified DRG and CPE with two default static tunnels. For more information, see
        [Site-to-Site VPN Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want the
        IPSec connection to reside. Notice that the IPSec connection doesn't have to be in the same compartment
        as the DRG, CPE, or other Networking Service components. If you're not sure which compartment to
        use, put the IPSec connection in the same compartment as the DRG. For more information about
        compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        You may optionally specify a *display name* for the IPSec connection, otherwise a default is provided.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        After creating the IPSec connection, you need to configure your on-premises router
        with tunnel-specific information. For tunnel status and the required configuration information, see:

          * [IPSecConnectionTunnel](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnel/)
          * [IPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnelSharedSecret/)

        To configure tunnel-specific information, use `Core.IpsecConnectionTunnelManagement` to update the tunnels. If
        you configure at least one tunnel to use static routing, then in the Core.Ipsec request you must provide
        at least one valid static route (you're allowed a maximum of 10). For example: 10.0.0.0/16.
        If you configure both tunnels to use BGP dynamic routing, the static routes will be ignored. However, you must provide a
        static route in `Core.Ipsec` even if you plan to use BGP routing because it defaults to two static tunnels.  For more
        information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).

        For each tunnel, you need the IP address of Oracle's VPN headend and the shared secret
        (that is, the pre-shared key). For more information, see
        [CPE Configuration](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/configuringCPE.htm).

        To configure tunnel-specific information for private ipsec connection over fastconnect, use attribute `tunnel_configuration`.
        You can provide configuration for maximum of 2 tunnels. You can configure each tunnel with `oracle_tunnel_ip`,
        `associated_virtual_circuits` and `drg_route_table_id` at time of creation. These attributes cannot be updated using IPSec
        connection APIs. To update drg route table id, use `Core.DrgAttachmentManagement` resource to update.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ip_sec_connection = oci.core.Ipsec("test_ip_sec_connection",
            compartment_id=compartment_id,
            cpe_id=test_cpe["id"],
            drg_id=test_drg["id"],
            static_routes=ip_sec_connection_static_routes,
            cpe_local_identifier=ip_sec_connection_cpe_local_identifier,
            cpe_local_identifier_type=ip_sec_connection_cpe_local_identifier_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=ip_sec_connection_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        test_ip_sec_connection_over_fc = oci.core.Ipsec("test_ip_sec_connection_over_fc",
            compartment_id=compartment_id,
            cpe_id=test_cpe["id"],
            drg_id=test_drg["id"],
            static_routes=ip_sec_connection_static_routes,
            cpe_local_identifier=ip_sec_connection_cpe_local_identifier,
            cpe_local_identifier_type=ip_sec_connection_cpe_local_identifier_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=ip_sec_connection_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            tunnel_configurations=[
                {
                    "oracle_tunnel_ip": "10.1.5.5",
                    "associated_virtual_circuits": [test_ipsec_over_fc_virtual_circuit["id"]],
                    "drg_route_table_id": test_drg_ipsec_over_fc_route_table["id"],
                },
                {
                    "oracle_tunnel_ip": "10.1.7.7",
                    "associated_virtual_circuits": [test_ipsec_over_fc_virtual_circuit["id"]],
                    "drg_route_table_id": test_drg_ipsec_over_fc_route_table["id"],
                },
            ])
        ```

        ## Import

        IpSecConnections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/ipsec:Ipsec test_ip_sec_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the IPSec connection.
        :param pulumi.Input[builtins.str] cpe_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.
        :param pulumi.Input[builtins.str] cpe_local_identifier: (Updatable) Your identifier for your CPE device. Can be either an IP address or a hostname (specifically, the fully qualified domain name (FQDN)). The type of identifier you provide here must correspond to the value for `cpeLocalIdentifierType`.
               
               If you don't provide a value, the `ipAddress` attribute for the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object specified by `cpeId` is used as the `cpeLocalIdentifier`.
               
               For information about why you'd provide this value, see [If Your CPE Is Behind a NAT Device](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm#nat).
               
               Example IP address: `10.0.3.3`
               
               Example hostname: `cpe.example.com`
        :param pulumi.Input[builtins.str] cpe_local_identifier_type: (Updatable) The type of identifier for your CPE device. The value you provide here must correspond to the value for `cpeLocalIdentifier`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] static_routes: (Updatable) Static routes to the CPE. A static route's CIDR must not be a multicast address or class E address.
               
               Used for routing a given IPSec tunnel's traffic only if the tunnel is using static routing. If you configure at least one tunnel to use static routing, then you must provide at least one valid static route. If you configure both tunnels to use BGP dynamic routing, you can provide an empty list for the static routes on update. For more information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).
               
               Example: `10.0.1.0/24`
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpsecTunnelConfigurationArgs', 'IpsecTunnelConfigurationArgsDict']]]] tunnel_configurations: (Non-updatable) Tunnel configuration for private ipsec connection over fastconnect.
               
               Example: `
               tunnel_configuration {
               oracle_tunnel_ip = "10.1.5.5"
               associated_virtual_circuits = [oci_core_virtual_circuit.test_ipsec_over_fc_virtual_circuit.id]
               drg_route_table_id = oci_core_drg_route_table.test_drg_ipsec_over_fc_route_table.id
               }`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IpsecArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Ip Sec Connection resource in Oracle Cloud Infrastructure Core service.

        Creates a new IPSec connection between the specified DRG and CPE with two default static tunnels. For more information, see
        [Site-to-Site VPN Overview](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm).

        For the purposes of access control, you must provide the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment where you want the
        IPSec connection to reside. Notice that the IPSec connection doesn't have to be in the same compartment
        as the DRG, CPE, or other Networking Service components. If you're not sure which compartment to
        use, put the IPSec connection in the same compartment as the DRG. For more information about
        compartments and access control, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        You may optionally specify a *display name* for the IPSec connection, otherwise a default is provided.
        It does not have to be unique, and you can change it. Avoid entering confidential information.

        After creating the IPSec connection, you need to configure your on-premises router
        with tunnel-specific information. For tunnel status and the required configuration information, see:

          * [IPSecConnectionTunnel](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnel/)
          * [IPSecConnectionTunnelSharedSecret](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnelSharedSecret/)

        To configure tunnel-specific information, use `Core.IpsecConnectionTunnelManagement` to update the tunnels. If
        you configure at least one tunnel to use static routing, then in the Core.Ipsec request you must provide
        at least one valid static route (you're allowed a maximum of 10). For example: 10.0.0.0/16.
        If you configure both tunnels to use BGP dynamic routing, the static routes will be ignored. However, you must provide a
        static route in `Core.Ipsec` even if you plan to use BGP routing because it defaults to two static tunnels.  For more
        information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).

        For each tunnel, you need the IP address of Oracle's VPN headend and the shared secret
        (that is, the pre-shared key). For more information, see
        [CPE Configuration](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/configuringCPE.htm).

        To configure tunnel-specific information for private ipsec connection over fastconnect, use attribute `tunnel_configuration`.
        You can provide configuration for maximum of 2 tunnels. You can configure each tunnel with `oracle_tunnel_ip`,
        `associated_virtual_circuits` and `drg_route_table_id` at time of creation. These attributes cannot be updated using IPSec
        connection APIs. To update drg route table id, use `Core.DrgAttachmentManagement` resource to update.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_ip_sec_connection = oci.core.Ipsec("test_ip_sec_connection",
            compartment_id=compartment_id,
            cpe_id=test_cpe["id"],
            drg_id=test_drg["id"],
            static_routes=ip_sec_connection_static_routes,
            cpe_local_identifier=ip_sec_connection_cpe_local_identifier,
            cpe_local_identifier_type=ip_sec_connection_cpe_local_identifier_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=ip_sec_connection_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        test_ip_sec_connection_over_fc = oci.core.Ipsec("test_ip_sec_connection_over_fc",
            compartment_id=compartment_id,
            cpe_id=test_cpe["id"],
            drg_id=test_drg["id"],
            static_routes=ip_sec_connection_static_routes,
            cpe_local_identifier=ip_sec_connection_cpe_local_identifier,
            cpe_local_identifier_type=ip_sec_connection_cpe_local_identifier_type,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=ip_sec_connection_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            tunnel_configurations=[
                {
                    "oracle_tunnel_ip": "10.1.5.5",
                    "associated_virtual_circuits": [test_ipsec_over_fc_virtual_circuit["id"]],
                    "drg_route_table_id": test_drg_ipsec_over_fc_route_table["id"],
                },
                {
                    "oracle_tunnel_ip": "10.1.7.7",
                    "associated_virtual_circuits": [test_ipsec_over_fc_virtual_circuit["id"]],
                    "drg_route_table_id": test_drg_ipsec_over_fc_route_table["id"],
                },
            ])
        ```

        ## Import

        IpSecConnections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/ipsec:Ipsec test_ip_sec_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param IpsecArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IpsecArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_id: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_local_identifier: Optional[pulumi.Input[builtins.str]] = None,
                 cpe_local_identifier_type: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 drg_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tunnel_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpsecTunnelConfigurationArgs', 'IpsecTunnelConfigurationArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IpsecArgs.__new__(IpsecArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if cpe_id is None and not opts.urn:
                raise TypeError("Missing required property 'cpe_id'")
            __props__.__dict__["cpe_id"] = cpe_id
            __props__.__dict__["cpe_local_identifier"] = cpe_local_identifier
            __props__.__dict__["cpe_local_identifier_type"] = cpe_local_identifier_type
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if drg_id is None and not opts.urn:
                raise TypeError("Missing required property 'drg_id'")
            __props__.__dict__["drg_id"] = drg_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            if static_routes is None and not opts.urn:
                raise TypeError("Missing required property 'static_routes'")
            __props__.__dict__["static_routes"] = static_routes
            __props__.__dict__["tunnel_configurations"] = tunnel_configurations
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["transport_type"] = None
        super(Ipsec, __self__).__init__(
            'oci:Core/ipsec:Ipsec',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            cpe_id: Optional[pulumi.Input[builtins.str]] = None,
            cpe_local_identifier: Optional[pulumi.Input[builtins.str]] = None,
            cpe_local_identifier_type: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            drg_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            static_routes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            transport_type: Optional[pulumi.Input[builtins.str]] = None,
            tunnel_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IpsecTunnelConfigurationArgs', 'IpsecTunnelConfigurationArgsDict']]]]] = None) -> 'Ipsec':
        """
        Get an existing Ipsec resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the IPSec connection.
        :param pulumi.Input[builtins.str] cpe_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.
        :param pulumi.Input[builtins.str] cpe_local_identifier: (Updatable) Your identifier for your CPE device. Can be either an IP address or a hostname (specifically, the fully qualified domain name (FQDN)). The type of identifier you provide here must correspond to the value for `cpeLocalIdentifierType`.
               
               If you don't provide a value, the `ipAddress` attribute for the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object specified by `cpeId` is used as the `cpeLocalIdentifier`.
               
               For information about why you'd provide this value, see [If Your CPE Is Behind a NAT Device](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm#nat).
               
               Example IP address: `10.0.3.3`
               
               Example hostname: `cpe.example.com`
        :param pulumi.Input[builtins.str] cpe_local_identifier_type: (Updatable) The type of identifier for your CPE device. The value you provide here must correspond to the value for `cpeLocalIdentifier`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] drg_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] state: The IPSec connection's current state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] static_routes: (Updatable) Static routes to the CPE. A static route's CIDR must not be a multicast address or class E address.
               
               Used for routing a given IPSec tunnel's traffic only if the tunnel is using static routing. If you configure at least one tunnel to use static routing, then you must provide at least one valid static route. If you configure both tunnels to use BGP dynamic routing, you can provide an empty list for the static routes on update. For more information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).
               
               Example: `10.0.1.0/24`
        :param pulumi.Input[builtins.str] time_created: The date and time the IPSec connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] transport_type: The transport type used for the IPSec connection.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IpsecTunnelConfigurationArgs', 'IpsecTunnelConfigurationArgsDict']]]] tunnel_configurations: (Non-updatable) Tunnel configuration for private ipsec connection over fastconnect.
               
               Example: `
               tunnel_configuration {
               oracle_tunnel_ip = "10.1.5.5"
               associated_virtual_circuits = [oci_core_virtual_circuit.test_ipsec_over_fc_virtual_circuit.id]
               drg_route_table_id = oci_core_drg_route_table.test_drg_ipsec_over_fc_route_table.id
               }`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IpsecState.__new__(_IpsecState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cpe_id"] = cpe_id
        __props__.__dict__["cpe_local_identifier"] = cpe_local_identifier
        __props__.__dict__["cpe_local_identifier_type"] = cpe_local_identifier_type
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["drg_id"] = drg_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["state"] = state
        __props__.__dict__["static_routes"] = static_routes
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["transport_type"] = transport_type
        __props__.__dict__["tunnel_configurations"] = tunnel_configurations
        return Ipsec(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to contain the IPSec connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpeId")
    def cpe_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object.
        """
        return pulumi.get(self, "cpe_id")

    @property
    @pulumi.getter(name="cpeLocalIdentifier")
    def cpe_local_identifier(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Your identifier for your CPE device. Can be either an IP address or a hostname (specifically, the fully qualified domain name (FQDN)). The type of identifier you provide here must correspond to the value for `cpeLocalIdentifierType`.

        If you don't provide a value, the `ipAddress` attribute for the [Cpe](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Cpe/) object specified by `cpeId` is used as the `cpeLocalIdentifier`.

        For information about why you'd provide this value, see [If Your CPE Is Behind a NAT Device](https://docs.cloud.oracle.com/iaas/Content/Network/Tasks/overviewIPsec.htm#nat).

        Example IP address: `10.0.3.3`

        Example hostname: `cpe.example.com`
        """
        return pulumi.get(self, "cpe_local_identifier")

    @property
    @pulumi.getter(name="cpeLocalIdentifierType")
    def cpe_local_identifier_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The type of identifier for your CPE device. The value you provide here must correspond to the value for `cpeLocalIdentifier`.
        """
        return pulumi.get(self, "cpe_local_identifier_type")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drgId")
    def drg_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DRG.
        """
        return pulumi.get(self, "drg_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The IPSec connection's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="staticRoutes")
    def static_routes(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Static routes to the CPE. A static route's CIDR must not be a multicast address or class E address.

        Used for routing a given IPSec tunnel's traffic only if the tunnel is using static routing. If you configure at least one tunnel to use static routing, then you must provide at least one valid static route. If you configure both tunnels to use BGP dynamic routing, you can provide an empty list for the static routes on update. For more information, see the important note in [IPSecConnection](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnection/).

        Example: `10.0.1.0/24`
        """
        return pulumi.get(self, "static_routes")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the IPSec connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> pulumi.Output[builtins.str]:
        """
        The transport type used for the IPSec connection.
        """
        return pulumi.get(self, "transport_type")

    @property
    @pulumi.getter(name="tunnelConfigurations")
    def tunnel_configurations(self) -> pulumi.Output[Sequence['outputs.IpsecTunnelConfiguration']]:
        """
        (Non-updatable) Tunnel configuration for private ipsec connection over fastconnect.

        Example: `
        tunnel_configuration {
        oracle_tunnel_ip = "10.1.5.5"
        associated_virtual_circuits = [oci_core_virtual_circuit.test_ipsec_over_fc_virtual_circuit.id]
        drg_route_table_id = oci_core_drg_route_table.test_drg_ipsec_over_fc_route_table.id
        }`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "tunnel_configurations")

