# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NetworkSecurityGroupSecurityRuleArgs', 'NetworkSecurityGroupSecurityRule']

@pulumi.input_type
class NetworkSecurityGroupSecurityRuleArgs:
    def __init__(__self__, *,
                 direction: pulumi.Input[builtins.str],
                 network_security_group_id: pulumi.Input[builtins.str],
                 protocol: pulumi.Input[builtins.str],
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 icmp_options: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs']] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 stateless: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_options: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleTcpOptionsArgs']] = None,
                 udp_options: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleUdpOptionsArgs']] = None):
        """
        The set of arguments for constructing a NetworkSecurityGroupSecurityRule resource.
        :param pulumi.Input[builtins.str] direction: Direction of the security rule. Set to `EGRESS` for rules to allow outbound IP packets, or `INGRESS` for rules to allow inbound IP packets.
        :param pulumi.Input[builtins.str] network_security_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
        :param pulumi.Input[builtins.str] protocol: The transport protocol. Specify either `all` or an IPv4 protocol number as defined in [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Options are supported only for ICMP ("1"), TCP ("6"), UDP ("17"), and ICMPv6 ("58").
        :param pulumi.Input[builtins.str] description: An optional description of your choice for the rule.
        :param pulumi.Input[builtins.str] destination: Conceptually, this is the range of IP addresses that a packet originating from the instance can go to.
        :param pulumi.Input[builtins.str] destination_type: Type of destination for the rule. Required if `direction` = `EGRESS`.
        :param pulumi.Input['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs'] icmp_options: Optional and valid only for ICMP and ICMPv6. Use to specify a particular ICMP type and code as defined in:
               * [ICMP Parameters](http://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml)
               * [ICMPv6 Parameters](https://www.iana.org/assignments/icmpv6-parameters/icmpv6-parameters.xhtml)
        :param pulumi.Input[builtins.str] source: Conceptually, this is the range of IP addresses that a packet coming into the instance can come from.
        :param pulumi.Input[builtins.str] source_type: Type of source for the rule. Required if `direction` = `INGRESS`.
               * `CIDR_BLOCK`: If the rule's `source` is an IP address range in CIDR notation.
               * `SERVICE_CIDR_BLOCK`: If the rule's `source` is the `cidrBlock` value for a [Service](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Service/) (the rule is for traffic coming from a particular `Service` through a service gateway).
               * `NETWORK_SECURITY_GROUP`: If the rule's `source` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/).
        :param pulumi.Input[builtins.bool] stateless: A stateless rule allows traffic in one direction. Remember to add a corresponding stateless rule in the other direction if you need to support bidirectional traffic. For example, if egress traffic allows TCP destination port 80, there should be an ingress rule to allow TCP source port 80. Defaults to false, which means the rule is stateful and a corresponding rule is not necessary for bidirectional traffic.
        :param pulumi.Input['NetworkSecurityGroupSecurityRuleTcpOptionsArgs'] tcp_options: Optional and valid only for TCP. Use to specify particular destination ports for TCP rules. If you specify TCP as the protocol but omit this object, then all destination ports are allowed.
        :param pulumi.Input['NetworkSecurityGroupSecurityRuleUdpOptionsArgs'] udp_options: Optional and valid only for UDP. Use to specify particular destination ports for UDP rules. If you specify UDP as the protocol but omit this object, then all destination ports are allowed.
        """
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        pulumi.set(__self__, "protocol", protocol)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if icmp_options is not None:
            pulumi.set(__self__, "icmp_options", icmp_options)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if stateless is not None:
            pulumi.set(__self__, "stateless", stateless)
        if tcp_options is not None:
            pulumi.set(__self__, "tcp_options", tcp_options)
        if udp_options is not None:
            pulumi.set(__self__, "udp_options", udp_options)

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Input[builtins.str]:
        """
        Direction of the security rule. Set to `EGRESS` for rules to allow outbound IP packets, or `INGRESS` for rules to allow inbound IP packets.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
        """
        return pulumi.get(self, "network_security_group_id")

    @network_security_group_id.setter
    def network_security_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_security_group_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[builtins.str]:
        """
        The transport protocol. Specify either `all` or an IPv4 protocol number as defined in [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Options are supported only for ICMP ("1"), TCP ("6"), UDP ("17"), and ICMPv6 ("58").
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of your choice for the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Conceptually, this is the range of IP addresses that a packet originating from the instance can go to.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of destination for the rule. Required if `direction` = `EGRESS`.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_type", value)

    @property
    @pulumi.getter(name="icmpOptions")
    def icmp_options(self) -> Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs']]:
        """
        Optional and valid only for ICMP and ICMPv6. Use to specify a particular ICMP type and code as defined in:
        * [ICMP Parameters](http://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml)
        * [ICMPv6 Parameters](https://www.iana.org/assignments/icmpv6-parameters/icmpv6-parameters.xhtml)
        """
        return pulumi.get(self, "icmp_options")

    @icmp_options.setter
    def icmp_options(self, value: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs']]):
        pulumi.set(self, "icmp_options", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Conceptually, this is the range of IP addresses that a packet coming into the instance can come from.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of source for the rule. Required if `direction` = `INGRESS`.
        * `CIDR_BLOCK`: If the rule's `source` is an IP address range in CIDR notation.
        * `SERVICE_CIDR_BLOCK`: If the rule's `source` is the `cidrBlock` value for a [Service](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Service/) (the rule is for traffic coming from a particular `Service` through a service gateway).
        * `NETWORK_SECURITY_GROUP`: If the rule's `source` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def stateless(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A stateless rule allows traffic in one direction. Remember to add a corresponding stateless rule in the other direction if you need to support bidirectional traffic. For example, if egress traffic allows TCP destination port 80, there should be an ingress rule to allow TCP source port 80. Defaults to false, which means the rule is stateful and a corresponding rule is not necessary for bidirectional traffic.
        """
        return pulumi.get(self, "stateless")

    @stateless.setter
    def stateless(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "stateless", value)

    @property
    @pulumi.getter(name="tcpOptions")
    def tcp_options(self) -> Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleTcpOptionsArgs']]:
        """
        Optional and valid only for TCP. Use to specify particular destination ports for TCP rules. If you specify TCP as the protocol but omit this object, then all destination ports are allowed.
        """
        return pulumi.get(self, "tcp_options")

    @tcp_options.setter
    def tcp_options(self, value: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleTcpOptionsArgs']]):
        pulumi.set(self, "tcp_options", value)

    @property
    @pulumi.getter(name="udpOptions")
    def udp_options(self) -> Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleUdpOptionsArgs']]:
        """
        Optional and valid only for UDP. Use to specify particular destination ports for UDP rules. If you specify UDP as the protocol but omit this object, then all destination ports are allowed.
        """
        return pulumi.get(self, "udp_options")

    @udp_options.setter
    def udp_options(self, value: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleUdpOptionsArgs']]):
        pulumi.set(self, "udp_options", value)


@pulumi.input_type
class _NetworkSecurityGroupSecurityRuleState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 icmp_options: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs']] = None,
                 is_valid: Optional[pulumi.Input[builtins.bool]] = None,
                 network_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 stateless: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_options: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleTcpOptionsArgs']] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 udp_options: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleUdpOptionsArgs']] = None):
        """
        Input properties used for looking up and filtering NetworkSecurityGroupSecurityRule resources.
        :param pulumi.Input[builtins.str] description: An optional description of your choice for the rule.
        :param pulumi.Input[builtins.str] destination: Conceptually, this is the range of IP addresses that a packet originating from the instance can go to.
        :param pulumi.Input[builtins.str] destination_type: Type of destination for the rule. Required if `direction` = `EGRESS`.
        :param pulumi.Input[builtins.str] direction: Direction of the security rule. Set to `EGRESS` for rules to allow outbound IP packets, or `INGRESS` for rules to allow inbound IP packets.
        :param pulumi.Input['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs'] icmp_options: Optional and valid only for ICMP and ICMPv6. Use to specify a particular ICMP type and code as defined in:
               * [ICMP Parameters](http://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml)
               * [ICMPv6 Parameters](https://www.iana.org/assignments/icmpv6-parameters/icmpv6-parameters.xhtml)
        :param pulumi.Input[builtins.bool] is_valid: Whether the rule is valid. The value is `True` when the rule is first created. If the rule's `source` or `destination` is a network security group, the value changes to `False` if that network security group is deleted.
        :param pulumi.Input[builtins.str] network_security_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
        :param pulumi.Input[builtins.str] protocol: The transport protocol. Specify either `all` or an IPv4 protocol number as defined in [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Options are supported only for ICMP ("1"), TCP ("6"), UDP ("17"), and ICMPv6 ("58").
        :param pulumi.Input[builtins.str] source: Conceptually, this is the range of IP addresses that a packet coming into the instance can come from.
        :param pulumi.Input[builtins.str] source_type: Type of source for the rule. Required if `direction` = `INGRESS`.
               * `CIDR_BLOCK`: If the rule's `source` is an IP address range in CIDR notation.
               * `SERVICE_CIDR_BLOCK`: If the rule's `source` is the `cidrBlock` value for a [Service](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Service/) (the rule is for traffic coming from a particular `Service` through a service gateway).
               * `NETWORK_SECURITY_GROUP`: If the rule's `source` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/).
        :param pulumi.Input[builtins.bool] stateless: A stateless rule allows traffic in one direction. Remember to add a corresponding stateless rule in the other direction if you need to support bidirectional traffic. For example, if egress traffic allows TCP destination port 80, there should be an ingress rule to allow TCP source port 80. Defaults to false, which means the rule is stateful and a corresponding rule is not necessary for bidirectional traffic.
        :param pulumi.Input['NetworkSecurityGroupSecurityRuleTcpOptionsArgs'] tcp_options: Optional and valid only for TCP. Use to specify particular destination ports for TCP rules. If you specify TCP as the protocol but omit this object, then all destination ports are allowed.
        :param pulumi.Input[builtins.str] time_created: The date and time the security rule was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input['NetworkSecurityGroupSecurityRuleUdpOptionsArgs'] udp_options: Optional and valid only for UDP. Use to specify particular destination ports for UDP rules. If you specify UDP as the protocol but omit this object, then all destination ports are allowed.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if icmp_options is not None:
            pulumi.set(__self__, "icmp_options", icmp_options)
        if is_valid is not None:
            pulumi.set(__self__, "is_valid", is_valid)
        if network_security_group_id is not None:
            pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if stateless is not None:
            pulumi.set(__self__, "stateless", stateless)
        if tcp_options is not None:
            pulumi.set(__self__, "tcp_options", tcp_options)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if udp_options is not None:
            pulumi.set(__self__, "udp_options", udp_options)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An optional description of your choice for the rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def destination(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Conceptually, this is the range of IP addresses that a packet originating from the instance can go to.
        """
        return pulumi.get(self, "destination")

    @destination.setter
    def destination(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination", value)

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of destination for the rule. Required if `direction` = `EGRESS`.
        """
        return pulumi.get(self, "destination_type")

    @destination_type.setter
    def destination_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "destination_type", value)

    @property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Direction of the security rule. Set to `EGRESS` for rules to allow outbound IP packets, or `INGRESS` for rules to allow inbound IP packets.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "direction", value)

    @property
    @pulumi.getter(name="icmpOptions")
    def icmp_options(self) -> Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs']]:
        """
        Optional and valid only for ICMP and ICMPv6. Use to specify a particular ICMP type and code as defined in:
        * [ICMP Parameters](http://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml)
        * [ICMPv6 Parameters](https://www.iana.org/assignments/icmpv6-parameters/icmpv6-parameters.xhtml)
        """
        return pulumi.get(self, "icmp_options")

    @icmp_options.setter
    def icmp_options(self, value: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs']]):
        pulumi.set(self, "icmp_options", value)

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the rule is valid. The value is `True` when the rule is first created. If the rule's `source` or `destination` is a network security group, the value changes to `False` if that network security group is deleted.
        """
        return pulumi.get(self, "is_valid")

    @is_valid.setter
    def is_valid(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_valid", value)

    @property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
        """
        return pulumi.get(self, "network_security_group_id")

    @network_security_group_id.setter
    def network_security_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_security_group_id", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The transport protocol. Specify either `all` or an IPv4 protocol number as defined in [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Options are supported only for ICMP ("1"), TCP ("6"), UDP ("17"), and ICMPv6 ("58").
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Conceptually, this is the range of IP addresses that a packet coming into the instance can come from.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of source for the rule. Required if `direction` = `INGRESS`.
        * `CIDR_BLOCK`: If the rule's `source` is an IP address range in CIDR notation.
        * `SERVICE_CIDR_BLOCK`: If the rule's `source` is the `cidrBlock` value for a [Service](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Service/) (the rule is for traffic coming from a particular `Service` through a service gateway).
        * `NETWORK_SECURITY_GROUP`: If the rule's `source` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_type", value)

    @property
    @pulumi.getter
    def stateless(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        A stateless rule allows traffic in one direction. Remember to add a corresponding stateless rule in the other direction if you need to support bidirectional traffic. For example, if egress traffic allows TCP destination port 80, there should be an ingress rule to allow TCP source port 80. Defaults to false, which means the rule is stateful and a corresponding rule is not necessary for bidirectional traffic.
        """
        return pulumi.get(self, "stateless")

    @stateless.setter
    def stateless(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "stateless", value)

    @property
    @pulumi.getter(name="tcpOptions")
    def tcp_options(self) -> Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleTcpOptionsArgs']]:
        """
        Optional and valid only for TCP. Use to specify particular destination ports for TCP rules. If you specify TCP as the protocol but omit this object, then all destination ports are allowed.
        """
        return pulumi.get(self, "tcp_options")

    @tcp_options.setter
    def tcp_options(self, value: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleTcpOptionsArgs']]):
        pulumi.set(self, "tcp_options", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the security rule was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="udpOptions")
    def udp_options(self) -> Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleUdpOptionsArgs']]:
        """
        Optional and valid only for UDP. Use to specify particular destination ports for UDP rules. If you specify UDP as the protocol but omit this object, then all destination ports are allowed.
        """
        return pulumi.get(self, "udp_options")

    @udp_options.setter
    def udp_options(self, value: Optional[pulumi.Input['NetworkSecurityGroupSecurityRuleUdpOptionsArgs']]):
        pulumi.set(self, "udp_options", value)


class NetworkSecurityGroupSecurityRule(pulumi.CustomResource):

    pulumi_type = "oci:Core/networkSecurityGroupSecurityRule:NetworkSecurityGroupSecurityRule"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 icmp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs', 'NetworkSecurityGroupSecurityRuleIcmpOptionsArgsDict']]] = None,
                 network_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 stateless: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleTcpOptionsArgs', 'NetworkSecurityGroupSecurityRuleTcpOptionsArgsDict']]] = None,
                 udp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleUdpOptionsArgs', 'NetworkSecurityGroupSecurityRuleUdpOptionsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Network Security Group Security Rule resource in Oracle Cloud Infrastructure Core service.

        Adds up to 25 security rules to the specified network security group. Adding more than 25 rules requires multiple operations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_security_group_security_rule = oci.core.NetworkSecurityGroupSecurityRule("test_network_security_group_security_rule",
            network_security_group_id=test_network_security_group["id"],
            direction=network_security_group_security_rule_direction,
            protocol=network_security_group_security_rule_protocol,
            description=network_security_group_security_rule_description,
            destination=network_security_group_security_rule_destination,
            destination_type=network_security_group_security_rule_destination_type,
            icmp_options={
                "type": network_security_group_security_rule_icmp_options_type,
                "code": network_security_group_security_rule_icmp_options_code,
            },
            source=network_security_group_security_rule_source,
            source_type=network_security_group_security_rule_source_type,
            stateless=network_security_group_security_rule_stateless,
            tcp_options={
                "destination_port_range": {
                    "max": network_security_group_security_rule_tcp_options_destination_port_range_max,
                    "min": network_security_group_security_rule_tcp_options_destination_port_range_min,
                },
                "source_port_range": {
                    "max": network_security_group_security_rule_tcp_options_source_port_range_max,
                    "min": network_security_group_security_rule_tcp_options_source_port_range_min,
                },
            },
            udp_options={
                "destination_port_range": {
                    "max": network_security_group_security_rule_udp_options_destination_port_range_max,
                    "min": network_security_group_security_rule_udp_options_destination_port_range_min,
                },
                "source_port_range": {
                    "max": network_security_group_security_rule_udp_options_source_port_range_max,
                    "min": network_security_group_security_rule_udp_options_source_port_range_min,
                },
            })
        ```

        ## Import

        NetworkSecurityGroupSecurityRule can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/networkSecurityGroupSecurityRule:NetworkSecurityGroupSecurityRule test_network_security_group_security_rule "networkSecurityGroups/{networkSecurityGroupId}/securityRules/{securityRuleId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of your choice for the rule.
        :param pulumi.Input[builtins.str] destination: Conceptually, this is the range of IP addresses that a packet originating from the instance can go to.
        :param pulumi.Input[builtins.str] destination_type: Type of destination for the rule. Required if `direction` = `EGRESS`.
        :param pulumi.Input[builtins.str] direction: Direction of the security rule. Set to `EGRESS` for rules to allow outbound IP packets, or `INGRESS` for rules to allow inbound IP packets.
        :param pulumi.Input[Union['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs', 'NetworkSecurityGroupSecurityRuleIcmpOptionsArgsDict']] icmp_options: Optional and valid only for ICMP and ICMPv6. Use to specify a particular ICMP type and code as defined in:
               * [ICMP Parameters](http://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml)
               * [ICMPv6 Parameters](https://www.iana.org/assignments/icmpv6-parameters/icmpv6-parameters.xhtml)
        :param pulumi.Input[builtins.str] network_security_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
        :param pulumi.Input[builtins.str] protocol: The transport protocol. Specify either `all` or an IPv4 protocol number as defined in [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Options are supported only for ICMP ("1"), TCP ("6"), UDP ("17"), and ICMPv6 ("58").
        :param pulumi.Input[builtins.str] source: Conceptually, this is the range of IP addresses that a packet coming into the instance can come from.
        :param pulumi.Input[builtins.str] source_type: Type of source for the rule. Required if `direction` = `INGRESS`.
               * `CIDR_BLOCK`: If the rule's `source` is an IP address range in CIDR notation.
               * `SERVICE_CIDR_BLOCK`: If the rule's `source` is the `cidrBlock` value for a [Service](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Service/) (the rule is for traffic coming from a particular `Service` through a service gateway).
               * `NETWORK_SECURITY_GROUP`: If the rule's `source` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/).
        :param pulumi.Input[builtins.bool] stateless: A stateless rule allows traffic in one direction. Remember to add a corresponding stateless rule in the other direction if you need to support bidirectional traffic. For example, if egress traffic allows TCP destination port 80, there should be an ingress rule to allow TCP source port 80. Defaults to false, which means the rule is stateful and a corresponding rule is not necessary for bidirectional traffic.
        :param pulumi.Input[Union['NetworkSecurityGroupSecurityRuleTcpOptionsArgs', 'NetworkSecurityGroupSecurityRuleTcpOptionsArgsDict']] tcp_options: Optional and valid only for TCP. Use to specify particular destination ports for TCP rules. If you specify TCP as the protocol but omit this object, then all destination ports are allowed.
        :param pulumi.Input[Union['NetworkSecurityGroupSecurityRuleUdpOptionsArgs', 'NetworkSecurityGroupSecurityRuleUdpOptionsArgsDict']] udp_options: Optional and valid only for UDP. Use to specify particular destination ports for UDP rules. If you specify UDP as the protocol but omit this object, then all destination ports are allowed.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkSecurityGroupSecurityRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Security Group Security Rule resource in Oracle Cloud Infrastructure Core service.

        Adds up to 25 security rules to the specified network security group. Adding more than 25 rules requires multiple operations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_security_group_security_rule = oci.core.NetworkSecurityGroupSecurityRule("test_network_security_group_security_rule",
            network_security_group_id=test_network_security_group["id"],
            direction=network_security_group_security_rule_direction,
            protocol=network_security_group_security_rule_protocol,
            description=network_security_group_security_rule_description,
            destination=network_security_group_security_rule_destination,
            destination_type=network_security_group_security_rule_destination_type,
            icmp_options={
                "type": network_security_group_security_rule_icmp_options_type,
                "code": network_security_group_security_rule_icmp_options_code,
            },
            source=network_security_group_security_rule_source,
            source_type=network_security_group_security_rule_source_type,
            stateless=network_security_group_security_rule_stateless,
            tcp_options={
                "destination_port_range": {
                    "max": network_security_group_security_rule_tcp_options_destination_port_range_max,
                    "min": network_security_group_security_rule_tcp_options_destination_port_range_min,
                },
                "source_port_range": {
                    "max": network_security_group_security_rule_tcp_options_source_port_range_max,
                    "min": network_security_group_security_rule_tcp_options_source_port_range_min,
                },
            },
            udp_options={
                "destination_port_range": {
                    "max": network_security_group_security_rule_udp_options_destination_port_range_max,
                    "min": network_security_group_security_rule_udp_options_destination_port_range_min,
                },
                "source_port_range": {
                    "max": network_security_group_security_rule_udp_options_source_port_range_max,
                    "min": network_security_group_security_rule_udp_options_source_port_range_min,
                },
            })
        ```

        ## Import

        NetworkSecurityGroupSecurityRule can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/networkSecurityGroupSecurityRule:NetworkSecurityGroupSecurityRule test_network_security_group_security_rule "networkSecurityGroups/{networkSecurityGroupId}/securityRules/{securityRuleId}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkSecurityGroupSecurityRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkSecurityGroupSecurityRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destination: Optional[pulumi.Input[builtins.str]] = None,
                 destination_type: Optional[pulumi.Input[builtins.str]] = None,
                 direction: Optional[pulumi.Input[builtins.str]] = None,
                 icmp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs', 'NetworkSecurityGroupSecurityRuleIcmpOptionsArgsDict']]] = None,
                 network_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 protocol: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 source_type: Optional[pulumi.Input[builtins.str]] = None,
                 stateless: Optional[pulumi.Input[builtins.bool]] = None,
                 tcp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleTcpOptionsArgs', 'NetworkSecurityGroupSecurityRuleTcpOptionsArgsDict']]] = None,
                 udp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleUdpOptionsArgs', 'NetworkSecurityGroupSecurityRuleUdpOptionsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkSecurityGroupSecurityRuleArgs.__new__(NetworkSecurityGroupSecurityRuleArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["destination"] = destination
            __props__.__dict__["destination_type"] = destination_type
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            __props__.__dict__["icmp_options"] = icmp_options
            if network_security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_security_group_id'")
            __props__.__dict__["network_security_group_id"] = network_security_group_id
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            __props__.__dict__["source"] = source
            __props__.__dict__["source_type"] = source_type
            __props__.__dict__["stateless"] = stateless
            __props__.__dict__["tcp_options"] = tcp_options
            __props__.__dict__["udp_options"] = udp_options
            __props__.__dict__["is_valid"] = None
            __props__.__dict__["time_created"] = None
        super(NetworkSecurityGroupSecurityRule, __self__).__init__(
            'oci:Core/networkSecurityGroupSecurityRule:NetworkSecurityGroupSecurityRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destination: Optional[pulumi.Input[builtins.str]] = None,
            destination_type: Optional[pulumi.Input[builtins.str]] = None,
            direction: Optional[pulumi.Input[builtins.str]] = None,
            icmp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs', 'NetworkSecurityGroupSecurityRuleIcmpOptionsArgsDict']]] = None,
            is_valid: Optional[pulumi.Input[builtins.bool]] = None,
            network_security_group_id: Optional[pulumi.Input[builtins.str]] = None,
            protocol: Optional[pulumi.Input[builtins.str]] = None,
            source: Optional[pulumi.Input[builtins.str]] = None,
            source_type: Optional[pulumi.Input[builtins.str]] = None,
            stateless: Optional[pulumi.Input[builtins.bool]] = None,
            tcp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleTcpOptionsArgs', 'NetworkSecurityGroupSecurityRuleTcpOptionsArgsDict']]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            udp_options: Optional[pulumi.Input[Union['NetworkSecurityGroupSecurityRuleUdpOptionsArgs', 'NetworkSecurityGroupSecurityRuleUdpOptionsArgsDict']]] = None) -> 'NetworkSecurityGroupSecurityRule':
        """
        Get an existing NetworkSecurityGroupSecurityRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] description: An optional description of your choice for the rule.
        :param pulumi.Input[builtins.str] destination: Conceptually, this is the range of IP addresses that a packet originating from the instance can go to.
        :param pulumi.Input[builtins.str] destination_type: Type of destination for the rule. Required if `direction` = `EGRESS`.
        :param pulumi.Input[builtins.str] direction: Direction of the security rule. Set to `EGRESS` for rules to allow outbound IP packets, or `INGRESS` for rules to allow inbound IP packets.
        :param pulumi.Input[Union['NetworkSecurityGroupSecurityRuleIcmpOptionsArgs', 'NetworkSecurityGroupSecurityRuleIcmpOptionsArgsDict']] icmp_options: Optional and valid only for ICMP and ICMPv6. Use to specify a particular ICMP type and code as defined in:
               * [ICMP Parameters](http://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml)
               * [ICMPv6 Parameters](https://www.iana.org/assignments/icmpv6-parameters/icmpv6-parameters.xhtml)
        :param pulumi.Input[builtins.bool] is_valid: Whether the rule is valid. The value is `True` when the rule is first created. If the rule's `source` or `destination` is a network security group, the value changes to `False` if that network security group is deleted.
        :param pulumi.Input[builtins.str] network_security_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
        :param pulumi.Input[builtins.str] protocol: The transport protocol. Specify either `all` or an IPv4 protocol number as defined in [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Options are supported only for ICMP ("1"), TCP ("6"), UDP ("17"), and ICMPv6 ("58").
        :param pulumi.Input[builtins.str] source: Conceptually, this is the range of IP addresses that a packet coming into the instance can come from.
        :param pulumi.Input[builtins.str] source_type: Type of source for the rule. Required if `direction` = `INGRESS`.
               * `CIDR_BLOCK`: If the rule's `source` is an IP address range in CIDR notation.
               * `SERVICE_CIDR_BLOCK`: If the rule's `source` is the `cidrBlock` value for a [Service](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Service/) (the rule is for traffic coming from a particular `Service` through a service gateway).
               * `NETWORK_SECURITY_GROUP`: If the rule's `source` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/).
        :param pulumi.Input[builtins.bool] stateless: A stateless rule allows traffic in one direction. Remember to add a corresponding stateless rule in the other direction if you need to support bidirectional traffic. For example, if egress traffic allows TCP destination port 80, there should be an ingress rule to allow TCP source port 80. Defaults to false, which means the rule is stateful and a corresponding rule is not necessary for bidirectional traffic.
        :param pulumi.Input[Union['NetworkSecurityGroupSecurityRuleTcpOptionsArgs', 'NetworkSecurityGroupSecurityRuleTcpOptionsArgsDict']] tcp_options: Optional and valid only for TCP. Use to specify particular destination ports for TCP rules. If you specify TCP as the protocol but omit this object, then all destination ports are allowed.
        :param pulumi.Input[builtins.str] time_created: The date and time the security rule was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[Union['NetworkSecurityGroupSecurityRuleUdpOptionsArgs', 'NetworkSecurityGroupSecurityRuleUdpOptionsArgsDict']] udp_options: Optional and valid only for UDP. Use to specify particular destination ports for UDP rules. If you specify UDP as the protocol but omit this object, then all destination ports are allowed.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkSecurityGroupSecurityRuleState.__new__(_NetworkSecurityGroupSecurityRuleState)

        __props__.__dict__["description"] = description
        __props__.__dict__["destination"] = destination
        __props__.__dict__["destination_type"] = destination_type
        __props__.__dict__["direction"] = direction
        __props__.__dict__["icmp_options"] = icmp_options
        __props__.__dict__["is_valid"] = is_valid
        __props__.__dict__["network_security_group_id"] = network_security_group_id
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["source"] = source
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["stateless"] = stateless
        __props__.__dict__["tcp_options"] = tcp_options
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["udp_options"] = udp_options
        return NetworkSecurityGroupSecurityRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        An optional description of your choice for the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def destination(self) -> pulumi.Output[builtins.str]:
        """
        Conceptually, this is the range of IP addresses that a packet originating from the instance can go to.
        """
        return pulumi.get(self, "destination")

    @property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of destination for the rule. Required if `direction` = `EGRESS`.
        """
        return pulumi.get(self, "destination_type")

    @property
    @pulumi.getter
    def direction(self) -> pulumi.Output[builtins.str]:
        """
        Direction of the security rule. Set to `EGRESS` for rules to allow outbound IP packets, or `INGRESS` for rules to allow inbound IP packets.
        """
        return pulumi.get(self, "direction")

    @property
    @pulumi.getter(name="icmpOptions")
    def icmp_options(self) -> pulumi.Output[Optional['outputs.NetworkSecurityGroupSecurityRuleIcmpOptions']]:
        """
        Optional and valid only for ICMP and ICMPv6. Use to specify a particular ICMP type and code as defined in:
        * [ICMP Parameters](http://www.iana.org/assignments/icmp-parameters/icmp-parameters.xhtml)
        * [ICMPv6 Parameters](https://www.iana.org/assignments/icmpv6-parameters/icmpv6-parameters.xhtml)
        """
        return pulumi.get(self, "icmp_options")

    @property
    @pulumi.getter(name="isValid")
    def is_valid(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the rule is valid. The value is `True` when the rule is first created. If the rule's `source` or `destination` is a network security group, the value changes to `False` if that network security group is deleted.
        """
        return pulumi.get(self, "is_valid")

    @property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security group.
        """
        return pulumi.get(self, "network_security_group_id")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[builtins.str]:
        """
        The transport protocol. Specify either `all` or an IPv4 protocol number as defined in [Protocol Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml). Options are supported only for ICMP ("1"), TCP ("6"), UDP ("17"), and ICMPv6 ("58").
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Conceptually, this is the range of IP addresses that a packet coming into the instance can come from.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of source for the rule. Required if `direction` = `INGRESS`.
        * `CIDR_BLOCK`: If the rule's `source` is an IP address range in CIDR notation.
        * `SERVICE_CIDR_BLOCK`: If the rule's `source` is the `cidrBlock` value for a [Service](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Service/) (the rule is for traffic coming from a particular `Service` through a service gateway).
        * `NETWORK_SECURITY_GROUP`: If the rule's `source` is the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of a [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter
    def stateless(self) -> pulumi.Output[builtins.bool]:
        """
        A stateless rule allows traffic in one direction. Remember to add a corresponding stateless rule in the other direction if you need to support bidirectional traffic. For example, if egress traffic allows TCP destination port 80, there should be an ingress rule to allow TCP source port 80. Defaults to false, which means the rule is stateful and a corresponding rule is not necessary for bidirectional traffic.
        """
        return pulumi.get(self, "stateless")

    @property
    @pulumi.getter(name="tcpOptions")
    def tcp_options(self) -> pulumi.Output[Optional['outputs.NetworkSecurityGroupSecurityRuleTcpOptions']]:
        """
        Optional and valid only for TCP. Use to specify particular destination ports for TCP rules. If you specify TCP as the protocol but omit this object, then all destination ports are allowed.
        """
        return pulumi.get(self, "tcp_options")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the security rule was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="udpOptions")
    def udp_options(self) -> pulumi.Output[Optional['outputs.NetworkSecurityGroupSecurityRuleUdpOptions']]:
        """
        Optional and valid only for UDP. Use to specify particular destination ports for UDP rules. If you specify UDP as the protocol but omit this object, then all destination ports are allowed.
        """
        return pulumi.get(self, "udp_options")

