# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PublicIpPoolCapacityArgs', 'PublicIpPoolCapacity']

@pulumi.input_type
class PublicIpPoolCapacityArgs:
    def __init__(__self__, *,
                 byoip_id: pulumi.Input[builtins.str],
                 cidr_block: pulumi.Input[builtins.str],
                 public_ip_pool_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a PublicIpPoolCapacity resource.
        :param pulumi.Input[builtins.str] byoip_id: The OCID of the Byoip Range Id object to which the cidr block belongs.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR IP address range to be added to the Public Ip Pool. Example: `10.0.1.0/24`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] public_ip_pool_id: The OCID of the pool object created by the current tenancy
        """
        pulumi.set(__self__, "byoip_id", byoip_id)
        pulumi.set(__self__, "cidr_block", cidr_block)
        pulumi.set(__self__, "public_ip_pool_id", public_ip_pool_id)

    @property
    @pulumi.getter(name="byoipId")
    def byoip_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the Byoip Range Id object to which the cidr block belongs.
        """
        return pulumi.get(self, "byoip_id")

    @byoip_id.setter
    def byoip_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "byoip_id", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Input[builtins.str]:
        """
        The CIDR IP address range to be added to the Public Ip Pool. Example: `10.0.1.0/24`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="publicIpPoolId")
    def public_ip_pool_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the pool object created by the current tenancy
        """
        return pulumi.get(self, "public_ip_pool_id")

    @public_ip_pool_id.setter
    def public_ip_pool_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "public_ip_pool_id", value)


@pulumi.input_type
class _PublicIpPoolCapacityState:
    def __init__(__self__, *,
                 byoip_id: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_pool_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PublicIpPoolCapacity resources.
        :param pulumi.Input[builtins.str] byoip_id: The OCID of the Byoip Range Id object to which the cidr block belongs.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR IP address range to be added to the Public Ip Pool. Example: `10.0.1.0/24`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] public_ip_pool_id: The OCID of the pool object created by the current tenancy
        """
        if byoip_id is not None:
            pulumi.set(__self__, "byoip_id", byoip_id)
        if cidr_block is not None:
            pulumi.set(__self__, "cidr_block", cidr_block)
        if public_ip_pool_id is not None:
            pulumi.set(__self__, "public_ip_pool_id", public_ip_pool_id)

    @property
    @pulumi.getter(name="byoipId")
    def byoip_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the Byoip Range Id object to which the cidr block belongs.
        """
        return pulumi.get(self, "byoip_id")

    @byoip_id.setter
    def byoip_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "byoip_id", value)

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR IP address range to be added to the Public Ip Pool. Example: `10.0.1.0/24`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "cidr_block")

    @cidr_block.setter
    def cidr_block(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cidr_block", value)

    @property
    @pulumi.getter(name="publicIpPoolId")
    def public_ip_pool_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the pool object created by the current tenancy
        """
        return pulumi.get(self, "public_ip_pool_id")

    @public_ip_pool_id.setter
    def public_ip_pool_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "public_ip_pool_id", value)


class PublicIpPoolCapacity(pulumi.CustomResource):

    pulumi_type = "oci:Core/publicIpPoolCapacity:PublicIpPoolCapacity"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 byoip_id: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_public_ip_pool_capacity = oci.core.PublicIpPoolCapacity("test_public_ip_pool_capacity",
            public_ip_pool_id=public_ip_pool_id,
            byoip_id=byoip_id,
            cidr_block=cidr_block)
        ```

        ## Import

        PublicIpPoolCapacity can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/publicIpPoolCapacity:PublicIpPoolCapacity test_public_ip_pool_capacity "publicIpPoolId/{publicIpPoolId}/byoipId/{byoipId}/cidrBlock/{cidrBlock}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] byoip_id: The OCID of the Byoip Range Id object to which the cidr block belongs.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR IP address range to be added to the Public Ip Pool. Example: `10.0.1.0/24`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] public_ip_pool_id: The OCID of the pool object created by the current tenancy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PublicIpPoolCapacityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_public_ip_pool_capacity = oci.core.PublicIpPoolCapacity("test_public_ip_pool_capacity",
            public_ip_pool_id=public_ip_pool_id,
            byoip_id=byoip_id,
            cidr_block=cidr_block)
        ```

        ## Import

        PublicIpPoolCapacity can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Core/publicIpPoolCapacity:PublicIpPoolCapacity test_public_ip_pool_capacity "publicIpPoolId/{publicIpPoolId}/byoipId/{byoipId}/cidrBlock/{cidrBlock}"
        ```

        :param str resource_name: The name of the resource.
        :param PublicIpPoolCapacityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PublicIpPoolCapacityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 byoip_id: Optional[pulumi.Input[builtins.str]] = None,
                 cidr_block: Optional[pulumi.Input[builtins.str]] = None,
                 public_ip_pool_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PublicIpPoolCapacityArgs.__new__(PublicIpPoolCapacityArgs)

            if byoip_id is None and not opts.urn:
                raise TypeError("Missing required property 'byoip_id'")
            __props__.__dict__["byoip_id"] = byoip_id
            if cidr_block is None and not opts.urn:
                raise TypeError("Missing required property 'cidr_block'")
            __props__.__dict__["cidr_block"] = cidr_block
            if public_ip_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip_pool_id'")
            __props__.__dict__["public_ip_pool_id"] = public_ip_pool_id
        super(PublicIpPoolCapacity, __self__).__init__(
            'oci:Core/publicIpPoolCapacity:PublicIpPoolCapacity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            byoip_id: Optional[pulumi.Input[builtins.str]] = None,
            cidr_block: Optional[pulumi.Input[builtins.str]] = None,
            public_ip_pool_id: Optional[pulumi.Input[builtins.str]] = None) -> 'PublicIpPoolCapacity':
        """
        Get an existing PublicIpPoolCapacity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] byoip_id: The OCID of the Byoip Range Id object to which the cidr block belongs.
        :param pulumi.Input[builtins.str] cidr_block: The CIDR IP address range to be added to the Public Ip Pool. Example: `10.0.1.0/24`
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] public_ip_pool_id: The OCID of the pool object created by the current tenancy
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PublicIpPoolCapacityState.__new__(_PublicIpPoolCapacityState)

        __props__.__dict__["byoip_id"] = byoip_id
        __props__.__dict__["cidr_block"] = cidr_block
        __props__.__dict__["public_ip_pool_id"] = public_ip_pool_id
        return PublicIpPoolCapacity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="byoipId")
    def byoip_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the Byoip Range Id object to which the cidr block belongs.
        """
        return pulumi.get(self, "byoip_id")

    @property
    @pulumi.getter(name="cidrBlock")
    def cidr_block(self) -> pulumi.Output[builtins.str]:
        """
        The CIDR IP address range to be added to the Public Ip Pool. Example: `10.0.1.0/24`

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "cidr_block")

    @property
    @pulumi.getter(name="publicIpPoolId")
    def public_ip_pool_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the pool object created by the current tenancy
        """
        return pulumi.get(self, "public_ip_pool_id")

