# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbHomeArgs', 'DbHome']

@pulumi.input_type
class DbHomeArgs:
    def __init__(__self__, *,
                 database: Optional[pulumi.Input['DbHomeDatabaseArgs']] = None,
                 database_software_image_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_database_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_desupported_version: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unified_auditing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DbHome resource.
        :param pulumi.Input['DbHomeDatabaseArgs'] database: (Updatable) Details for creating a database.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[builtins.str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[builtins.str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[builtins.str] db_version: A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-provided name of the Database Home.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_desupported_version: If true, the customer acknowledges that the specified Oracle Database software is an older release that is not currently supported by OCI.
        :param pulumi.Input[builtins.bool] is_unified_auditing_enabled: Indicates whether unified autiding is enabled or not. Set to True to enable unified auditing on respective DBHome.
        :param pulumi.Input[builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        :param pulumi.Input[builtins.str] source: The source of database: NONE for creating a new database. DB_BACKUP for creating a new database by restoring from a database backup. VM_CLUSTER_NEW for creating a database for VM Cluster.
        :param pulumi.Input[builtins.str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if database is not None:
            pulumi.set(__self__, "database", database)
        if database_software_image_id is not None:
            pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_database_delete is not None:
            pulumi.set(__self__, "enable_database_delete", enable_database_delete)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_desupported_version is not None:
            pulumi.set(__self__, "is_desupported_version", is_desupported_version)
        if is_unified_auditing_enabled is not None:
            pulumi.set(__self__, "is_unified_auditing_enabled", is_unified_auditing_enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if vm_cluster_id is not None:
            pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['DbHomeDatabaseArgs']]:
        """
        (Updatable) Details for creating a database.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['DbHomeDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @database_software_image_id.setter
    def database_software_image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_software_image_id", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-provided name of the Database Home.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableDatabaseDelete")
    def enable_database_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "enable_database_delete")

    @enable_database_delete.setter
    def enable_database_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_database_delete", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isDesupportedVersion")
    def is_desupported_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the customer acknowledges that the specified Oracle Database software is an older release that is not currently supported by OCI.
        """
        return pulumi.get(self, "is_desupported_version")

    @is_desupported_version.setter
    def is_desupported_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_desupported_version", value)

    @property
    @pulumi.getter(name="isUnifiedAuditingEnabled")
    def is_unified_auditing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether unified autiding is enabled or not. Set to True to enable unified auditing on respective DBHome.
        """
        return pulumi.get(self, "is_unified_auditing_enabled")

    @is_unified_auditing_enabled.setter
    def is_unified_auditing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_unified_auditing_enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source of database: NONE for creating a new database. DB_BACKUP for creating a new database by restoring from a database backup. VM_CLUSTER_NEW for creating a database for VM Cluster.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_id")

    @vm_cluster_id.setter
    def vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vm_cluster_id", value)


@pulumi.input_type
class _DbHomeState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 database: Optional[pulumi.Input['DbHomeDatabaseArgs']] = None,
                 database_software_image_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_home_location: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_database_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_desupported_version: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unified_auditing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
                 last_patch_history_entry_id: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DbHome resources.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input['DbHomeDatabaseArgs'] database: (Updatable) Details for creating a database.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[builtins.str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[builtins.str] db_home_location: The location of the Oracle Database Home.
        :param pulumi.Input[builtins.str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[builtins.str] db_version: A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-provided name of the Database Home.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_desupported_version: If true, the customer acknowledges that the specified Oracle Database software is an older release that is not currently supported by OCI.
        :param pulumi.Input[builtins.bool] is_unified_auditing_enabled: Indicates whether unified autiding is enabled or not. Set to True to enable unified auditing on respective DBHome.
        :param pulumi.Input[builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        :param pulumi.Input[builtins.str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation is started.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] source: The source of database: NONE for creating a new database. DB_BACKUP for creating a new database by restoring from a database backup. VM_CLUSTER_NEW for creating a database for VM Cluster.
        :param pulumi.Input[builtins.str] state: The current state of the Database Home.
        :param pulumi.Input[builtins.str] time_created: The date and time the Database Home was created.
        :param pulumi.Input[builtins.str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if database is not None:
            pulumi.set(__self__, "database", database)
        if database_software_image_id is not None:
            pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if db_home_location is not None:
            pulumi.set(__self__, "db_home_location", db_home_location)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if enable_database_delete is not None:
            pulumi.set(__self__, "enable_database_delete", enable_database_delete)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_desupported_version is not None:
            pulumi.set(__self__, "is_desupported_version", is_desupported_version)
        if is_unified_auditing_enabled is not None:
            pulumi.set(__self__, "is_unified_auditing_enabled", is_unified_auditing_enabled)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_version_id is not None:
            pulumi.set(__self__, "kms_key_version_id", kms_key_version_id)
        if last_patch_history_entry_id is not None:
            pulumi.set(__self__, "last_patch_history_entry_id", last_patch_history_entry_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if vm_cluster_id is not None:
            pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def database(self) -> Optional[pulumi.Input['DbHomeDatabaseArgs']]:
        """
        (Updatable) Details for creating a database.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "database")

    @database.setter
    def database(self, value: Optional[pulumi.Input['DbHomeDatabaseArgs']]):
        pulumi.set(self, "database", value)

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @database_software_image_id.setter
    def database_software_image_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_software_image_id", value)

    @property
    @pulumi.getter(name="dbHomeLocation")
    def db_home_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of the Oracle Database Home.
        """
        return pulumi.get(self, "db_home_location")

    @db_home_location.setter
    def db_home_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_home_location", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The user-provided name of the Database Home.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="enableDatabaseDelete")
    def enable_database_delete(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "enable_database_delete")

    @enable_database_delete.setter
    def enable_database_delete(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enable_database_delete", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isDesupportedVersion")
    def is_desupported_version(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        If true, the customer acknowledges that the specified Oracle Database software is an older release that is not currently supported by OCI.
        """
        return pulumi.get(self, "is_desupported_version")

    @is_desupported_version.setter
    def is_desupported_version(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_desupported_version", value)

    @property
    @pulumi.getter(name="isUnifiedAuditingEnabled")
    def is_unified_auditing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether unified autiding is enabled or not. Set to True to enable unified auditing on respective DBHome.
        """
        return pulumi.get(self, "is_unified_auditing_enabled")

    @is_unified_auditing_enabled.setter
    def is_unified_auditing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_unified_auditing_enabled", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        """
        return pulumi.get(self, "kms_key_version_id")

    @kms_key_version_id.setter
    def kms_key_version_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "kms_key_version_id", value)

    @property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation is started.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @last_patch_history_entry_id.setter
    def last_patch_history_entry_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_patch_history_entry_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The source of database: NONE for creating a new database. DB_BACKUP for creating a new database by restoring from a database backup. VM_CLUSTER_NEW for creating a database for VM Cluster.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Database Home.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Database Home was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_id")

    @vm_cluster_id.setter
    def vm_cluster_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vm_cluster_id", value)


class DbHome(pulumi.CustomResource):

    pulumi_type = "oci:Database/dbHome:DbHome"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[Union['DbHomeDatabaseArgs', 'DbHomeDatabaseArgsDict']]] = None,
                 database_software_image_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_database_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_desupported_version: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unified_auditing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        DbHomes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbHome:DbHome test_db_home "id"
        ```

        Import is only supported for source=NONE

        database.0.admin_password is not returned by the service for security reasons. Add the following to the resource:

            lifecycle {
            
                ignore_changes = ["database.0.admin_password"]
            
            }

        The creation of an oci_database_db_system requires that it be created with exactly one oci_database_db_home. Therefore the first db home will have to be a property of the db system resource and any further db homes to be added to the db system will have to be added as first class resources using "oci_database_db_home".

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['DbHomeDatabaseArgs', 'DbHomeDatabaseArgsDict']] database: (Updatable) Details for creating a database.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[builtins.str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[builtins.str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[builtins.str] db_version: A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-provided name of the Database Home.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_desupported_version: If true, the customer acknowledges that the specified Oracle Database software is an older release that is not currently supported by OCI.
        :param pulumi.Input[builtins.bool] is_unified_auditing_enabled: Indicates whether unified autiding is enabled or not. Set to True to enable unified auditing on respective DBHome.
        :param pulumi.Input[builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        :param pulumi.Input[builtins.str] source: The source of database: NONE for creating a new database. DB_BACKUP for creating a new database by restoring from a database backup. VM_CLUSTER_NEW for creating a database for VM Cluster.
        :param pulumi.Input[builtins.str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DbHomeArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        DbHomes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/dbHome:DbHome test_db_home "id"
        ```

        Import is only supported for source=NONE

        database.0.admin_password is not returned by the service for security reasons. Add the following to the resource:

            lifecycle {
            
                ignore_changes = ["database.0.admin_password"]
            
            }

        The creation of an oci_database_db_system requires that it be created with exactly one oci_database_db_home. Therefore the first db home will have to be a property of the db system resource and any further db homes to be added to the db system will have to be added as first class resources using "oci_database_db_home".

        :param str resource_name: The name of the resource.
        :param DbHomeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbHomeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database: Optional[pulumi.Input[Union['DbHomeDatabaseArgs', 'DbHomeDatabaseArgsDict']]] = None,
                 database_software_image_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 enable_database_delete: Optional[pulumi.Input[builtins.bool]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_desupported_version: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unified_auditing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
                 kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
                 source: Optional[pulumi.Input[builtins.str]] = None,
                 vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbHomeArgs.__new__(DbHomeArgs)

            __props__.__dict__["database"] = database
            __props__.__dict__["database_software_image_id"] = database_software_image_id
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["db_version"] = db_version
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["enable_database_delete"] = enable_database_delete
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_desupported_version"] = is_desupported_version
            __props__.__dict__["is_unified_auditing_enabled"] = is_unified_auditing_enabled
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["kms_key_version_id"] = kms_key_version_id
            __props__.__dict__["source"] = source
            __props__.__dict__["vm_cluster_id"] = vm_cluster_id
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["db_home_location"] = None
            __props__.__dict__["last_patch_history_entry_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(DbHome, __self__).__init__(
            'oci:Database/dbHome:DbHome',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            database: Optional[pulumi.Input[Union['DbHomeDatabaseArgs', 'DbHomeDatabaseArgsDict']]] = None,
            database_software_image_id: Optional[pulumi.Input[builtins.str]] = None,
            db_home_location: Optional[pulumi.Input[builtins.str]] = None,
            db_system_id: Optional[pulumi.Input[builtins.str]] = None,
            db_version: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            enable_database_delete: Optional[pulumi.Input[builtins.bool]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_desupported_version: Optional[pulumi.Input[builtins.bool]] = None,
            is_unified_auditing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            kms_key_id: Optional[pulumi.Input[builtins.str]] = None,
            kms_key_version_id: Optional[pulumi.Input[builtins.str]] = None,
            last_patch_history_entry_id: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            source: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            vm_cluster_id: Optional[pulumi.Input[builtins.str]] = None) -> 'DbHome':
        """
        Get an existing DbHome resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Union['DbHomeDatabaseArgs', 'DbHomeDatabaseArgsDict']] database: (Updatable) Details for creating a database.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[builtins.str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[builtins.str] db_home_location: The location of the Oracle Database Home.
        :param pulumi.Input[builtins.str] db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[builtins.str] db_version: A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.
               
               This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: The user-provided name of the Database Home.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_desupported_version: If true, the customer acknowledges that the specified Oracle Database software is an older release that is not currently supported by OCI.
        :param pulumi.Input[builtins.bool] is_unified_auditing_enabled: Indicates whether unified autiding is enabled or not. Set to True to enable unified auditing on respective DBHome.
        :param pulumi.Input[builtins.str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[builtins.str] kms_key_version_id: The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        :param pulumi.Input[builtins.str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation is started.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] source: The source of database: NONE for creating a new database. DB_BACKUP for creating a new database by restoring from a database backup. VM_CLUSTER_NEW for creating a database for VM Cluster.
        :param pulumi.Input[builtins.str] state: The current state of the Database Home.
        :param pulumi.Input[builtins.str] time_created: The date and time the Database Home was created.
        :param pulumi.Input[builtins.str] vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbHomeState.__new__(_DbHomeState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["database"] = database
        __props__.__dict__["database_software_image_id"] = database_software_image_id
        __props__.__dict__["db_home_location"] = db_home_location
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["enable_database_delete"] = enable_database_delete
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_desupported_version"] = is_desupported_version
        __props__.__dict__["is_unified_auditing_enabled"] = is_unified_auditing_enabled
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_version_id"] = kms_key_version_id
        __props__.__dict__["last_patch_history_entry_id"] = last_patch_history_entry_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["vm_cluster_id"] = vm_cluster_id
        return DbHome(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def database(self) -> pulumi.Output['outputs.DbHomeDatabase']:
        """
        (Updatable) Details for creating a database.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> pulumi.Output[builtins.str]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "database_software_image_id")

    @property
    @pulumi.getter(name="dbHomeLocation")
    def db_home_location(self) -> pulumi.Output[builtins.str]:
        """
        The location of the Oracle Database Home.
        """
        return pulumi.get(self, "db_home_location")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[builtins.str]:
        """
        A valid Oracle Database version. For a list of supported versions, use the ListDbVersions operation.

        This cannot be updated in parallel with any of the following: licenseModel, dbEdition, cpuCoreCount, computeCount, computeModel, adminPassword, whitelistedIps, isMTLSConnectionRequired, openMode, permissionLevel, dbWorkload, privateEndpointLabel, nsgIds, isRefreshable, dbName, scheduledOperations, dbToolsDetails, isLocalDataGuardEnabled, or isFreeTier.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The user-provided name of the Database Home.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableDatabaseDelete")
    def enable_database_delete(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "enable_database_delete")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isDesupportedVersion")
    def is_desupported_version(self) -> pulumi.Output[builtins.bool]:
        """
        If true, the customer acknowledges that the specified Oracle Database software is an older release that is not currently supported by OCI.
        """
        return pulumi.get(self, "is_desupported_version")

    @property
    @pulumi.getter(name="isUnifiedAuditingEnabled")
    def is_unified_auditing_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether unified autiding is enabled or not. Set to True to enable unified auditing on respective DBHome.
        """
        return pulumi.get(self, "is_unified_auditing_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the key container version that is used in database transparent data encryption (TDE) operations KMS Key can have multiple key versions. If none is specified, the current key version (latest) of the Key Id is used for the operation.
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation is started.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[builtins.str]:
        """
        The source of database: NONE for creating a new database. DB_BACKUP for creating a new database by restoring from a database backup. VM_CLUSTER_NEW for creating a database for VM Cluster.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Database Home.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Database Home was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM cluster.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vm_cluster_id")

