# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ExascaleDbStorageVaultArgs', 'ExascaleDbStorageVault']

@pulumi.input_type
class ExascaleDbStorageVaultArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 high_capacity_database_storage: pulumi.Input['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs'],
                 additional_flash_cache_in_percent: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ExascaleDbStorageVault resource.
        :param pulumi.Input[builtins.str] availability_domain: The name of the availability domain in which the Exadata Database Storage Vault is located.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        :param pulumi.Input['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs'] high_capacity_database_storage: (Updatable) Create exadata Database Storage Details
        :param pulumi.Input[builtins.int] additional_flash_cache_in_percent: (Updatable) The size of additional Flash Cache in percentage of High Capacity database storage.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] description: (Updatable) Exadata Database Storage Vault description.
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        :param pulumi.Input[builtins.str] time_zone: The time zone that you want to use for the Exadata Database Storage Vault. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "high_capacity_database_storage", high_capacity_database_storage)
        if additional_flash_cache_in_percent is not None:
            pulumi.set(__self__, "additional_flash_cache_in_percent", additional_flash_cache_in_percent)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[builtins.str]:
        """
        The name of the availability domain in which the Exadata Database Storage Vault is located.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="highCapacityDatabaseStorage")
    def high_capacity_database_storage(self) -> pulumi.Input['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs']:
        """
        (Updatable) Create exadata Database Storage Details
        """
        return pulumi.get(self, "high_capacity_database_storage")

    @high_capacity_database_storage.setter
    def high_capacity_database_storage(self, value: pulumi.Input['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs']):
        pulumi.set(self, "high_capacity_database_storage", value)

    @property
    @pulumi.getter(name="additionalFlashCacheInPercent")
    def additional_flash_cache_in_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The size of additional Flash Cache in percentage of High Capacity database storage.
        """
        return pulumi.get(self, "additional_flash_cache_in_percent")

    @additional_flash_cache_in_percent.setter
    def additional_flash_cache_in_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "additional_flash_cache_in_percent", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Exadata Database Storage Vault description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time zone that you want to use for the Exadata Database Storage Vault. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _ExascaleDbStorageVaultState:
    def __init__(__self__, *,
                 additional_flash_cache_in_percent: Optional[pulumi.Input[builtins.int]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 high_capacity_database_storage: Optional[pulumi.Input['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs']] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 vm_cluster_count: Optional[pulumi.Input[builtins.int]] = None,
                 vm_cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ExascaleDbStorageVault resources.
        :param pulumi.Input[builtins.int] additional_flash_cache_in_percent: (Updatable) The size of additional Flash Cache in percentage of High Capacity database storage.
        :param pulumi.Input[builtins.str] availability_domain: The name of the availability domain in which the Exadata Database Storage Vault is located.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] description: (Updatable) Exadata Database Storage Vault description.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs'] high_capacity_database_storage: (Updatable) Create exadata Database Storage Details
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] state: The current state of the Exadata Database Storage Vault.
        :param pulumi.Input[builtins.str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] time_created: The date and time that the Exadata Database Storage Vault was created.
        :param pulumi.Input[builtins.str] time_zone: The time zone that you want to use for the Exadata Database Storage Vault. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.int] vm_cluster_count: The number of Exadata VM clusters used the Exadata Database Storage Vault.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vm_cluster_ids: The List of Exadata VM cluster on Exascale Infrastructure [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) **Note:** If Exadata Database Storage Vault is not used for any Exadata VM cluster on Exascale Infrastructure, this list is empty.
        """
        if additional_flash_cache_in_percent is not None:
            pulumi.set(__self__, "additional_flash_cache_in_percent", additional_flash_cache_in_percent)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if cluster_placement_group_id is not None:
            pulumi.set(__self__, "cluster_placement_group_id", cluster_placement_group_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if exadata_infrastructure_id is not None:
            pulumi.set(__self__, "exadata_infrastructure_id", exadata_infrastructure_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if high_capacity_database_storage is not None:
            pulumi.set(__self__, "high_capacity_database_storage", high_capacity_database_storage)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subscription_id is not None:
            pulumi.set(__self__, "subscription_id", subscription_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if vm_cluster_count is not None:
            pulumi.set(__self__, "vm_cluster_count", vm_cluster_count)
        if vm_cluster_ids is not None:
            pulumi.set(__self__, "vm_cluster_ids", vm_cluster_ids)

    @property
    @pulumi.getter(name="additionalFlashCacheInPercent")
    def additional_flash_cache_in_percent(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The size of additional Flash Cache in percentage of High Capacity database storage.
        """
        return pulumi.get(self, "additional_flash_cache_in_percent")

    @additional_flash_cache_in_percent.setter
    def additional_flash_cache_in_percent(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "additional_flash_cache_in_percent", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the availability domain in which the Exadata Database Storage Vault is located.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_placement_group_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Exadata Database Storage Vault description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="highCapacityDatabaseStorage")
    def high_capacity_database_storage(self) -> Optional[pulumi.Input['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs']]:
        """
        (Updatable) Create exadata Database Storage Details
        """
        return pulumi.get(self, "high_capacity_database_storage")

    @high_capacity_database_storage.setter
    def high_capacity_database_storage(self, value: Optional[pulumi.Input['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs']]):
        pulumi.set(self, "high_capacity_database_storage", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        """
        return pulumi.get(self, "subscription_id")

    @subscription_id.setter
    def subscription_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subscription_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time that the Exadata Database Storage Vault was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time zone that you want to use for the Exadata Database Storage Vault. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="vmClusterCount")
    def vm_cluster_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of Exadata VM clusters used the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "vm_cluster_count")

    @vm_cluster_count.setter
    def vm_cluster_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "vm_cluster_count", value)

    @property
    @pulumi.getter(name="vmClusterIds")
    def vm_cluster_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The List of Exadata VM cluster on Exascale Infrastructure [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) **Note:** If Exadata Database Storage Vault is not used for any Exadata VM cluster on Exascale Infrastructure, this list is empty.
        """
        return pulumi.get(self, "vm_cluster_ids")

    @vm_cluster_ids.setter
    def vm_cluster_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "vm_cluster_ids", value)


class ExascaleDbStorageVault(pulumi.CustomResource):

    pulumi_type = "oci:Database/exascaleDbStorageVault:ExascaleDbStorageVault"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_flash_cache_in_percent: Optional[pulumi.Input[builtins.int]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 high_capacity_database_storage: Optional[pulumi.Input[Union['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDbStorageVaultHighCapacityDatabaseStorageArgsDict']]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Exascale Db Storage Vault resource in Oracle Cloud Infrastructure Database service.

        Creates an Exadata Database Storage Vault

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exascale_db_storage_vault = oci.database.ExascaleDbStorageVault("test_exascale_db_storage_vault",
            availability_domain=exascale_db_storage_vault_availability_domain,
            compartment_id=compartment_id,
            display_name=exascale_db_storage_vault_display_name,
            high_capacity_database_storage={
                "total_size_in_gbs": exascale_db_storage_vault_high_capacity_database_storage_total_size_in_gbs,
            },
            additional_flash_cache_in_percent=exascale_db_storage_vault_additional_flash_cache_in_percent,
            cluster_placement_group_id=test_cluster_placement_group["id"],
            defined_tags=exascale_db_storage_vault_defined_tags,
            description=exascale_db_storage_vault_description,
            exadata_infrastructure_id=test_exadata_infrastructure["id"],
            freeform_tags={
                "Department": "Finance",
            },
            subscription_id=tenant_subscription_id,
            time_zone=exascale_db_storage_vault_time_zone)
        ```

        ## Import

        ExascaleDbStorageVaults can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/exascaleDbStorageVault:ExascaleDbStorageVault test_exascale_db_storage_vault "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] additional_flash_cache_in_percent: (Updatable) The size of additional Flash Cache in percentage of High Capacity database storage.
        :param pulumi.Input[builtins.str] availability_domain: The name of the availability domain in which the Exadata Database Storage Vault is located.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] description: (Updatable) Exadata Database Storage Vault description.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDbStorageVaultHighCapacityDatabaseStorageArgsDict']] high_capacity_database_storage: (Updatable) Create exadata Database Storage Details
        :param pulumi.Input[builtins.str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        :param pulumi.Input[builtins.str] time_zone: The time zone that you want to use for the Exadata Database Storage Vault. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ExascaleDbStorageVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Exascale Db Storage Vault resource in Oracle Cloud Infrastructure Database service.

        Creates an Exadata Database Storage Vault

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_exascale_db_storage_vault = oci.database.ExascaleDbStorageVault("test_exascale_db_storage_vault",
            availability_domain=exascale_db_storage_vault_availability_domain,
            compartment_id=compartment_id,
            display_name=exascale_db_storage_vault_display_name,
            high_capacity_database_storage={
                "total_size_in_gbs": exascale_db_storage_vault_high_capacity_database_storage_total_size_in_gbs,
            },
            additional_flash_cache_in_percent=exascale_db_storage_vault_additional_flash_cache_in_percent,
            cluster_placement_group_id=test_cluster_placement_group["id"],
            defined_tags=exascale_db_storage_vault_defined_tags,
            description=exascale_db_storage_vault_description,
            exadata_infrastructure_id=test_exadata_infrastructure["id"],
            freeform_tags={
                "Department": "Finance",
            },
            subscription_id=tenant_subscription_id,
            time_zone=exascale_db_storage_vault_time_zone)
        ```

        ## Import

        ExascaleDbStorageVaults can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/exascaleDbStorageVault:ExascaleDbStorageVault test_exascale_db_storage_vault "id"
        ```

        :param str resource_name: The name of the resource.
        :param ExascaleDbStorageVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ExascaleDbStorageVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_flash_cache_in_percent: Optional[pulumi.Input[builtins.int]] = None,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 high_capacity_database_storage: Optional[pulumi.Input[Union['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDbStorageVaultHighCapacityDatabaseStorageArgsDict']]] = None,
                 subscription_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ExascaleDbStorageVaultArgs.__new__(ExascaleDbStorageVaultArgs)

            __props__.__dict__["additional_flash_cache_in_percent"] = additional_flash_cache_in_percent
            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            if high_capacity_database_storage is None and not opts.urn:
                raise TypeError("Missing required property 'high_capacity_database_storage'")
            __props__.__dict__["high_capacity_database_storage"] = high_capacity_database_storage
            __props__.__dict__["subscription_id"] = subscription_id
            __props__.__dict__["time_zone"] = time_zone
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["vm_cluster_count"] = None
            __props__.__dict__["vm_cluster_ids"] = None
        super(ExascaleDbStorageVault, __self__).__init__(
            'oci:Database/exascaleDbStorageVault:ExascaleDbStorageVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_flash_cache_in_percent: Optional[pulumi.Input[builtins.int]] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            cluster_placement_group_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            exadata_infrastructure_id: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            high_capacity_database_storage: Optional[pulumi.Input[Union['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDbStorageVaultHighCapacityDatabaseStorageArgsDict']]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subscription_id: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None,
            vm_cluster_count: Optional[pulumi.Input[builtins.int]] = None,
            vm_cluster_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'ExascaleDbStorageVault':
        """
        Get an existing ExascaleDbStorageVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] additional_flash_cache_in_percent: (Updatable) The size of additional Flash Cache in percentage of High Capacity database storage.
        :param pulumi.Input[builtins.str] availability_domain: The name of the availability domain in which the Exadata Database Storage Vault is located.
        :param pulumi.Input[builtins.str] cluster_placement_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] description: (Updatable) Exadata Database Storage Vault description.
        :param pulumi.Input[builtins.str] display_name: (Updatable) The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        :param pulumi.Input[builtins.str] exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['ExascaleDbStorageVaultHighCapacityDatabaseStorageArgs', 'ExascaleDbStorageVaultHighCapacityDatabaseStorageArgsDict']] high_capacity_database_storage: (Updatable) Create exadata Database Storage Details
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[builtins.str] state: The current state of the Exadata Database Storage Vault.
        :param pulumi.Input[builtins.str] subscription_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] time_created: The date and time that the Exadata Database Storage Vault was created.
        :param pulumi.Input[builtins.str] time_zone: The time zone that you want to use for the Exadata Database Storage Vault. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.int] vm_cluster_count: The number of Exadata VM clusters used the Exadata Database Storage Vault.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] vm_cluster_ids: The List of Exadata VM cluster on Exascale Infrastructure [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) **Note:** If Exadata Database Storage Vault is not used for any Exadata VM cluster on Exascale Infrastructure, this list is empty.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ExascaleDbStorageVaultState.__new__(_ExascaleDbStorageVaultState)

        __props__.__dict__["additional_flash_cache_in_percent"] = additional_flash_cache_in_percent
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["cluster_placement_group_id"] = cluster_placement_group_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["exadata_infrastructure_id"] = exadata_infrastructure_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["high_capacity_database_storage"] = high_capacity_database_storage
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["state"] = state
        __props__.__dict__["subscription_id"] = subscription_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["vm_cluster_count"] = vm_cluster_count
        __props__.__dict__["vm_cluster_ids"] = vm_cluster_ids
        return ExascaleDbStorageVault(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalFlashCacheInPercent")
    def additional_flash_cache_in_percent(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The size of additional Flash Cache in percentage of High Capacity database storage.
        """
        return pulumi.get(self, "additional_flash_cache_in_percent")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The name of the availability domain in which the Exadata Database Storage Vault is located.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="clusterPlacementGroupId")
    def cluster_placement_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cluster placement group of the Exadata Infrastructure.
        """
        return pulumi.get(self, "cluster_placement_group_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Exadata Database Storage Vault description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The user-friendly name for the Exadata Database Storage Vault. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exadataInfrastructureId")
    def exadata_infrastructure_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
        """
        return pulumi.get(self, "exadata_infrastructure_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="highCapacityDatabaseStorage")
    def high_capacity_database_storage(self) -> pulumi.Output['outputs.ExascaleDbStorageVaultHighCapacityDatabaseStorage']:
        """
        (Updatable) Create exadata Database Storage Details
        """
        return pulumi.get(self, "high_capacity_database_storage")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subscription with which resource needs to be associated with.
        """
        return pulumi.get(self, "subscription_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time that the Exadata Database Storage Vault was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[builtins.str]:
        """
        The time zone that you want to use for the Exadata Database Storage Vault. For details, see [Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm). 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vmClusterCount")
    def vm_cluster_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of Exadata VM clusters used the Exadata Database Storage Vault.
        """
        return pulumi.get(self, "vm_cluster_count")

    @property
    @pulumi.getter(name="vmClusterIds")
    def vm_cluster_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The List of Exadata VM cluster on Exascale Infrastructure [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) **Note:** If Exadata Database Storage Vault is not used for any Exadata VM cluster on Exascale Infrastructure, this list is empty.
        """
        return pulumi.get(self, "vm_cluster_ids")

