# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OneoffPatchArgs', 'OneoffPatch']

@pulumi.input_type
class OneoffPatchArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 db_version: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 release_update: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 download_oneoff_patch_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a OneoffPatch resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] db_version: A valid Oracle Database version. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[builtins.str] display_name: One-off patch name.
        :param pulumi.Input[builtins.str] release_update: The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.int] download_oneoff_patch_trigger: (Updatable) An optional property when incremented triggers Download Oneoff Patch. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] one_off_patches: List of one-off patches for Database Homes.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "release_update", release_update)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if download_oneoff_patch_trigger is not None:
            pulumi.set(__self__, "download_oneoff_patch_trigger", download_oneoff_patch_trigger)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if one_off_patches is not None:
            pulumi.set(__self__, "one_off_patches", one_off_patches)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Input[builtins.str]:
        """
        A valid Oracle Database version. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        One-off patch name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="releaseUpdate")
    def release_update(self) -> pulumi.Input[builtins.str]:
        """
        The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "release_update")

    @release_update.setter
    def release_update(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "release_update", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="downloadOneoffPatchTrigger")
    def download_oneoff_patch_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Download Oneoff Patch. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "download_oneoff_patch_trigger")

    @download_oneoff_patch_trigger.setter
    def download_oneoff_patch_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "download_oneoff_patch_trigger", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="oneOffPatches")
    def one_off_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "one_off_patches")

    @one_off_patches.setter
    def one_off_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "one_off_patches", value)


@pulumi.input_type
class _OneoffPatchState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 download_oneoff_patch_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 release_update: Optional[pulumi.Input[builtins.str]] = None,
                 sha256sum: Optional[pulumi.Input[builtins.str]] = None,
                 size_in_kbs: Optional[pulumi.Input[builtins.float]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_of_expiration: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OneoffPatch resources.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] db_version: A valid Oracle Database version. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: One-off patch name.
        :param pulumi.Input[builtins.int] download_oneoff_patch_trigger: (Updatable) An optional property when incremented triggers Download Oneoff Patch. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] one_off_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[builtins.str] release_update: The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[builtins.str] sha256sum: SHA-256 checksum of the one-off patch.
        :param pulumi.Input[builtins.float] size_in_kbs: The size of one-off patch in kilobytes.
        :param pulumi.Input[builtins.str] state: The current state of the one-off patch.
        :param pulumi.Input[builtins.str] time_created: The date and time one-off patch was created.
        :param pulumi.Input[builtins.str] time_of_expiration: The date and time until which the one-off patch will be available for download.
        :param pulumi.Input[builtins.str] time_updated: The date and time one-off patch was updated.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if download_oneoff_patch_trigger is not None:
            pulumi.set(__self__, "download_oneoff_patch_trigger", download_oneoff_patch_trigger)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if one_off_patches is not None:
            pulumi.set(__self__, "one_off_patches", one_off_patches)
        if release_update is not None:
            pulumi.set(__self__, "release_update", release_update)
        if sha256sum is not None:
            pulumi.set(__self__, "sha256sum", sha256sum)
        if size_in_kbs is not None:
            pulumi.set(__self__, "size_in_kbs", size_in_kbs)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_expiration is not None:
            pulumi.set(__self__, "time_of_expiration", time_of_expiration)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A valid Oracle Database version. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        One-off patch name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="downloadOneoffPatchTrigger")
    def download_oneoff_patch_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Download Oneoff Patch. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "download_oneoff_patch_trigger")

    @download_oneoff_patch_trigger.setter
    def download_oneoff_patch_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "download_oneoff_patch_trigger", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="oneOffPatches")
    def one_off_patches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "one_off_patches")

    @one_off_patches.setter
    def one_off_patches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "one_off_patches", value)

    @property
    @pulumi.getter(name="releaseUpdate")
    def release_update(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "release_update")

    @release_update.setter
    def release_update(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "release_update", value)

    @property
    @pulumi.getter
    def sha256sum(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        SHA-256 checksum of the one-off patch.
        """
        return pulumi.get(self, "sha256sum")

    @sha256sum.setter
    def sha256sum(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sha256sum", value)

    @property
    @pulumi.getter(name="sizeInKbs")
    def size_in_kbs(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The size of one-off patch in kilobytes.
        """
        return pulumi.get(self, "size_in_kbs")

    @size_in_kbs.setter
    def size_in_kbs(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "size_in_kbs", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the one-off patch.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time one-off patch was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeOfExpiration")
    def time_of_expiration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time until which the one-off patch will be available for download.
        """
        return pulumi.get(self, "time_of_expiration")

    @time_of_expiration.setter
    def time_of_expiration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_of_expiration", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time one-off patch was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class OneoffPatch(pulumi.CustomResource):

    pulumi_type = "oci:Database/oneoffPatch:OneoffPatch"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 download_oneoff_patch_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 release_update: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Oneoff Patch resource in Oracle Cloud Infrastructure Database service.

        Creates one-off patch for specified database version to download.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oneoff_patch = oci.database.OneoffPatch("test_oneoff_patch",
            compartment_id=compartment_id,
            db_version=oneoff_patch_db_version,
            display_name=oneoff_patch_display_name,
            release_update=oneoff_patch_release_update,
            defined_tags=oneoff_patch_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            one_off_patches=oneoff_patch_one_off_patches)
        ```

        ## Import

        OneoffPatches can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/oneoffPatch:OneoffPatch test_oneoff_patch "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] db_version: A valid Oracle Database version. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: One-off patch name.
        :param pulumi.Input[builtins.int] download_oneoff_patch_trigger: (Updatable) An optional property when incremented triggers Download Oneoff Patch. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] one_off_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[builtins.str] release_update: The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OneoffPatchArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Oneoff Patch resource in Oracle Cloud Infrastructure Database service.

        Creates one-off patch for specified database version to download.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oneoff_patch = oci.database.OneoffPatch("test_oneoff_patch",
            compartment_id=compartment_id,
            db_version=oneoff_patch_db_version,
            display_name=oneoff_patch_display_name,
            release_update=oneoff_patch_release_update,
            defined_tags=oneoff_patch_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            one_off_patches=oneoff_patch_one_off_patches)
        ```

        ## Import

        OneoffPatches can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/oneoffPatch:OneoffPatch test_oneoff_patch "id"
        ```

        :param str resource_name: The name of the resource.
        :param OneoffPatchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OneoffPatchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 download_oneoff_patch_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 release_update: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OneoffPatchArgs.__new__(OneoffPatchArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if db_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_version'")
            __props__.__dict__["db_version"] = db_version
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["download_oneoff_patch_trigger"] = download_oneoff_patch_trigger
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["one_off_patches"] = one_off_patches
            if release_update is None and not opts.urn:
                raise TypeError("Missing required property 'release_update'")
            __props__.__dict__["release_update"] = release_update
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["sha256sum"] = None
            __props__.__dict__["size_in_kbs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_expiration"] = None
            __props__.__dict__["time_updated"] = None
        super(OneoffPatch, __self__).__init__(
            'oci:Database/oneoffPatch:OneoffPatch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            db_version: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            download_oneoff_patch_trigger: Optional[pulumi.Input[builtins.int]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            one_off_patches: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            release_update: Optional[pulumi.Input[builtins.str]] = None,
            sha256sum: Optional[pulumi.Input[builtins.str]] = None,
            size_in_kbs: Optional[pulumi.Input[builtins.float]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_of_expiration: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'OneoffPatch':
        """
        Get an existing OneoffPatch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[builtins.str] db_version: A valid Oracle Database version. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[builtins.str] display_name: One-off patch name.
        :param pulumi.Input[builtins.int] download_oneoff_patch_trigger: (Updatable) An optional property when incremented triggers Download Oneoff Patch. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] one_off_patches: List of one-off patches for Database Homes.
        :param pulumi.Input[builtins.str] release_update: The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        :param pulumi.Input[builtins.str] sha256sum: SHA-256 checksum of the one-off patch.
        :param pulumi.Input[builtins.float] size_in_kbs: The size of one-off patch in kilobytes.
        :param pulumi.Input[builtins.str] state: The current state of the one-off patch.
        :param pulumi.Input[builtins.str] time_created: The date and time one-off patch was created.
        :param pulumi.Input[builtins.str] time_of_expiration: The date and time until which the one-off patch will be available for download.
        :param pulumi.Input[builtins.str] time_updated: The date and time one-off patch was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OneoffPatchState.__new__(_OneoffPatchState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["download_oneoff_patch_trigger"] = download_oneoff_patch_trigger
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["one_off_patches"] = one_off_patches
        __props__.__dict__["release_update"] = release_update
        __props__.__dict__["sha256sum"] = sha256sum
        __props__.__dict__["size_in_kbs"] = size_in_kbs
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_expiration"] = time_of_expiration
        __props__.__dict__["time_updated"] = time_updated
        return OneoffPatch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[builtins.str]:
        """
        A valid Oracle Database version. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        One-off patch name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="downloadOneoffPatchTrigger")
    def download_oneoff_patch_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Download Oneoff Patch. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "download_oneoff_patch_trigger")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="oneOffPatches")
    def one_off_patches(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of one-off patches for Database Homes.
        """
        return pulumi.get(self, "one_off_patches")

    @property
    @pulumi.getter(name="releaseUpdate")
    def release_update(self) -> pulumi.Output[builtins.str]:
        """
        The PSU or PBP or Release Updates. To get a list of supported versions, use the [ListDbVersions](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbVersionSummary/ListDbVersions) operation.
        """
        return pulumi.get(self, "release_update")

    @property
    @pulumi.getter
    def sha256sum(self) -> pulumi.Output[builtins.str]:
        """
        SHA-256 checksum of the one-off patch.
        """
        return pulumi.get(self, "sha256sum")

    @property
    @pulumi.getter(name="sizeInKbs")
    def size_in_kbs(self) -> pulumi.Output[builtins.float]:
        """
        The size of one-off patch in kilobytes.
        """
        return pulumi.get(self, "size_in_kbs")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the one-off patch.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time one-off patch was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfExpiration")
    def time_of_expiration(self) -> pulumi.Output[builtins.str]:
        """
        The date and time until which the one-off patch will be available for download.
        """
        return pulumi.get(self, "time_of_expiration")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time one-off patch was updated.
        """
        return pulumi.get(self, "time_updated")

