# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PluggableDatabasesLocalCloneArgs', 'PluggableDatabasesLocalClone']

@pulumi.input_type
class PluggableDatabasesLocalCloneArgs:
    def __init__(__self__, *,
                 cloned_pdb_name: pulumi.Input[builtins.str],
                 pluggable_database_id: pulumi.Input[builtins.str],
                 pdb_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 should_pdb_admin_account_be_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 target_tde_wallet_password: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a PluggableDatabasesLocalClone resource.
        :param pulumi.Input[builtins.str] cloned_pdb_name: The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        :param pulumi.Input[builtins.str] pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] pdb_admin_password: A strong password for PDB Admin of the newly cloned PDB. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.
        :param pulumi.Input[builtins.bool] should_pdb_admin_account_be_locked: The locked mode of the pluggable database admin account. If false, the user needs to provide the PDB Admin Password to connect to it. If true, the pluggable database will be locked and user cannot login to it.
        :param pulumi.Input[builtins.str] target_tde_wallet_password: The existing TDE wallet password of the target CDB.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "cloned_pdb_name", cloned_pdb_name)
        pulumi.set(__self__, "pluggable_database_id", pluggable_database_id)
        if pdb_admin_password is not None:
            pulumi.set(__self__, "pdb_admin_password", pdb_admin_password)
        if should_pdb_admin_account_be_locked is not None:
            pulumi.set(__self__, "should_pdb_admin_account_be_locked", should_pdb_admin_account_be_locked)
        if target_tde_wallet_password is not None:
            pulumi.set(__self__, "target_tde_wallet_password", target_tde_wallet_password)

    @property
    @pulumi.getter(name="clonedPdbName")
    def cloned_pdb_name(self) -> pulumi.Input[builtins.str]:
        """
        The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        """
        return pulumi.get(self, "cloned_pdb_name")

    @cloned_pdb_name.setter
    def cloned_pdb_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "cloned_pdb_name", value)

    @property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> pulumi.Input[builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "pluggable_database_id")

    @pluggable_database_id.setter
    def pluggable_database_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "pluggable_database_id", value)

    @property
    @pulumi.getter(name="pdbAdminPassword")
    def pdb_admin_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A strong password for PDB Admin of the newly cloned PDB. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.
        """
        return pulumi.get(self, "pdb_admin_password")

    @pdb_admin_password.setter
    def pdb_admin_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pdb_admin_password", value)

    @property
    @pulumi.getter(name="shouldPdbAdminAccountBeLocked")
    def should_pdb_admin_account_be_locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The locked mode of the pluggable database admin account. If false, the user needs to provide the PDB Admin Password to connect to it. If true, the pluggable database will be locked and user cannot login to it.
        """
        return pulumi.get(self, "should_pdb_admin_account_be_locked")

    @should_pdb_admin_account_be_locked.setter
    def should_pdb_admin_account_be_locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_pdb_admin_account_be_locked", value)

    @property
    @pulumi.getter(name="targetTdeWalletPassword")
    def target_tde_wallet_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The existing TDE wallet password of the target CDB.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_tde_wallet_password")

    @target_tde_wallet_password.setter
    def target_tde_wallet_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_tde_wallet_password", value)


@pulumi.input_type
class _PluggableDatabasesLocalCloneState:
    def __init__(__self__, *,
                 cloned_pdb_name: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalCloneConnectionStringArgs']]]] = None,
                 container_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_restricted: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 open_mode: Optional[pulumi.Input[builtins.str]] = None,
                 pdb_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 pdb_name: Optional[pulumi.Input[builtins.str]] = None,
                 pdb_node_level_details: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalClonePdbNodeLevelDetailArgs']]]] = None,
                 pluggable_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 pluggable_database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalClonePluggableDatabaseManagementConfigArgs']]]] = None,
                 refreshable_clone_configs: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalCloneRefreshableCloneConfigArgs']]]] = None,
                 should_pdb_admin_account_be_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 target_tde_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering PluggableDatabasesLocalClone resources.
        :param pulumi.Input[builtins.str] cloned_pdb_name: The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalCloneConnectionStringArgs']]] connection_strings: Connection strings to connect to an Oracle Pluggable Database.
        :param pulumi.Input[builtins.str] container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_restricted: The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        :param pulumi.Input[builtins.str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[builtins.str] open_mode: The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        :param pulumi.Input[builtins.str] pdb_admin_password: A strong password for PDB Admin of the newly cloned PDB. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.
        :param pulumi.Input[builtins.str] pdb_name: The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        :param pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalClonePdbNodeLevelDetailArgs']]] pdb_node_level_details: Pluggable Database Node Level Details. Example: [{"nodeName" : "node1", "openMode" : "READ_WRITE"}, {"nodeName" : "node2", "openMode" : "READ_ONLY"}]
        :param pulumi.Input[builtins.str] pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalClonePluggableDatabaseManagementConfigArgs']]] pluggable_database_management_configs: The configuration of the Pluggable Database Management service.
        :param pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalCloneRefreshableCloneConfigArgs']]] refreshable_clone_configs: Pluggable Database Refreshable Clone Configuration.
        :param pulumi.Input[builtins.bool] should_pdb_admin_account_be_locked: The locked mode of the pluggable database admin account. If false, the user needs to provide the PDB Admin Password to connect to it. If true, the pluggable database will be locked and user cannot login to it.
        :param pulumi.Input[builtins.str] state: The current state of the pluggable database.
        :param pulumi.Input[builtins.str] target_tde_wallet_password: The existing TDE wallet password of the target CDB.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the pluggable database was created.
        """
        if cloned_pdb_name is not None:
            pulumi.set(__self__, "cloned_pdb_name", cloned_pdb_name)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if container_database_id is not None:
            pulumi.set(__self__, "container_database_id", container_database_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_restricted is not None:
            pulumi.set(__self__, "is_restricted", is_restricted)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if open_mode is not None:
            pulumi.set(__self__, "open_mode", open_mode)
        if pdb_admin_password is not None:
            pulumi.set(__self__, "pdb_admin_password", pdb_admin_password)
        if pdb_name is not None:
            pulumi.set(__self__, "pdb_name", pdb_name)
        if pdb_node_level_details is not None:
            pulumi.set(__self__, "pdb_node_level_details", pdb_node_level_details)
        if pluggable_database_id is not None:
            pulumi.set(__self__, "pluggable_database_id", pluggable_database_id)
        if pluggable_database_management_configs is not None:
            pulumi.set(__self__, "pluggable_database_management_configs", pluggable_database_management_configs)
        if refreshable_clone_configs is not None:
            pulumi.set(__self__, "refreshable_clone_configs", refreshable_clone_configs)
        if should_pdb_admin_account_be_locked is not None:
            pulumi.set(__self__, "should_pdb_admin_account_be_locked", should_pdb_admin_account_be_locked)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_tde_wallet_password is not None:
            pulumi.set(__self__, "target_tde_wallet_password", target_tde_wallet_password)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="clonedPdbName")
    def cloned_pdb_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        """
        return pulumi.get(self, "cloned_pdb_name")

    @cloned_pdb_name.setter
    def cloned_pdb_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cloned_pdb_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalCloneConnectionStringArgs']]]]:
        """
        Connection strings to connect to an Oracle Pluggable Database.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalCloneConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        """
        return pulumi.get(self, "container_database_id")

    @container_database_id.setter
    def container_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "container_database_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        """
        return pulumi.get(self, "is_restricted")

    @is_restricted.setter
    def is_restricted(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_restricted", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="openMode")
    def open_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        """
        return pulumi.get(self, "open_mode")

    @open_mode.setter
    def open_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "open_mode", value)

    @property
    @pulumi.getter(name="pdbAdminPassword")
    def pdb_admin_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A strong password for PDB Admin of the newly cloned PDB. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.
        """
        return pulumi.get(self, "pdb_admin_password")

    @pdb_admin_password.setter
    def pdb_admin_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pdb_admin_password", value)

    @property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        """
        return pulumi.get(self, "pdb_name")

    @pdb_name.setter
    def pdb_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pdb_name", value)

    @property
    @pulumi.getter(name="pdbNodeLevelDetails")
    def pdb_node_level_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalClonePdbNodeLevelDetailArgs']]]]:
        """
        Pluggable Database Node Level Details. Example: [{"nodeName" : "node1", "openMode" : "READ_WRITE"}, {"nodeName" : "node2", "openMode" : "READ_ONLY"}]
        """
        return pulumi.get(self, "pdb_node_level_details")

    @pdb_node_level_details.setter
    def pdb_node_level_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalClonePdbNodeLevelDetailArgs']]]]):
        pulumi.set(self, "pdb_node_level_details", value)

    @property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "pluggable_database_id")

    @pluggable_database_id.setter
    def pluggable_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "pluggable_database_id", value)

    @property
    @pulumi.getter(name="pluggableDatabaseManagementConfigs")
    def pluggable_database_management_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalClonePluggableDatabaseManagementConfigArgs']]]]:
        """
        The configuration of the Pluggable Database Management service.
        """
        return pulumi.get(self, "pluggable_database_management_configs")

    @pluggable_database_management_configs.setter
    def pluggable_database_management_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalClonePluggableDatabaseManagementConfigArgs']]]]):
        pulumi.set(self, "pluggable_database_management_configs", value)

    @property
    @pulumi.getter(name="refreshableCloneConfigs")
    def refreshable_clone_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalCloneRefreshableCloneConfigArgs']]]]:
        """
        Pluggable Database Refreshable Clone Configuration.
        """
        return pulumi.get(self, "refreshable_clone_configs")

    @refreshable_clone_configs.setter
    def refreshable_clone_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PluggableDatabasesLocalCloneRefreshableCloneConfigArgs']]]]):
        pulumi.set(self, "refreshable_clone_configs", value)

    @property
    @pulumi.getter(name="shouldPdbAdminAccountBeLocked")
    def should_pdb_admin_account_be_locked(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The locked mode of the pluggable database admin account. If false, the user needs to provide the PDB Admin Password to connect to it. If true, the pluggable database will be locked and user cannot login to it.
        """
        return pulumi.get(self, "should_pdb_admin_account_be_locked")

    @should_pdb_admin_account_be_locked.setter
    def should_pdb_admin_account_be_locked(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "should_pdb_admin_account_be_locked", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the pluggable database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetTdeWalletPassword")
    def target_tde_wallet_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The existing TDE wallet password of the target CDB.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_tde_wallet_password")

    @target_tde_wallet_password.setter
    def target_tde_wallet_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_tde_wallet_password", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the pluggable database was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


class PluggableDatabasesLocalClone(pulumi.CustomResource):

    pulumi_type = "oci:Database/pluggableDatabasesLocalClone:PluggableDatabasesLocalClone"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloned_pdb_name: Optional[pulumi.Input[builtins.str]] = None,
                 pdb_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 pluggable_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 should_pdb_admin_account_be_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 target_tde_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Pluggable Databases Local Clone resource in Oracle Cloud Infrastructure Database service. Although pluggable databases(PDB) belong to a container database(CDB), there is no change to the parent(CDB) as a result of this operation.

        **Deprecated.** Use [CreatePluggableDatabase](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/PluggableDatabase/CreatePluggableDatabase) for Pluggable Database LocalClone Operation.
        Clones and starts a pluggable database (PDB) in the same database (CDB) as the source PDB. The source PDB must be in the `READ_WRITE` openMode to perform the clone operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pluggable_databases_local_clone = oci.database.PluggableDatabasesLocalClone("test_pluggable_databases_local_clone",
            cloned_pdb_name=pluggable_databases_local_clone_cloned_pdb_name,
            pluggable_database_id=test_pluggable_database["id"],
            pdb_admin_password=pluggable_databases_local_clone_pdb_admin_password,
            should_pdb_admin_account_be_locked=pluggable_databases_local_clone_should_pdb_admin_account_be_locked,
            target_tde_wallet_password=pluggable_databases_local_clone_target_tde_wallet_password)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloned_pdb_name: The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        :param pulumi.Input[builtins.str] pdb_admin_password: A strong password for PDB Admin of the newly cloned PDB. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.
        :param pulumi.Input[builtins.str] pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.bool] should_pdb_admin_account_be_locked: The locked mode of the pluggable database admin account. If false, the user needs to provide the PDB Admin Password to connect to it. If true, the pluggable database will be locked and user cannot login to it.
        :param pulumi.Input[builtins.str] target_tde_wallet_password: The existing TDE wallet password of the target CDB.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PluggableDatabasesLocalCloneArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Pluggable Databases Local Clone resource in Oracle Cloud Infrastructure Database service. Although pluggable databases(PDB) belong to a container database(CDB), there is no change to the parent(CDB) as a result of this operation.

        **Deprecated.** Use [CreatePluggableDatabase](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/PluggableDatabase/CreatePluggableDatabase) for Pluggable Database LocalClone Operation.
        Clones and starts a pluggable database (PDB) in the same database (CDB) as the source PDB. The source PDB must be in the `READ_WRITE` openMode to perform the clone operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pluggable_databases_local_clone = oci.database.PluggableDatabasesLocalClone("test_pluggable_databases_local_clone",
            cloned_pdb_name=pluggable_databases_local_clone_cloned_pdb_name,
            pluggable_database_id=test_pluggable_database["id"],
            pdb_admin_password=pluggable_databases_local_clone_pdb_admin_password,
            should_pdb_admin_account_be_locked=pluggable_databases_local_clone_should_pdb_admin_account_be_locked,
            target_tde_wallet_password=pluggable_databases_local_clone_target_tde_wallet_password)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param PluggableDatabasesLocalCloneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PluggableDatabasesLocalCloneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloned_pdb_name: Optional[pulumi.Input[builtins.str]] = None,
                 pdb_admin_password: Optional[pulumi.Input[builtins.str]] = None,
                 pluggable_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 should_pdb_admin_account_be_locked: Optional[pulumi.Input[builtins.bool]] = None,
                 target_tde_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PluggableDatabasesLocalCloneArgs.__new__(PluggableDatabasesLocalCloneArgs)

            if cloned_pdb_name is None and not opts.urn:
                raise TypeError("Missing required property 'cloned_pdb_name'")
            __props__.__dict__["cloned_pdb_name"] = cloned_pdb_name
            __props__.__dict__["pdb_admin_password"] = None if pdb_admin_password is None else pulumi.Output.secret(pdb_admin_password)
            if pluggable_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'pluggable_database_id'")
            __props__.__dict__["pluggable_database_id"] = pluggable_database_id
            __props__.__dict__["should_pdb_admin_account_be_locked"] = should_pdb_admin_account_be_locked
            __props__.__dict__["target_tde_wallet_password"] = None if target_tde_wallet_password is None else pulumi.Output.secret(target_tde_wallet_password)
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["connection_strings"] = None
            __props__.__dict__["container_database_id"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["is_restricted"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["open_mode"] = None
            __props__.__dict__["pdb_name"] = None
            __props__.__dict__["pdb_node_level_details"] = None
            __props__.__dict__["pluggable_database_management_configs"] = None
            __props__.__dict__["refreshable_clone_configs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["pdbAdminPassword", "targetTdeWalletPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PluggableDatabasesLocalClone, __self__).__init__(
            'oci:Database/pluggableDatabasesLocalClone:PluggableDatabasesLocalClone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloned_pdb_name: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabasesLocalCloneConnectionStringArgs', 'PluggableDatabasesLocalCloneConnectionStringArgsDict']]]]] = None,
            container_database_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_restricted: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            open_mode: Optional[pulumi.Input[builtins.str]] = None,
            pdb_admin_password: Optional[pulumi.Input[builtins.str]] = None,
            pdb_name: Optional[pulumi.Input[builtins.str]] = None,
            pdb_node_level_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabasesLocalClonePdbNodeLevelDetailArgs', 'PluggableDatabasesLocalClonePdbNodeLevelDetailArgsDict']]]]] = None,
            pluggable_database_id: Optional[pulumi.Input[builtins.str]] = None,
            pluggable_database_management_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabasesLocalClonePluggableDatabaseManagementConfigArgs', 'PluggableDatabasesLocalClonePluggableDatabaseManagementConfigArgsDict']]]]] = None,
            refreshable_clone_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabasesLocalCloneRefreshableCloneConfigArgs', 'PluggableDatabasesLocalCloneRefreshableCloneConfigArgsDict']]]]] = None,
            should_pdb_admin_account_be_locked: Optional[pulumi.Input[builtins.bool]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            target_tde_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'PluggableDatabasesLocalClone':
        """
        Get an existing PluggableDatabasesLocalClone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] cloned_pdb_name: The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabasesLocalCloneConnectionStringArgs', 'PluggableDatabasesLocalCloneConnectionStringArgsDict']]]] connection_strings: Connection strings to connect to an Oracle Pluggable Database.
        :param pulumi.Input[builtins.str] container_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_restricted: The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        :param pulumi.Input[builtins.str] lifecycle_details: Detailed message for the lifecycle state.
        :param pulumi.Input[builtins.str] open_mode: The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        :param pulumi.Input[builtins.str] pdb_admin_password: A strong password for PDB Admin of the newly cloned PDB. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.
        :param pulumi.Input[builtins.str] pdb_name: The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabasesLocalClonePdbNodeLevelDetailArgs', 'PluggableDatabasesLocalClonePdbNodeLevelDetailArgsDict']]]] pdb_node_level_details: Pluggable Database Node Level Details. Example: [{"nodeName" : "node1", "openMode" : "READ_WRITE"}, {"nodeName" : "node2", "openMode" : "READ_ONLY"}]
        :param pulumi.Input[builtins.str] pluggable_database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabasesLocalClonePluggableDatabaseManagementConfigArgs', 'PluggableDatabasesLocalClonePluggableDatabaseManagementConfigArgsDict']]]] pluggable_database_management_configs: The configuration of the Pluggable Database Management service.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PluggableDatabasesLocalCloneRefreshableCloneConfigArgs', 'PluggableDatabasesLocalCloneRefreshableCloneConfigArgsDict']]]] refreshable_clone_configs: Pluggable Database Refreshable Clone Configuration.
        :param pulumi.Input[builtins.bool] should_pdb_admin_account_be_locked: The locked mode of the pluggable database admin account. If false, the user needs to provide the PDB Admin Password to connect to it. If true, the pluggable database will be locked and user cannot login to it.
        :param pulumi.Input[builtins.str] state: The current state of the pluggable database.
        :param pulumi.Input[builtins.str] target_tde_wallet_password: The existing TDE wallet password of the target CDB.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the pluggable database was created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PluggableDatabasesLocalCloneState.__new__(_PluggableDatabasesLocalCloneState)

        __props__.__dict__["cloned_pdb_name"] = cloned_pdb_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["container_database_id"] = container_database_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_restricted"] = is_restricted
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["open_mode"] = open_mode
        __props__.__dict__["pdb_admin_password"] = pdb_admin_password
        __props__.__dict__["pdb_name"] = pdb_name
        __props__.__dict__["pdb_node_level_details"] = pdb_node_level_details
        __props__.__dict__["pluggable_database_id"] = pluggable_database_id
        __props__.__dict__["pluggable_database_management_configs"] = pluggable_database_management_configs
        __props__.__dict__["refreshable_clone_configs"] = refreshable_clone_configs
        __props__.__dict__["should_pdb_admin_account_be_locked"] = should_pdb_admin_account_be_locked
        __props__.__dict__["state"] = state
        __props__.__dict__["target_tde_wallet_password"] = target_tde_wallet_password
        __props__.__dict__["time_created"] = time_created
        return PluggableDatabasesLocalClone(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clonedPdbName")
    def cloned_pdb_name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        """
        return pulumi.get(self, "cloned_pdb_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.PluggableDatabasesLocalCloneConnectionString']]:
        """
        Connection strings to connect to an Oracle Pluggable Database.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="containerDatabaseId")
    def container_database_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the CDB.
        """
        return pulumi.get(self, "container_database_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isRestricted")
    def is_restricted(self) -> pulumi.Output[builtins.bool]:
        """
        The restricted mode of the pluggable database. If a pluggable database is opened in restricted mode, the user needs both create a session and have restricted session privileges to connect to it.
        """
        return pulumi.get(self, "is_restricted")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="openMode")
    def open_mode(self) -> pulumi.Output[builtins.str]:
        """
        The mode that pluggable database is in. Open mode can only be changed to READ_ONLY or MIGRATE directly from the backend (within the Oracle Database software).
        """
        return pulumi.get(self, "open_mode")

    @property
    @pulumi.getter(name="pdbAdminPassword")
    def pdb_admin_password(self) -> pulumi.Output[builtins.str]:
        """
        A strong password for PDB Admin of the newly cloned PDB. The password must be at least nine characters and contain at least two uppercase, two lowercase, two numbers, and two special characters. The special characters must be _, \\#, or -.
        """
        return pulumi.get(self, "pdb_admin_password")

    @property
    @pulumi.getter(name="pdbName")
    def pdb_name(self) -> pulumi.Output[builtins.str]:
        """
        The name for the pluggable database (PDB). The name is unique in the context of a [container database](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/Database/). The name must begin with an alphabetic character and can contain a maximum of thirty alphanumeric characters. Special characters are not permitted. The pluggable database name should not be same as the container database name.
        """
        return pulumi.get(self, "pdb_name")

    @property
    @pulumi.getter(name="pdbNodeLevelDetails")
    def pdb_node_level_details(self) -> pulumi.Output[Sequence['outputs.PluggableDatabasesLocalClonePdbNodeLevelDetail']]:
        """
        Pluggable Database Node Level Details. Example: [{"nodeName" : "node1", "openMode" : "READ_WRITE"}, {"nodeName" : "node2", "openMode" : "READ_ONLY"}]
        """
        return pulumi.get(self, "pdb_node_level_details")

    @property
    @pulumi.getter(name="pluggableDatabaseId")
    def pluggable_database_id(self) -> pulumi.Output[builtins.str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "pluggable_database_id")

    @property
    @pulumi.getter(name="pluggableDatabaseManagementConfigs")
    def pluggable_database_management_configs(self) -> pulumi.Output[Sequence['outputs.PluggableDatabasesLocalClonePluggableDatabaseManagementConfig']]:
        """
        The configuration of the Pluggable Database Management service.
        """
        return pulumi.get(self, "pluggable_database_management_configs")

    @property
    @pulumi.getter(name="refreshableCloneConfigs")
    def refreshable_clone_configs(self) -> pulumi.Output[Sequence['outputs.PluggableDatabasesLocalCloneRefreshableCloneConfig']]:
        """
        Pluggable Database Refreshable Clone Configuration.
        """
        return pulumi.get(self, "refreshable_clone_configs")

    @property
    @pulumi.getter(name="shouldPdbAdminAccountBeLocked")
    def should_pdb_admin_account_be_locked(self) -> pulumi.Output[builtins.bool]:
        """
        The locked mode of the pluggable database admin account. If false, the user needs to provide the PDB Admin Password to connect to it. If true, the pluggable database will be locked and user cannot login to it.
        """
        return pulumi.get(self, "should_pdb_admin_account_be_locked")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the pluggable database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetTdeWalletPassword")
    def target_tde_wallet_password(self) -> pulumi.Output[builtins.str]:
        """
        The existing TDE wallet password of the target CDB.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_tde_wallet_password")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the pluggable database was created.
        """
        return pulumi.get(self, "time_created")

