# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConnectionArgs', 'Connection']

@pulumi.input_type
class ConnectionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 connection_type: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 key_id: pulumi.Input[builtins.str],
                 password: pulumi.Input[builtins.str],
                 technology_type: pulumi.Input[builtins.str],
                 username: pulumi.Input[builtins.str],
                 vault_id: pulumi.Input[builtins.str],
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 replication_password: Optional[pulumi.Input[builtins.str]] = None,
                 replication_username: Optional[pulumi.Input[builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_host: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_sudo_location: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_user: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_cert: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_crl: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_key: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 wallet: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Connection resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] connection_type: (Updatable) Defines the type of connection. For example, ORACLE.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[builtins.str] key_id: (Updatable) The OCID of the key used in cryptographic operations.
        :param pulumi.Input[builtins.str] password: (Updatable) The password (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] technology_type: The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        :param pulumi.Input[builtins.str] username: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] vault_id: (Updatable) Oracle Cloud Infrastructure resource ID.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]] additional_attributes: (Updatable) An array of name-value pair attribute entries.
        :param pulumi.Input[builtins.str] connection_string: (Updatable) Connect descriptor or Easy Connect Naming method used to connect to a database.
        :param pulumi.Input[builtins.str] database_id: (Updatable) The OCID of the database being referenced.
        :param pulumi.Input[builtins.str] database_name: (Updatable) The name of the database being referenced.
        :param pulumi.Input[builtins.str] db_system_id: (Updatable) The OCID of the database system being referenced.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[builtins.str] host: (Updatable) The IP Address of the host.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        :param pulumi.Input[builtins.int] port: (Updatable) The port to be used for the connection.
        :param pulumi.Input[builtins.str] replication_password: (Updatable) The password (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] replication_username: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] security_protocol: (Updatable) Security Type for MySQL.
        :param pulumi.Input[builtins.str] ssh_host: (Updatable) Name of the host the SSH key is valid for.
        :param pulumi.Input[builtins.str] ssh_key: (Updatable) Private SSH key string.
        :param pulumi.Input[builtins.str] ssh_sudo_location: (Updatable) Sudo location
        :param pulumi.Input[builtins.str] ssh_user: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] ssl_ca: (Updatable) Database Certificate - The base64 encoded content of mysql.pem file containing the server public key (for 1 and 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_cert: (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_crl: (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        :param pulumi.Input[builtins.str] ssl_key: (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_mode: (Updatable) SSL modes for MySQL.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) Oracle Cloud Infrastructure resource ID.
        :param pulumi.Input[builtins.str] wallet: (Updatable) The wallet contents used to make connections to a database.  This attribute is expected to be base64 encoded.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "connection_type", connection_type)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "technology_type", technology_type)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "vault_id", vault_id)
        if additional_attributes is not None:
            pulumi.set(__self__, "additional_attributes", additional_attributes)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if replication_password is not None:
            pulumi.set(__self__, "replication_password", replication_password)
        if replication_username is not None:
            pulumi.set(__self__, "replication_username", replication_username)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssh_host is not None:
            pulumi.set(__self__, "ssh_host", ssh_host)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if ssh_sudo_location is not None:
            pulumi.set(__self__, "ssh_sudo_location", ssh_sudo_location)
        if ssh_user is not None:
            pulumi.set(__self__, "ssh_user", ssh_user)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if ssl_cert is not None:
            pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_crl is not None:
            pulumi.set(__self__, "ssl_crl", ssl_crl)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if wallet is not None:
            pulumi.set(__self__, "wallet", wallet)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Defines the type of connection. For example, ORACLE.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the key used in cryptographic operations.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The password (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="technologyType")
    def technology_type(self) -> pulumi.Input[builtins.str]:
        """
        The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        """
        return pulumi.get(self, "technology_type")

    @technology_type.setter
    def technology_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "technology_type", value)

    @property
    @pulumi.getter
    def username(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure resource ID.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]]:
        """
        (Updatable) An array of name-value pair attribute entries.
        """
        return pulumi.get(self, "additional_attributes")

    @additional_attributes.setter
    def additional_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]]):
        pulumi.set(self, "additional_attributes", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Connect descriptor or Easy Connect Naming method used to connect to a database.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the database being referenced.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the database being referenced.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the database system being referenced.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The IP Address of the host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The port to be used for the connection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="replicationPassword")
    def replication_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The password (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "replication_password")

    @replication_password.setter
    def replication_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_password", value)

    @property
    @pulumi.getter(name="replicationUsername")
    def replication_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "replication_username")

    @replication_username.setter
    def replication_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_username", value)

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Security Type for MySQL.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_protocol", value)

    @property
    @pulumi.getter(name="sshHost")
    def ssh_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "ssh_host")

    @ssh_host.setter
    def ssh_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_host", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Private SSH key string.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter(name="sshSudoLocation")
    def ssh_sudo_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Sudo location
        """
        return pulumi.get(self, "ssh_sudo_location")

    @ssh_sudo_location.setter
    def ssh_sudo_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_sudo_location", value)

    @property
    @pulumi.getter(name="sshUser")
    def ssh_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "ssh_user")

    @ssh_user.setter
    def ssh_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_user", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Database Certificate - The base64 encoded content of mysql.pem file containing the server public key (for 1 and 2-way SSL).
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_cert")

    @ssl_cert.setter
    def ssl_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_cert", value)

    @property
    @pulumi.getter(name="sslCrl")
    def ssl_crl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        """
        return pulumi.get(self, "ssl_crl")

    @ssl_crl.setter
    def ssl_crl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_crl", value)

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_key", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) SSL modes for MySQL.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure resource ID.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def wallet(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The wallet contents used to make connections to a database.  This attribute is expected to be base64 encoded.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "wallet")

    @wallet.setter
    def wallet(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wallet", value)


@pulumi.input_type
class _ConnectionState:
    def __init__(__self__, *,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[builtins.str]] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 ingress_ips: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionIngressIpArgs']]]] = None,
                 key_id: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
                 replication_password: Optional[pulumi.Input[builtins.str]] = None,
                 replication_username: Optional[pulumi.Input[builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_host: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_sudo_location: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_user: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_cert: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_crl: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_key: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 technology_type: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 wallet: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Connection resources.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]] additional_attributes: (Updatable) An array of name-value pair attribute entries.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] connection_string: (Updatable) Connect descriptor or Easy Connect Naming method used to connect to a database.
        :param pulumi.Input[builtins.str] connection_type: (Updatable) Defines the type of connection. For example, ORACLE.
        :param pulumi.Input[builtins.str] database_id: (Updatable) The OCID of the database being referenced.
        :param pulumi.Input[builtins.str] database_name: (Updatable) The name of the database being referenced.
        :param pulumi.Input[builtins.str] db_system_id: (Updatable) The OCID of the database system being referenced.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[builtins.str] host: (Updatable) The IP Address of the host.
        :param pulumi.Input[Sequence[pulumi.Input['ConnectionIngressIpArgs']]] ingress_ips: List of ingress IP addresses from where to connect to this connection's privateIp.
        :param pulumi.Input[builtins.str] key_id: (Updatable) The OCID of the key used in cryptographic operations.
        :param pulumi.Input[builtins.str] lifecycle_details: The message describing the current state of the connection's lifecycle in detail. For example, can be used to provide actionable information for a connection in a Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        :param pulumi.Input[builtins.str] password: (Updatable) The password (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.int] port: (Updatable) The port to be used for the connection.
        :param pulumi.Input[builtins.str] private_endpoint_id: The OCID of the resource being referenced.
        :param pulumi.Input[builtins.str] replication_password: (Updatable) The password (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] replication_username: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] secret_id: The OCID of the resource being referenced.
        :param pulumi.Input[builtins.str] security_protocol: (Updatable) Security Type for MySQL.
        :param pulumi.Input[builtins.str] ssh_host: (Updatable) Name of the host the SSH key is valid for.
        :param pulumi.Input[builtins.str] ssh_key: (Updatable) Private SSH key string.
        :param pulumi.Input[builtins.str] ssh_sudo_location: (Updatable) Sudo location
        :param pulumi.Input[builtins.str] ssh_user: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] ssl_ca: (Updatable) Database Certificate - The base64 encoded content of mysql.pem file containing the server public key (for 1 and 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_cert: (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_crl: (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        :param pulumi.Input[builtins.str] ssl_key: (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_mode: (Updatable) SSL modes for MySQL.
        :param pulumi.Input[builtins.str] state: The Connection's current lifecycle state.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) Oracle Cloud Infrastructure resource ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] technology_type: The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        :param pulumi.Input[builtins.str] time_created: The time when this resource was created. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[builtins.str] time_updated: The time when this resource was updated. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[builtins.str] username: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] vault_id: (Updatable) Oracle Cloud Infrastructure resource ID.
        :param pulumi.Input[builtins.str] wallet: (Updatable) The wallet contents used to make connections to a database.  This attribute is expected to be base64 encoded.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if additional_attributes is not None:
            pulumi.set(__self__, "additional_attributes", additional_attributes)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_type is not None:
            pulumi.set(__self__, "connection_type", connection_type)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if ingress_ips is not None:
            pulumi.set(__self__, "ingress_ips", ingress_ips)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_endpoint_id is not None:
            pulumi.set(__self__, "private_endpoint_id", private_endpoint_id)
        if replication_password is not None:
            pulumi.set(__self__, "replication_password", replication_password)
        if replication_username is not None:
            pulumi.set(__self__, "replication_username", replication_username)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssh_host is not None:
            pulumi.set(__self__, "ssh_host", ssh_host)
        if ssh_key is not None:
            pulumi.set(__self__, "ssh_key", ssh_key)
        if ssh_sudo_location is not None:
            pulumi.set(__self__, "ssh_sudo_location", ssh_sudo_location)
        if ssh_user is not None:
            pulumi.set(__self__, "ssh_user", ssh_user)
        if ssl_ca is not None:
            pulumi.set(__self__, "ssl_ca", ssl_ca)
        if ssl_cert is not None:
            pulumi.set(__self__, "ssl_cert", ssl_cert)
        if ssl_crl is not None:
            pulumi.set(__self__, "ssl_crl", ssl_crl)
        if ssl_key is not None:
            pulumi.set(__self__, "ssl_key", ssl_key)
        if ssl_mode is not None:
            pulumi.set(__self__, "ssl_mode", ssl_mode)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if technology_type is not None:
            pulumi.set(__self__, "technology_type", technology_type)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if vault_id is not None:
            pulumi.set(__self__, "vault_id", vault_id)
        if wallet is not None:
            pulumi.set(__self__, "wallet", wallet)

    @property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]]:
        """
        (Updatable) An array of name-value pair attribute entries.
        """
        return pulumi.get(self, "additional_attributes")

    @additional_attributes.setter
    def additional_attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionAdditionalAttributeArgs']]]]):
        pulumi.set(self, "additional_attributes", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Connect descriptor or Easy Connect Naming method used to connect to a database.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Defines the type of connection. For example, ORACLE.
        """
        return pulumi.get(self, "connection_type")

    @connection_type.setter
    def connection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "connection_type", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the database being referenced.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The name of the database being referenced.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the database system being referenced.
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The IP Address of the host.
        """
        return pulumi.get(self, "host")

    @host.setter
    def host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "host", value)

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionIngressIpArgs']]]]:
        """
        List of ingress IP addresses from where to connect to this connection's privateIp.
        """
        return pulumi.get(self, "ingress_ips")

    @ingress_ips.setter
    def ingress_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConnectionIngressIpArgs']]]]):
        pulumi.set(self, "ingress_ips", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the key used in cryptographic operations.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The message describing the current state of the connection's lifecycle in detail. For example, can be used to provide actionable information for a connection in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The password (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) The port to be used for the connection.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "private_endpoint_id")

    @private_endpoint_id.setter
    def private_endpoint_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_endpoint_id", value)

    @property
    @pulumi.getter(name="replicationPassword")
    def replication_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The password (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "replication_password")

    @replication_password.setter
    def replication_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_password", value)

    @property
    @pulumi.getter(name="replicationUsername")
    def replication_username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "replication_username")

    @replication_username.setter
    def replication_username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_username", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Security Type for MySQL.
        """
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "security_protocol", value)

    @property
    @pulumi.getter(name="sshHost")
    def ssh_host(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "ssh_host")

    @ssh_host.setter
    def ssh_host(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_host", value)

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Private SSH key string.
        """
        return pulumi.get(self, "ssh_key")

    @ssh_key.setter
    def ssh_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_key", value)

    @property
    @pulumi.getter(name="sshSudoLocation")
    def ssh_sudo_location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Sudo location
        """
        return pulumi.get(self, "ssh_sudo_location")

    @ssh_sudo_location.setter
    def ssh_sudo_location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_sudo_location", value)

    @property
    @pulumi.getter(name="sshUser")
    def ssh_user(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "ssh_user")

    @ssh_user.setter
    def ssh_user(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssh_user", value)

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Database Certificate - The base64 encoded content of mysql.pem file containing the server public key (for 1 and 2-way SSL).
        """
        return pulumi.get(self, "ssl_ca")

    @ssl_ca.setter
    def ssl_ca(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_ca", value)

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_cert")

    @ssl_cert.setter
    def ssl_cert(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_cert", value)

    @property
    @pulumi.getter(name="sslCrl")
    def ssl_crl(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        """
        return pulumi.get(self, "ssl_crl")

    @ssl_crl.setter
    def ssl_crl(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_crl", value)

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_key")

    @ssl_key.setter
    def ssl_key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_key", value)

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) SSL modes for MySQL.
        """
        return pulumi.get(self, "ssl_mode")

    @ssl_mode.setter
    def ssl_mode(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ssl_mode", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Connection's current lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure resource ID.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="technologyType")
    def technology_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        """
        return pulumi.get(self, "technology_type")

    @technology_type.setter
    def technology_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "technology_type", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when this resource was created. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time when this resource was updated. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "username", value)

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure resource ID.
        """
        return pulumi.get(self, "vault_id")

    @vault_id.setter
    def vault_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vault_id", value)

    @property
    @pulumi.getter
    def wallet(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The wallet contents used to make connections to a database.  This attribute is expected to be base64 encoded.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "wallet")

    @wallet.setter
    def wallet(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "wallet", value)


class Connection(pulumi.CustomResource):

    pulumi_type = "oci:DatabaseMigration/connection:Connection"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionAdditionalAttributeArgs', 'ConnectionAdditionalAttributeArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[builtins.str]] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 key_id: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 replication_password: Optional[pulumi.Input[builtins.str]] = None,
                 replication_username: Optional[pulumi.Input[builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_host: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_sudo_location: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_user: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_cert: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_crl: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_key: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 technology_type: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 wallet: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.database_migration.Connection("test_connection",
            compartment_id=compartment_id,
            connection_type=connection_connection_type,
            display_name=connection_display_name,
            key_id=test_key["id"],
            password=connection_password,
            technology_type=connection_technology_type,
            username=connection_username,
            vault_id=test_vault["id"],
            additional_attributes=[{
                "name": connection_additional_attributes_name,
                "value": connection_additional_attributes_value,
            }],
            connection_string=connection_connection_string,
            database_id=test_database["id"],
            database_name=test_database["name"],
            db_system_id=test_db_system["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=connection_description,
            freeform_tags=connection_freeform_tags,
            host=connection_host,
            nsg_ids=connection_nsg_ids,
            port=connection_port,
            replication_password=connection_replication_password,
            replication_username=connection_replication_username,
            security_protocol=connection_security_protocol,
            ssh_host=connection_ssh_host,
            ssh_key=connection_ssh_key,
            ssh_sudo_location=connection_ssh_sudo_location,
            ssh_user=connection_ssh_user,
            ssl_ca=connection_ssl_ca,
            ssl_cert=connection_ssl_cert,
            ssl_crl=connection_ssl_crl,
            ssl_key=connection_ssl_key,
            ssl_mode=connection_ssl_mode,
            subnet_id=test_subnet["id"],
            wallet=connection_wallet)
        ```

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseMigration/connection:Connection test_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionAdditionalAttributeArgs', 'ConnectionAdditionalAttributeArgsDict']]]] additional_attributes: (Updatable) An array of name-value pair attribute entries.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] connection_string: (Updatable) Connect descriptor or Easy Connect Naming method used to connect to a database.
        :param pulumi.Input[builtins.str] connection_type: (Updatable) Defines the type of connection. For example, ORACLE.
        :param pulumi.Input[builtins.str] database_id: (Updatable) The OCID of the database being referenced.
        :param pulumi.Input[builtins.str] database_name: (Updatable) The name of the database being referenced.
        :param pulumi.Input[builtins.str] db_system_id: (Updatable) The OCID of the database system being referenced.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[builtins.str] host: (Updatable) The IP Address of the host.
        :param pulumi.Input[builtins.str] key_id: (Updatable) The OCID of the key used in cryptographic operations.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        :param pulumi.Input[builtins.str] password: (Updatable) The password (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.int] port: (Updatable) The port to be used for the connection.
        :param pulumi.Input[builtins.str] replication_password: (Updatable) The password (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] replication_username: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] security_protocol: (Updatable) Security Type for MySQL.
        :param pulumi.Input[builtins.str] ssh_host: (Updatable) Name of the host the SSH key is valid for.
        :param pulumi.Input[builtins.str] ssh_key: (Updatable) Private SSH key string.
        :param pulumi.Input[builtins.str] ssh_sudo_location: (Updatable) Sudo location
        :param pulumi.Input[builtins.str] ssh_user: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] ssl_ca: (Updatable) Database Certificate - The base64 encoded content of mysql.pem file containing the server public key (for 1 and 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_cert: (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_crl: (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        :param pulumi.Input[builtins.str] ssl_key: (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_mode: (Updatable) SSL modes for MySQL.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) Oracle Cloud Infrastructure resource ID.
        :param pulumi.Input[builtins.str] technology_type: The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        :param pulumi.Input[builtins.str] username: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] vault_id: (Updatable) Oracle Cloud Infrastructure resource ID.
        :param pulumi.Input[builtins.str] wallet: (Updatable) The wallet contents used to make connections to a database.  This attribute is expected to be base64 encoded.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConnectionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_connection = oci.database_migration.Connection("test_connection",
            compartment_id=compartment_id,
            connection_type=connection_connection_type,
            display_name=connection_display_name,
            key_id=test_key["id"],
            password=connection_password,
            technology_type=connection_technology_type,
            username=connection_username,
            vault_id=test_vault["id"],
            additional_attributes=[{
                "name": connection_additional_attributes_name,
                "value": connection_additional_attributes_value,
            }],
            connection_string=connection_connection_string,
            database_id=test_database["id"],
            database_name=test_database["name"],
            db_system_id=test_db_system["id"],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=connection_description,
            freeform_tags=connection_freeform_tags,
            host=connection_host,
            nsg_ids=connection_nsg_ids,
            port=connection_port,
            replication_password=connection_replication_password,
            replication_username=connection_replication_username,
            security_protocol=connection_security_protocol,
            ssh_host=connection_ssh_host,
            ssh_key=connection_ssh_key,
            ssh_sudo_location=connection_ssh_sudo_location,
            ssh_user=connection_ssh_user,
            ssl_ca=connection_ssl_ca,
            ssl_cert=connection_ssl_cert,
            ssl_crl=connection_ssl_crl,
            ssl_key=connection_ssl_key,
            ssl_mode=connection_ssl_mode,
            subnet_id=test_subnet["id"],
            wallet=connection_wallet)
        ```

        ## Import

        Connections can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DatabaseMigration/connection:Connection test_connection "id"
        ```

        :param str resource_name: The name of the resource.
        :param ConnectionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConnectionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionAdditionalAttributeArgs', 'ConnectionAdditionalAttributeArgsDict']]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 connection_string: Optional[pulumi.Input[builtins.str]] = None,
                 connection_type: Optional[pulumi.Input[builtins.str]] = None,
                 database_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_name: Optional[pulumi.Input[builtins.str]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 host: Optional[pulumi.Input[builtins.str]] = None,
                 key_id: Optional[pulumi.Input[builtins.str]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 password: Optional[pulumi.Input[builtins.str]] = None,
                 port: Optional[pulumi.Input[builtins.int]] = None,
                 replication_password: Optional[pulumi.Input[builtins.str]] = None,
                 replication_username: Optional[pulumi.Input[builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_host: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_key: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_sudo_location: Optional[pulumi.Input[builtins.str]] = None,
                 ssh_user: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_cert: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_crl: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_key: Optional[pulumi.Input[builtins.str]] = None,
                 ssl_mode: Optional[pulumi.Input[builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[builtins.str]] = None,
                 technology_type: Optional[pulumi.Input[builtins.str]] = None,
                 username: Optional[pulumi.Input[builtins.str]] = None,
                 vault_id: Optional[pulumi.Input[builtins.str]] = None,
                 wallet: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConnectionArgs.__new__(ConnectionArgs)

            __props__.__dict__["additional_attributes"] = additional_attributes
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connection_string"] = connection_string
            if connection_type is None and not opts.urn:
                raise TypeError("Missing required property 'connection_type'")
            __props__.__dict__["connection_type"] = connection_type
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["host"] = host
            if key_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_id'")
            __props__.__dict__["key_id"] = key_id
            __props__.__dict__["nsg_ids"] = nsg_ids
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["port"] = port
            __props__.__dict__["replication_password"] = None if replication_password is None else pulumi.Output.secret(replication_password)
            __props__.__dict__["replication_username"] = replication_username
            __props__.__dict__["security_protocol"] = security_protocol
            __props__.__dict__["ssh_host"] = ssh_host
            __props__.__dict__["ssh_key"] = ssh_key
            __props__.__dict__["ssh_sudo_location"] = ssh_sudo_location
            __props__.__dict__["ssh_user"] = ssh_user
            __props__.__dict__["ssl_ca"] = ssl_ca
            __props__.__dict__["ssl_cert"] = ssl_cert
            __props__.__dict__["ssl_crl"] = ssl_crl
            __props__.__dict__["ssl_key"] = ssl_key
            __props__.__dict__["ssl_mode"] = ssl_mode
            __props__.__dict__["subnet_id"] = subnet_id
            if technology_type is None and not opts.urn:
                raise TypeError("Missing required property 'technology_type'")
            __props__.__dict__["technology_type"] = technology_type
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            if vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'vault_id'")
            __props__.__dict__["vault_id"] = vault_id
            __props__.__dict__["wallet"] = wallet
            __props__.__dict__["ingress_ips"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["private_endpoint_id"] = None
            __props__.__dict__["secret_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password", "replicationPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Connection, __self__).__init__(
            'oci:DatabaseMigration/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_attributes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionAdditionalAttributeArgs', 'ConnectionAdditionalAttributeArgsDict']]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            connection_string: Optional[pulumi.Input[builtins.str]] = None,
            connection_type: Optional[pulumi.Input[builtins.str]] = None,
            database_id: Optional[pulumi.Input[builtins.str]] = None,
            database_name: Optional[pulumi.Input[builtins.str]] = None,
            db_system_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            host: Optional[pulumi.Input[builtins.str]] = None,
            ingress_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ConnectionIngressIpArgs', 'ConnectionIngressIpArgsDict']]]]] = None,
            key_id: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            password: Optional[pulumi.Input[builtins.str]] = None,
            port: Optional[pulumi.Input[builtins.int]] = None,
            private_endpoint_id: Optional[pulumi.Input[builtins.str]] = None,
            replication_password: Optional[pulumi.Input[builtins.str]] = None,
            replication_username: Optional[pulumi.Input[builtins.str]] = None,
            secret_id: Optional[pulumi.Input[builtins.str]] = None,
            security_protocol: Optional[pulumi.Input[builtins.str]] = None,
            ssh_host: Optional[pulumi.Input[builtins.str]] = None,
            ssh_key: Optional[pulumi.Input[builtins.str]] = None,
            ssh_sudo_location: Optional[pulumi.Input[builtins.str]] = None,
            ssh_user: Optional[pulumi.Input[builtins.str]] = None,
            ssl_ca: Optional[pulumi.Input[builtins.str]] = None,
            ssl_cert: Optional[pulumi.Input[builtins.str]] = None,
            ssl_crl: Optional[pulumi.Input[builtins.str]] = None,
            ssl_key: Optional[pulumi.Input[builtins.str]] = None,
            ssl_mode: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            technology_type: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            username: Optional[pulumi.Input[builtins.str]] = None,
            vault_id: Optional[pulumi.Input[builtins.str]] = None,
            wallet: Optional[pulumi.Input[builtins.str]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionAdditionalAttributeArgs', 'ConnectionAdditionalAttributeArgsDict']]]] additional_attributes: (Updatable) An array of name-value pair attribute entries.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[builtins.str] connection_string: (Updatable) Connect descriptor or Easy Connect Naming method used to connect to a database.
        :param pulumi.Input[builtins.str] connection_type: (Updatable) Defines the type of connection. For example, ORACLE.
        :param pulumi.Input[builtins.str] database_id: (Updatable) The OCID of the database being referenced.
        :param pulumi.Input[builtins.str] database_name: (Updatable) The name of the database being referenced.
        :param pulumi.Input[builtins.str] db_system_id: (Updatable) The OCID of the database system being referenced.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        :param pulumi.Input[builtins.str] host: (Updatable) The IP Address of the host.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ConnectionIngressIpArgs', 'ConnectionIngressIpArgsDict']]]] ingress_ips: List of ingress IP addresses from where to connect to this connection's privateIp.
        :param pulumi.Input[builtins.str] key_id: (Updatable) The OCID of the key used in cryptographic operations.
        :param pulumi.Input[builtins.str] lifecycle_details: The message describing the current state of the connection's lifecycle in detail. For example, can be used to provide actionable information for a connection in a Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] nsg_ids: (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        :param pulumi.Input[builtins.str] password: (Updatable) The password (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.int] port: (Updatable) The port to be used for the connection.
        :param pulumi.Input[builtins.str] private_endpoint_id: The OCID of the resource being referenced.
        :param pulumi.Input[builtins.str] replication_password: (Updatable) The password (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] replication_username: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] secret_id: The OCID of the resource being referenced.
        :param pulumi.Input[builtins.str] security_protocol: (Updatable) Security Type for MySQL.
        :param pulumi.Input[builtins.str] ssh_host: (Updatable) Name of the host the SSH key is valid for.
        :param pulumi.Input[builtins.str] ssh_key: (Updatable) Private SSH key string.
        :param pulumi.Input[builtins.str] ssh_sudo_location: (Updatable) Sudo location
        :param pulumi.Input[builtins.str] ssh_user: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] ssl_ca: (Updatable) Database Certificate - The base64 encoded content of mysql.pem file containing the server public key (for 1 and 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_cert: (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_crl: (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        :param pulumi.Input[builtins.str] ssl_key: (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        :param pulumi.Input[builtins.str] ssl_mode: (Updatable) SSL modes for MySQL.
        :param pulumi.Input[builtins.str] state: The Connection's current lifecycle state.
        :param pulumi.Input[builtins.str] subnet_id: (Updatable) Oracle Cloud Infrastructure resource ID.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] technology_type: The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        :param pulumi.Input[builtins.str] time_created: The time when this resource was created. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[builtins.str] time_updated: The time when this resource was updated. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[builtins.str] username: (Updatable) The username (credential) used when creating or updating this resource.
        :param pulumi.Input[builtins.str] vault_id: (Updatable) Oracle Cloud Infrastructure resource ID.
        :param pulumi.Input[builtins.str] wallet: (Updatable) The wallet contents used to make connections to a database.  This attribute is expected to be base64 encoded.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConnectionState.__new__(_ConnectionState)

        __props__.__dict__["additional_attributes"] = additional_attributes
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["connection_type"] = connection_type
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host"] = host
        __props__.__dict__["ingress_ips"] = ingress_ips
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["private_endpoint_id"] = private_endpoint_id
        __props__.__dict__["replication_password"] = replication_password
        __props__.__dict__["replication_username"] = replication_username
        __props__.__dict__["secret_id"] = secret_id
        __props__.__dict__["security_protocol"] = security_protocol
        __props__.__dict__["ssh_host"] = ssh_host
        __props__.__dict__["ssh_key"] = ssh_key
        __props__.__dict__["ssh_sudo_location"] = ssh_sudo_location
        __props__.__dict__["ssh_user"] = ssh_user
        __props__.__dict__["ssl_ca"] = ssl_ca
        __props__.__dict__["ssl_cert"] = ssl_cert
        __props__.__dict__["ssl_crl"] = ssl_crl
        __props__.__dict__["ssl_key"] = ssl_key
        __props__.__dict__["ssl_mode"] = ssl_mode
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["technology_type"] = technology_type
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["username"] = username
        __props__.__dict__["vault_id"] = vault_id
        __props__.__dict__["wallet"] = wallet
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalAttributes")
    def additional_attributes(self) -> pulumi.Output[Sequence['outputs.ConnectionAdditionalAttribute']]:
        """
        (Updatable) An array of name-value pair attribute entries.
        """
        return pulumi.get(self, "additional_attributes")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Connect descriptor or Easy Connect Naming method used to connect to a database.
        """
        return pulumi.get(self, "connection_string")

    @property
    @pulumi.getter(name="connectionType")
    def connection_type(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Defines the type of connection. For example, ORACLE.
        """
        return pulumi.get(self, "connection_type")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the database being referenced.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The name of the database being referenced.
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the database system being referenced.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly description. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable.  Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.  For more information, see Resource Tags. Example: {"Department": "Finance"}
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def host(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The IP Address of the host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="ingressIps")
    def ingress_ips(self) -> pulumi.Output[Sequence['outputs.ConnectionIngressIp']]:
        """
        List of ingress IP addresses from where to connect to this connection's privateIp.
        """
        return pulumi.get(self, "ingress_ips")

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the key used in cryptographic operations.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        The message describing the current state of the connection's lifecycle in detail. For example, can be used to provide actionable information for a connection in a Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) An array of Network Security Group OCIDs used to define network access for Connections.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The password (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) The port to be used for the connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="privateEndpointId")
    def private_endpoint_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "private_endpoint_id")

    @property
    @pulumi.getter(name="replicationPassword")
    def replication_password(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The password (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "replication_password")

    @property
    @pulumi.getter(name="replicationUsername")
    def replication_username(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "replication_username")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the resource being referenced.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Security Type for MySQL.
        """
        return pulumi.get(self, "security_protocol")

    @property
    @pulumi.getter(name="sshHost")
    def ssh_host(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Name of the host the SSH key is valid for.
        """
        return pulumi.get(self, "ssh_host")

    @property
    @pulumi.getter(name="sshKey")
    def ssh_key(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Private SSH key string.
        """
        return pulumi.get(self, "ssh_key")

    @property
    @pulumi.getter(name="sshSudoLocation")
    def ssh_sudo_location(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Sudo location
        """
        return pulumi.get(self, "ssh_sudo_location")

    @property
    @pulumi.getter(name="sshUser")
    def ssh_user(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "ssh_user")

    @property
    @pulumi.getter(name="sslCa")
    def ssl_ca(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Database Certificate - The base64 encoded content of mysql.pem file containing the server public key (for 1 and 2-way SSL).
        """
        return pulumi.get(self, "ssl_ca")

    @property
    @pulumi.getter(name="sslCert")
    def ssl_cert(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Client Certificate - The base64 encoded content of client-cert.pem file  containing the client public key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_cert")

    @property
    @pulumi.getter(name="sslCrl")
    def ssl_crl(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Certificates revoked by certificate authorities (CA). Server certificate must not be on this list (for 1 and 2-way SSL). Note: This is an optional and that too only applicable if TLS/MTLS option is selected.
        """
        return pulumi.get(self, "ssl_crl")

    @property
    @pulumi.getter(name="sslKey")
    def ssl_key(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Client Key - The client-key.pem containing the client private key (for 2-way SSL).
        """
        return pulumi.get(self, "ssl_key")

    @property
    @pulumi.getter(name="sslMode")
    def ssl_mode(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) SSL modes for MySQL.
        """
        return pulumi.get(self, "ssl_mode")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The Connection's current lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure resource ID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="technologyType")
    def technology_type(self) -> pulumi.Output[builtins.str]:
        """
        The type of MySQL source or target connection. Example: OCI_MYSQL represents Oracle Cloud Infrastructure MySQL HeatWave Database Service
        """
        return pulumi.get(self, "technology_type")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time when this resource was created. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time when this resource was updated. An RFC3339 formatted datetime string such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The username (credential) used when creating or updating this resource.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure resource ID.
        """
        return pulumi.get(self, "vault_id")

    @property
    @pulumi.getter
    def wallet(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The wallet contents used to make connections to a database.  This attribute is expected to be base64 encoded.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "wallet")

