# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CalculateAuditVolumeAvailableArgs', 'CalculateAuditVolumeAvailable']

@pulumi.input_type
class CalculateAuditVolumeAvailableArgs:
    def __init__(__self__, *,
                 audit_profile_id: pulumi.Input[builtins.str],
                 audit_collection_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 database_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 trail_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a CalculateAuditVolumeAvailable resource.
        :param pulumi.Input[builtins.str] audit_profile_id: The OCID of the audit.
        :param pulumi.Input[builtins.str] audit_collection_start_time: The date from which the audit trail must start collecting data in UTC, in the format defined by RFC3339. If not specified, this will default to the date based on the retention period.
        :param pulumi.Input[builtins.str] database_unique_name: Unique name of the database associated to the peer target database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trail_locations: The trail locations for which the audit data volume has to be calculated.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if audit_collection_start_time is not None:
            pulumi.set(__self__, "audit_collection_start_time", audit_collection_start_time)
        if database_unique_name is not None:
            pulumi.set(__self__, "database_unique_name", database_unique_name)
        if trail_locations is not None:
            pulumi.set(__self__, "trail_locations", trail_locations)

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @audit_profile_id.setter
    def audit_profile_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "audit_profile_id", value)

    @property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date from which the audit trail must start collecting data in UTC, in the format defined by RFC3339. If not specified, this will default to the date based on the retention period.
        """
        return pulumi.get(self, "audit_collection_start_time")

    @audit_collection_start_time.setter
    def audit_collection_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audit_collection_start_time", value)

    @property
    @pulumi.getter(name="databaseUniqueName")
    def database_unique_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name of the database associated to the peer target database.
        """
        return pulumi.get(self, "database_unique_name")

    @database_unique_name.setter
    def database_unique_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_unique_name", value)

    @property
    @pulumi.getter(name="trailLocations")
    def trail_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The trail locations for which the audit data volume has to be calculated.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "trail_locations")

    @trail_locations.setter
    def trail_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trail_locations", value)


@pulumi.input_type
class _CalculateAuditVolumeAvailableState:
    def __init__(__self__, *,
                 audit_collection_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 audit_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 available_audit_volumes: Optional[pulumi.Input[Sequence[pulumi.Input['CalculateAuditVolumeAvailableAvailableAuditVolumeArgs']]]] = None,
                 database_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 trail_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering CalculateAuditVolumeAvailable resources.
        :param pulumi.Input[builtins.str] audit_collection_start_time: The date from which the audit trail must start collecting data in UTC, in the format defined by RFC3339. If not specified, this will default to the date based on the retention period.
        :param pulumi.Input[builtins.str] audit_profile_id: The OCID of the audit.
        :param pulumi.Input[Sequence[pulumi.Input['CalculateAuditVolumeAvailableAvailableAuditVolumeArgs']]] available_audit_volumes: List of available audit volumes.
        :param pulumi.Input[builtins.str] database_unique_name: Unique name of the database associated to the peer target database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trail_locations: The trail locations for which the audit data volume has to be calculated.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if audit_collection_start_time is not None:
            pulumi.set(__self__, "audit_collection_start_time", audit_collection_start_time)
        if audit_profile_id is not None:
            pulumi.set(__self__, "audit_profile_id", audit_profile_id)
        if available_audit_volumes is not None:
            pulumi.set(__self__, "available_audit_volumes", available_audit_volumes)
        if database_unique_name is not None:
            pulumi.set(__self__, "database_unique_name", database_unique_name)
        if trail_locations is not None:
            pulumi.set(__self__, "trail_locations", trail_locations)

    @property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date from which the audit trail must start collecting data in UTC, in the format defined by RFC3339. If not specified, this will default to the date based on the retention period.
        """
        return pulumi.get(self, "audit_collection_start_time")

    @audit_collection_start_time.setter
    def audit_collection_start_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audit_collection_start_time", value)

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @audit_profile_id.setter
    def audit_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "audit_profile_id", value)

    @property
    @pulumi.getter(name="availableAuditVolumes")
    def available_audit_volumes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CalculateAuditVolumeAvailableAvailableAuditVolumeArgs']]]]:
        """
        List of available audit volumes.
        """
        return pulumi.get(self, "available_audit_volumes")

    @available_audit_volumes.setter
    def available_audit_volumes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CalculateAuditVolumeAvailableAvailableAuditVolumeArgs']]]]):
        pulumi.set(self, "available_audit_volumes", value)

    @property
    @pulumi.getter(name="databaseUniqueName")
    def database_unique_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name of the database associated to the peer target database.
        """
        return pulumi.get(self, "database_unique_name")

    @database_unique_name.setter
    def database_unique_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "database_unique_name", value)

    @property
    @pulumi.getter(name="trailLocations")
    def trail_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The trail locations for which the audit data volume has to be calculated.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "trail_locations")

    @trail_locations.setter
    def trail_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "trail_locations", value)


class CalculateAuditVolumeAvailable(pulumi.CustomResource):

    pulumi_type = "oci:DataSafe/calculateAuditVolumeAvailable:CalculateAuditVolumeAvailable"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_collection_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 audit_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 trail_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Calculate Audit Volume Available resource in Oracle Cloud Infrastructure Data Safe service.

        Calculates the volume of audit events available on the target database to be collected. Measurable up to the defined retention period of the audit target resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_calculate_audit_volume_available = oci.data_safe.CalculateAuditVolumeAvailable("test_calculate_audit_volume_available",
            audit_profile_id=test_audit_profile["id"],
            audit_collection_start_time=calculate_audit_volume_available_audit_collection_start_time,
            database_unique_name=calculate_audit_volume_available_database_unique_name,
            trail_locations=calculate_audit_volume_available_trail_locations)
        ```

        ## Import

        CalculateAuditVolumeAvailable can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/calculateAuditVolumeAvailable:CalculateAuditVolumeAvailable test_calculate_audit_volume_available "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] audit_collection_start_time: The date from which the audit trail must start collecting data in UTC, in the format defined by RFC3339. If not specified, this will default to the date based on the retention period.
        :param pulumi.Input[builtins.str] audit_profile_id: The OCID of the audit.
        :param pulumi.Input[builtins.str] database_unique_name: Unique name of the database associated to the peer target database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trail_locations: The trail locations for which the audit data volume has to be calculated.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CalculateAuditVolumeAvailableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Calculate Audit Volume Available resource in Oracle Cloud Infrastructure Data Safe service.

        Calculates the volume of audit events available on the target database to be collected. Measurable up to the defined retention period of the audit target resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_calculate_audit_volume_available = oci.data_safe.CalculateAuditVolumeAvailable("test_calculate_audit_volume_available",
            audit_profile_id=test_audit_profile["id"],
            audit_collection_start_time=calculate_audit_volume_available_audit_collection_start_time,
            database_unique_name=calculate_audit_volume_available_database_unique_name,
            trail_locations=calculate_audit_volume_available_trail_locations)
        ```

        ## Import

        CalculateAuditVolumeAvailable can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/calculateAuditVolumeAvailable:CalculateAuditVolumeAvailable test_calculate_audit_volume_available "id"
        ```

        :param str resource_name: The name of the resource.
        :param CalculateAuditVolumeAvailableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CalculateAuditVolumeAvailableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 audit_collection_start_time: Optional[pulumi.Input[builtins.str]] = None,
                 audit_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 database_unique_name: Optional[pulumi.Input[builtins.str]] = None,
                 trail_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CalculateAuditVolumeAvailableArgs.__new__(CalculateAuditVolumeAvailableArgs)

            __props__.__dict__["audit_collection_start_time"] = audit_collection_start_time
            if audit_profile_id is None and not opts.urn:
                raise TypeError("Missing required property 'audit_profile_id'")
            __props__.__dict__["audit_profile_id"] = audit_profile_id
            __props__.__dict__["database_unique_name"] = database_unique_name
            __props__.__dict__["trail_locations"] = trail_locations
            __props__.__dict__["available_audit_volumes"] = None
        super(CalculateAuditVolumeAvailable, __self__).__init__(
            'oci:DataSafe/calculateAuditVolumeAvailable:CalculateAuditVolumeAvailable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_collection_start_time: Optional[pulumi.Input[builtins.str]] = None,
            audit_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            available_audit_volumes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CalculateAuditVolumeAvailableAvailableAuditVolumeArgs', 'CalculateAuditVolumeAvailableAvailableAuditVolumeArgsDict']]]]] = None,
            database_unique_name: Optional[pulumi.Input[builtins.str]] = None,
            trail_locations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'CalculateAuditVolumeAvailable':
        """
        Get an existing CalculateAuditVolumeAvailable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] audit_collection_start_time: The date from which the audit trail must start collecting data in UTC, in the format defined by RFC3339. If not specified, this will default to the date based on the retention period.
        :param pulumi.Input[builtins.str] audit_profile_id: The OCID of the audit.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CalculateAuditVolumeAvailableAvailableAuditVolumeArgs', 'CalculateAuditVolumeAvailableAvailableAuditVolumeArgsDict']]]] available_audit_volumes: List of available audit volumes.
        :param pulumi.Input[builtins.str] database_unique_name: Unique name of the database associated to the peer target database.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] trail_locations: The trail locations for which the audit data volume has to be calculated.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CalculateAuditVolumeAvailableState.__new__(_CalculateAuditVolumeAvailableState)

        __props__.__dict__["audit_collection_start_time"] = audit_collection_start_time
        __props__.__dict__["audit_profile_id"] = audit_profile_id
        __props__.__dict__["available_audit_volumes"] = available_audit_volumes
        __props__.__dict__["database_unique_name"] = database_unique_name
        __props__.__dict__["trail_locations"] = trail_locations
        return CalculateAuditVolumeAvailable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditCollectionStartTime")
    def audit_collection_start_time(self) -> pulumi.Output[builtins.str]:
        """
        The date from which the audit trail must start collecting data in UTC, in the format defined by RFC3339. If not specified, this will default to the date based on the retention period.
        """
        return pulumi.get(self, "audit_collection_start_time")

    @property
    @pulumi.getter(name="auditProfileId")
    def audit_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the audit.
        """
        return pulumi.get(self, "audit_profile_id")

    @property
    @pulumi.getter(name="availableAuditVolumes")
    def available_audit_volumes(self) -> pulumi.Output[Sequence['outputs.CalculateAuditVolumeAvailableAvailableAuditVolume']]:
        """
        List of available audit volumes.
        """
        return pulumi.get(self, "available_audit_volumes")

    @property
    @pulumi.getter(name="databaseUniqueName")
    def database_unique_name(self) -> pulumi.Output[builtins.str]:
        """
        Unique name of the database associated to the peer target database.
        """
        return pulumi.get(self, "database_unique_name")

    @property
    @pulumi.getter(name="trailLocations")
    def trail_locations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The trail locations for which the audit data volume has to be calculated.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "trail_locations")

