# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['CompareUserAssessmentArgs', 'CompareUserAssessment']

@pulumi.input_type
class CompareUserAssessmentArgs:
    def __init__(__self__, *,
                 comparison_user_assessment_id: pulumi.Input[builtins.str],
                 user_assessment_id: pulumi.Input[builtins.str]):
        """
        The set of arguments for constructing a CompareUserAssessment resource.
        :param pulumi.Input[builtins.str] comparison_user_assessment_id: The OCID of the user assessment to be compared. You can compare with another user assessment, a latest assessment, or a baseline.
        :param pulumi.Input[builtins.str] user_assessment_id: The OCID of the user assessment.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "comparison_user_assessment_id", comparison_user_assessment_id)
        pulumi.set(__self__, "user_assessment_id", user_assessment_id)

    @property
    @pulumi.getter(name="comparisonUserAssessmentId")
    def comparison_user_assessment_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the user assessment to be compared. You can compare with another user assessment, a latest assessment, or a baseline.
        """
        return pulumi.get(self, "comparison_user_assessment_id")

    @comparison_user_assessment_id.setter
    def comparison_user_assessment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "comparison_user_assessment_id", value)

    @property
    @pulumi.getter(name="userAssessmentId")
    def user_assessment_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the user assessment.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_assessment_id")

    @user_assessment_id.setter
    def user_assessment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "user_assessment_id", value)


@pulumi.input_type
class _CompareUserAssessmentState:
    def __init__(__self__, *,
                 comparison_user_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_assessment_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering CompareUserAssessment resources.
        :param pulumi.Input[builtins.str] comparison_user_assessment_id: The OCID of the user assessment to be compared. You can compare with another user assessment, a latest assessment, or a baseline.
        :param pulumi.Input[builtins.str] user_assessment_id: The OCID of the user assessment.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if comparison_user_assessment_id is not None:
            pulumi.set(__self__, "comparison_user_assessment_id", comparison_user_assessment_id)
        if user_assessment_id is not None:
            pulumi.set(__self__, "user_assessment_id", user_assessment_id)

    @property
    @pulumi.getter(name="comparisonUserAssessmentId")
    def comparison_user_assessment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the user assessment to be compared. You can compare with another user assessment, a latest assessment, or a baseline.
        """
        return pulumi.get(self, "comparison_user_assessment_id")

    @comparison_user_assessment_id.setter
    def comparison_user_assessment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "comparison_user_assessment_id", value)

    @property
    @pulumi.getter(name="userAssessmentId")
    def user_assessment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the user assessment.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_assessment_id")

    @user_assessment_id.setter
    def user_assessment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "user_assessment_id", value)


class CompareUserAssessment(pulumi.CustomResource):

    pulumi_type = "oci:DataSafe/compareUserAssessment:CompareUserAssessment"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison_user_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Compare User Assessment resource in Oracle Cloud Infrastructure Data Safe service.

        Compares two user assessments. For this comparison, a user assessment can be a saved, a latest assessment, or a baseline.
        As an example, it can be used to compare a user assessment saved or a latest assessment with a baseline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_compare_user_assessment = oci.data_safe.CompareUserAssessment("test_compare_user_assessment",
            comparison_user_assessment_id=test_user_assessment["id"],
            user_assessment_id=test_user_assessment["id"])
        ```

        ## Import

        CompareUserAssessment can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/compareUserAssessment:CompareUserAssessment test_compare_user_assessment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] comparison_user_assessment_id: The OCID of the user assessment to be compared. You can compare with another user assessment, a latest assessment, or a baseline.
        :param pulumi.Input[builtins.str] user_assessment_id: The OCID of the user assessment.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CompareUserAssessmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Compare User Assessment resource in Oracle Cloud Infrastructure Data Safe service.

        Compares two user assessments. For this comparison, a user assessment can be a saved, a latest assessment, or a baseline.
        As an example, it can be used to compare a user assessment saved or a latest assessment with a baseline.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_compare_user_assessment = oci.data_safe.CompareUserAssessment("test_compare_user_assessment",
            comparison_user_assessment_id=test_user_assessment["id"],
            user_assessment_id=test_user_assessment["id"])
        ```

        ## Import

        CompareUserAssessment can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/compareUserAssessment:CompareUserAssessment test_compare_user_assessment "id"
        ```

        :param str resource_name: The name of the resource.
        :param CompareUserAssessmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CompareUserAssessmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comparison_user_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 user_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CompareUserAssessmentArgs.__new__(CompareUserAssessmentArgs)

            if comparison_user_assessment_id is None and not opts.urn:
                raise TypeError("Missing required property 'comparison_user_assessment_id'")
            __props__.__dict__["comparison_user_assessment_id"] = comparison_user_assessment_id
            if user_assessment_id is None and not opts.urn:
                raise TypeError("Missing required property 'user_assessment_id'")
            __props__.__dict__["user_assessment_id"] = user_assessment_id
        super(CompareUserAssessment, __self__).__init__(
            'oci:DataSafe/compareUserAssessment:CompareUserAssessment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            comparison_user_assessment_id: Optional[pulumi.Input[builtins.str]] = None,
            user_assessment_id: Optional[pulumi.Input[builtins.str]] = None) -> 'CompareUserAssessment':
        """
        Get an existing CompareUserAssessment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] comparison_user_assessment_id: The OCID of the user assessment to be compared. You can compare with another user assessment, a latest assessment, or a baseline.
        :param pulumi.Input[builtins.str] user_assessment_id: The OCID of the user assessment.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CompareUserAssessmentState.__new__(_CompareUserAssessmentState)

        __props__.__dict__["comparison_user_assessment_id"] = comparison_user_assessment_id
        __props__.__dict__["user_assessment_id"] = user_assessment_id
        return CompareUserAssessment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="comparisonUserAssessmentId")
    def comparison_user_assessment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the user assessment to be compared. You can compare with another user assessment, a latest assessment, or a baseline.
        """
        return pulumi.get(self, "comparison_user_assessment_id")

    @property
    @pulumi.getter(name="userAssessmentId")
    def user_assessment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the user assessment.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "user_assessment_id")

