# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityPolicyReportsResult',
    'AwaitableGetSecurityPolicyReportsResult',
    'get_security_policy_reports',
    'get_security_policy_reports_output',
]

@pulumi.output_type
class GetSecurityPolicyReportsResult:
    """
    A collection of values returned by getSecurityPolicyReports.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, security_policy_report_collections=None, security_policy_report_id=None, state=None, target_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_policy_report_collections and not isinstance(security_policy_report_collections, list):
            raise TypeError("Expected argument 'security_policy_report_collections' to be a list")
        pulumi.set(__self__, "security_policy_report_collections", security_policy_report_collections)
        if security_policy_report_id and not isinstance(security_policy_report_id, str):
            raise TypeError("Expected argument 'security_policy_report_id' to be a str")
        pulumi.set(__self__, "security_policy_report_id", security_policy_report_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[builtins.str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the security policy report.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        The display name of the security policy report.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityPolicyReportsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityPolicyReportCollections")
    def security_policy_report_collections(self) -> Sequence['outputs.GetSecurityPolicyReportsSecurityPolicyReportCollectionResult']:
        """
        The list of security_policy_report_collection.
        """
        return pulumi.get(self, "security_policy_report_collections")

    @property
    @pulumi.getter(name="securityPolicyReportId")
    def security_policy_report_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "security_policy_report_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the security policy report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[builtins.str]:
        """
        The OCID of the of the  target database.
        """
        return pulumi.get(self, "target_id")


class AwaitableGetSecurityPolicyReportsResult(GetSecurityPolicyReportsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityPolicyReportsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            security_policy_report_collections=self.security_policy_report_collections,
            security_policy_report_id=self.security_policy_report_id,
            state=self.state,
            target_id=self.target_id)


def get_security_policy_reports(access_level: Optional[builtins.str] = None,
                                compartment_id: Optional[builtins.str] = None,
                                compartment_id_in_subtree: Optional[builtins.bool] = None,
                                display_name: Optional[builtins.str] = None,
                                filters: Optional[Sequence[Union['GetSecurityPolicyReportsFilterArgs', 'GetSecurityPolicyReportsFilterArgsDict']]] = None,
                                security_policy_report_id: Optional[builtins.str] = None,
                                state: Optional[builtins.str] = None,
                                target_id: Optional[builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityPolicyReportsResult:
    """
    This data source provides the list of Security Policy Reports in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all security policy reports in Data Safe.

    The ListSecurityPolicyReports operation returns only the security policy reports in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListSecurityPolicyReports on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_reports = oci.DataSafe.get_security_policy_reports(compartment_id=compartment_id,
        access_level=security_policy_report_access_level,
        compartment_id_in_subtree=security_policy_report_compartment_id_in_subtree,
        display_name=security_policy_report_display_name,
        security_policy_report_id=test_security_policy_report["id"],
        state=security_policy_report_state,
        target_id=test_target["id"])
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param builtins.str display_name: A filter to return only resources that match the specified display name.
    :param builtins.str security_policy_report_id: An optional filter to return only resources that match the specified OCID of the security policy report resource.
    :param builtins.str state: The current state of the security policy report.
    :param builtins.str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['securityPolicyReportId'] = security_policy_report_id
    __args__['state'] = state
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityPolicyReports:getSecurityPolicyReports', __args__, opts=opts, typ=GetSecurityPolicyReportsResult).value

    return AwaitableGetSecurityPolicyReportsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        security_policy_report_collections=pulumi.get(__ret__, 'security_policy_report_collections'),
        security_policy_report_id=pulumi.get(__ret__, 'security_policy_report_id'),
        state=pulumi.get(__ret__, 'state'),
        target_id=pulumi.get(__ret__, 'target_id'))
def get_security_policy_reports_output(access_level: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                       compartment_id_in_subtree: Optional[pulumi.Input[Optional[builtins.bool]]] = None,
                                       display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetSecurityPolicyReportsFilterArgs', 'GetSecurityPolicyReportsFilterArgsDict']]]]] = None,
                                       security_policy_report_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       target_id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSecurityPolicyReportsResult]:
    """
    This data source provides the list of Security Policy Reports in Oracle Cloud Infrastructure Data Safe service.

    Retrieves a list of all security policy reports in Data Safe.

    The ListSecurityPolicyReports operation returns only the security policy reports in the specified `compartmentId`.

    The parameter `accessLevel` specifies whether to return only those compartments for which the
    requestor has INSPECT permissions on at least one resource directly
    or indirectly (ACCESSIBLE) (the resource can be in a subcompartment) or to return Not Authorized if
    Principal doesn't have access to even one of the child compartments. This is valid only when
    `compartmentIdInSubtree` is set to `true`.

    The parameter `compartmentIdInSubtree` applies when you perform ListSecurityPolicyReports on the
    `compartmentId` passed and when it is set to true, the entire hierarchy of compartments can be returned.
    To get a full list of all compartments and subcompartments in the tenancy (root compartment),
    set the parameter `compartmentIdInSubtree` to true and `accessLevel` to ACCESSIBLE.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_policy_reports = oci.DataSafe.get_security_policy_reports(compartment_id=compartment_id,
        access_level=security_policy_report_access_level,
        compartment_id_in_subtree=security_policy_report_compartment_id_in_subtree,
        display_name=security_policy_report_display_name,
        security_policy_report_id=test_security_policy_report["id"],
        state=security_policy_report_state,
        target_id=test_target["id"])
    ```


    :param builtins.str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param builtins.str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param builtins.bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param builtins.str display_name: A filter to return only resources that match the specified display name.
    :param builtins.str security_policy_report_id: An optional filter to return only resources that match the specified OCID of the security policy report resource.
    :param builtins.str state: The current state of the security policy report.
    :param builtins.str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['securityPolicyReportId'] = security_policy_report_id
    __args__['state'] = state
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataSafe/getSecurityPolicyReports:getSecurityPolicyReports', __args__, opts=opts, typ=GetSecurityPolicyReportsResult)
    return __ret__.apply(lambda __response__: GetSecurityPolicyReportsResult(
        access_level=pulumi.get(__response__, 'access_level'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__response__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        security_policy_report_collections=pulumi.get(__response__, 'security_policy_report_collections'),
        security_policy_report_id=pulumi.get(__response__, 'security_policy_report_id'),
        state=pulumi.get(__response__, 'state'),
        target_id=pulumi.get(__response__, 'target_id')))
