# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MaskingPolicyHealthReportManagementArgs', 'MaskingPolicyHealthReportManagement']

@pulumi.input_type
class MaskingPolicyHealthReportManagementArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MaskingPolicyHealthReportManagement resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment that contains the masking report.
        :param pulumi.Input[builtins.str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[builtins.str] target_id: The OCID of the target database masked.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if masking_policy_id is not None:
            pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment that contains the masking report.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @masking_policy_id.setter
    def masking_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "masking_policy_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the target database masked.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)


@pulumi.input_type
class _MaskingPolicyHealthReportManagementState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering MaskingPolicyHealthReportManagement resources.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment that contains the masking report.
        :param pulumi.Input[builtins.str] description: Description for the pre-masking report,
        :param pulumi.Input[builtins.str] display_name: The display name of the pre-masking report,
        :param pulumi.Input[builtins.str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[builtins.str] state: The current state of the pre-masking report.
        :param pulumi.Input[builtins.str] target_id: The OCID of the target database masked.
        :param pulumi.Input[builtins.str] time_created: The date and time the pre-masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339),
        :param pulumi.Input[builtins.str] time_updated: The date and time the pre-masking report was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339),
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if masking_policy_id is not None:
            pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment that contains the masking report.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description for the pre-masking report,
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The display name of the pre-masking report,
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @masking_policy_id.setter
    def masking_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "masking_policy_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the pre-masking report.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the target database masked.
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the pre-masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339),
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the pre-masking report was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339),
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class MaskingPolicyHealthReportManagement(pulumi.CustomResource):

    pulumi_type = "oci:DataSafe/maskingPolicyHealthReportManagement:MaskingPolicyHealthReportManagement"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides Pre-masking Report Management resource in Oracle Cloud Infrastructure Data Safe service.

        Gets the details of the specified pre-masking health report.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pre_masking_report_management = oci.data_safe.MaskingPolicyHealthReportManagement("test_pre_masking_report_management",
            target_id=test_target_database["id"],
            masking_policy_id=test_masking_policy["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment that contains the masking report.
        :param pulumi.Input[builtins.str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[builtins.str] target_id: The OCID of the target database masked.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[MaskingPolicyHealthReportManagementArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides Pre-masking Report Management resource in Oracle Cloud Infrastructure Data Safe service.

        Gets the details of the specified pre-masking health report.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_pre_masking_report_management = oci.data_safe.MaskingPolicyHealthReportManagement("test_pre_masking_report_management",
            target_id=test_target_database["id"],
            masking_policy_id=test_masking_policy["id"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param MaskingPolicyHealthReportManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MaskingPolicyHealthReportManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MaskingPolicyHealthReportManagementArgs.__new__(MaskingPolicyHealthReportManagementArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["masking_policy_id"] = masking_policy_id
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["description"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MaskingPolicyHealthReportManagement, __self__).__init__(
            'oci:DataSafe/maskingPolicyHealthReportManagement:MaskingPolicyHealthReportManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            masking_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            target_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'MaskingPolicyHealthReportManagement':
        """
        Get an existing MaskingPolicyHealthReportManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment that contains the masking report.
        :param pulumi.Input[builtins.str] description: Description for the pre-masking report,
        :param pulumi.Input[builtins.str] display_name: The display name of the pre-masking report,
        :param pulumi.Input[builtins.str] masking_policy_id: The OCID of the masking policy.
        :param pulumi.Input[builtins.str] state: The current state of the pre-masking report.
        :param pulumi.Input[builtins.str] target_id: The OCID of the target database masked.
        :param pulumi.Input[builtins.str] time_created: The date and time the pre-masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339),
        :param pulumi.Input[builtins.str] time_updated: The date and time the pre-masking report was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339),
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MaskingPolicyHealthReportManagementState.__new__(_MaskingPolicyHealthReportManagementState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["masking_policy_id"] = masking_policy_id
        __props__.__dict__["state"] = state
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return MaskingPolicyHealthReportManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the compartment that contains the masking report.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        Description for the pre-masking report,
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        The display name of the pre-masking report,
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the masking policy.
        """
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the pre-masking report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the target database masked.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the pre-masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339),
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the pre-masking report was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339),
        """
        return pulumi.get(self, "time_updated")

