# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SensitiveTypeGroupGroupedSensitiveTypeArgs', 'SensitiveTypeGroupGroupedSensitiveType']

@pulumi.input_type
class SensitiveTypeGroupGroupedSensitiveTypeArgs:
    def __init__(__self__, *,
                 sensitive_type_group_id: pulumi.Input[builtins.str],
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs']]]] = None):
        """
        The set of arguments for constructing a SensitiveTypeGroupGroupedSensitiveType resource.
        :param pulumi.Input[builtins.str] sensitive_type_group_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs']]] patch_operations: (Updatable)
        """
        pulumi.set(__self__, "sensitive_type_group_id", sensitive_type_group_id)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)

    @property
    @pulumi.getter(name="sensitiveTypeGroupId")
    def sensitive_type_group_id(self) -> pulumi.Input[builtins.str]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_group_id")

    @sensitive_type_group_id.setter
    def sensitive_type_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sensitive_type_group_id", value)

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)


@pulumi.input_type
class _SensitiveTypeGroupGroupedSensitiveTypeState:
    def __init__(__self__, *,
                 items: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypeItemArgs']]]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs']]]] = None,
                 sensitive_type_group_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SensitiveTypeGroupGroupedSensitiveType resources.
        :param pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypeItemArgs']]] items: List of sensitive type id summary objects present in the sensitive type group.
        :param pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs']]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.str] sensitive_type_group_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if items is not None:
            pulumi.set(__self__, "items", items)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if sensitive_type_group_id is not None:
            pulumi.set(__self__, "sensitive_type_group_id", sensitive_type_group_id)

    @property
    @pulumi.getter
    def items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypeItemArgs']]]]:
        """
        List of sensitive type id summary objects present in the sensitive type group.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypeItemArgs']]]]):
        pulumi.set(self, "items", value)

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @property
    @pulumi.getter(name="sensitiveTypeGroupId")
    def sensitive_type_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_group_id")

    @sensitive_type_group_id.setter
    def sensitive_type_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sensitive_type_group_id", value)


class SensitiveTypeGroupGroupedSensitiveType(pulumi.CustomResource):

    pulumi_type = "oci:DataSafe/sensitiveTypeGroupGroupedSensitiveType:SensitiveTypeGroupGroupedSensitiveType"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs', 'SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgsDict']]]]] = None,
                 sensitive_type_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Sensitive Type Group Grouped Sensitive Type resource in Oracle Cloud Infrastructure Data Safe service.

          Patches one or more sensitive types in a sensitive type group. You can use this operation to add or remove
        sensitive type ids in a sensitive type group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_type_group_grouped_sensitive_type = oci.data_safe.SensitiveTypeGroupGroupedSensitiveType("test_sensitive_type_group_grouped_sensitive_type",
            sensitive_type_group_id=test_sensitive_type_group["id"],
            patch_operations=[{
                "operation": sensitive_type_group_grouped_sensitive_type_patch_operations_operation,
                "selection": sensitive_type_group_grouped_sensitive_type_patch_operations_selection,
                "value": sensitive_type_group_grouped_sensitive_type_patch_operations_value,
            }])
        ```

        ## Import

        SensitiveTypeGroupGroupedSensitiveTypes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sensitiveTypeGroupGroupedSensitiveType:SensitiveTypeGroupGroupedSensitiveType test_sensitive_type_group_grouped_sensitive_type "sensitiveTypeGroups/{sensitiveTypeGroupId}/groupedSensitiveTypes"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs', 'SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.str] sensitive_type_group_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensitiveTypeGroupGroupedSensitiveTypeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sensitive Type Group Grouped Sensitive Type resource in Oracle Cloud Infrastructure Data Safe service.

          Patches one or more sensitive types in a sensitive type group. You can use this operation to add or remove
        sensitive type ids in a sensitive type group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_type_group_grouped_sensitive_type = oci.data_safe.SensitiveTypeGroupGroupedSensitiveType("test_sensitive_type_group_grouped_sensitive_type",
            sensitive_type_group_id=test_sensitive_type_group["id"],
            patch_operations=[{
                "operation": sensitive_type_group_grouped_sensitive_type_patch_operations_operation,
                "selection": sensitive_type_group_grouped_sensitive_type_patch_operations_selection,
                "value": sensitive_type_group_grouped_sensitive_type_patch_operations_value,
            }])
        ```

        ## Import

        SensitiveTypeGroupGroupedSensitiveTypes can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sensitiveTypeGroupGroupedSensitiveType:SensitiveTypeGroupGroupedSensitiveType test_sensitive_type_group_grouped_sensitive_type "sensitiveTypeGroups/{sensitiveTypeGroupId}/groupedSensitiveTypes"
        ```

        :param str resource_name: The name of the resource.
        :param SensitiveTypeGroupGroupedSensitiveTypeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensitiveTypeGroupGroupedSensitiveTypeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs', 'SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgsDict']]]]] = None,
                 sensitive_type_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensitiveTypeGroupGroupedSensitiveTypeArgs.__new__(SensitiveTypeGroupGroupedSensitiveTypeArgs)

            __props__.__dict__["patch_operations"] = patch_operations
            if sensitive_type_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'sensitive_type_group_id'")
            __props__.__dict__["sensitive_type_group_id"] = sensitive_type_group_id
            __props__.__dict__["items"] = None
        super(SensitiveTypeGroupGroupedSensitiveType, __self__).__init__(
            'oci:DataSafe/sensitiveTypeGroupGroupedSensitiveType:SensitiveTypeGroupGroupedSensitiveType',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveTypeGroupGroupedSensitiveTypeItemArgs', 'SensitiveTypeGroupGroupedSensitiveTypeItemArgsDict']]]]] = None,
            patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs', 'SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgsDict']]]]] = None,
            sensitive_type_group_id: Optional[pulumi.Input[builtins.str]] = None) -> 'SensitiveTypeGroupGroupedSensitiveType':
        """
        Get an existing SensitiveTypeGroupGroupedSensitiveType resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensitiveTypeGroupGroupedSensitiveTypeItemArgs', 'SensitiveTypeGroupGroupedSensitiveTypeItemArgsDict']]]] items: List of sensitive type id summary objects present in the sensitive type group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgs', 'SensitiveTypeGroupGroupedSensitiveTypePatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.str] sensitive_type_group_id: ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensitiveTypeGroupGroupedSensitiveTypeState.__new__(_SensitiveTypeGroupGroupedSensitiveTypeState)

        __props__.__dict__["items"] = items
        __props__.__dict__["patch_operations"] = patch_operations
        __props__.__dict__["sensitive_type_group_id"] = sensitive_type_group_id
        return SensitiveTypeGroupGroupedSensitiveType(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Output[Sequence['outputs.SensitiveTypeGroupGroupedSensitiveTypeItem']]:
        """
        List of sensitive type id summary objects present in the sensitive type group.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> pulumi.Output[Optional[Sequence['outputs.SensitiveTypeGroupGroupedSensitiveTypePatchOperation']]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @property
    @pulumi.getter(name="sensitiveTypeGroupId")
    def sensitive_type_group_id(self) -> pulumi.Output[builtins.str]:
        """
        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "sensitive_type_group_id")

