# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ZonePromoteDnssecKeyVersionArgs', 'ZonePromoteDnssecKeyVersion']

@pulumi.input_type
class ZonePromoteDnssecKeyVersionArgs:
    def __init__(__self__, *,
                 dnssec_key_version_uuid: pulumi.Input[builtins.str],
                 zone_id: pulumi.Input[builtins.str],
                 scope: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ZonePromoteDnssecKeyVersion resource.
        :param pulumi.Input[builtins.str] dnssec_key_version_uuid: The UUID of the `DnssecKeyVersion` that is being promoted.
        :param pulumi.Input[builtins.str] zone_id: The OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        """
        pulumi.set(__self__, "dnssec_key_version_uuid", dnssec_key_version_uuid)
        pulumi.set(__self__, "zone_id", zone_id)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @property
    @pulumi.getter(name="dnssecKeyVersionUuid")
    def dnssec_key_version_uuid(self) -> pulumi.Input[builtins.str]:
        """
        The UUID of the `DnssecKeyVersion` that is being promoted.
        """
        return pulumi.get(self, "dnssec_key_version_uuid")

    @dnssec_key_version_uuid.setter
    def dnssec_key_version_uuid(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "dnssec_key_version_uuid", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "zone_id", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)


@pulumi.input_type
class _ZonePromoteDnssecKeyVersionState:
    def __init__(__self__, *,
                 dnssec_key_version_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ZonePromoteDnssecKeyVersion resources.
        :param pulumi.Input[builtins.str] dnssec_key_version_uuid: The UUID of the `DnssecKeyVersion` that is being promoted.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] zone_id: The OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if dnssec_key_version_uuid is not None:
            pulumi.set(__self__, "dnssec_key_version_uuid", dnssec_key_version_uuid)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="dnssecKeyVersionUuid")
    def dnssec_key_version_uuid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The UUID of the `DnssecKeyVersion` that is being promoted.
        """
        return pulumi.get(self, "dnssec_key_version_uuid")

    @dnssec_key_version_uuid.setter
    def dnssec_key_version_uuid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "dnssec_key_version_uuid", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "zone_id", value)


class ZonePromoteDnssecKeyVersion(pulumi.CustomResource):

    pulumi_type = "oci:Dns/zonePromoteDnssecKeyVersion:ZonePromoteDnssecKeyVersion"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dnssec_key_version_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Zone Promote Dnssec Key Version resource in Oracle Cloud Infrastructure DNS service.

        Promotes a specified `DnssecKeyVersion` on the zone.

        If the `DnssecKeyVersion` identified in the request body is a key signing key (KSK) that is replacing
        another `DnssecKeyVersion`, then the old `DnssecKeyVersion` is scheduled for removal from the zone.

        For key signing keys (KSKs), you must create the DS record with the new key information **before** promoting
        the new key to establish a chain of trust. To avoid a service disruption, remove the old DS record as soon
        as its TTL (time to live) expires.

        For more information, see [DNSSEC](https://docs.cloud.oracle.com/iaas/Content/DNS/Concepts/dnssec.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_zone_promote_dnssec_key_version = oci.dns.ZonePromoteDnssecKeyVersion("test_zone_promote_dnssec_key_version",
            dnssec_key_version_uuid=zone_promote_dnssec_key_version_dnssec_key_version_uuid,
            zone_id=test_zone["id"],
            scope=zone_promote_dnssec_key_version_scope)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] dnssec_key_version_uuid: The UUID of the `DnssecKeyVersion` that is being promoted.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] zone_id: The OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ZonePromoteDnssecKeyVersionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Zone Promote Dnssec Key Version resource in Oracle Cloud Infrastructure DNS service.

        Promotes a specified `DnssecKeyVersion` on the zone.

        If the `DnssecKeyVersion` identified in the request body is a key signing key (KSK) that is replacing
        another `DnssecKeyVersion`, then the old `DnssecKeyVersion` is scheduled for removal from the zone.

        For key signing keys (KSKs), you must create the DS record with the new key information **before** promoting
        the new key to establish a chain of trust. To avoid a service disruption, remove the old DS record as soon
        as its TTL (time to live) expires.

        For more information, see [DNSSEC](https://docs.cloud.oracle.com/iaas/Content/DNS/Concepts/dnssec.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_zone_promote_dnssec_key_version = oci.dns.ZonePromoteDnssecKeyVersion("test_zone_promote_dnssec_key_version",
            dnssec_key_version_uuid=zone_promote_dnssec_key_version_dnssec_key_version_uuid,
            zone_id=test_zone["id"],
            scope=zone_promote_dnssec_key_version_scope)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param ZonePromoteDnssecKeyVersionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZonePromoteDnssecKeyVersionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 dnssec_key_version_uuid: Optional[pulumi.Input[builtins.str]] = None,
                 scope: Optional[pulumi.Input[builtins.str]] = None,
                 zone_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZonePromoteDnssecKeyVersionArgs.__new__(ZonePromoteDnssecKeyVersionArgs)

            if dnssec_key_version_uuid is None and not opts.urn:
                raise TypeError("Missing required property 'dnssec_key_version_uuid'")
            __props__.__dict__["dnssec_key_version_uuid"] = dnssec_key_version_uuid
            __props__.__dict__["scope"] = scope
            if zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'zone_id'")
            __props__.__dict__["zone_id"] = zone_id
        super(ZonePromoteDnssecKeyVersion, __self__).__init__(
            'oci:Dns/zonePromoteDnssecKeyVersion:ZonePromoteDnssecKeyVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            dnssec_key_version_uuid: Optional[pulumi.Input[builtins.str]] = None,
            scope: Optional[pulumi.Input[builtins.str]] = None,
            zone_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ZonePromoteDnssecKeyVersion':
        """
        Get an existing ZonePromoteDnssecKeyVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] dnssec_key_version_uuid: The UUID of the `DnssecKeyVersion` that is being promoted.
        :param pulumi.Input[builtins.str] scope: Specifies to operate only on resources that have a matching DNS scope.
        :param pulumi.Input[builtins.str] zone_id: The OCID of the target zone.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZonePromoteDnssecKeyVersionState.__new__(_ZonePromoteDnssecKeyVersionState)

        __props__.__dict__["dnssec_key_version_uuid"] = dnssec_key_version_uuid
        __props__.__dict__["scope"] = scope
        __props__.__dict__["zone_id"] = zone_id
        return ZonePromoteDnssecKeyVersion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dnssecKeyVersionUuid")
    def dnssec_key_version_uuid(self) -> pulumi.Output[builtins.str]:
        """
        The UUID of the `DnssecKeyVersion` that is being promoted.
        """
        return pulumi.get(self, "dnssec_key_version_uuid")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[builtins.str]:
        """
        Specifies to operate only on resources that have a matching DNS scope.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the target zone.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "zone_id")

