# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ReplicationArgs', 'Replication']

@pulumi.input_type
class ReplicationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 source_id: pulumi.Input[builtins.str],
                 target_id: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationLockArgs']]]] = None,
                 replication_interval: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Replication resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the replication.
        :param pulumi.Input[builtins.str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        :param pulumi.Input[builtins.str] target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. An associated replication target will also created with the same `displayName`. Example: `My replication`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[builtins.str] replication_interval: (Updatable) Duration in minutes between replication snapshots.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "source_id", source_id)
        pulumi.set(__self__, "target_id", target_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if replication_interval is not None:
            pulumi.set(__self__, "replication_interval", replication_interval)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the replication.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. An associated replication target will also created with the same `displayName`. Example: `My replication`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="replicationInterval")
    def replication_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Duration in minutes between replication snapshots.
        """
        return pulumi.get(self, "replication_interval")

    @replication_interval.setter
    def replication_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_interval", value)


@pulumi.input_type
class _ReplicationState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 delta_progress: Optional[pulumi.Input[builtins.str]] = None,
                 delta_status: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
                 last_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationLockArgs']]]] = None,
                 recovery_point_time: Optional[pulumi.Input[builtins.str]] = None,
                 replication_interval: Optional[pulumi.Input[builtins.str]] = None,
                 replication_target_id: Optional[pulumi.Input[builtins.str]] = None,
                 source_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Replication resources.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain the replication is in. The replication must be in the same availability domain as the source file system. Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the replication.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] delta_progress: Percentage progress of the current replication cycle.
        :param pulumi.Input[builtins.str] delta_status: The current state of the snapshot during replication operations.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. An associated replication target will also created with the same `displayName`. Example: `My replication`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] last_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last snapshot that has been replicated completely. Empty if the copy of the initial snapshot is not complete.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current 'lifecycleState'.
        :param pulumi.Input[Sequence[pulumi.Input['ReplicationLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[builtins.str] recovery_point_time: The [`snapshotTime`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Snapshot/snapshotTime) of the most recent recoverable replication snapshot in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-04-04T20:01:29.100Z`
        :param pulumi.Input[builtins.str] replication_interval: (Updatable) Duration in minutes between replication snapshots.
        :param pulumi.Input[builtins.str] replication_target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [`ReplicationTarget`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ReplicationTarget).
        :param pulumi.Input[builtins.str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        :param pulumi.Input[builtins.str] state: The current state of this replication. This resource can be in a `FAILED` state if replication target is deleted instead of the replication resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param pulumi.Input[builtins.str] target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if delta_progress is not None:
            pulumi.set(__self__, "delta_progress", delta_progress)
        if delta_status is not None:
            pulumi.set(__self__, "delta_status", delta_status)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if last_snapshot_id is not None:
            pulumi.set(__self__, "last_snapshot_id", last_snapshot_id)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if recovery_point_time is not None:
            pulumi.set(__self__, "recovery_point_time", recovery_point_time)
        if replication_interval is not None:
            pulumi.set(__self__, "replication_interval", replication_interval)
        if replication_target_id is not None:
            pulumi.set(__self__, "replication_target_id", replication_target_id)
        if source_id is not None:
            pulumi.set(__self__, "source_id", source_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain the replication is in. The replication must be in the same availability domain as the source file system. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the replication.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deltaProgress")
    def delta_progress(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Percentage progress of the current replication cycle.
        """
        return pulumi.get(self, "delta_progress")

    @delta_progress.setter
    def delta_progress(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delta_progress", value)

    @property
    @pulumi.getter(name="deltaStatus")
    def delta_status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the snapshot during replication operations.
        """
        return pulumi.get(self, "delta_status")

    @delta_status.setter
    def delta_status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "delta_status", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. An associated replication target will also created with the same `displayName`. Example: `My replication`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter(name="lastSnapshotId")
    def last_snapshot_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last snapshot that has been replicated completely. Empty if the copy of the initial snapshot is not complete.
        """
        return pulumi.get(self, "last_snapshot_id")

    @last_snapshot_id.setter
    def last_snapshot_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_snapshot_id", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ReplicationLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="recoveryPointTime")
    def recovery_point_time(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [`snapshotTime`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Snapshot/snapshotTime) of the most recent recoverable replication snapshot in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-04-04T20:01:29.100Z`
        """
        return pulumi.get(self, "recovery_point_time")

    @recovery_point_time.setter
    def recovery_point_time(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "recovery_point_time", value)

    @property
    @pulumi.getter(name="replicationInterval")
    def replication_interval(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Duration in minutes between replication snapshots.
        """
        return pulumi.get(self, "replication_interval")

    @replication_interval.setter
    def replication_interval(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_interval", value)

    @property
    @pulumi.getter(name="replicationTargetId")
    def replication_target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [`ReplicationTarget`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ReplicationTarget).
        """
        return pulumi.get(self, "replication_target_id")

    @replication_target_id.setter
    def replication_target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_target_id", value)

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        """
        return pulumi.get(self, "source_id")

    @source_id.setter
    def source_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "source_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of this replication. This resource can be in a `FAILED` state if replication target is deleted instead of the replication resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)


class Replication(pulumi.CustomResource):

    pulumi_type = "oci:FileStorage/replication:Replication"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationLockArgs', 'ReplicationLockArgsDict']]]]] = None,
                 replication_interval: Optional[pulumi.Input[builtins.str]] = None,
                 source_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Replication resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new replication in the specified compartment.
        Replications are the primary resource that governs the policy of cross-region replication between source
        and target file systems. Replications are associated with a secondary resource called a [`ReplicationTarget`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ReplicationTarget)
        located in another availability domain.
        The associated replication target resource is automatically created along with the replication resource.
        The replication retrieves the delta of data between two snapshots of a source file system
        and sends it to the associated `ReplicationTarget`, which retrieves the delta and applies it to the target
        file system.
        Only unexported file systems can be used as target file systems.
        For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/FSreplication.htm).

        For information about access control and compartments, see
        [Overview of the IAM
        Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure Services resources, including
        replications, get an Oracle-assigned, unique ID called an
        Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type, or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_replication = oci.file_storage.Replication("test_replication",
            compartment_id=compartment_id,
            source_id=test_source["id"],
            target_id=test_target["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=replication_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            locks=[{
                "type": replication_locks_type,
                "message": replication_locks_message,
                "related_resource_id": test_resource["id"],
                "time_created": replication_locks_time_created,
            }],
            replication_interval=replication_replication_interval)
        ```

        ## Import

        Replications can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FileStorage/replication:Replication test_replication "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the replication.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. An associated replication target will also created with the same `displayName`. Example: `My replication`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationLockArgs', 'ReplicationLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[builtins.str] replication_interval: (Updatable) Duration in minutes between replication snapshots.
        :param pulumi.Input[builtins.str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        :param pulumi.Input[builtins.str] target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Replication resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new replication in the specified compartment.
        Replications are the primary resource that governs the policy of cross-region replication between source
        and target file systems. Replications are associated with a secondary resource called a [`ReplicationTarget`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ReplicationTarget)
        located in another availability domain.
        The associated replication target resource is automatically created along with the replication resource.
        The replication retrieves the delta of data between two snapshots of a source file system
        and sends it to the associated `ReplicationTarget`, which retrieves the delta and applies it to the target
        file system.
        Only unexported file systems can be used as target file systems.
        For more information, see [Using Replication](https://docs.cloud.oracle.com/iaas/Content/File/Tasks/FSreplication.htm).

        For information about access control and compartments, see
        [Overview of the IAM
        Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure Services resources, including
        replications, get an Oracle-assigned, unique ID called an
        Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type, or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_replication = oci.file_storage.Replication("test_replication",
            compartment_id=compartment_id,
            source_id=test_source["id"],
            target_id=test_target["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=replication_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            locks=[{
                "type": replication_locks_type,
                "message": replication_locks_message,
                "related_resource_id": test_resource["id"],
                "time_created": replication_locks_time_created,
            }],
            replication_interval=replication_replication_interval)
        ```

        ## Import

        Replications can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FileStorage/replication:Replication test_replication "id"
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationLockArgs', 'ReplicationLockArgsDict']]]]] = None,
                 replication_interval: Optional[pulumi.Input[builtins.str]] = None,
                 source_id: Optional[pulumi.Input[builtins.str]] = None,
                 target_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationArgs.__new__(ReplicationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_lock_override"] = is_lock_override
            __props__.__dict__["locks"] = locks
            __props__.__dict__["replication_interval"] = replication_interval
            if source_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_id'")
            __props__.__dict__["source_id"] = source_id
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["delta_progress"] = None
            __props__.__dict__["delta_status"] = None
            __props__.__dict__["last_snapshot_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["recovery_point_time"] = None
            __props__.__dict__["replication_target_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
        super(Replication, __self__).__init__(
            'oci:FileStorage/replication:Replication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            delta_progress: Optional[pulumi.Input[builtins.str]] = None,
            delta_status: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_lock_override: Optional[pulumi.Input[builtins.bool]] = None,
            last_snapshot_id: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ReplicationLockArgs', 'ReplicationLockArgsDict']]]]] = None,
            recovery_point_time: Optional[pulumi.Input[builtins.str]] = None,
            replication_interval: Optional[pulumi.Input[builtins.str]] = None,
            replication_target_id: Optional[pulumi.Input[builtins.str]] = None,
            source_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            target_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None) -> 'Replication':
        """
        Get an existing Replication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] availability_domain: The availability domain the replication is in. The replication must be in the same availability domain as the source file system. Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the replication.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] delta_progress: Percentage progress of the current replication cycle.
        :param pulumi.Input[builtins.str] delta_status: The current state of the snapshot during replication operations.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. An associated replication target will also created with the same `displayName`. Example: `My replication`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] last_snapshot_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last snapshot that has been replicated completely. Empty if the copy of the initial snapshot is not complete.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current 'lifecycleState'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ReplicationLockArgs', 'ReplicationLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[builtins.str] recovery_point_time: The [`snapshotTime`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Snapshot/snapshotTime) of the most recent recoverable replication snapshot in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-04-04T20:01:29.100Z`
        :param pulumi.Input[builtins.str] replication_interval: (Updatable) Duration in minutes between replication snapshots.
        :param pulumi.Input[builtins.str] replication_target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [`ReplicationTarget`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ReplicationTarget).
        :param pulumi.Input[builtins.str] source_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        :param pulumi.Input[builtins.str] state: The current state of this replication. This resource can be in a `FAILED` state if replication target is deleted instead of the replication resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param pulumi.Input[builtins.str] target_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationState.__new__(_ReplicationState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["delta_progress"] = delta_progress
        __props__.__dict__["delta_status"] = delta_status
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_lock_override"] = is_lock_override
        __props__.__dict__["last_snapshot_id"] = last_snapshot_id
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["locks"] = locks
        __props__.__dict__["recovery_point_time"] = recovery_point_time
        __props__.__dict__["replication_interval"] = replication_interval
        __props__.__dict__["replication_target_id"] = replication_target_id
        __props__.__dict__["source_id"] = source_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_created"] = time_created
        return Replication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The availability domain the replication is in. The replication must be in the same availability domain as the source file system. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the replication.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deltaProgress")
    def delta_progress(self) -> pulumi.Output[builtins.str]:
        """
        Percentage progress of the current replication cycle.
        """
        return pulumi.get(self, "delta_progress")

    @property
    @pulumi.getter(name="deltaStatus")
    def delta_status(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the snapshot during replication operations.
        """
        return pulumi.get(self, "delta_status")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information. An associated replication target will also created with the same `displayName`. Example: `My replication`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> pulumi.Output[builtins.bool]:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter(name="lastSnapshotId")
    def last_snapshot_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last snapshot that has been replicated completely. Empty if the copy of the initial snapshot is not complete.
        """
        return pulumi.get(self, "last_snapshot_id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Sequence['outputs.ReplicationLock']]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="recoveryPointTime")
    def recovery_point_time(self) -> pulumi.Output[builtins.str]:
        """
        The [`snapshotTime`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/Snapshot/snapshotTime) of the most recent recoverable replication snapshot in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Example: `2021-04-04T20:01:29.100Z`
        """
        return pulumi.get(self, "recovery_point_time")

    @property
    @pulumi.getter(name="replicationInterval")
    def replication_interval(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Duration in minutes between replication snapshots.
        """
        return pulumi.get(self, "replication_interval")

    @property
    @pulumi.getter(name="replicationTargetId")
    def replication_target_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the [`ReplicationTarget`](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/ReplicationTarget).
        """
        return pulumi.get(self, "replication_target_id")

    @property
    @pulumi.getter(name="sourceId")
    def source_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the source file system.
        """
        return pulumi.get(self, "source_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of this replication. This resource can be in a `FAILED` state if replication target is deleted instead of the replication resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the target file system. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the replication was created in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2021-01-04T20:01:29.100Z`
        """
        return pulumi.get(self, "time_created")

