# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FleetArgs', 'Fleet']

@pulumi.input_type
class FleetArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 fleet_type: pulumi.Input[builtins.str],
                 application_type: Optional[pulumi.Input[builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input['FleetCredentialArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment_type: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 group_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_target_auto_confirm: Optional[pulumi.Input[builtins.bool]] = None,
                 notification_preferences: Optional[pulumi.Input['FleetNotificationPreferencesArgs']] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_selection_type: Optional[pulumi.Input[builtins.str]] = None,
                 rule_selection_criteria: Optional[pulumi.Input['FleetRuleSelectionCriteriaArgs']] = None):
        """
        The set of arguments for constructing a Fleet resource.
        :param pulumi.Input[builtins.str] compartment_id: Tenancy OCID
        :param pulumi.Input[builtins.str] fleet_type: Type of the Fleet. PRODUCT - A fleet of product-specific resources for a product type. ENVIRONMENT - A fleet of environment-specific resources for a product stack. GROUP - A fleet of a fleet of either environment or product fleets. GENERIC - A fleet of resources selected dynamically or manually for reporting purposes
        :param pulumi.Input[builtins.str] application_type: Product stack associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        :param pulumi.Input[Sequence[pulumi.Input['FleetCredentialArgs']]] credentials: Credentials associated with the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[builtins.str] environment_type: Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] group_type: Group Type associated with Group Fleet.
        :param pulumi.Input[builtins.bool] is_target_auto_confirm: (Updatable) A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.
        :param pulumi.Input['FleetNotificationPreferencesArgs'] notification_preferences: (Updatable) Notification information to get notified when the fleet status changes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] products: Products associated with the Fleet.
        :param pulumi.Input[builtins.str] resource_selection_type: Type of resource selection in a Fleet. Select resources manually or select resources based on rules.
        :param pulumi.Input['FleetRuleSelectionCriteriaArgs'] rule_selection_criteria: (Updatable) Rule Selection Criteria for DYNAMIC resource selection for a GENERIC fleet. Rules define what resources are members of this fleet. All resources that meet the criteria are added automatically.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "fleet_type", fleet_type)
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_type is not None:
            pulumi.set(__self__, "environment_type", environment_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if is_target_auto_confirm is not None:
            pulumi.set(__self__, "is_target_auto_confirm", is_target_auto_confirm)
        if notification_preferences is not None:
            pulumi.set(__self__, "notification_preferences", notification_preferences)
        if products is not None:
            pulumi.set(__self__, "products", products)
        if resource_selection_type is not None:
            pulumi.set(__self__, "resource_selection_type", resource_selection_type)
        if rule_selection_criteria is not None:
            pulumi.set(__self__, "rule_selection_criteria", rule_selection_criteria)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> pulumi.Input[builtins.str]:
        """
        Type of the Fleet. PRODUCT - A fleet of product-specific resources for a product type. ENVIRONMENT - A fleet of environment-specific resources for a product stack. GROUP - A fleet of a fleet of either environment or product fleets. GENERIC - A fleet of resources selected dynamically or manually for reporting purposes
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "fleet_type", value)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Product stack associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetCredentialArgs']]]]:
        """
        Credentials associated with the Fleet.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetCredentialArgs']]]]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Group Type associated with Group Fleet.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_type", value)

    @property
    @pulumi.getter(name="isTargetAutoConfirm")
    def is_target_auto_confirm(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.
        """
        return pulumi.get(self, "is_target_auto_confirm")

    @is_target_auto_confirm.setter
    def is_target_auto_confirm(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_target_auto_confirm", value)

    @property
    @pulumi.getter(name="notificationPreferences")
    def notification_preferences(self) -> Optional[pulumi.Input['FleetNotificationPreferencesArgs']]:
        """
        (Updatable) Notification information to get notified when the fleet status changes.
        """
        return pulumi.get(self, "notification_preferences")

    @notification_preferences.setter
    def notification_preferences(self, value: Optional[pulumi.Input['FleetNotificationPreferencesArgs']]):
        pulumi.set(self, "notification_preferences", value)

    @property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Products associated with the Fleet.
        """
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "products", value)

    @property
    @pulumi.getter(name="resourceSelectionType")
    def resource_selection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of resource selection in a Fleet. Select resources manually or select resources based on rules.
        """
        return pulumi.get(self, "resource_selection_type")

    @resource_selection_type.setter
    def resource_selection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_selection_type", value)

    @property
    @pulumi.getter(name="ruleSelectionCriteria")
    def rule_selection_criteria(self) -> Optional[pulumi.Input['FleetRuleSelectionCriteriaArgs']]:
        """
        (Updatable) Rule Selection Criteria for DYNAMIC resource selection for a GENERIC fleet. Rules define what resources are members of this fleet. All resources that meet the criteria are added automatically.
        """
        return pulumi.get(self, "rule_selection_criteria")

    @rule_selection_criteria.setter
    def rule_selection_criteria(self, value: Optional[pulumi.Input['FleetRuleSelectionCriteriaArgs']]):
        pulumi.set(self, "rule_selection_criteria", value)


@pulumi.input_type
class _FleetState:
    def __init__(__self__, *,
                 application_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input['FleetCredentialArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment_type: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 group_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_target_auto_confirm: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 notification_preferences: Optional[pulumi.Input['FleetNotificationPreferencesArgs']] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_region: Optional[pulumi.Input[builtins.str]] = None,
                 resource_selection_type: Optional[pulumi.Input[builtins.str]] = None,
                 rule_selection_criteria: Optional[pulumi.Input['FleetRuleSelectionCriteriaArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Fleet resources.
        :param pulumi.Input[builtins.str] application_type: Product stack associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        :param pulumi.Input[builtins.str] compartment_id: Tenancy OCID
        :param pulumi.Input[Sequence[pulumi.Input['FleetCredentialArgs']]] credentials: Credentials associated with the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[builtins.str] environment_type: Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        :param pulumi.Input[builtins.str] fleet_type: Type of the Fleet. PRODUCT - A fleet of product-specific resources for a product type. ENVIRONMENT - A fleet of environment-specific resources for a product stack. GROUP - A fleet of a fleet of either environment or product fleets. GENERIC - A fleet of resources selected dynamically or manually for reporting purposes
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] group_type: Group Type associated with Group Fleet.
        :param pulumi.Input[builtins.bool] is_target_auto_confirm: (Updatable) A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input['FleetNotificationPreferencesArgs'] notification_preferences: (Updatable) Notification information to get notified when the fleet status changes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] products: Products associated with the Fleet.
        :param pulumi.Input[builtins.str] resource_region: Associated region
        :param pulumi.Input[builtins.str] resource_selection_type: Type of resource selection in a Fleet. Select resources manually or select resources based on rules.
        :param pulumi.Input['FleetRuleSelectionCriteriaArgs'] rule_selection_criteria: (Updatable) Rule Selection Criteria for DYNAMIC resource selection for a GENERIC fleet. Rules define what resources are members of this fleet. All resources that meet the criteria are added automatically.
        :param pulumi.Input[builtins.str] state: The lifecycle state of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        if application_type is not None:
            pulumi.set(__self__, "application_type", application_type)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if environment_type is not None:
            pulumi.set(__self__, "environment_type", environment_type)
        if fleet_type is not None:
            pulumi.set(__self__, "fleet_type", fleet_type)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if group_type is not None:
            pulumi.set(__self__, "group_type", group_type)
        if is_target_auto_confirm is not None:
            pulumi.set(__self__, "is_target_auto_confirm", is_target_auto_confirm)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if notification_preferences is not None:
            pulumi.set(__self__, "notification_preferences", notification_preferences)
        if products is not None:
            pulumi.set(__self__, "products", products)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if resource_selection_type is not None:
            pulumi.set(__self__, "resource_selection_type", resource_selection_type)
        if rule_selection_criteria is not None:
            pulumi.set(__self__, "rule_selection_criteria", rule_selection_criteria)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Product stack associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        """
        return pulumi.get(self, "application_type")

    @application_type.setter
    def application_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "application_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FleetCredentialArgs']]]]:
        """
        Credentials associated with the Fleet.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FleetCredentialArgs']]]]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        """
        return pulumi.get(self, "environment_type")

    @environment_type.setter
    def environment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "environment_type", value)

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of the Fleet. PRODUCT - A fleet of product-specific resources for a product type. ENVIRONMENT - A fleet of environment-specific resources for a product stack. GROUP - A fleet of a fleet of either environment or product fleets. GENERIC - A fleet of resources selected dynamically or manually for reporting purposes
        """
        return pulumi.get(self, "fleet_type")

    @fleet_type.setter
    def fleet_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "fleet_type", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Group Type associated with Group Fleet.
        """
        return pulumi.get(self, "group_type")

    @group_type.setter
    def group_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "group_type", value)

    @property
    @pulumi.getter(name="isTargetAutoConfirm")
    def is_target_auto_confirm(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.
        """
        return pulumi.get(self, "is_target_auto_confirm")

    @is_target_auto_confirm.setter
    def is_target_auto_confirm(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_target_auto_confirm", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="notificationPreferences")
    def notification_preferences(self) -> Optional[pulumi.Input['FleetNotificationPreferencesArgs']]:
        """
        (Updatable) Notification information to get notified when the fleet status changes.
        """
        return pulumi.get(self, "notification_preferences")

    @notification_preferences.setter
    def notification_preferences(self, value: Optional[pulumi.Input['FleetNotificationPreferencesArgs']]):
        pulumi.set(self, "notification_preferences", value)

    @property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        Products associated with the Fleet.
        """
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "products", value)

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_region", value)

    @property
    @pulumi.getter(name="resourceSelectionType")
    def resource_selection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of resource selection in a Fleet. Select resources manually or select resources based on rules.
        """
        return pulumi.get(self, "resource_selection_type")

    @resource_selection_type.setter
    def resource_selection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_selection_type", value)

    @property
    @pulumi.getter(name="ruleSelectionCriteria")
    def rule_selection_criteria(self) -> Optional[pulumi.Input['FleetRuleSelectionCriteriaArgs']]:
        """
        (Updatable) Rule Selection Criteria for DYNAMIC resource selection for a GENERIC fleet. Rules define what resources are members of this fleet. All resources that meet the criteria are added automatically.
        """
        return pulumi.get(self, "rule_selection_criteria")

    @rule_selection_criteria.setter
    def rule_selection_criteria(self, value: Optional[pulumi.Input['FleetRuleSelectionCriteriaArgs']]):
        pulumi.set(self, "rule_selection_criteria", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The lifecycle state of the Fleet.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class Fleet(pulumi.CustomResource):

    pulumi_type = "oci:FleetAppsManagement/fleet:Fleet"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetCredentialArgs', 'FleetCredentialArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment_type: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 group_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_target_auto_confirm: Optional[pulumi.Input[builtins.bool]] = None,
                 notification_preferences: Optional[pulumi.Input[Union['FleetNotificationPreferencesArgs', 'FleetNotificationPreferencesArgsDict']]] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_selection_type: Optional[pulumi.Input[builtins.str]] = None,
                 rule_selection_criteria: Optional[pulumi.Input[Union['FleetRuleSelectionCriteriaArgs', 'FleetRuleSelectionCriteriaArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Fleet resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Create a product, environment, group, or generic type of fleet in Fleet Application Management.

        ## Import

        Fleets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/fleet:Fleet test_fleet "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_type: Product stack associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        :param pulumi.Input[builtins.str] compartment_id: Tenancy OCID
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetCredentialArgs', 'FleetCredentialArgsDict']]]] credentials: Credentials associated with the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[builtins.str] environment_type: Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        :param pulumi.Input[builtins.str] fleet_type: Type of the Fleet. PRODUCT - A fleet of product-specific resources for a product type. ENVIRONMENT - A fleet of environment-specific resources for a product stack. GROUP - A fleet of a fleet of either environment or product fleets. GENERIC - A fleet of resources selected dynamically or manually for reporting purposes
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] group_type: Group Type associated with Group Fleet.
        :param pulumi.Input[builtins.bool] is_target_auto_confirm: (Updatable) A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.
        :param pulumi.Input[Union['FleetNotificationPreferencesArgs', 'FleetNotificationPreferencesArgsDict']] notification_preferences: (Updatable) Notification information to get notified when the fleet status changes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] products: Products associated with the Fleet.
        :param pulumi.Input[builtins.str] resource_selection_type: Type of resource selection in a Fleet. Select resources manually or select resources based on rules.
        :param pulumi.Input[Union['FleetRuleSelectionCriteriaArgs', 'FleetRuleSelectionCriteriaArgsDict']] rule_selection_criteria: (Updatable) Rule Selection Criteria for DYNAMIC resource selection for a GENERIC fleet. Rules define what resources are members of this fleet. All resources that meet the criteria are added automatically.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Fleet resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Create a product, environment, group, or generic type of fleet in Fleet Application Management.

        ## Import

        Fleets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/fleet:Fleet test_fleet "id"
        ```

        :param str resource_name: The name of the resource.
        :param FleetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_type: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetCredentialArgs', 'FleetCredentialArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 environment_type: Optional[pulumi.Input[builtins.str]] = None,
                 fleet_type: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 group_type: Optional[pulumi.Input[builtins.str]] = None,
                 is_target_auto_confirm: Optional[pulumi.Input[builtins.bool]] = None,
                 notification_preferences: Optional[pulumi.Input[Union['FleetNotificationPreferencesArgs', 'FleetNotificationPreferencesArgsDict']]] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_selection_type: Optional[pulumi.Input[builtins.str]] = None,
                 rule_selection_criteria: Optional[pulumi.Input[Union['FleetRuleSelectionCriteriaArgs', 'FleetRuleSelectionCriteriaArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetArgs.__new__(FleetArgs)

            __props__.__dict__["application_type"] = application_type
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["environment_type"] = environment_type
            if fleet_type is None and not opts.urn:
                raise TypeError("Missing required property 'fleet_type'")
            __props__.__dict__["fleet_type"] = fleet_type
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["group_type"] = group_type
            __props__.__dict__["is_target_auto_confirm"] = is_target_auto_confirm
            __props__.__dict__["notification_preferences"] = notification_preferences
            __props__.__dict__["products"] = products
            __props__.__dict__["resource_selection_type"] = resource_selection_type
            __props__.__dict__["rule_selection_criteria"] = rule_selection_criteria
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["resource_region"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(Fleet, __self__).__init__(
            'oci:FleetAppsManagement/fleet:Fleet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_type: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['FleetCredentialArgs', 'FleetCredentialArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            environment_type: Optional[pulumi.Input[builtins.str]] = None,
            fleet_type: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            group_type: Optional[pulumi.Input[builtins.str]] = None,
            is_target_auto_confirm: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            notification_preferences: Optional[pulumi.Input[Union['FleetNotificationPreferencesArgs', 'FleetNotificationPreferencesArgsDict']]] = None,
            products: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            resource_region: Optional[pulumi.Input[builtins.str]] = None,
            resource_selection_type: Optional[pulumi.Input[builtins.str]] = None,
            rule_selection_criteria: Optional[pulumi.Input[Union['FleetRuleSelectionCriteriaArgs', 'FleetRuleSelectionCriteriaArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'Fleet':
        """
        Get an existing Fleet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] application_type: Product stack associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        :param pulumi.Input[builtins.str] compartment_id: Tenancy OCID
        :param pulumi.Input[Sequence[pulumi.Input[Union['FleetCredentialArgs', 'FleetCredentialArgsDict']]]] credentials: Credentials associated with the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[builtins.str] environment_type: Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        :param pulumi.Input[builtins.str] fleet_type: Type of the Fleet. PRODUCT - A fleet of product-specific resources for a product type. ENVIRONMENT - A fleet of environment-specific resources for a product stack. GROUP - A fleet of a fleet of either environment or product fleets. GENERIC - A fleet of resources selected dynamically or manually for reporting purposes
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] group_type: Group Type associated with Group Fleet.
        :param pulumi.Input[builtins.bool] is_target_auto_confirm: (Updatable) A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Union['FleetNotificationPreferencesArgs', 'FleetNotificationPreferencesArgsDict']] notification_preferences: (Updatable) Notification information to get notified when the fleet status changes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] products: Products associated with the Fleet.
        :param pulumi.Input[builtins.str] resource_region: Associated region
        :param pulumi.Input[builtins.str] resource_selection_type: Type of resource selection in a Fleet. Select resources manually or select resources based on rules.
        :param pulumi.Input[Union['FleetRuleSelectionCriteriaArgs', 'FleetRuleSelectionCriteriaArgsDict']] rule_selection_criteria: (Updatable) Rule Selection Criteria for DYNAMIC resource selection for a GENERIC fleet. Rules define what resources are members of this fleet. All resources that meet the criteria are added automatically.
        :param pulumi.Input[builtins.str] state: The lifecycle state of the Fleet.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetState.__new__(_FleetState)

        __props__.__dict__["application_type"] = application_type
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["environment_type"] = environment_type
        __props__.__dict__["fleet_type"] = fleet_type
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["group_type"] = group_type
        __props__.__dict__["is_target_auto_confirm"] = is_target_auto_confirm
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["notification_preferences"] = notification_preferences
        __props__.__dict__["products"] = products
        __props__.__dict__["resource_region"] = resource_region
        __props__.__dict__["resource_selection_type"] = resource_selection_type
        __props__.__dict__["rule_selection_criteria"] = rule_selection_criteria
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return Fleet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationType")
    def application_type(self) -> pulumi.Output[builtins.str]:
        """
        Product stack associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        """
        return pulumi.get(self, "application_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Sequence['outputs.FleetCredential']]:
        """
        Credentials associated with the Fleet.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentType")
    def environment_type(self) -> pulumi.Output[builtins.str]:
        """
        Environment Type associated with the Fleet. Applicable for ENVIRONMENT fleet types.
        """
        return pulumi.get(self, "environment_type")

    @property
    @pulumi.getter(name="fleetType")
    def fleet_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of the Fleet. PRODUCT - A fleet of product-specific resources for a product type. ENVIRONMENT - A fleet of environment-specific resources for a product stack. GROUP - A fleet of a fleet of either environment or product fleets. GENERIC - A fleet of resources selected dynamically or manually for reporting purposes
        """
        return pulumi.get(self, "fleet_type")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="groupType")
    def group_type(self) -> pulumi.Output[builtins.str]:
        """
        Group Type associated with Group Fleet.
        """
        return pulumi.get(self, "group_type")

    @property
    @pulumi.getter(name="isTargetAutoConfirm")
    def is_target_auto_confirm(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A value that represents if auto-confirming of the targets can be enabled. This will allow targets to be auto-confirmed in the fleet without manual intervention.
        """
        return pulumi.get(self, "is_target_auto_confirm")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="notificationPreferences")
    def notification_preferences(self) -> pulumi.Output['outputs.FleetNotificationPreferences']:
        """
        (Updatable) Notification information to get notified when the fleet status changes.
        """
        return pulumi.get(self, "notification_preferences")

    @property
    @pulumi.getter
    def products(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        Products associated with the Fleet.
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> pulumi.Output[builtins.str]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="resourceSelectionType")
    def resource_selection_type(self) -> pulumi.Output[builtins.str]:
        """
        Type of resource selection in a Fleet. Select resources manually or select resources based on rules.
        """
        return pulumi.get(self, "resource_selection_type")

    @property
    @pulumi.getter(name="ruleSelectionCriteria")
    def rule_selection_criteria(self) -> pulumi.Output['outputs.FleetRuleSelectionCriteria']:
        """
        (Updatable) Rule Selection Criteria for DYNAMIC resource selection for a GENERIC fleet. Rules define what resources are members of this fleet. All resources that meet the criteria are added automatically.
        """
        return pulumi.get(self, "rule_selection_criteria")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The lifecycle state of the Fleet.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

