# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInventoryResourcesResult',
    'AwaitableGetInventoryResourcesResult',
    'get_inventory_resources',
    'get_inventory_resources_output',
]

@pulumi.output_type
class GetInventoryResourcesResult:
    """
    A collection of values returned by getInventoryResources.
    """
    def __init__(__self__, compartment_id=None, defined_tag_equals=None, display_name=None, filters=None, freeform_tag_equals=None, id=None, inventory_properties=None, inventory_resource_collections=None, matching_criteria=None, resource_compartment_id=None, resource_region=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tag_equals and not isinstance(defined_tag_equals, list):
            raise TypeError("Expected argument 'defined_tag_equals' to be a list")
        pulumi.set(__self__, "defined_tag_equals", defined_tag_equals)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if freeform_tag_equals and not isinstance(freeform_tag_equals, list):
            raise TypeError("Expected argument 'freeform_tag_equals' to be a list")
        pulumi.set(__self__, "freeform_tag_equals", freeform_tag_equals)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inventory_properties and not isinstance(inventory_properties, list):
            raise TypeError("Expected argument 'inventory_properties' to be a list")
        pulumi.set(__self__, "inventory_properties", inventory_properties)
        if inventory_resource_collections and not isinstance(inventory_resource_collections, list):
            raise TypeError("Expected argument 'inventory_resource_collections' to be a list")
        pulumi.set(__self__, "inventory_resource_collections", inventory_resource_collections)
        if matching_criteria and not isinstance(matching_criteria, str):
            raise TypeError("Expected argument 'matching_criteria' to be a str")
        pulumi.set(__self__, "matching_criteria", matching_criteria)
        if resource_compartment_id and not isinstance(resource_compartment_id, str):
            raise TypeError("Expected argument 'resource_compartment_id' to be a str")
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        if resource_region and not isinstance(resource_region, str):
            raise TypeError("Expected argument 'resource_region' to be a str")
        pulumi.set(__self__, "resource_region", resource_region)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        OCID of the compartment to which the resource belongs to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTagEquals")
    def defined_tag_equals(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "defined_tag_equals")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[builtins.str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInventoryResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="freeformTagEquals")
    def freeform_tag_equals(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "freeform_tag_equals")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inventoryProperties")
    def inventory_properties(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "inventory_properties")

    @property
    @pulumi.getter(name="inventoryResourceCollections")
    def inventory_resource_collections(self) -> Sequence['outputs.GetInventoryResourcesInventoryResourceCollectionResult']:
        """
        The list of inventory_resource_collection.
        """
        return pulumi.get(self, "inventory_resource_collections")

    @property
    @pulumi.getter(name="matchingCriteria")
    def matching_criteria(self) -> Optional[builtins.str]:
        return pulumi.get(self, "matching_criteria")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> builtins.str:
        """
        Compartment Id of the resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[builtins.str]:
        """
        The region the resource belongs to.
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetInventoryResourcesResult(GetInventoryResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInventoryResourcesResult(
            compartment_id=self.compartment_id,
            defined_tag_equals=self.defined_tag_equals,
            display_name=self.display_name,
            filters=self.filters,
            freeform_tag_equals=self.freeform_tag_equals,
            id=self.id,
            inventory_properties=self.inventory_properties,
            inventory_resource_collections=self.inventory_resource_collections,
            matching_criteria=self.matching_criteria,
            resource_compartment_id=self.resource_compartment_id,
            resource_region=self.resource_region,
            state=self.state)


def get_inventory_resources(compartment_id: Optional[builtins.str] = None,
                            defined_tag_equals: Optional[Sequence[builtins.str]] = None,
                            display_name: Optional[builtins.str] = None,
                            filters: Optional[Sequence[Union['GetInventoryResourcesFilterArgs', 'GetInventoryResourcesFilterArgsDict']]] = None,
                            freeform_tag_equals: Optional[Sequence[builtins.str]] = None,
                            inventory_properties: Optional[Sequence[builtins.str]] = None,
                            matching_criteria: Optional[builtins.str] = None,
                            resource_compartment_id: Optional[builtins.str] = None,
                            resource_region: Optional[builtins.str] = None,
                            state: Optional[builtins.str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInventoryResourcesResult:
    """
    This data source provides the list of Inventory Resources in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of InventoryResources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_inventory_resources = oci.FleetAppsManagement.get_inventory_resources(compartment_id=compartment_id,
        resource_compartment_id=test_compartment["id"],
        defined_tag_equals=inventory_resource_defined_tag_equals,
        display_name=inventory_resource_display_name,
        freeform_tag_equals=inventory_resource_freeform_tag_equals,
        inventory_properties=inventory_resource_inventory_properties,
        matching_criteria=inventory_resource_matching_criteria,
        resource_region=inventory_resource_resource_region,
        state=inventory_resource_state)
    ```


    :param builtins.str compartment_id: A filter to return only resources whose base Compartment ID(TenancyId) matches the given base Compartment ID.
    :param Sequence[builtins.str] defined_tag_equals: A list of tag filters to apply.  Only resources with a defined tag matching the value will be returned. Each item in the list has the format "{namespace}.{tagName}={value}".  All inputs are case-insensitive. Multiple values for the same key (i.e. same namespace and tag name) are interpreted as "OR". Values for different keys (i.e. different namespaces, different tag names, or both) are interpreted as "AND". Example: Identification.Development=Yes
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param Sequence[builtins.str] freeform_tag_equals: A list of tag filters to apply.  Only resources with a freeform tag matching the value will be returned. The key for each tag is "{tagName}.{value}".  All inputs are case-insensitive. Multiple values for the same tag name are interpreted as "OR".  Values for different tag names are interpreted as "AND".
    :param Sequence[builtins.str] inventory_properties: A list of inventory properties filters to apply. The key for each inventory property and value for each resource type is "{resourceType}.{inventoryProperty}={value}". Example: Instance.displayName=TEST_INSTANCE
    :param builtins.str matching_criteria: Fetch resources matching ANY or ALL criteria passed as params in "tags" and "inventoryProperties". Example: matchingCriteria=ANY
    :param builtins.str resource_compartment_id: A filter to return only resources whose resource Compartment ID matches the given resource Compartment ID.
    :param builtins.str resource_region: Resource Region
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['definedTagEquals'] = defined_tag_equals
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['freeformTagEquals'] = freeform_tag_equals
    __args__['inventoryProperties'] = inventory_properties
    __args__['matchingCriteria'] = matching_criteria
    __args__['resourceCompartmentId'] = resource_compartment_id
    __args__['resourceRegion'] = resource_region
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getInventoryResources:getInventoryResources', __args__, opts=opts, typ=GetInventoryResourcesResult).value

    return AwaitableGetInventoryResourcesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tag_equals=pulumi.get(__ret__, 'defined_tag_equals'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        freeform_tag_equals=pulumi.get(__ret__, 'freeform_tag_equals'),
        id=pulumi.get(__ret__, 'id'),
        inventory_properties=pulumi.get(__ret__, 'inventory_properties'),
        inventory_resource_collections=pulumi.get(__ret__, 'inventory_resource_collections'),
        matching_criteria=pulumi.get(__ret__, 'matching_criteria'),
        resource_compartment_id=pulumi.get(__ret__, 'resource_compartment_id'),
        resource_region=pulumi.get(__ret__, 'resource_region'),
        state=pulumi.get(__ret__, 'state'))
def get_inventory_resources_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                   defined_tag_equals: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInventoryResourcesFilterArgs', 'GetInventoryResourcesFilterArgsDict']]]]] = None,
                                   freeform_tag_equals: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                   inventory_properties: Optional[pulumi.Input[Optional[Sequence[builtins.str]]]] = None,
                                   matching_criteria: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   resource_compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                   resource_region: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInventoryResourcesResult]:
    """
    This data source provides the list of Inventory Resources in Oracle Cloud Infrastructure Fleet Apps Management service.

    Returns a list of InventoryResources.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_inventory_resources = oci.FleetAppsManagement.get_inventory_resources(compartment_id=compartment_id,
        resource_compartment_id=test_compartment["id"],
        defined_tag_equals=inventory_resource_defined_tag_equals,
        display_name=inventory_resource_display_name,
        freeform_tag_equals=inventory_resource_freeform_tag_equals,
        inventory_properties=inventory_resource_inventory_properties,
        matching_criteria=inventory_resource_matching_criteria,
        resource_region=inventory_resource_resource_region,
        state=inventory_resource_state)
    ```


    :param builtins.str compartment_id: A filter to return only resources whose base Compartment ID(TenancyId) matches the given base Compartment ID.
    :param Sequence[builtins.str] defined_tag_equals: A list of tag filters to apply.  Only resources with a defined tag matching the value will be returned. Each item in the list has the format "{namespace}.{tagName}={value}".  All inputs are case-insensitive. Multiple values for the same key (i.e. same namespace and tag name) are interpreted as "OR". Values for different keys (i.e. different namespaces, different tag names, or both) are interpreted as "AND". Example: Identification.Development=Yes
    :param builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param Sequence[builtins.str] freeform_tag_equals: A list of tag filters to apply.  Only resources with a freeform tag matching the value will be returned. The key for each tag is "{tagName}.{value}".  All inputs are case-insensitive. Multiple values for the same tag name are interpreted as "OR".  Values for different tag names are interpreted as "AND".
    :param Sequence[builtins.str] inventory_properties: A list of inventory properties filters to apply. The key for each inventory property and value for each resource type is "{resourceType}.{inventoryProperty}={value}". Example: Instance.displayName=TEST_INSTANCE
    :param builtins.str matching_criteria: Fetch resources matching ANY or ALL criteria passed as params in "tags" and "inventoryProperties". Example: matchingCriteria=ANY
    :param builtins.str resource_compartment_id: A filter to return only resources whose resource Compartment ID matches the given resource Compartment ID.
    :param builtins.str resource_region: Resource Region
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['definedTagEquals'] = defined_tag_equals
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['freeformTagEquals'] = freeform_tag_equals
    __args__['inventoryProperties'] = inventory_properties
    __args__['matchingCriteria'] = matching_criteria
    __args__['resourceCompartmentId'] = resource_compartment_id
    __args__['resourceRegion'] = resource_region
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getInventoryResources:getInventoryResources', __args__, opts=opts, typ=GetInventoryResourcesResult)
    return __ret__.apply(lambda __response__: GetInventoryResourcesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tag_equals=pulumi.get(__response__, 'defined_tag_equals'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        freeform_tag_equals=pulumi.get(__response__, 'freeform_tag_equals'),
        id=pulumi.get(__response__, 'id'),
        inventory_properties=pulumi.get(__response__, 'inventory_properties'),
        inventory_resource_collections=pulumi.get(__response__, 'inventory_resource_collections'),
        matching_criteria=pulumi.get(__response__, 'matching_criteria'),
        resource_compartment_id=pulumi.get(__response__, 'resource_compartment_id'),
        resource_region=pulumi.get(__response__, 'resource_region'),
        state=pulumi.get(__response__, 'state')))
