# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SchedulerDefinitionArgs', 'SchedulerDefinition']

@pulumi.input_type
class SchedulerDefinitionArgs:
    def __init__(__self__, *,
                 action_groups: pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]],
                 compartment_id: pulumi.Input[builtins.str],
                 schedule: pulumi.Input['SchedulerDefinitionScheduleArgs'],
                 activity_initiation_cut_off: Optional[pulumi.Input[builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 run_books: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]] = None):
        """
        The set of arguments for constructing a SchedulerDefinition resource.
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]] action_groups: (Updatable) Action Groups associated with the Schedule.
        :param pulumi.Input[builtins.str] compartment_id: Tenancy OCID
        :param pulumi.Input['SchedulerDefinitionScheduleArgs'] schedule: (Updatable) Schedule Information.
        :param pulumi.Input[builtins.int] activity_initiation_cut_off: (Updatable) Activity Initiation Cut Off
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]] run_books: (Updatable) Runbooks.
        """
        pulumi.set(__self__, "action_groups", action_groups)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "schedule", schedule)
        if activity_initiation_cut_off is not None:
            pulumi.set(__self__, "activity_initiation_cut_off", activity_initiation_cut_off)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if run_books is not None:
            pulumi.set(__self__, "run_books", run_books)

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]:
        """
        (Updatable) Action Groups associated with the Schedule.
        """
        return pulumi.get(self, "action_groups")

    @action_groups.setter
    def action_groups(self, value: pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]):
        pulumi.set(self, "action_groups", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Input['SchedulerDefinitionScheduleArgs']:
        """
        (Updatable) Schedule Information.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: pulumi.Input['SchedulerDefinitionScheduleArgs']):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter(name="activityInitiationCutOff")
    def activity_initiation_cut_off(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Activity Initiation Cut Off
        """
        return pulumi.get(self, "activity_initiation_cut_off")

    @activity_initiation_cut_off.setter
    def activity_initiation_cut_off(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "activity_initiation_cut_off", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="runBooks")
    def run_books(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]]:
        """
        (Updatable) Runbooks.
        """
        return pulumi.get(self, "run_books")

    @run_books.setter
    def run_books(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]]):
        pulumi.set(self, "run_books", value)


@pulumi.input_type
class _SchedulerDefinitionState:
    def __init__(__self__, *,
                 action_group_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]] = None,
                 activity_initiation_cut_off: Optional[pulumi.Input[builtins.int]] = None,
                 application_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 count_of_affected_action_groups: Optional[pulumi.Input[builtins.int]] = None,
                 count_of_affected_resources: Optional[pulumi.Input[builtins.int]] = None,
                 count_of_affected_targets: Optional[pulumi.Input[builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 products: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_region: Optional[pulumi.Input[builtins.str]] = None,
                 run_books: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]] = None,
                 schedule: Optional[pulumi.Input['SchedulerDefinitionScheduleArgs']] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_of_next_run: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering SchedulerDefinition resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] action_group_types: All ActionGroup Types that are part of the schedule.
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]] action_groups: (Updatable) Action Groups associated with the Schedule.
        :param pulumi.Input[builtins.int] activity_initiation_cut_off: (Updatable) Activity Initiation Cut Off
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_types: All application types that are part of the schedule for ENVIRONMENT ActionGroup Type.
        :param pulumi.Input[builtins.str] compartment_id: Tenancy OCID
        :param pulumi.Input[builtins.int] count_of_affected_action_groups: Count of Action Groups affected by the Schedule.
        :param pulumi.Input[builtins.int] count_of_affected_resources: Count of Resources affected by the Schedule.
        :param pulumi.Input[builtins.int] count_of_affected_targets: Count of Targets affected by the Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lifecycle_operations: All LifeCycle Operations that are part of the schedule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] products: All products that are part of the schedule for PRODUCT ActionGroup Type.
        :param pulumi.Input[builtins.str] resource_region: Associated region
        :param pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]] run_books: (Updatable) Runbooks.
        :param pulumi.Input['SchedulerDefinitionScheduleArgs'] schedule: (Updatable) Schedule Information.
        :param pulumi.Input[builtins.str] state: The current state of the SchedulerDefinition.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_of_next_run: The scheduled date for the next run of the Job.
        :param pulumi.Input[builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        if action_group_types is not None:
            pulumi.set(__self__, "action_group_types", action_group_types)
        if action_groups is not None:
            pulumi.set(__self__, "action_groups", action_groups)
        if activity_initiation_cut_off is not None:
            pulumi.set(__self__, "activity_initiation_cut_off", activity_initiation_cut_off)
        if application_types is not None:
            pulumi.set(__self__, "application_types", application_types)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if count_of_affected_action_groups is not None:
            pulumi.set(__self__, "count_of_affected_action_groups", count_of_affected_action_groups)
        if count_of_affected_resources is not None:
            pulumi.set(__self__, "count_of_affected_resources", count_of_affected_resources)
        if count_of_affected_targets is not None:
            pulumi.set(__self__, "count_of_affected_targets", count_of_affected_targets)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if lifecycle_operations is not None:
            pulumi.set(__self__, "lifecycle_operations", lifecycle_operations)
        if products is not None:
            pulumi.set(__self__, "products", products)
        if resource_region is not None:
            pulumi.set(__self__, "resource_region", resource_region)
        if run_books is not None:
            pulumi.set(__self__, "run_books", run_books)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_of_next_run is not None:
            pulumi.set(__self__, "time_of_next_run", time_of_next_run)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="actionGroupTypes")
    def action_group_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        All ActionGroup Types that are part of the schedule.
        """
        return pulumi.get(self, "action_group_types")

    @action_group_types.setter
    def action_group_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "action_group_types", value)

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]]:
        """
        (Updatable) Action Groups associated with the Schedule.
        """
        return pulumi.get(self, "action_groups")

    @action_groups.setter
    def action_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionActionGroupArgs']]]]):
        pulumi.set(self, "action_groups", value)

    @property
    @pulumi.getter(name="activityInitiationCutOff")
    def activity_initiation_cut_off(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Activity Initiation Cut Off
        """
        return pulumi.get(self, "activity_initiation_cut_off")

    @activity_initiation_cut_off.setter
    def activity_initiation_cut_off(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "activity_initiation_cut_off", value)

    @property
    @pulumi.getter(name="applicationTypes")
    def application_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        All application types that are part of the schedule for ENVIRONMENT ActionGroup Type.
        """
        return pulumi.get(self, "application_types")

    @application_types.setter
    def application_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "application_types", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="countOfAffectedActionGroups")
    def count_of_affected_action_groups(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of Action Groups affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_action_groups")

    @count_of_affected_action_groups.setter
    def count_of_affected_action_groups(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "count_of_affected_action_groups", value)

    @property
    @pulumi.getter(name="countOfAffectedResources")
    def count_of_affected_resources(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of Resources affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_resources")

    @count_of_affected_resources.setter
    def count_of_affected_resources(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "count_of_affected_resources", value)

    @property
    @pulumi.getter(name="countOfAffectedTargets")
    def count_of_affected_targets(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of Targets affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_targets")

    @count_of_affected_targets.setter
    def count_of_affected_targets(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "count_of_affected_targets", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="lifecycleOperations")
    def lifecycle_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        All LifeCycle Operations that are part of the schedule.
        """
        return pulumi.get(self, "lifecycle_operations")

    @lifecycle_operations.setter
    def lifecycle_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "lifecycle_operations", value)

    @property
    @pulumi.getter
    def products(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        All products that are part of the schedule for PRODUCT ActionGroup Type.
        """
        return pulumi.get(self, "products")

    @products.setter
    def products(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "products", value)

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @resource_region.setter
    def resource_region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_region", value)

    @property
    @pulumi.getter(name="runBooks")
    def run_books(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]]:
        """
        (Updatable) Runbooks.
        """
        return pulumi.get(self, "run_books")

    @run_books.setter
    def run_books(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SchedulerDefinitionRunBookArgs']]]]):
        pulumi.set(self, "run_books", value)

    @property
    @pulumi.getter
    def schedule(self) -> Optional[pulumi.Input['SchedulerDefinitionScheduleArgs']]:
        """
        (Updatable) Schedule Information.
        """
        return pulumi.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: Optional[pulumi.Input['SchedulerDefinitionScheduleArgs']]):
        pulumi.set(self, "schedule", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the SchedulerDefinition.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeOfNextRun")
    def time_of_next_run(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The scheduled date for the next run of the Job.
        """
        return pulumi.get(self, "time_of_next_run")

    @time_of_next_run.setter
    def time_of_next_run(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_of_next_run", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class SchedulerDefinition(pulumi.CustomResource):

    pulumi_type = "oci:FleetAppsManagement/schedulerDefinition:SchedulerDefinition"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]]] = None,
                 activity_initiation_cut_off: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 run_books: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Scheduler Definition resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Create a SchedulerDefinition to perform lifecycle operations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduler_definition = oci.fleet_apps_management.SchedulerDefinition("test_scheduler_definition",
            action_groups=[{
                "resource_id": test_resource["id"],
                "runbook_id": test_runbook["id"],
                "application_type": scheduler_definition_action_groups_application_type,
                "lifecycle_operation": scheduler_definition_action_groups_lifecycle_operation,
                "product": scheduler_definition_action_groups_product,
                "subjects": scheduler_definition_action_groups_subjects,
                "target_id": test_target["id"],
                "type": scheduler_definition_action_groups_type,
            }],
            compartment_id=compartment_id,
            schedule={
                "execution_startdate": scheduler_definition_schedule_execution_startdate,
                "type": scheduler_definition_schedule_type,
                "duration": scheduler_definition_schedule_duration,
                "maintenance_window_id": test_maintenance_window["id"],
                "recurrences": scheduler_definition_schedule_recurrences,
            },
            activity_initiation_cut_off=scheduler_definition_activity_initiation_cut_off,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=scheduler_definition_description,
            display_name=scheduler_definition_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            run_books=[{
                "id": scheduler_definition_run_books_id,
                "input_parameters": [{
                    "step_name": scheduler_definition_run_books_input_parameters_step_name,
                    "arguments": [{
                        "name": scheduler_definition_run_books_input_parameters_arguments_name,
                        "value": scheduler_definition_run_books_input_parameters_arguments_value,
                    }],
                }],
            }])
        ```

        ## Import

        SchedulerDefinitions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/schedulerDefinition:SchedulerDefinition test_scheduler_definition "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]] action_groups: (Updatable) Action Groups associated with the Schedule.
        :param pulumi.Input[builtins.int] activity_initiation_cut_off: (Updatable) Activity Initiation Cut Off
        :param pulumi.Input[builtins.str] compartment_id: Tenancy OCID
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]] run_books: (Updatable) Runbooks.
        :param pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']] schedule: (Updatable) Schedule Information.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchedulerDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Scheduler Definition resource in Oracle Cloud Infrastructure Fleet Apps Management service.

        Create a SchedulerDefinition to perform lifecycle operations.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_scheduler_definition = oci.fleet_apps_management.SchedulerDefinition("test_scheduler_definition",
            action_groups=[{
                "resource_id": test_resource["id"],
                "runbook_id": test_runbook["id"],
                "application_type": scheduler_definition_action_groups_application_type,
                "lifecycle_operation": scheduler_definition_action_groups_lifecycle_operation,
                "product": scheduler_definition_action_groups_product,
                "subjects": scheduler_definition_action_groups_subjects,
                "target_id": test_target["id"],
                "type": scheduler_definition_action_groups_type,
            }],
            compartment_id=compartment_id,
            schedule={
                "execution_startdate": scheduler_definition_schedule_execution_startdate,
                "type": scheduler_definition_schedule_type,
                "duration": scheduler_definition_schedule_duration,
                "maintenance_window_id": test_maintenance_window["id"],
                "recurrences": scheduler_definition_schedule_recurrences,
            },
            activity_initiation_cut_off=scheduler_definition_activity_initiation_cut_off,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=scheduler_definition_description,
            display_name=scheduler_definition_display_name,
            freeform_tags={
                "bar-key": "value",
            },
            run_books=[{
                "id": scheduler_definition_run_books_id,
                "input_parameters": [{
                    "step_name": scheduler_definition_run_books_input_parameters_step_name,
                    "arguments": [{
                        "name": scheduler_definition_run_books_input_parameters_arguments_name,
                        "value": scheduler_definition_run_books_input_parameters_arguments_value,
                    }],
                }],
            }])
        ```

        ## Import

        SchedulerDefinitions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FleetAppsManagement/schedulerDefinition:SchedulerDefinition test_scheduler_definition "id"
        ```

        :param str resource_name: The name of the resource.
        :param SchedulerDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchedulerDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]]] = None,
                 activity_initiation_cut_off: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 run_books: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]]] = None,
                 schedule: Optional[pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchedulerDefinitionArgs.__new__(SchedulerDefinitionArgs)

            if action_groups is None and not opts.urn:
                raise TypeError("Missing required property 'action_groups'")
            __props__.__dict__["action_groups"] = action_groups
            __props__.__dict__["activity_initiation_cut_off"] = activity_initiation_cut_off
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["run_books"] = run_books
            if schedule is None and not opts.urn:
                raise TypeError("Missing required property 'schedule'")
            __props__.__dict__["schedule"] = schedule
            __props__.__dict__["action_group_types"] = None
            __props__.__dict__["application_types"] = None
            __props__.__dict__["count_of_affected_action_groups"] = None
            __props__.__dict__["count_of_affected_resources"] = None
            __props__.__dict__["count_of_affected_targets"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["lifecycle_operations"] = None
            __props__.__dict__["products"] = None
            __props__.__dict__["resource_region"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_of_next_run"] = None
            __props__.__dict__["time_updated"] = None
        super(SchedulerDefinition, __self__).__init__(
            'oci:FleetAppsManagement/schedulerDefinition:SchedulerDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action_group_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            action_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]]] = None,
            activity_initiation_cut_off: Optional[pulumi.Input[builtins.int]] = None,
            application_types: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            count_of_affected_action_groups: Optional[pulumi.Input[builtins.int]] = None,
            count_of_affected_resources: Optional[pulumi.Input[builtins.int]] = None,
            count_of_affected_targets: Optional[pulumi.Input[builtins.int]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            products: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            resource_region: Optional[pulumi.Input[builtins.str]] = None,
            run_books: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]]] = None,
            schedule: Optional[pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_of_next_run: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'SchedulerDefinition':
        """
        Get an existing SchedulerDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] action_group_types: All ActionGroup Types that are part of the schedule.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionActionGroupArgs', 'SchedulerDefinitionActionGroupArgsDict']]]] action_groups: (Updatable) Action Groups associated with the Schedule.
        :param pulumi.Input[builtins.int] activity_initiation_cut_off: (Updatable) Activity Initiation Cut Off
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] application_types: All application types that are part of the schedule for ENVIRONMENT ActionGroup Type.
        :param pulumi.Input[builtins.str] compartment_id: Tenancy OCID
        :param pulumi.Input[builtins.int] count_of_affected_action_groups: Count of Action Groups affected by the Schedule.
        :param pulumi.Input[builtins.int] count_of_affected_resources: Count of Resources affected by the Schedule.
        :param pulumi.Input[builtins.int] count_of_affected_targets: Count of Targets affected by the Schedule.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] lifecycle_operations: All LifeCycle Operations that are part of the schedule.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] products: All products that are part of the schedule for PRODUCT ActionGroup Type.
        :param pulumi.Input[builtins.str] resource_region: Associated region
        :param pulumi.Input[Sequence[pulumi.Input[Union['SchedulerDefinitionRunBookArgs', 'SchedulerDefinitionRunBookArgsDict']]]] run_books: (Updatable) Runbooks.
        :param pulumi.Input[Union['SchedulerDefinitionScheduleArgs', 'SchedulerDefinitionScheduleArgsDict']] schedule: (Updatable) Schedule Information.
        :param pulumi.Input[builtins.str] state: The current state of the SchedulerDefinition.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time this resource was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[builtins.str] time_of_next_run: The scheduled date for the next run of the Job.
        :param pulumi.Input[builtins.str] time_updated: The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchedulerDefinitionState.__new__(_SchedulerDefinitionState)

        __props__.__dict__["action_group_types"] = action_group_types
        __props__.__dict__["action_groups"] = action_groups
        __props__.__dict__["activity_initiation_cut_off"] = activity_initiation_cut_off
        __props__.__dict__["application_types"] = application_types
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["count_of_affected_action_groups"] = count_of_affected_action_groups
        __props__.__dict__["count_of_affected_resources"] = count_of_affected_resources
        __props__.__dict__["count_of_affected_targets"] = count_of_affected_targets
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["lifecycle_operations"] = lifecycle_operations
        __props__.__dict__["products"] = products
        __props__.__dict__["resource_region"] = resource_region
        __props__.__dict__["run_books"] = run_books
        __props__.__dict__["schedule"] = schedule
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_of_next_run"] = time_of_next_run
        __props__.__dict__["time_updated"] = time_updated
        return SchedulerDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actionGroupTypes")
    def action_group_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        All ActionGroup Types that are part of the schedule.
        """
        return pulumi.get(self, "action_group_types")

    @property
    @pulumi.getter(name="actionGroups")
    def action_groups(self) -> pulumi.Output[Sequence['outputs.SchedulerDefinitionActionGroup']]:
        """
        (Updatable) Action Groups associated with the Schedule.
        """
        return pulumi.get(self, "action_groups")

    @property
    @pulumi.getter(name="activityInitiationCutOff")
    def activity_initiation_cut_off(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Activity Initiation Cut Off
        """
        return pulumi.get(self, "activity_initiation_cut_off")

    @property
    @pulumi.getter(name="applicationTypes")
    def application_types(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        All application types that are part of the schedule for ENVIRONMENT ActionGroup Type.
        """
        return pulumi.get(self, "application_types")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="countOfAffectedActionGroups")
    def count_of_affected_action_groups(self) -> pulumi.Output[builtins.int]:
        """
        Count of Action Groups affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_action_groups")

    @property
    @pulumi.getter(name="countOfAffectedResources")
    def count_of_affected_resources(self) -> pulumi.Output[builtins.int]:
        """
        Count of Resources affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_resources")

    @property
    @pulumi.getter(name="countOfAffectedTargets")
    def count_of_affected_targets(self) -> pulumi.Output[builtins.int]:
        """
        Count of Targets affected by the Schedule.
        """
        return pulumi.get(self, "count_of_affected_targets")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly description. To provide some insight about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="lifecycleOperations")
    def lifecycle_operations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        All LifeCycle Operations that are part of the schedule.
        """
        return pulumi.get(self, "lifecycle_operations")

    @property
    @pulumi.getter
    def products(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        All products that are part of the schedule for PRODUCT ActionGroup Type.
        """
        return pulumi.get(self, "products")

    @property
    @pulumi.getter(name="resourceRegion")
    def resource_region(self) -> pulumi.Output[builtins.str]:
        """
        Associated region
        """
        return pulumi.get(self, "resource_region")

    @property
    @pulumi.getter(name="runBooks")
    def run_books(self) -> pulumi.Output[Sequence['outputs.SchedulerDefinitionRunBook']]:
        """
        (Updatable) Runbooks.
        """
        return pulumi.get(self, "run_books")

    @property
    @pulumi.getter
    def schedule(self) -> pulumi.Output['outputs.SchedulerDefinitionSchedule']:
        """
        (Updatable) Schedule Information.
        """
        return pulumi.get(self, "schedule")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the SchedulerDefinition.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeOfNextRun")
    def time_of_next_run(self) -> pulumi.Output[builtins.str]:
        """
        The scheduled date for the next run of the Job.
        """
        return pulumi.get(self, "time_of_next_run")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

