# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ShardedDatabaseArgs', 'ShardedDatabase']

@pulumi.input_type
class ShardedDatabaseArgs:
    def __init__(__self__, *,
                 catalog_details: pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseCatalogDetailArgs']]],
                 character_set: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 db_deployment_type: pulumi.Input[builtins.str],
                 db_version: pulumi.Input[builtins.str],
                 db_workload: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 listener_port: pulumi.Input[builtins.int],
                 listener_port_tls: pulumi.Input[builtins.int],
                 ncharacter_set: pulumi.Input[builtins.str],
                 ons_port_local: pulumi.Input[builtins.int],
                 ons_port_remote: pulumi.Input[builtins.int],
                 prefix: pulumi.Input[builtins.str],
                 shard_details: pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseShardDetailArgs']]],
                 sharding_method: pulumi.Input[builtins.str],
                 ca_signed_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 chunks: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_certificate_common_name: Optional[pulumi.Input[builtins.str]] = None,
                 configure_gsms_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 configure_gsms_trigger_is_latest_gsm_image: Optional[pulumi.Input[builtins.bool]] = None,
                 configure_gsms_trigger_old_gsm_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 configure_sharding_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 download_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 generate_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 generate_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
                 generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 get_connection_string_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabasePatchOperationArgs']]]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 replication_method: Optional[pulumi.Input[builtins.str]] = None,
                 replication_unit: Optional[pulumi.Input[builtins.int]] = None,
                 start_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 stop_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 upload_signed_certificate_and_generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 validate_network_trigger: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ShardedDatabase resource.
        :param pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseCatalogDetailArgs']]] catalog_details: Collection of ATP-Dedicated catalogs that needs to be created.
        :param pulumi.Input[builtins.str] character_set: The character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Identifier of the compartment where sharded database is to be created.
        :param pulumi.Input[builtins.str] db_deployment_type: The database deployment type.
        :param pulumi.Input[builtins.str] db_version: Oracle Database version of the Autonomous Container Database.
        :param pulumi.Input[builtins.str] db_workload: Possible workload types.
        :param pulumi.Input[builtins.str] display_name: (Updatable) Oracle sharded database display name.
        :param pulumi.Input[builtins.int] listener_port: The listener port number for sharded database.
        :param pulumi.Input[builtins.int] listener_port_tls: The TLS listener port number for sharded database.
        :param pulumi.Input[builtins.str] ncharacter_set: The national character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed national character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        :param pulumi.Input[builtins.int] ons_port_local: Ons port local for sharded database.
        :param pulumi.Input[builtins.int] ons_port_remote: Ons remote port for sharded database.
        :param pulumi.Input[builtins.str] prefix: Unique name prefix for the sharded databases. Only alpha-numeric values are allowed. First character has to be a letter followed by any combination of letter and number.
        :param pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseShardDetailArgs']]] shard_details: Collection of ATP-Dedicated shards that needs to be created.
        :param pulumi.Input[builtins.str] sharding_method: Sharding Method.
        :param pulumi.Input[builtins.int] chunks: The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        :param pulumi.Input[builtins.str] cluster_certificate_common_name: The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        :param pulumi.Input[builtins.int] configure_gsms_trigger: (Updatable) An optional property when incremented triggers Configure Gsms. Could be set to any integer value.
        :param pulumi.Input[builtins.int] configure_sharding_trigger: (Updatable) An optional property when incremented triggers Configure Sharding. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.int] download_gsm_certificate_signing_request_trigger: (Updatable) An optional property when incremented triggers Download Gsm Certificate Signing Request. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.int] generate_gsm_certificate_signing_request_trigger: (Updatable) An optional property when incremented triggers Generate Gsm Certificate Signing Request. Could be set to any integer value.
        :param pulumi.Input[builtins.int] generate_wallet_trigger: (Updatable) An optional property when incremented triggers Generate Wallet. Could be set to any integer value.
        :param pulumi.Input[builtins.int] get_connection_string_trigger: (Updatable) An optional property when incremented triggers Get Connection String. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input['ShardedDatabasePatchOperationArgs']]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.int] replication_factor: The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        :param pulumi.Input[builtins.str] replication_method: The Replication method for sharded database.
        :param pulumi.Input[builtins.int] replication_unit: For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        :param pulumi.Input[builtins.int] start_database_trigger: (Updatable) An optional property when incremented triggers Start Database. Could be set to any integer value.
        :param pulumi.Input[builtins.int] stop_database_trigger: (Updatable) An optional property when incremented triggers Stop Database. Could be set to any integer value.
        :param pulumi.Input[builtins.int] upload_signed_certificate_and_generate_wallet_trigger: (Updatable) An optional property when incremented triggers Upload Signed Certificate And Generate Wallet. Could be set to any integer value.
        :param pulumi.Input[builtins.int] validate_network_trigger: (Updatable) An optional property when incremented triggers Validate Network. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "catalog_details", catalog_details)
        pulumi.set(__self__, "character_set", character_set)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "db_deployment_type", db_deployment_type)
        pulumi.set(__self__, "db_version", db_version)
        pulumi.set(__self__, "db_workload", db_workload)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "listener_port", listener_port)
        pulumi.set(__self__, "listener_port_tls", listener_port_tls)
        pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        pulumi.set(__self__, "ons_port_local", ons_port_local)
        pulumi.set(__self__, "ons_port_remote", ons_port_remote)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "shard_details", shard_details)
        pulumi.set(__self__, "sharding_method", sharding_method)
        if ca_signed_certificate is not None:
            pulumi.set(__self__, "ca_signed_certificate", ca_signed_certificate)
        if chunks is not None:
            pulumi.set(__self__, "chunks", chunks)
        if cluster_certificate_common_name is not None:
            pulumi.set(__self__, "cluster_certificate_common_name", cluster_certificate_common_name)
        if configure_gsms_trigger is not None:
            pulumi.set(__self__, "configure_gsms_trigger", configure_gsms_trigger)
        if configure_gsms_trigger_is_latest_gsm_image is not None:
            pulumi.set(__self__, "configure_gsms_trigger_is_latest_gsm_image", configure_gsms_trigger_is_latest_gsm_image)
        if configure_gsms_trigger_old_gsm_names is not None:
            pulumi.set(__self__, "configure_gsms_trigger_old_gsm_names", configure_gsms_trigger_old_gsm_names)
        if configure_sharding_trigger is not None:
            pulumi.set(__self__, "configure_sharding_trigger", configure_sharding_trigger)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if download_gsm_certificate_signing_request_trigger is not None:
            pulumi.set(__self__, "download_gsm_certificate_signing_request_trigger", download_gsm_certificate_signing_request_trigger)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_gsm_certificate_signing_request_trigger is not None:
            pulumi.set(__self__, "generate_gsm_certificate_signing_request_trigger", generate_gsm_certificate_signing_request_trigger)
        if generate_wallet_password is not None:
            pulumi.set(__self__, "generate_wallet_password", generate_wallet_password)
        if generate_wallet_trigger is not None:
            pulumi.set(__self__, "generate_wallet_trigger", generate_wallet_trigger)
        if get_connection_string_trigger is not None:
            pulumi.set(__self__, "get_connection_string_trigger", get_connection_string_trigger)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if replication_method is not None:
            pulumi.set(__self__, "replication_method", replication_method)
        if replication_unit is not None:
            pulumi.set(__self__, "replication_unit", replication_unit)
        if start_database_trigger is not None:
            pulumi.set(__self__, "start_database_trigger", start_database_trigger)
        if stop_database_trigger is not None:
            pulumi.set(__self__, "stop_database_trigger", stop_database_trigger)
        if upload_signed_certificate_and_generate_wallet_trigger is not None:
            pulumi.set(__self__, "upload_signed_certificate_and_generate_wallet_trigger", upload_signed_certificate_and_generate_wallet_trigger)
        if validate_network_trigger is not None:
            pulumi.set(__self__, "validate_network_trigger", validate_network_trigger)

    @property
    @pulumi.getter(name="catalogDetails")
    def catalog_details(self) -> pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseCatalogDetailArgs']]]:
        """
        Collection of ATP-Dedicated catalogs that needs to be created.
        """
        return pulumi.get(self, "catalog_details")

    @catalog_details.setter
    def catalog_details(self, value: pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseCatalogDetailArgs']]]):
        pulumi.set(self, "catalog_details", value)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Input[builtins.str]:
        """
        The character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Identifier of the compartment where sharded database is to be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="dbDeploymentType")
    def db_deployment_type(self) -> pulumi.Input[builtins.str]:
        """
        The database deployment type.
        """
        return pulumi.get(self, "db_deployment_type")

    @db_deployment_type.setter
    def db_deployment_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_deployment_type", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Input[builtins.str]:
        """
        Oracle Database version of the Autonomous Container Database.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> pulumi.Input[builtins.str]:
        """
        Possible workload types.
        """
        return pulumi.get(self, "db_workload")

    @db_workload.setter
    def db_workload(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_workload", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Oracle sharded database display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Input[builtins.int]:
        """
        The listener port number for sharded database.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="listenerPortTls")
    def listener_port_tls(self) -> pulumi.Input[builtins.int]:
        """
        The TLS listener port number for sharded database.
        """
        return pulumi.get(self, "listener_port_tls")

    @listener_port_tls.setter
    def listener_port_tls(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "listener_port_tls", value)

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> pulumi.Input[builtins.str]:
        """
        The national character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed national character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        """
        return pulumi.get(self, "ncharacter_set")

    @ncharacter_set.setter
    def ncharacter_set(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "ncharacter_set", value)

    @property
    @pulumi.getter(name="onsPortLocal")
    def ons_port_local(self) -> pulumi.Input[builtins.int]:
        """
        Ons port local for sharded database.
        """
        return pulumi.get(self, "ons_port_local")

    @ons_port_local.setter
    def ons_port_local(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "ons_port_local", value)

    @property
    @pulumi.getter(name="onsPortRemote")
    def ons_port_remote(self) -> pulumi.Input[builtins.int]:
        """
        Ons remote port for sharded database.
        """
        return pulumi.get(self, "ons_port_remote")

    @ons_port_remote.setter
    def ons_port_remote(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "ons_port_remote", value)

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Input[builtins.str]:
        """
        Unique name prefix for the sharded databases. Only alpha-numeric values are allowed. First character has to be a letter followed by any combination of letter and number.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="shardDetails")
    def shard_details(self) -> pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseShardDetailArgs']]]:
        """
        Collection of ATP-Dedicated shards that needs to be created.
        """
        return pulumi.get(self, "shard_details")

    @shard_details.setter
    def shard_details(self, value: pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseShardDetailArgs']]]):
        pulumi.set(self, "shard_details", value)

    @property
    @pulumi.getter(name="shardingMethod")
    def sharding_method(self) -> pulumi.Input[builtins.str]:
        """
        Sharding Method.
        """
        return pulumi.get(self, "sharding_method")

    @sharding_method.setter
    def sharding_method(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sharding_method", value)

    @property
    @pulumi.getter(name="caSignedCertificate")
    def ca_signed_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ca_signed_certificate")

    @ca_signed_certificate.setter
    def ca_signed_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_signed_certificate", value)

    @property
    @pulumi.getter
    def chunks(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        """
        return pulumi.get(self, "chunks")

    @chunks.setter
    def chunks(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "chunks", value)

    @property
    @pulumi.getter(name="clusterCertificateCommonName")
    def cluster_certificate_common_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        """
        return pulumi.get(self, "cluster_certificate_common_name")

    @cluster_certificate_common_name.setter
    def cluster_certificate_common_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_certificate_common_name", value)

    @property
    @pulumi.getter(name="configureGsmsTrigger")
    def configure_gsms_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Gsms. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_gsms_trigger")

    @configure_gsms_trigger.setter
    def configure_gsms_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "configure_gsms_trigger", value)

    @property
    @pulumi.getter(name="configureGsmsTriggerIsLatestGsmImage")
    def configure_gsms_trigger_is_latest_gsm_image(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "configure_gsms_trigger_is_latest_gsm_image")

    @configure_gsms_trigger_is_latest_gsm_image.setter
    def configure_gsms_trigger_is_latest_gsm_image(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "configure_gsms_trigger_is_latest_gsm_image", value)

    @property
    @pulumi.getter(name="configureGsmsTriggerOldGsmNames")
    def configure_gsms_trigger_old_gsm_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "configure_gsms_trigger_old_gsm_names")

    @configure_gsms_trigger_old_gsm_names.setter
    def configure_gsms_trigger_old_gsm_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "configure_gsms_trigger_old_gsm_names", value)

    @property
    @pulumi.getter(name="configureShardingTrigger")
    def configure_sharding_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Sharding. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_sharding_trigger")

    @configure_sharding_trigger.setter
    def configure_sharding_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "configure_sharding_trigger", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="downloadGsmCertificateSigningRequestTrigger")
    def download_gsm_certificate_signing_request_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Download Gsm Certificate Signing Request. Could be set to any integer value.
        """
        return pulumi.get(self, "download_gsm_certificate_signing_request_trigger")

    @download_gsm_certificate_signing_request_trigger.setter
    def download_gsm_certificate_signing_request_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "download_gsm_certificate_signing_request_trigger", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="generateGsmCertificateSigningRequestTrigger")
    def generate_gsm_certificate_signing_request_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Gsm Certificate Signing Request. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_gsm_certificate_signing_request_trigger")

    @generate_gsm_certificate_signing_request_trigger.setter
    def generate_gsm_certificate_signing_request_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "generate_gsm_certificate_signing_request_trigger", value)

    @property
    @pulumi.getter(name="generateWalletPassword")
    def generate_wallet_password(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "generate_wallet_password")

    @generate_wallet_password.setter
    def generate_wallet_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generate_wallet_password", value)

    @property
    @pulumi.getter(name="generateWalletTrigger")
    def generate_wallet_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Wallet. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_wallet_trigger")

    @generate_wallet_trigger.setter
    def generate_wallet_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "generate_wallet_trigger", value)

    @property
    @pulumi.getter(name="getConnectionStringTrigger")
    def get_connection_string_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Get Connection String. Could be set to any integer value.
        """
        return pulumi.get(self, "get_connection_string_trigger")

    @get_connection_string_trigger.setter
    def get_connection_string_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "get_connection_string_trigger", value)

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabasePatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabasePatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter(name="replicationMethod")
    def replication_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Replication method for sharded database.
        """
        return pulumi.get(self, "replication_method")

    @replication_method.setter
    def replication_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_method", value)

    @property
    @pulumi.getter(name="replicationUnit")
    def replication_unit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        """
        return pulumi.get(self, "replication_unit")

    @replication_unit.setter
    def replication_unit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replication_unit", value)

    @property
    @pulumi.getter(name="startDatabaseTrigger")
    def start_database_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Database. Could be set to any integer value.
        """
        return pulumi.get(self, "start_database_trigger")

    @start_database_trigger.setter
    def start_database_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start_database_trigger", value)

    @property
    @pulumi.getter(name="stopDatabaseTrigger")
    def stop_database_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Database. Could be set to any integer value.
        """
        return pulumi.get(self, "stop_database_trigger")

    @stop_database_trigger.setter
    def stop_database_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "stop_database_trigger", value)

    @property
    @pulumi.getter(name="uploadSignedCertificateAndGenerateWalletTrigger")
    def upload_signed_certificate_and_generate_wallet_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Upload Signed Certificate And Generate Wallet. Could be set to any integer value.
        """
        return pulumi.get(self, "upload_signed_certificate_and_generate_wallet_trigger")

    @upload_signed_certificate_and_generate_wallet_trigger.setter
    def upload_signed_certificate_and_generate_wallet_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "upload_signed_certificate_and_generate_wallet_trigger", value)

    @property
    @pulumi.getter(name="validateNetworkTrigger")
    def validate_network_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Validate Network. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "validate_network_trigger")

    @validate_network_trigger.setter
    def validate_network_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "validate_network_trigger", value)


@pulumi.input_type
class _ShardedDatabaseState:
    def __init__(__self__, *,
                 ca_signed_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 catalog_details: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseCatalogDetailArgs']]]] = None,
                 character_set: Optional[pulumi.Input[builtins.str]] = None,
                 chunks: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_certificate_common_name: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configure_gsms_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 configure_gsms_trigger_is_latest_gsm_image: Optional[pulumi.Input[builtins.bool]] = None,
                 configure_gsms_trigger_old_gsm_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 configure_sharding_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseConnectionStringArgs']]]] = None,
                 db_deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 db_workload: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 download_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 generate_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 generate_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
                 generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 get_connection_string_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 gsms: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseGsmArgs']]]] = None,
                 lifecycle_state: Optional[pulumi.Input[builtins.str]] = None,
                 lifecycle_state_details: Optional[pulumi.Input[builtins.str]] = None,
                 listener_port: Optional[pulumi.Input[builtins.int]] = None,
                 listener_port_tls: Optional[pulumi.Input[builtins.int]] = None,
                 ncharacter_set: Optional[pulumi.Input[builtins.str]] = None,
                 ons_port_local: Optional[pulumi.Input[builtins.int]] = None,
                 ons_port_remote: Optional[pulumi.Input[builtins.int]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabasePatchOperationArgs']]]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 private_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 replication_method: Optional[pulumi.Input[builtins.str]] = None,
                 replication_unit: Optional[pulumi.Input[builtins.int]] = None,
                 shard_details: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseShardDetailArgs']]]] = None,
                 sharded_database_id: Optional[pulumi.Input[builtins.str]] = None,
                 sharding_method: Optional[pulumi.Input[builtins.str]] = None,
                 start_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 stop_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 time_zone: Optional[pulumi.Input[builtins.str]] = None,
                 upload_signed_certificate_and_generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 validate_network_trigger: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering ShardedDatabase resources.
        :param pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseCatalogDetailArgs']]] catalog_details: Collection of ATP-Dedicated catalogs that needs to be created.
        :param pulumi.Input[builtins.str] character_set: The character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        :param pulumi.Input[builtins.int] chunks: The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        :param pulumi.Input[builtins.str] cluster_certificate_common_name: The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Identifier of the compartment where sharded database is to be created.
        :param pulumi.Input[builtins.int] configure_gsms_trigger: (Updatable) An optional property when incremented triggers Configure Gsms. Could be set to any integer value.
        :param pulumi.Input[builtins.int] configure_sharding_trigger: (Updatable) An optional property when incremented triggers Configure Sharding. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseConnectionStringArgs']]] connection_strings: Details of sharded database connection String.
        :param pulumi.Input[builtins.str] db_deployment_type: The database deployment type.
        :param pulumi.Input[builtins.str] db_version: Oracle Database version of the Autonomous Container Database.
        :param pulumi.Input[builtins.str] db_workload: Possible workload types.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Oracle sharded database display name.
        :param pulumi.Input[builtins.int] download_gsm_certificate_signing_request_trigger: (Updatable) An optional property when incremented triggers Download Gsm Certificate Signing Request. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.int] generate_gsm_certificate_signing_request_trigger: (Updatable) An optional property when incremented triggers Generate Gsm Certificate Signing Request. Could be set to any integer value.
        :param pulumi.Input[builtins.int] generate_wallet_trigger: (Updatable) An optional property when incremented triggers Generate Wallet. Could be set to any integer value.
        :param pulumi.Input[builtins.int] get_connection_string_trigger: (Updatable) An optional property when incremented triggers Get Connection String. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseGsmArgs']]] gsms: Details of GSM instances for the sharded database.
        :param pulumi.Input[builtins.str] lifecycle_state_details: Detailed message for the lifecycle state.
        :param pulumi.Input[builtins.int] listener_port: The listener port number for sharded database.
        :param pulumi.Input[builtins.int] listener_port_tls: The TLS listener port number for sharded database.
        :param pulumi.Input[builtins.str] ncharacter_set: The national character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed national character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        :param pulumi.Input[builtins.int] ons_port_local: Ons port local for sharded database.
        :param pulumi.Input[builtins.int] ons_port_remote: Ons remote port for sharded database.
        :param pulumi.Input[Sequence[pulumi.Input['ShardedDatabasePatchOperationArgs']]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.str] prefix: Unique name prefix for the sharded databases. Only alpha-numeric values are allowed. First character has to be a letter followed by any combination of letter and number.
        :param pulumi.Input[builtins.str] private_endpoint: The OCID of private endpoint being used by the sharded database.
        :param pulumi.Input[builtins.int] replication_factor: The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        :param pulumi.Input[builtins.str] replication_method: The Replication method for sharded database.
        :param pulumi.Input[builtins.int] replication_unit: For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        :param pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseShardDetailArgs']]] shard_details: Collection of ATP-Dedicated shards that needs to be created.
        :param pulumi.Input[builtins.str] sharding_method: Sharding Method.
        :param pulumi.Input[builtins.int] start_database_trigger: (Updatable) An optional property when incremented triggers Start Database. Could be set to any integer value.
        :param pulumi.Input[builtins.str] state: Lifecycle states for sharded databases.
        :param pulumi.Input[builtins.int] stop_database_trigger: (Updatable) An optional property when incremented triggers Stop Database. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_zone: Timezone associated with the sharded database.
        :param pulumi.Input[builtins.int] upload_signed_certificate_and_generate_wallet_trigger: (Updatable) An optional property when incremented triggers Upload Signed Certificate And Generate Wallet. Could be set to any integer value.
        :param pulumi.Input[builtins.int] validate_network_trigger: (Updatable) An optional property when incremented triggers Validate Network. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if ca_signed_certificate is not None:
            pulumi.set(__self__, "ca_signed_certificate", ca_signed_certificate)
        if catalog_details is not None:
            pulumi.set(__self__, "catalog_details", catalog_details)
        if character_set is not None:
            pulumi.set(__self__, "character_set", character_set)
        if chunks is not None:
            pulumi.set(__self__, "chunks", chunks)
        if cluster_certificate_common_name is not None:
            pulumi.set(__self__, "cluster_certificate_common_name", cluster_certificate_common_name)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if configure_gsms_trigger is not None:
            pulumi.set(__self__, "configure_gsms_trigger", configure_gsms_trigger)
        if configure_gsms_trigger_is_latest_gsm_image is not None:
            pulumi.set(__self__, "configure_gsms_trigger_is_latest_gsm_image", configure_gsms_trigger_is_latest_gsm_image)
        if configure_gsms_trigger_old_gsm_names is not None:
            pulumi.set(__self__, "configure_gsms_trigger_old_gsm_names", configure_gsms_trigger_old_gsm_names)
        if configure_sharding_trigger is not None:
            pulumi.set(__self__, "configure_sharding_trigger", configure_sharding_trigger)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if db_deployment_type is not None:
            pulumi.set(__self__, "db_deployment_type", db_deployment_type)
        if db_version is not None:
            pulumi.set(__self__, "db_version", db_version)
        if db_workload is not None:
            pulumi.set(__self__, "db_workload", db_workload)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if download_gsm_certificate_signing_request_trigger is not None:
            pulumi.set(__self__, "download_gsm_certificate_signing_request_trigger", download_gsm_certificate_signing_request_trigger)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if generate_gsm_certificate_signing_request_trigger is not None:
            pulumi.set(__self__, "generate_gsm_certificate_signing_request_trigger", generate_gsm_certificate_signing_request_trigger)
        if generate_wallet_password is not None:
            pulumi.set(__self__, "generate_wallet_password", generate_wallet_password)
        if generate_wallet_trigger is not None:
            pulumi.set(__self__, "generate_wallet_trigger", generate_wallet_trigger)
        if get_connection_string_trigger is not None:
            pulumi.set(__self__, "get_connection_string_trigger", get_connection_string_trigger)
        if gsms is not None:
            pulumi.set(__self__, "gsms", gsms)
        if lifecycle_state is not None:
            pulumi.set(__self__, "lifecycle_state", lifecycle_state)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if listener_port_tls is not None:
            pulumi.set(__self__, "listener_port_tls", listener_port_tls)
        if ncharacter_set is not None:
            pulumi.set(__self__, "ncharacter_set", ncharacter_set)
        if ons_port_local is not None:
            pulumi.set(__self__, "ons_port_local", ons_port_local)
        if ons_port_remote is not None:
            pulumi.set(__self__, "ons_port_remote", ons_port_remote)
        if patch_operations is not None:
            pulumi.set(__self__, "patch_operations", patch_operations)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if replication_factor is not None:
            pulumi.set(__self__, "replication_factor", replication_factor)
        if replication_method is not None:
            pulumi.set(__self__, "replication_method", replication_method)
        if replication_unit is not None:
            pulumi.set(__self__, "replication_unit", replication_unit)
        if shard_details is not None:
            pulumi.set(__self__, "shard_details", shard_details)
        if sharded_database_id is not None:
            pulumi.set(__self__, "sharded_database_id", sharded_database_id)
        if sharding_method is not None:
            pulumi.set(__self__, "sharding_method", sharding_method)
        if start_database_trigger is not None:
            pulumi.set(__self__, "start_database_trigger", start_database_trigger)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if stop_database_trigger is not None:
            pulumi.set(__self__, "stop_database_trigger", stop_database_trigger)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if upload_signed_certificate_and_generate_wallet_trigger is not None:
            pulumi.set(__self__, "upload_signed_certificate_and_generate_wallet_trigger", upload_signed_certificate_and_generate_wallet_trigger)
        if validate_network_trigger is not None:
            pulumi.set(__self__, "validate_network_trigger", validate_network_trigger)

    @property
    @pulumi.getter(name="caSignedCertificate")
    def ca_signed_certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "ca_signed_certificate")

    @ca_signed_certificate.setter
    def ca_signed_certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ca_signed_certificate", value)

    @property
    @pulumi.getter(name="catalogDetails")
    def catalog_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseCatalogDetailArgs']]]]:
        """
        Collection of ATP-Dedicated catalogs that needs to be created.
        """
        return pulumi.get(self, "catalog_details")

    @catalog_details.setter
    def catalog_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseCatalogDetailArgs']]]]):
        pulumi.set(self, "catalog_details", value)

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        """
        return pulumi.get(self, "character_set")

    @character_set.setter
    def character_set(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "character_set", value)

    @property
    @pulumi.getter
    def chunks(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        """
        return pulumi.get(self, "chunks")

    @chunks.setter
    def chunks(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "chunks", value)

    @property
    @pulumi.getter(name="clusterCertificateCommonName")
    def cluster_certificate_common_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        """
        return pulumi.get(self, "cluster_certificate_common_name")

    @cluster_certificate_common_name.setter
    def cluster_certificate_common_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cluster_certificate_common_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Identifier of the compartment where sharded database is to be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="configureGsmsTrigger")
    def configure_gsms_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Gsms. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_gsms_trigger")

    @configure_gsms_trigger.setter
    def configure_gsms_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "configure_gsms_trigger", value)

    @property
    @pulumi.getter(name="configureGsmsTriggerIsLatestGsmImage")
    def configure_gsms_trigger_is_latest_gsm_image(self) -> Optional[pulumi.Input[builtins.bool]]:
        return pulumi.get(self, "configure_gsms_trigger_is_latest_gsm_image")

    @configure_gsms_trigger_is_latest_gsm_image.setter
    def configure_gsms_trigger_is_latest_gsm_image(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "configure_gsms_trigger_is_latest_gsm_image", value)

    @property
    @pulumi.getter(name="configureGsmsTriggerOldGsmNames")
    def configure_gsms_trigger_old_gsm_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        return pulumi.get(self, "configure_gsms_trigger_old_gsm_names")

    @configure_gsms_trigger_old_gsm_names.setter
    def configure_gsms_trigger_old_gsm_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "configure_gsms_trigger_old_gsm_names", value)

    @property
    @pulumi.getter(name="configureShardingTrigger")
    def configure_sharding_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Sharding. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_sharding_trigger")

    @configure_sharding_trigger.setter
    def configure_sharding_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "configure_sharding_trigger", value)

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseConnectionStringArgs']]]]:
        """
        Details of sharded database connection String.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @property
    @pulumi.getter(name="dbDeploymentType")
    def db_deployment_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The database deployment type.
        """
        return pulumi.get(self, "db_deployment_type")

    @db_deployment_type.setter
    def db_deployment_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_deployment_type", value)

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Oracle Database version of the Autonomous Container Database.
        """
        return pulumi.get(self, "db_version")

    @db_version.setter
    def db_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_version", value)

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Possible workload types.
        """
        return pulumi.get(self, "db_workload")

    @db_workload.setter
    def db_workload(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_workload", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle sharded database display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="downloadGsmCertificateSigningRequestTrigger")
    def download_gsm_certificate_signing_request_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Download Gsm Certificate Signing Request. Could be set to any integer value.
        """
        return pulumi.get(self, "download_gsm_certificate_signing_request_trigger")

    @download_gsm_certificate_signing_request_trigger.setter
    def download_gsm_certificate_signing_request_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "download_gsm_certificate_signing_request_trigger", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="generateGsmCertificateSigningRequestTrigger")
    def generate_gsm_certificate_signing_request_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Gsm Certificate Signing Request. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_gsm_certificate_signing_request_trigger")

    @generate_gsm_certificate_signing_request_trigger.setter
    def generate_gsm_certificate_signing_request_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "generate_gsm_certificate_signing_request_trigger", value)

    @property
    @pulumi.getter(name="generateWalletPassword")
    def generate_wallet_password(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "generate_wallet_password")

    @generate_wallet_password.setter
    def generate_wallet_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "generate_wallet_password", value)

    @property
    @pulumi.getter(name="generateWalletTrigger")
    def generate_wallet_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Wallet. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_wallet_trigger")

    @generate_wallet_trigger.setter
    def generate_wallet_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "generate_wallet_trigger", value)

    @property
    @pulumi.getter(name="getConnectionStringTrigger")
    def get_connection_string_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Get Connection String. Could be set to any integer value.
        """
        return pulumi.get(self, "get_connection_string_trigger")

    @get_connection_string_trigger.setter
    def get_connection_string_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "get_connection_string_trigger", value)

    @property
    @pulumi.getter
    def gsms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseGsmArgs']]]]:
        """
        Details of GSM instances for the sharded database.
        """
        return pulumi.get(self, "gsms")

    @gsms.setter
    def gsms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseGsmArgs']]]]):
        pulumi.set(self, "gsms", value)

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "lifecycle_state")

    @lifecycle_state.setter
    def lifecycle_state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_state", value)

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The listener port number for sharded database.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="listenerPortTls")
    def listener_port_tls(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The TLS listener port number for sharded database.
        """
        return pulumi.get(self, "listener_port_tls")

    @listener_port_tls.setter
    def listener_port_tls(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "listener_port_tls", value)

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The national character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed national character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        """
        return pulumi.get(self, "ncharacter_set")

    @ncharacter_set.setter
    def ncharacter_set(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ncharacter_set", value)

    @property
    @pulumi.getter(name="onsPortLocal")
    def ons_port_local(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Ons port local for sharded database.
        """
        return pulumi.get(self, "ons_port_local")

    @ons_port_local.setter
    def ons_port_local(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ons_port_local", value)

    @property
    @pulumi.getter(name="onsPortRemote")
    def ons_port_remote(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Ons remote port for sharded database.
        """
        return pulumi.get(self, "ons_port_remote")

    @ons_port_remote.setter
    def ons_port_remote(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "ons_port_remote", value)

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabasePatchOperationArgs']]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @patch_operations.setter
    def patch_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabasePatchOperationArgs']]]]):
        pulumi.set(self, "patch_operations", value)

    @property
    @pulumi.getter
    def prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name prefix for the sharded databases. Only alpha-numeric values are allowed. First character has to be a letter followed by any combination of letter and number.
        """
        return pulumi.get(self, "prefix")

    @prefix.setter
    def prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "prefix", value)

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of private endpoint being used by the sharded database.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "private_endpoint", value)

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        """
        return pulumi.get(self, "replication_factor")

    @replication_factor.setter
    def replication_factor(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replication_factor", value)

    @property
    @pulumi.getter(name="replicationMethod")
    def replication_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Replication method for sharded database.
        """
        return pulumi.get(self, "replication_method")

    @replication_method.setter
    def replication_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "replication_method", value)

    @property
    @pulumi.getter(name="replicationUnit")
    def replication_unit(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        """
        return pulumi.get(self, "replication_unit")

    @replication_unit.setter
    def replication_unit(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "replication_unit", value)

    @property
    @pulumi.getter(name="shardDetails")
    def shard_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseShardDetailArgs']]]]:
        """
        Collection of ATP-Dedicated shards that needs to be created.
        """
        return pulumi.get(self, "shard_details")

    @shard_details.setter
    def shard_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ShardedDatabaseShardDetailArgs']]]]):
        pulumi.set(self, "shard_details", value)

    @property
    @pulumi.getter(name="shardedDatabaseId")
    def sharded_database_id(self) -> Optional[pulumi.Input[builtins.str]]:
        return pulumi.get(self, "sharded_database_id")

    @sharded_database_id.setter
    def sharded_database_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sharded_database_id", value)

    @property
    @pulumi.getter(name="shardingMethod")
    def sharding_method(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Sharding Method.
        """
        return pulumi.get(self, "sharding_method")

    @sharding_method.setter
    def sharding_method(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sharding_method", value)

    @property
    @pulumi.getter(name="startDatabaseTrigger")
    def start_database_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Database. Could be set to any integer value.
        """
        return pulumi.get(self, "start_database_trigger")

    @start_database_trigger.setter
    def start_database_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "start_database_trigger", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Lifecycle states for sharded databases.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="stopDatabaseTrigger")
    def stop_database_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Database. Could be set to any integer value.
        """
        return pulumi.get(self, "stop_database_trigger")

    @stop_database_trigger.setter
    def stop_database_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "stop_database_trigger", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Timezone associated with the sharded database.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="uploadSignedCertificateAndGenerateWalletTrigger")
    def upload_signed_certificate_and_generate_wallet_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Upload Signed Certificate And Generate Wallet. Could be set to any integer value.
        """
        return pulumi.get(self, "upload_signed_certificate_and_generate_wallet_trigger")

    @upload_signed_certificate_and_generate_wallet_trigger.setter
    def upload_signed_certificate_and_generate_wallet_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "upload_signed_certificate_and_generate_wallet_trigger", value)

    @property
    @pulumi.getter(name="validateNetworkTrigger")
    def validate_network_trigger(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Validate Network. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "validate_network_trigger")

    @validate_network_trigger.setter
    def validate_network_trigger(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "validate_network_trigger", value)


class ShardedDatabase(pulumi.CustomResource):

    pulumi_type = "oci:GloballyDistributedDatabase/shardedDatabase:ShardedDatabase"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_signed_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 catalog_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseCatalogDetailArgs', 'ShardedDatabaseCatalogDetailArgsDict']]]]] = None,
                 character_set: Optional[pulumi.Input[builtins.str]] = None,
                 chunks: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_certificate_common_name: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configure_gsms_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 configure_gsms_trigger_is_latest_gsm_image: Optional[pulumi.Input[builtins.bool]] = None,
                 configure_gsms_trigger_old_gsm_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 configure_sharding_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 db_deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 db_workload: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 download_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 generate_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 generate_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
                 generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 get_connection_string_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 listener_port: Optional[pulumi.Input[builtins.int]] = None,
                 listener_port_tls: Optional[pulumi.Input[builtins.int]] = None,
                 ncharacter_set: Optional[pulumi.Input[builtins.str]] = None,
                 ons_port_local: Optional[pulumi.Input[builtins.int]] = None,
                 ons_port_remote: Optional[pulumi.Input[builtins.int]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabasePatchOperationArgs', 'ShardedDatabasePatchOperationArgsDict']]]]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 replication_method: Optional[pulumi.Input[builtins.str]] = None,
                 replication_unit: Optional[pulumi.Input[builtins.int]] = None,
                 shard_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseShardDetailArgs', 'ShardedDatabaseShardDetailArgsDict']]]]] = None,
                 sharding_method: Optional[pulumi.Input[builtins.str]] = None,
                 start_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 stop_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 upload_signed_certificate_and_generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 validate_network_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        This resource provides the Sharded Database resource in Oracle Cloud Infrastructure Globally Distributed Database service.

        Creates a Sharded Database.

          Patch operation to add, remove or update shards to the sharded database topology. In single patch
        operation, multiple shards can be either added, or removed or updated. Combination of inserts, update
        and remove in single operation is not allowed.

        ## Import

        ShardedDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GloballyDistributedDatabase/shardedDatabase:ShardedDatabase test_sharded_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseCatalogDetailArgs', 'ShardedDatabaseCatalogDetailArgsDict']]]] catalog_details: Collection of ATP-Dedicated catalogs that needs to be created.
        :param pulumi.Input[builtins.str] character_set: The character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        :param pulumi.Input[builtins.int] chunks: The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        :param pulumi.Input[builtins.str] cluster_certificate_common_name: The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Identifier of the compartment where sharded database is to be created.
        :param pulumi.Input[builtins.int] configure_gsms_trigger: (Updatable) An optional property when incremented triggers Configure Gsms. Could be set to any integer value.
        :param pulumi.Input[builtins.int] configure_sharding_trigger: (Updatable) An optional property when incremented triggers Configure Sharding. Could be set to any integer value.
        :param pulumi.Input[builtins.str] db_deployment_type: The database deployment type.
        :param pulumi.Input[builtins.str] db_version: Oracle Database version of the Autonomous Container Database.
        :param pulumi.Input[builtins.str] db_workload: Possible workload types.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Oracle sharded database display name.
        :param pulumi.Input[builtins.int] download_gsm_certificate_signing_request_trigger: (Updatable) An optional property when incremented triggers Download Gsm Certificate Signing Request. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.int] generate_gsm_certificate_signing_request_trigger: (Updatable) An optional property when incremented triggers Generate Gsm Certificate Signing Request. Could be set to any integer value.
        :param pulumi.Input[builtins.int] generate_wallet_trigger: (Updatable) An optional property when incremented triggers Generate Wallet. Could be set to any integer value.
        :param pulumi.Input[builtins.int] get_connection_string_trigger: (Updatable) An optional property when incremented triggers Get Connection String. Could be set to any integer value.
        :param pulumi.Input[builtins.int] listener_port: The listener port number for sharded database.
        :param pulumi.Input[builtins.int] listener_port_tls: The TLS listener port number for sharded database.
        :param pulumi.Input[builtins.str] ncharacter_set: The national character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed national character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        :param pulumi.Input[builtins.int] ons_port_local: Ons port local for sharded database.
        :param pulumi.Input[builtins.int] ons_port_remote: Ons remote port for sharded database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabasePatchOperationArgs', 'ShardedDatabasePatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.str] prefix: Unique name prefix for the sharded databases. Only alpha-numeric values are allowed. First character has to be a letter followed by any combination of letter and number.
        :param pulumi.Input[builtins.int] replication_factor: The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        :param pulumi.Input[builtins.str] replication_method: The Replication method for sharded database.
        :param pulumi.Input[builtins.int] replication_unit: For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseShardDetailArgs', 'ShardedDatabaseShardDetailArgsDict']]]] shard_details: Collection of ATP-Dedicated shards that needs to be created.
        :param pulumi.Input[builtins.str] sharding_method: Sharding Method.
        :param pulumi.Input[builtins.int] start_database_trigger: (Updatable) An optional property when incremented triggers Start Database. Could be set to any integer value.
        :param pulumi.Input[builtins.int] stop_database_trigger: (Updatable) An optional property when incremented triggers Stop Database. Could be set to any integer value.
        :param pulumi.Input[builtins.int] upload_signed_certificate_and_generate_wallet_trigger: (Updatable) An optional property when incremented triggers Upload Signed Certificate And Generate Wallet. Could be set to any integer value.
        :param pulumi.Input[builtins.int] validate_network_trigger: (Updatable) An optional property when incremented triggers Validate Network. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ShardedDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sharded Database resource in Oracle Cloud Infrastructure Globally Distributed Database service.

        Creates a Sharded Database.

          Patch operation to add, remove or update shards to the sharded database topology. In single patch
        operation, multiple shards can be either added, or removed or updated. Combination of inserts, update
        and remove in single operation is not allowed.

        ## Import

        ShardedDatabases can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GloballyDistributedDatabase/shardedDatabase:ShardedDatabase test_sharded_database "id"
        ```

        :param str resource_name: The name of the resource.
        :param ShardedDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ShardedDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ca_signed_certificate: Optional[pulumi.Input[builtins.str]] = None,
                 catalog_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseCatalogDetailArgs', 'ShardedDatabaseCatalogDetailArgsDict']]]]] = None,
                 character_set: Optional[pulumi.Input[builtins.str]] = None,
                 chunks: Optional[pulumi.Input[builtins.int]] = None,
                 cluster_certificate_common_name: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 configure_gsms_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 configure_gsms_trigger_is_latest_gsm_image: Optional[pulumi.Input[builtins.bool]] = None,
                 configure_gsms_trigger_old_gsm_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 configure_sharding_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 db_deployment_type: Optional[pulumi.Input[builtins.str]] = None,
                 db_version: Optional[pulumi.Input[builtins.str]] = None,
                 db_workload: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 download_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 generate_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 generate_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
                 generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 get_connection_string_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 listener_port: Optional[pulumi.Input[builtins.int]] = None,
                 listener_port_tls: Optional[pulumi.Input[builtins.int]] = None,
                 ncharacter_set: Optional[pulumi.Input[builtins.str]] = None,
                 ons_port_local: Optional[pulumi.Input[builtins.int]] = None,
                 ons_port_remote: Optional[pulumi.Input[builtins.int]] = None,
                 patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabasePatchOperationArgs', 'ShardedDatabasePatchOperationArgsDict']]]]] = None,
                 prefix: Optional[pulumi.Input[builtins.str]] = None,
                 replication_factor: Optional[pulumi.Input[builtins.int]] = None,
                 replication_method: Optional[pulumi.Input[builtins.str]] = None,
                 replication_unit: Optional[pulumi.Input[builtins.int]] = None,
                 shard_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseShardDetailArgs', 'ShardedDatabaseShardDetailArgsDict']]]]] = None,
                 sharding_method: Optional[pulumi.Input[builtins.str]] = None,
                 start_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 stop_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 upload_signed_certificate_and_generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 validate_network_trigger: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ShardedDatabaseArgs.__new__(ShardedDatabaseArgs)

            __props__.__dict__["ca_signed_certificate"] = ca_signed_certificate
            if catalog_details is None and not opts.urn:
                raise TypeError("Missing required property 'catalog_details'")
            __props__.__dict__["catalog_details"] = catalog_details
            if character_set is None and not opts.urn:
                raise TypeError("Missing required property 'character_set'")
            __props__.__dict__["character_set"] = character_set
            __props__.__dict__["chunks"] = chunks
            __props__.__dict__["cluster_certificate_common_name"] = cluster_certificate_common_name
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["configure_gsms_trigger"] = configure_gsms_trigger
            __props__.__dict__["configure_gsms_trigger_is_latest_gsm_image"] = configure_gsms_trigger_is_latest_gsm_image
            __props__.__dict__["configure_gsms_trigger_old_gsm_names"] = configure_gsms_trigger_old_gsm_names
            __props__.__dict__["configure_sharding_trigger"] = configure_sharding_trigger
            if db_deployment_type is None and not opts.urn:
                raise TypeError("Missing required property 'db_deployment_type'")
            __props__.__dict__["db_deployment_type"] = db_deployment_type
            if db_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_version'")
            __props__.__dict__["db_version"] = db_version
            if db_workload is None and not opts.urn:
                raise TypeError("Missing required property 'db_workload'")
            __props__.__dict__["db_workload"] = db_workload
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["download_gsm_certificate_signing_request_trigger"] = download_gsm_certificate_signing_request_trigger
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["generate_gsm_certificate_signing_request_trigger"] = generate_gsm_certificate_signing_request_trigger
            __props__.__dict__["generate_wallet_password"] = None if generate_wallet_password is None else pulumi.Output.secret(generate_wallet_password)
            __props__.__dict__["generate_wallet_trigger"] = generate_wallet_trigger
            __props__.__dict__["get_connection_string_trigger"] = get_connection_string_trigger
            if listener_port is None and not opts.urn:
                raise TypeError("Missing required property 'listener_port'")
            __props__.__dict__["listener_port"] = listener_port
            if listener_port_tls is None and not opts.urn:
                raise TypeError("Missing required property 'listener_port_tls'")
            __props__.__dict__["listener_port_tls"] = listener_port_tls
            if ncharacter_set is None and not opts.urn:
                raise TypeError("Missing required property 'ncharacter_set'")
            __props__.__dict__["ncharacter_set"] = ncharacter_set
            if ons_port_local is None and not opts.urn:
                raise TypeError("Missing required property 'ons_port_local'")
            __props__.__dict__["ons_port_local"] = ons_port_local
            if ons_port_remote is None and not opts.urn:
                raise TypeError("Missing required property 'ons_port_remote'")
            __props__.__dict__["ons_port_remote"] = ons_port_remote
            __props__.__dict__["patch_operations"] = patch_operations
            if prefix is None and not opts.urn:
                raise TypeError("Missing required property 'prefix'")
            __props__.__dict__["prefix"] = prefix
            __props__.__dict__["replication_factor"] = replication_factor
            __props__.__dict__["replication_method"] = replication_method
            __props__.__dict__["replication_unit"] = replication_unit
            if shard_details is None and not opts.urn:
                raise TypeError("Missing required property 'shard_details'")
            __props__.__dict__["shard_details"] = shard_details
            if sharding_method is None and not opts.urn:
                raise TypeError("Missing required property 'sharding_method'")
            __props__.__dict__["sharding_method"] = sharding_method
            __props__.__dict__["start_database_trigger"] = start_database_trigger
            __props__.__dict__["stop_database_trigger"] = stop_database_trigger
            __props__.__dict__["upload_signed_certificate_and_generate_wallet_trigger"] = upload_signed_certificate_and_generate_wallet_trigger
            __props__.__dict__["validate_network_trigger"] = validate_network_trigger
            __props__.__dict__["connection_strings"] = None
            __props__.__dict__["gsms"] = None
            __props__.__dict__["lifecycle_state"] = None
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["private_endpoint"] = None
            __props__.__dict__["sharded_database_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["time_zone"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["generateWalletPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ShardedDatabase, __self__).__init__(
            'oci:GloballyDistributedDatabase/shardedDatabase:ShardedDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ca_signed_certificate: Optional[pulumi.Input[builtins.str]] = None,
            catalog_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseCatalogDetailArgs', 'ShardedDatabaseCatalogDetailArgsDict']]]]] = None,
            character_set: Optional[pulumi.Input[builtins.str]] = None,
            chunks: Optional[pulumi.Input[builtins.int]] = None,
            cluster_certificate_common_name: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            configure_gsms_trigger: Optional[pulumi.Input[builtins.int]] = None,
            configure_gsms_trigger_is_latest_gsm_image: Optional[pulumi.Input[builtins.bool]] = None,
            configure_gsms_trigger_old_gsm_names: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            configure_sharding_trigger: Optional[pulumi.Input[builtins.int]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseConnectionStringArgs', 'ShardedDatabaseConnectionStringArgsDict']]]]] = None,
            db_deployment_type: Optional[pulumi.Input[builtins.str]] = None,
            db_version: Optional[pulumi.Input[builtins.str]] = None,
            db_workload: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            download_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            generate_gsm_certificate_signing_request_trigger: Optional[pulumi.Input[builtins.int]] = None,
            generate_wallet_password: Optional[pulumi.Input[builtins.str]] = None,
            generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
            get_connection_string_trigger: Optional[pulumi.Input[builtins.int]] = None,
            gsms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseGsmArgs', 'ShardedDatabaseGsmArgsDict']]]]] = None,
            lifecycle_state: Optional[pulumi.Input[builtins.str]] = None,
            lifecycle_state_details: Optional[pulumi.Input[builtins.str]] = None,
            listener_port: Optional[pulumi.Input[builtins.int]] = None,
            listener_port_tls: Optional[pulumi.Input[builtins.int]] = None,
            ncharacter_set: Optional[pulumi.Input[builtins.str]] = None,
            ons_port_local: Optional[pulumi.Input[builtins.int]] = None,
            ons_port_remote: Optional[pulumi.Input[builtins.int]] = None,
            patch_operations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabasePatchOperationArgs', 'ShardedDatabasePatchOperationArgsDict']]]]] = None,
            prefix: Optional[pulumi.Input[builtins.str]] = None,
            private_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            replication_factor: Optional[pulumi.Input[builtins.int]] = None,
            replication_method: Optional[pulumi.Input[builtins.str]] = None,
            replication_unit: Optional[pulumi.Input[builtins.int]] = None,
            shard_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseShardDetailArgs', 'ShardedDatabaseShardDetailArgsDict']]]]] = None,
            sharded_database_id: Optional[pulumi.Input[builtins.str]] = None,
            sharding_method: Optional[pulumi.Input[builtins.str]] = None,
            start_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            stop_database_trigger: Optional[pulumi.Input[builtins.int]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            time_zone: Optional[pulumi.Input[builtins.str]] = None,
            upload_signed_certificate_and_generate_wallet_trigger: Optional[pulumi.Input[builtins.int]] = None,
            validate_network_trigger: Optional[pulumi.Input[builtins.int]] = None) -> 'ShardedDatabase':
        """
        Get an existing ShardedDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseCatalogDetailArgs', 'ShardedDatabaseCatalogDetailArgsDict']]]] catalog_details: Collection of ATP-Dedicated catalogs that needs to be created.
        :param pulumi.Input[builtins.str] character_set: The character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        :param pulumi.Input[builtins.int] chunks: The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        :param pulumi.Input[builtins.str] cluster_certificate_common_name: The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) Identifier of the compartment where sharded database is to be created.
        :param pulumi.Input[builtins.int] configure_gsms_trigger: (Updatable) An optional property when incremented triggers Configure Gsms. Could be set to any integer value.
        :param pulumi.Input[builtins.int] configure_sharding_trigger: (Updatable) An optional property when incremented triggers Configure Sharding. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseConnectionStringArgs', 'ShardedDatabaseConnectionStringArgsDict']]]] connection_strings: Details of sharded database connection String.
        :param pulumi.Input[builtins.str] db_deployment_type: The database deployment type.
        :param pulumi.Input[builtins.str] db_version: Oracle Database version of the Autonomous Container Database.
        :param pulumi.Input[builtins.str] db_workload: Possible workload types.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) Oracle sharded database display name.
        :param pulumi.Input[builtins.int] download_gsm_certificate_signing_request_trigger: (Updatable) An optional property when incremented triggers Download Gsm Certificate Signing Request. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.int] generate_gsm_certificate_signing_request_trigger: (Updatable) An optional property when incremented triggers Generate Gsm Certificate Signing Request. Could be set to any integer value.
        :param pulumi.Input[builtins.int] generate_wallet_trigger: (Updatable) An optional property when incremented triggers Generate Wallet. Could be set to any integer value.
        :param pulumi.Input[builtins.int] get_connection_string_trigger: (Updatable) An optional property when incremented triggers Get Connection String. Could be set to any integer value.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseGsmArgs', 'ShardedDatabaseGsmArgsDict']]]] gsms: Details of GSM instances for the sharded database.
        :param pulumi.Input[builtins.str] lifecycle_state_details: Detailed message for the lifecycle state.
        :param pulumi.Input[builtins.int] listener_port: The listener port number for sharded database.
        :param pulumi.Input[builtins.int] listener_port_tls: The TLS listener port number for sharded database.
        :param pulumi.Input[builtins.str] ncharacter_set: The national character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed national character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        :param pulumi.Input[builtins.int] ons_port_local: Ons port local for sharded database.
        :param pulumi.Input[builtins.int] ons_port_remote: Ons remote port for sharded database.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabasePatchOperationArgs', 'ShardedDatabasePatchOperationArgsDict']]]] patch_operations: (Updatable)
        :param pulumi.Input[builtins.str] prefix: Unique name prefix for the sharded databases. Only alpha-numeric values are allowed. First character has to be a letter followed by any combination of letter and number.
        :param pulumi.Input[builtins.str] private_endpoint: The OCID of private endpoint being used by the sharded database.
        :param pulumi.Input[builtins.int] replication_factor: The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        :param pulumi.Input[builtins.str] replication_method: The Replication method for sharded database.
        :param pulumi.Input[builtins.int] replication_unit: For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ShardedDatabaseShardDetailArgs', 'ShardedDatabaseShardDetailArgsDict']]]] shard_details: Collection of ATP-Dedicated shards that needs to be created.
        :param pulumi.Input[builtins.str] sharding_method: Sharding Method.
        :param pulumi.Input[builtins.int] start_database_trigger: (Updatable) An optional property when incremented triggers Start Database. Could be set to any integer value.
        :param pulumi.Input[builtins.str] state: Lifecycle states for sharded databases.
        :param pulumi.Input[builtins.int] stop_database_trigger: (Updatable) An optional property when incremented triggers Stop Database. Could be set to any integer value.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the the Sharded Database was created. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_updated: The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        :param pulumi.Input[builtins.str] time_zone: Timezone associated with the sharded database.
        :param pulumi.Input[builtins.int] upload_signed_certificate_and_generate_wallet_trigger: (Updatable) An optional property when incremented triggers Upload Signed Certificate And Generate Wallet. Could be set to any integer value.
        :param pulumi.Input[builtins.int] validate_network_trigger: (Updatable) An optional property when incremented triggers Validate Network. Could be set to any integer value.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ShardedDatabaseState.__new__(_ShardedDatabaseState)

        __props__.__dict__["ca_signed_certificate"] = ca_signed_certificate
        __props__.__dict__["catalog_details"] = catalog_details
        __props__.__dict__["character_set"] = character_set
        __props__.__dict__["chunks"] = chunks
        __props__.__dict__["cluster_certificate_common_name"] = cluster_certificate_common_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["configure_gsms_trigger"] = configure_gsms_trigger
        __props__.__dict__["configure_gsms_trigger_is_latest_gsm_image"] = configure_gsms_trigger_is_latest_gsm_image
        __props__.__dict__["configure_gsms_trigger_old_gsm_names"] = configure_gsms_trigger_old_gsm_names
        __props__.__dict__["configure_sharding_trigger"] = configure_sharding_trigger
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["db_deployment_type"] = db_deployment_type
        __props__.__dict__["db_version"] = db_version
        __props__.__dict__["db_workload"] = db_workload
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["download_gsm_certificate_signing_request_trigger"] = download_gsm_certificate_signing_request_trigger
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["generate_gsm_certificate_signing_request_trigger"] = generate_gsm_certificate_signing_request_trigger
        __props__.__dict__["generate_wallet_password"] = generate_wallet_password
        __props__.__dict__["generate_wallet_trigger"] = generate_wallet_trigger
        __props__.__dict__["get_connection_string_trigger"] = get_connection_string_trigger
        __props__.__dict__["gsms"] = gsms
        __props__.__dict__["lifecycle_state"] = lifecycle_state
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["listener_port_tls"] = listener_port_tls
        __props__.__dict__["ncharacter_set"] = ncharacter_set
        __props__.__dict__["ons_port_local"] = ons_port_local
        __props__.__dict__["ons_port_remote"] = ons_port_remote
        __props__.__dict__["patch_operations"] = patch_operations
        __props__.__dict__["prefix"] = prefix
        __props__.__dict__["private_endpoint"] = private_endpoint
        __props__.__dict__["replication_factor"] = replication_factor
        __props__.__dict__["replication_method"] = replication_method
        __props__.__dict__["replication_unit"] = replication_unit
        __props__.__dict__["shard_details"] = shard_details
        __props__.__dict__["sharded_database_id"] = sharded_database_id
        __props__.__dict__["sharding_method"] = sharding_method
        __props__.__dict__["start_database_trigger"] = start_database_trigger
        __props__.__dict__["state"] = state
        __props__.__dict__["stop_database_trigger"] = stop_database_trigger
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["upload_signed_certificate_and_generate_wallet_trigger"] = upload_signed_certificate_and_generate_wallet_trigger
        __props__.__dict__["validate_network_trigger"] = validate_network_trigger
        return ShardedDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="caSignedCertificate")
    def ca_signed_certificate(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "ca_signed_certificate")

    @property
    @pulumi.getter(name="catalogDetails")
    def catalog_details(self) -> pulumi.Output[Sequence['outputs.ShardedDatabaseCatalogDetail']]:
        """
        Collection of ATP-Dedicated catalogs that needs to be created.
        """
        return pulumi.get(self, "catalog_details")

    @property
    @pulumi.getter(name="characterSet")
    def character_set(self) -> pulumi.Output[builtins.str]:
        """
        The character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        """
        return pulumi.get(self, "character_set")

    @property
    @pulumi.getter
    def chunks(self) -> pulumi.Output[builtins.int]:
        """
        The default number of unique chunks in a shardspace. The value of chunks must be greater than 2 times the size of the largest shardgroup in any shardspace.
        """
        return pulumi.get(self, "chunks")

    @property
    @pulumi.getter(name="clusterCertificateCommonName")
    def cluster_certificate_common_name(self) -> pulumi.Output[builtins.str]:
        """
        The certificate common name used in all cloudAutonomousVmClusters for the sharded database topology. Eg. Production. All the clusters used in one sharded database topology shall have same CABundle setup. Valid characterset for clusterCertificateCommonName include uppercase or lowercase letters, numbers, hyphens, underscores, and period.
        """
        return pulumi.get(self, "cluster_certificate_common_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Identifier of the compartment where sharded database is to be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configureGsmsTrigger")
    def configure_gsms_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Gsms. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_gsms_trigger")

    @property
    @pulumi.getter(name="configureGsmsTriggerIsLatestGsmImage")
    def configure_gsms_trigger_is_latest_gsm_image(self) -> pulumi.Output[Optional[builtins.bool]]:
        return pulumi.get(self, "configure_gsms_trigger_is_latest_gsm_image")

    @property
    @pulumi.getter(name="configureGsmsTriggerOldGsmNames")
    def configure_gsms_trigger_old_gsm_names(self) -> pulumi.Output[Optional[Sequence[builtins.str]]]:
        return pulumi.get(self, "configure_gsms_trigger_old_gsm_names")

    @property
    @pulumi.getter(name="configureShardingTrigger")
    def configure_sharding_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Configure Sharding. Could be set to any integer value.
        """
        return pulumi.get(self, "configure_sharding_trigger")

    @property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.ShardedDatabaseConnectionString']]:
        """
        Details of sharded database connection String.
        """
        return pulumi.get(self, "connection_strings")

    @property
    @pulumi.getter(name="dbDeploymentType")
    def db_deployment_type(self) -> pulumi.Output[builtins.str]:
        """
        The database deployment type.
        """
        return pulumi.get(self, "db_deployment_type")

    @property
    @pulumi.getter(name="dbVersion")
    def db_version(self) -> pulumi.Output[builtins.str]:
        """
        Oracle Database version of the Autonomous Container Database.
        """
        return pulumi.get(self, "db_version")

    @property
    @pulumi.getter(name="dbWorkload")
    def db_workload(self) -> pulumi.Output[builtins.str]:
        """
        Possible workload types.
        """
        return pulumi.get(self, "db_workload")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle sharded database display name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="downloadGsmCertificateSigningRequestTrigger")
    def download_gsm_certificate_signing_request_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Download Gsm Certificate Signing Request. Could be set to any integer value.
        """
        return pulumi.get(self, "download_gsm_certificate_signing_request_trigger")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="generateGsmCertificateSigningRequestTrigger")
    def generate_gsm_certificate_signing_request_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Gsm Certificate Signing Request. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_gsm_certificate_signing_request_trigger")

    @property
    @pulumi.getter(name="generateWalletPassword")
    def generate_wallet_password(self) -> pulumi.Output[Optional[builtins.str]]:
        return pulumi.get(self, "generate_wallet_password")

    @property
    @pulumi.getter(name="generateWalletTrigger")
    def generate_wallet_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Generate Wallet. Could be set to any integer value.
        """
        return pulumi.get(self, "generate_wallet_trigger")

    @property
    @pulumi.getter(name="getConnectionStringTrigger")
    def get_connection_string_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Get Connection String. Could be set to any integer value.
        """
        return pulumi.get(self, "get_connection_string_trigger")

    @property
    @pulumi.getter
    def gsms(self) -> pulumi.Output[Sequence['outputs.ShardedDatabaseGsm']]:
        """
        Details of GSM instances for the sharded database.
        """
        return pulumi.get(self, "gsms")

    @property
    @pulumi.getter(name="lifecycleState")
    def lifecycle_state(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "lifecycle_state")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[builtins.str]:
        """
        Detailed message for the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[builtins.int]:
        """
        The listener port number for sharded database.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="listenerPortTls")
    def listener_port_tls(self) -> pulumi.Output[builtins.int]:
        """
        The TLS listener port number for sharded database.
        """
        return pulumi.get(self, "listener_port_tls")

    @property
    @pulumi.getter(name="ncharacterSet")
    def ncharacter_set(self) -> pulumi.Output[builtins.str]:
        """
        The national character set for the new shard database being created. Use database api ListAutonomousDatabaseCharacterSets to get the list of allowed national character set for autonomous dedicated database. See documentation: https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/ListAutonomousDatabaseCharacterSets
        """
        return pulumi.get(self, "ncharacter_set")

    @property
    @pulumi.getter(name="onsPortLocal")
    def ons_port_local(self) -> pulumi.Output[builtins.int]:
        """
        Ons port local for sharded database.
        """
        return pulumi.get(self, "ons_port_local")

    @property
    @pulumi.getter(name="onsPortRemote")
    def ons_port_remote(self) -> pulumi.Output[builtins.int]:
        """
        Ons remote port for sharded database.
        """
        return pulumi.get(self, "ons_port_remote")

    @property
    @pulumi.getter(name="patchOperations")
    def patch_operations(self) -> pulumi.Output[Optional[Sequence['outputs.ShardedDatabasePatchOperation']]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "patch_operations")

    @property
    @pulumi.getter
    def prefix(self) -> pulumi.Output[builtins.str]:
        """
        Unique name prefix for the sharded databases. Only alpha-numeric values are allowed. First character has to be a letter followed by any combination of letter and number.
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of private endpoint being used by the sharded database.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="replicationFactor")
    def replication_factor(self) -> pulumi.Output[builtins.int]:
        """
        The Replication factor for RAFT replication based sharded database. Currently supported values are 3, 5 and 7.
        """
        return pulumi.get(self, "replication_factor")

    @property
    @pulumi.getter(name="replicationMethod")
    def replication_method(self) -> pulumi.Output[builtins.str]:
        """
        The Replication method for sharded database.
        """
        return pulumi.get(self, "replication_method")

    @property
    @pulumi.getter(name="replicationUnit")
    def replication_unit(self) -> pulumi.Output[builtins.int]:
        """
        For RAFT replication based sharded database, the value should be atleast twice the number of shards.
        """
        return pulumi.get(self, "replication_unit")

    @property
    @pulumi.getter(name="shardDetails")
    def shard_details(self) -> pulumi.Output[Sequence['outputs.ShardedDatabaseShardDetail']]:
        """
        Collection of ATP-Dedicated shards that needs to be created.
        """
        return pulumi.get(self, "shard_details")

    @property
    @pulumi.getter(name="shardedDatabaseId")
    def sharded_database_id(self) -> pulumi.Output[builtins.str]:
        return pulumi.get(self, "sharded_database_id")

    @property
    @pulumi.getter(name="shardingMethod")
    def sharding_method(self) -> pulumi.Output[builtins.str]:
        """
        Sharding Method.
        """
        return pulumi.get(self, "sharding_method")

    @property
    @pulumi.getter(name="startDatabaseTrigger")
    def start_database_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Start Database. Could be set to any integer value.
        """
        return pulumi.get(self, "start_database_trigger")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        Lifecycle states for sharded databases.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stopDatabaseTrigger")
    def stop_database_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Stop Database. Could be set to any integer value.
        """
        return pulumi.get(self, "stop_database_trigger")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the the Sharded Database was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the Sharded Database was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[builtins.str]:
        """
        Timezone associated with the sharded database.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="uploadSignedCertificateAndGenerateWalletTrigger")
    def upload_signed_certificate_and_generate_wallet_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Upload Signed Certificate And Generate Wallet. Could be set to any integer value.
        """
        return pulumi.get(self, "upload_signed_certificate_and_generate_wallet_trigger")

    @property
    @pulumi.getter(name="validateNetworkTrigger")
    def validate_network_trigger(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        (Updatable) An optional property when incremented triggers Validate Network. Could be set to any integer value.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "validate_network_trigger")

