# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsOauthPartnerCertificateArgs', 'DomainsOauthPartnerCertificate']

@pulumi.input_type
class DomainsOauthPartnerCertificateArgs:
    def __init__(__self__, *,
                 certificate_alias: pulumi.Input[builtins.str],
                 idcs_endpoint: pulumi.Input[builtins.str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_password: Optional[pulumi.Input[builtins.str]] = None,
                 map: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateTagArgs']]]] = None,
                 x509base64certificate: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DomainsOauthPartnerCertificate resource.
        :param pulumi.Input[builtins.str] certificate_alias: Certificate alias
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: always
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] external_id: An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[builtins.str] key_store_id: Key store ID
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: true
               * returned: never
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[builtins.str] key_store_name: Key store name
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * returned: always
               * uniqueness: none
        :param pulumi.Input[builtins.str] key_store_password: Key store password
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * idcsSensitive: none
               * required: false
               * caseExact: true
               * returned: never
               * uniqueness: none
        :param pulumi.Input[builtins.str] map: Map
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * returned: always
               * uniqueness: none
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateTagArgs']]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] x509base64certificate: Base 64Key data attribute
               
               **SCIM++ Properties:**
               * caseExact: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "certificate_alias", certificate_alias)
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "schemas", schemas)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_name is not None:
            pulumi.set(__self__, "key_store_name", key_store_name)
        if key_store_password is not None:
            pulumi.set(__self__, "key_store_password", key_store_password)
        if map is not None:
            pulumi.set(__self__, "map", map)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if x509base64certificate is not None:
            pulumi.set(__self__, "x509base64certificate", x509base64certificate)

    @property
    @pulumi.getter(name="certificateAlias")
    def certificate_alias(self) -> pulumi.Input[builtins.str]:
        """
        Certificate alias

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: always
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "certificate_alias")

    @certificate_alias.setter
    def certificate_alias(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "certificate_alias", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key store ID

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: true
        * returned: never
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_id", value)

    @property
    @pulumi.getter(name="keyStoreName")
    def key_store_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key store name

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * returned: always
        * uniqueness: none
        """
        return pulumi.get(self, "key_store_name")

    @key_store_name.setter
    def key_store_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_name", value)

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key store password

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * idcsSensitive: none
        * required: false
        * caseExact: true
        * returned: never
        * uniqueness: none
        """
        return pulumi.get(self, "key_store_password")

    @key_store_password.setter
    def key_store_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_password", value)

    @property
    @pulumi.getter
    def map(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Map

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * returned: always
        * uniqueness: none
        """
        return pulumi.get(self, "map")

    @map.setter
    def map(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "map", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateTagArgs']]]]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def x509base64certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base 64Key data attribute

        **SCIM++ Properties:**
        * caseExact: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "x509base64certificate")

    @x509base64certificate.setter
    def x509base64certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "x509base64certificate", value)


@pulumi.input_type
class _DomainsOauthPartnerCertificateState:
    def __init__(__self__, *,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 cert_end_date: Optional[pulumi.Input[builtins.str]] = None,
                 cert_start_date: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_alias: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
                 domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 key_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_password: Optional[pulumi.Input[builtins.str]] = None,
                 map: Optional[pulumi.Input[builtins.str]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateMetaArgs']]]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 sha1thumbprint: Optional[pulumi.Input[builtins.str]] = None,
                 sha256thumbprint: Optional[pulumi.Input[builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
                 x509base64certificate: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DomainsOauthPartnerCertificate resources.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] cert_end_date: (Updatable) Certificate end date
               
               **SCIM++ Properties:**
               * type: dateTime
               * multiValued: false
               * required: false
               * caseExact: true
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[builtins.str] cert_start_date: (Updatable) Certificate start date
               
               **SCIM++ Properties:**
               * type: dateTime
               * multiValued: false
               * required: false
               * caseExact: true
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[builtins.str] certificate_alias: Certificate alias
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: always
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] key_store_id: Key store ID
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: true
               * returned: never
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[builtins.str] key_store_name: Key store name
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * returned: always
               * uniqueness: none
        :param pulumi.Input[builtins.str] key_store_password: Key store password
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * idcsSensitive: none
               * required: false
               * caseExact: true
               * returned: never
               * uniqueness: none
        :param pulumi.Input[builtins.str] map: Map
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * returned: always
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] sha1thumbprint: (Updatable) SHA-1 Thumbprint
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: true
               * returned: default
               * idcsSearchable: true
               * uniqueness: none
        :param pulumi.Input[builtins.str] sha256thumbprint: (Updatable) SHA-256 Thumbprint
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: true
               * returned: default
               * idcsSearchable: true
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateTagArgs']]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] x509base64certificate: Base 64Key data attribute
               
               **SCIM++ Properties:**
               * caseExact: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if cert_end_date is not None:
            pulumi.set(__self__, "cert_end_date", cert_end_date)
        if cert_start_date is not None:
            pulumi.set(__self__, "cert_start_date", cert_start_date)
        if certificate_alias is not None:
            pulumi.set(__self__, "certificate_alias", certificate_alias)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if key_store_id is not None:
            pulumi.set(__self__, "key_store_id", key_store_id)
        if key_store_name is not None:
            pulumi.set(__self__, "key_store_name", key_store_name)
        if key_store_password is not None:
            pulumi.set(__self__, "key_store_password", key_store_password)
        if map is not None:
            pulumi.set(__self__, "map", map)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if sha1thumbprint is not None:
            pulumi.set(__self__, "sha1thumbprint", sha1thumbprint)
        if sha256thumbprint is not None:
            pulumi.set(__self__, "sha256thumbprint", sha256thumbprint)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if x509base64certificate is not None:
            pulumi.set(__self__, "x509base64certificate", x509base64certificate)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="certEndDate")
    def cert_end_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Certificate end date

        **SCIM++ Properties:**
        * type: dateTime
        * multiValued: false
        * required: false
        * caseExact: true
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "cert_end_date")

    @cert_end_date.setter
    def cert_end_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cert_end_date", value)

    @property
    @pulumi.getter(name="certStartDate")
    def cert_start_date(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Certificate start date

        **SCIM++ Properties:**
        * type: dateTime
        * multiValued: false
        * required: false
        * caseExact: true
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "cert_start_date")

    @cert_start_date.setter
    def cert_start_date(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "cert_start_date", value)

    @property
    @pulumi.getter(name="certificateAlias")
    def certificate_alias(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Certificate alias

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: always
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "certificate_alias")

    @certificate_alias.setter
    def certificate_alias(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "certificate_alias", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key store ID

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: true
        * returned: never
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "key_store_id")

    @key_store_id.setter
    def key_store_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_id", value)

    @property
    @pulumi.getter(name="keyStoreName")
    def key_store_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key store name

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * returned: always
        * uniqueness: none
        """
        return pulumi.get(self, "key_store_name")

    @key_store_name.setter
    def key_store_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_name", value)

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Key store password

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * idcsSensitive: none
        * required: false
        * caseExact: true
        * returned: never
        * uniqueness: none
        """
        return pulumi.get(self, "key_store_password")

    @key_store_password.setter
    def key_store_password(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key_store_password", value)

    @property
    @pulumi.getter
    def map(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Map

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * returned: always
        * uniqueness: none
        """
        return pulumi.get(self, "map")

    @map.setter
    def map(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "map", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def sha1thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) SHA-1 Thumbprint

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: true
        * returned: default
        * idcsSearchable: true
        * uniqueness: none
        """
        return pulumi.get(self, "sha1thumbprint")

    @sha1thumbprint.setter
    def sha1thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sha1thumbprint", value)

    @property
    @pulumi.getter
    def sha256thumbprint(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) SHA-256 Thumbprint

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: true
        * returned: default
        * idcsSearchable: true
        * uniqueness: none
        """
        return pulumi.get(self, "sha256thumbprint")

    @sha256thumbprint.setter
    def sha256thumbprint(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sha256thumbprint", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateTagArgs']]]]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsOauthPartnerCertificateTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter
    def x509base64certificate(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Base 64Key data attribute

        **SCIM++ Properties:**
        * caseExact: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "x509base64certificate")

    @x509base64certificate.setter
    def x509base64certificate(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "x509base64certificate", value)


class DomainsOauthPartnerCertificate(pulumi.CustomResource):

    pulumi_type = "oci:Identity/domainsOauthPartnerCertificate:DomainsOauthPartnerCertificate"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_alias: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_password: Optional[pulumi.Input[builtins.str]] = None,
                 map: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateTagArgs', 'DomainsOauthPartnerCertificateTagArgsDict']]]]] = None,
                 x509base64certificate: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the O Auth Partner Certificate resource in Oracle Cloud Infrastructure Identity Domains service.

        Create an OAuth Partner Certificate

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oauth_partner_certificate = oci.identity.DomainsOauthPartnerCertificate("test_oauth_partner_certificate",
            certificate_alias=oauth_partner_certificate_certificate_alias,
            idcs_endpoint=test_domain["url"],
            schemas=["urn:ietf:params:scim:schemas:oracle:idcs:OAuthPartnerCertificate"],
            authorization=oauth_partner_certificate_authorization,
            external_id="externalId",
            key_store_id=test_key_store["id"],
            key_store_name=test_key_store["name"],
            key_store_password=oauth_partner_certificate_key_store_password,
            map=oauth_partner_certificate_map,
            ocid=oauth_partner_certificate_ocid,
            resource_type_schema_version=oauth_partner_certificate_resource_type_schema_version,
            tags=[{
                "key": oauth_partner_certificate_tags_key,
                "value": oauth_partner_certificate_tags_value,
            }],
            x509base64certificate=oauth_partner_certificate_x509base64certificate)
        ```

        ## Import

        OAuthPartnerCertificates can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsOauthPartnerCertificate:DomainsOauthPartnerCertificate test_oauth_partner_certificate "idcsEndpoint/{idcsEndpoint}/oAuthPartnerCertificates/{oAuthPartnerCertificateId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] certificate_alias: Certificate alias
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: always
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[builtins.str] external_id: An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[builtins.str] key_store_id: Key store ID
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: true
               * returned: never
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[builtins.str] key_store_name: Key store name
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * returned: always
               * uniqueness: none
        :param pulumi.Input[builtins.str] key_store_password: Key store password
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * idcsSensitive: none
               * required: false
               * caseExact: true
               * returned: never
               * uniqueness: none
        :param pulumi.Input[builtins.str] map: Map
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * returned: always
               * uniqueness: none
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateTagArgs', 'DomainsOauthPartnerCertificateTagArgsDict']]]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] x509base64certificate: Base 64Key data attribute
               
               **SCIM++ Properties:**
               * caseExact: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsOauthPartnerCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the O Auth Partner Certificate resource in Oracle Cloud Infrastructure Identity Domains service.

        Create an OAuth Partner Certificate

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_oauth_partner_certificate = oci.identity.DomainsOauthPartnerCertificate("test_oauth_partner_certificate",
            certificate_alias=oauth_partner_certificate_certificate_alias,
            idcs_endpoint=test_domain["url"],
            schemas=["urn:ietf:params:scim:schemas:oracle:idcs:OAuthPartnerCertificate"],
            authorization=oauth_partner_certificate_authorization,
            external_id="externalId",
            key_store_id=test_key_store["id"],
            key_store_name=test_key_store["name"],
            key_store_password=oauth_partner_certificate_key_store_password,
            map=oauth_partner_certificate_map,
            ocid=oauth_partner_certificate_ocid,
            resource_type_schema_version=oauth_partner_certificate_resource_type_schema_version,
            tags=[{
                "key": oauth_partner_certificate_tags_key,
                "value": oauth_partner_certificate_tags_value,
            }],
            x509base64certificate=oauth_partner_certificate_x509base64certificate)
        ```

        ## Import

        OAuthPartnerCertificates can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsOauthPartnerCertificate:DomainsOauthPartnerCertificate test_oauth_partner_certificate "idcsEndpoint/{idcsEndpoint}/oAuthPartnerCertificates/{oAuthPartnerCertificateId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsOauthPartnerCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsOauthPartnerCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorization: Optional[pulumi.Input[builtins.str]] = None,
                 certificate_alias: Optional[pulumi.Input[builtins.str]] = None,
                 external_id: Optional[pulumi.Input[builtins.str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_id: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_name: Optional[pulumi.Input[builtins.str]] = None,
                 key_store_password: Optional[pulumi.Input[builtins.str]] = None,
                 map: Optional[pulumi.Input[builtins.str]] = None,
                 ocid: Optional[pulumi.Input[builtins.str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateTagArgs', 'DomainsOauthPartnerCertificateTagArgsDict']]]]] = None,
                 x509base64certificate: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsOauthPartnerCertificateArgs.__new__(DomainsOauthPartnerCertificateArgs)

            __props__.__dict__["authorization"] = authorization
            if certificate_alias is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_alias'")
            __props__.__dict__["certificate_alias"] = certificate_alias
            __props__.__dict__["external_id"] = external_id
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["key_store_id"] = key_store_id
            __props__.__dict__["key_store_name"] = key_store_name
            __props__.__dict__["key_store_password"] = None if key_store_password is None else pulumi.Output.secret(key_store_password)
            __props__.__dict__["map"] = map
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tags"] = tags
            __props__.__dict__["x509base64certificate"] = x509base64certificate
            __props__.__dict__["cert_end_date"] = None
            __props__.__dict__["cert_start_date"] = None
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["sha1thumbprint"] = None
            __props__.__dict__["sha256thumbprint"] = None
            __props__.__dict__["tenancy_ocid"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["keyStorePassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DomainsOauthPartnerCertificate, __self__).__init__(
            'oci:Identity/domainsOauthPartnerCertificate:DomainsOauthPartnerCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorization: Optional[pulumi.Input[builtins.str]] = None,
            cert_end_date: Optional[pulumi.Input[builtins.str]] = None,
            cert_start_date: Optional[pulumi.Input[builtins.str]] = None,
            certificate_alias: Optional[pulumi.Input[builtins.str]] = None,
            compartment_ocid: Optional[pulumi.Input[builtins.str]] = None,
            delete_in_progress: Optional[pulumi.Input[builtins.bool]] = None,
            domain_ocid: Optional[pulumi.Input[builtins.str]] = None,
            external_id: Optional[pulumi.Input[builtins.str]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateIdcsCreatedByArgs', 'DomainsOauthPartnerCertificateIdcsCreatedByArgsDict']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[builtins.str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateIdcsLastModifiedByArgs', 'DomainsOauthPartnerCertificateIdcsLastModifiedByArgsDict']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[builtins.str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            key_store_id: Optional[pulumi.Input[builtins.str]] = None,
            key_store_name: Optional[pulumi.Input[builtins.str]] = None,
            key_store_password: Optional[pulumi.Input[builtins.str]] = None,
            map: Optional[pulumi.Input[builtins.str]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateMetaArgs', 'DomainsOauthPartnerCertificateMetaArgsDict']]]]] = None,
            ocid: Optional[pulumi.Input[builtins.str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[builtins.str]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            sha1thumbprint: Optional[pulumi.Input[builtins.str]] = None,
            sha256thumbprint: Optional[pulumi.Input[builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateTagArgs', 'DomainsOauthPartnerCertificateTagArgsDict']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[builtins.str]] = None,
            x509base64certificate: Optional[pulumi.Input[builtins.str]] = None) -> 'DomainsOauthPartnerCertificate':
        """
        Get an existing DomainsOauthPartnerCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] authorization: The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[builtins.str] cert_end_date: (Updatable) Certificate end date
               
               **SCIM++ Properties:**
               * type: dateTime
               * multiValued: false
               * required: false
               * caseExact: true
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[builtins.str] cert_start_date: (Updatable) Certificate start date
               
               **SCIM++ Properties:**
               * type: dateTime
               * multiValued: false
               * required: false
               * caseExact: true
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[builtins.str] certificate_alias: Certificate alias
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: true
               * caseExact: false
               * mutability: readWrite
               * returned: always
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[builtins.str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[builtins.str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] external_id: An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * mutability: readWrite
               * returned: default
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateIdcsCreatedByArgs', 'DomainsOauthPartnerCertificateIdcsCreatedByArgsDict']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateIdcsLastModifiedByArgs', 'DomainsOauthPartnerCertificateIdcsLastModifiedByArgsDict']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[builtins.str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] key_store_id: Key store ID
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: true
               * returned: never
               * uniqueness: none
               * idcsSearchable: true
        :param pulumi.Input[builtins.str] key_store_name: Key store name
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * returned: always
               * uniqueness: none
        :param pulumi.Input[builtins.str] key_store_password: Key store password
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * idcsSensitive: none
               * required: false
               * caseExact: true
               * returned: never
               * uniqueness: none
        :param pulumi.Input[builtins.str] map: Map
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: false
               * returned: always
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateMetaArgs', 'DomainsOauthPartnerCertificateMetaArgsDict']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[builtins.str] ocid: Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: immutable
               * required: false
               * returned: default
               * type: string
               * uniqueness: global
        :param pulumi.Input[builtins.str] resource_type_schema_version: An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] schemas: REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] sha1thumbprint: (Updatable) SHA-1 Thumbprint
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: true
               * returned: default
               * idcsSearchable: true
               * uniqueness: none
        :param pulumi.Input[builtins.str] sha256thumbprint: (Updatable) SHA-256 Thumbprint
               
               **SCIM++ Properties:**
               * type: string
               * multiValued: false
               * required: false
               * caseExact: true
               * returned: default
               * idcsSearchable: true
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[Union['DomainsOauthPartnerCertificateTagArgs', 'DomainsOauthPartnerCertificateTagArgsDict']]]] tags: A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[builtins.str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[builtins.str] x509base64certificate: Base 64Key data attribute
               
               **SCIM++ Properties:**
               * caseExact: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsOauthPartnerCertificateState.__new__(_DomainsOauthPartnerCertificateState)

        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["cert_end_date"] = cert_end_date
        __props__.__dict__["cert_start_date"] = cert_start_date
        __props__.__dict__["certificate_alias"] = certificate_alias
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["key_store_id"] = key_store_id
        __props__.__dict__["key_store_name"] = key_store_name
        __props__.__dict__["key_store_password"] = key_store_password
        __props__.__dict__["map"] = map
        __props__.__dict__["metas"] = metas
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["sha1thumbprint"] = sha1thumbprint
        __props__.__dict__["sha256thumbprint"] = sha256thumbprint
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["x509base64certificate"] = x509base64certificate
        return DomainsOauthPartnerCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="certEndDate")
    def cert_end_date(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Certificate end date

        **SCIM++ Properties:**
        * type: dateTime
        * multiValued: false
        * required: false
        * caseExact: true
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "cert_end_date")

    @property
    @pulumi.getter(name="certStartDate")
    def cert_start_date(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Certificate start date

        **SCIM++ Properties:**
        * type: dateTime
        * multiValued: false
        * required: false
        * caseExact: true
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "cert_start_date")

    @property
    @pulumi.getter(name="certificateAlias")
    def certificate_alias(self) -> pulumi.Output[builtins.str]:
        """
        Certificate alias

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: true
        * caseExact: false
        * mutability: readWrite
        * returned: always
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "certificate_alias")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[builtins.str]:
        """
        An identifier for the Resource as defined by the Service Consumer. The externalId may simplify identification of the Resource between Service Consumer and Service Provider by allowing the Consumer to refer to the Resource with its own identifier, obviating the need to store a local mapping between the local identifier of the Resource and the identifier used by the Service Provider. Each Resource MAY include a non-empty externalId value. The value of the externalId attribute is always issued by the Service Consumer and can never be specified by the Service Provider. The Service Provider MUST always interpret the externalId as scoped to the Service Consumer's tenant.

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * mutability: readWrite
        * returned: default
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsOauthPartnerCertificateIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[builtins.str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsOauthPartnerCertificateIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter(name="keyStoreId")
    def key_store_id(self) -> pulumi.Output[builtins.str]:
        """
        Key store ID

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: true
        * returned: never
        * uniqueness: none
        * idcsSearchable: true
        """
        return pulumi.get(self, "key_store_id")

    @property
    @pulumi.getter(name="keyStoreName")
    def key_store_name(self) -> pulumi.Output[builtins.str]:
        """
        Key store name

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * returned: always
        * uniqueness: none
        """
        return pulumi.get(self, "key_store_name")

    @property
    @pulumi.getter(name="keyStorePassword")
    def key_store_password(self) -> pulumi.Output[builtins.str]:
        """
        Key store password

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * idcsSensitive: none
        * required: false
        * caseExact: true
        * returned: never
        * uniqueness: none
        """
        return pulumi.get(self, "key_store_password")

    @property
    @pulumi.getter
    def map(self) -> pulumi.Output[builtins.str]:
        """
        Map

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: false
        * returned: always
        * uniqueness: none
        """
        return pulumi.get(self, "map")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsOauthPartnerCertificateMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[builtins.str]:
        """
        Unique Oracle Cloud Infrastructure identifier for the SCIM Resource.

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: immutable
        * required: false
        * returned: default
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def sha1thumbprint(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) SHA-1 Thumbprint

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: true
        * returned: default
        * idcsSearchable: true
        * uniqueness: none
        """
        return pulumi.get(self, "sha1thumbprint")

    @property
    @pulumi.getter
    def sha256thumbprint(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) SHA-256 Thumbprint

        **SCIM++ Properties:**
        * type: string
        * multiValued: false
        * required: false
        * caseExact: true
        * returned: default
        * idcsSearchable: true
        * uniqueness: none
        """
        return pulumi.get(self, "sha256thumbprint")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsOauthPartnerCertificateTag']]:
        """
        A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter
    def x509base64certificate(self) -> pulumi.Output[builtins.str]:
        """
        Base 64Key data attribute

        **SCIM++ Properties:**
        * caseExact: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "x509base64certificate")

