# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCostTrackingTagsResult',
    'AwaitableGetCostTrackingTagsResult',
    'get_cost_tracking_tags',
    'get_cost_tracking_tags_output',
]

@pulumi.output_type
class GetCostTrackingTagsResult:
    """
    A collection of values returned by getCostTrackingTags.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, tags=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment that contains the tag definition.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCostTrackingTagsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetCostTrackingTagsTagResult']:
        """
        The list of tags.
        """
        return pulumi.get(self, "tags")


class AwaitableGetCostTrackingTagsResult(GetCostTrackingTagsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCostTrackingTagsResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            tags=self.tags)


def get_cost_tracking_tags(compartment_id: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetCostTrackingTagsFilterArgs', 'GetCostTrackingTagsFilterArgsDict']]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCostTrackingTagsResult:
    """
    This data source provides the list of Cost Tracking Tags in Oracle Cloud Infrastructure Identity service.

    Lists all the tags enabled for cost-tracking in the specified tenancy. For information about
    cost-tracking tags, see [Using Cost-tracking Tags](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/taggingoverview.htm#costs).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cost_tracking_tags = oci.Identity.get_cost_tracking_tags(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Identity/getCostTrackingTags:getCostTrackingTags', __args__, opts=opts, typ=GetCostTrackingTagsResult).value

    return AwaitableGetCostTrackingTagsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        tags=pulumi.get(__ret__, 'tags'))
def get_cost_tracking_tags_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCostTrackingTagsFilterArgs', 'GetCostTrackingTagsFilterArgsDict']]]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCostTrackingTagsResult]:
    """
    This data source provides the list of Cost Tracking Tags in Oracle Cloud Infrastructure Identity service.

    Lists all the tags enabled for cost-tracking in the specified tenancy. For information about
    cost-tracking tags, see [Using Cost-tracking Tags](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/taggingoverview.htm#costs).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_cost_tracking_tags = oci.Identity.get_cost_tracking_tags(compartment_id=compartment_id)
    ```


    :param builtins.str compartment_id: The OCID of the compartment (remember that the tenancy is simply the root compartment).
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Identity/getCostTrackingTags:getCostTrackingTags', __args__, opts=opts, typ=GetCostTrackingTagsResult)
    return __ret__.apply(lambda __response__: GetCostTrackingTagsResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        tags=pulumi.get(__response__, 'tags')))
