# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetJmsPluginResult',
    'AwaitableGetJmsPluginResult',
    'get_jms_plugin',
    'get_jms_plugin_output',
]

@pulumi.output_type
class GetJmsPluginResult:
    """
    A collection of values returned by getJmsPlugin.
    """
    def __init__(__self__, agent_id=None, agent_type=None, availability_status=None, compartment_id=None, defined_tags=None, fleet_id=None, freeform_tags=None, hostname=None, id=None, jms_plugin_id=None, os_architecture=None, os_distribution=None, os_family=None, plugin_version=None, state=None, system_tags=None, time_last_seen=None, time_registered=None):
        if agent_id and not isinstance(agent_id, str):
            raise TypeError("Expected argument 'agent_id' to be a str")
        pulumi.set(__self__, "agent_id", agent_id)
        if agent_type and not isinstance(agent_type, str):
            raise TypeError("Expected argument 'agent_type' to be a str")
        pulumi.set(__self__, "agent_type", agent_type)
        if availability_status and not isinstance(availability_status, str):
            raise TypeError("Expected argument 'availability_status' to be a str")
        pulumi.set(__self__, "availability_status", availability_status)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jms_plugin_id and not isinstance(jms_plugin_id, str):
            raise TypeError("Expected argument 'jms_plugin_id' to be a str")
        pulumi.set(__self__, "jms_plugin_id", jms_plugin_id)
        if os_architecture and not isinstance(os_architecture, str):
            raise TypeError("Expected argument 'os_architecture' to be a str")
        pulumi.set(__self__, "os_architecture", os_architecture)
        if os_distribution and not isinstance(os_distribution, str):
            raise TypeError("Expected argument 'os_distribution' to be a str")
        pulumi.set(__self__, "os_distribution", os_distribution)
        if os_family and not isinstance(os_family, str):
            raise TypeError("Expected argument 'os_family' to be a str")
        pulumi.set(__self__, "os_family", os_family)
        if plugin_version and not isinstance(plugin_version, str):
            raise TypeError("Expected argument 'plugin_version' to be a str")
        pulumi.set(__self__, "plugin_version", plugin_version)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_last_seen and not isinstance(time_last_seen, str):
            raise TypeError("Expected argument 'time_last_seen' to be a str")
        pulumi.set(__self__, "time_last_seen", time_last_seen)
        if time_registered and not isinstance(time_registered, str):
            raise TypeError("Expected argument 'time_registered' to be a str")
        pulumi.set(__self__, "time_registered", time_registered)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Management Agent (OMA) or the Oracle Cloud Agent (OCA) instance where the JMS plugin is deployed.
        """
        return pulumi.get(self, "agent_id")

    @property
    @pulumi.getter(name="agentType")
    def agent_type(self) -> builtins.str:
        """
        The agent type.
        """
        return pulumi.get(self, "agent_type")

    @property
    @pulumi.getter(name="availabilityStatus")
    def availability_status(self) -> builtins.str:
        """
        The availability status.
        """
        return pulumi.get(self, "availability_status")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OMA/OCA agent's compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the fleet.
        """
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> builtins.str:
        """
        The hostname of the agent.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to identify this JmsPlugin.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jmsPluginId")
    def jms_plugin_id(self) -> builtins.str:
        return pulumi.get(self, "jms_plugin_id")

    @property
    @pulumi.getter(name="osArchitecture")
    def os_architecture(self) -> builtins.str:
        """
        The architecture of the operating system of the plugin.
        """
        return pulumi.get(self, "os_architecture")

    @property
    @pulumi.getter(name="osDistribution")
    def os_distribution(self) -> builtins.str:
        """
        The distribution of the operating system of the plugin.
        """
        return pulumi.get(self, "os_distribution")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> builtins.str:
        """
        The operating system family for the plugin.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="pluginVersion")
    def plugin_version(self) -> builtins.str:
        """
        The version of the plugin.
        """
        return pulumi.get(self, "plugin_version")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The lifecycle state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeLastSeen")
    def time_last_seen(self) -> builtins.str:
        """
        The date and time the resource was _last_ reported to JMS. This is potentially _after_ the specified time period provided by the filters. For example, a resource can be last reported to JMS before the start of a specified time period, if it is also reported during the time period.
        """
        return pulumi.get(self, "time_last_seen")

    @property
    @pulumi.getter(name="timeRegistered")
    def time_registered(self) -> builtins.str:
        """
        The date and time the plugin was registered.
        """
        return pulumi.get(self, "time_registered")


class AwaitableGetJmsPluginResult(GetJmsPluginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJmsPluginResult(
            agent_id=self.agent_id,
            agent_type=self.agent_type,
            availability_status=self.availability_status,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            fleet_id=self.fleet_id,
            freeform_tags=self.freeform_tags,
            hostname=self.hostname,
            id=self.id,
            jms_plugin_id=self.jms_plugin_id,
            os_architecture=self.os_architecture,
            os_distribution=self.os_distribution,
            os_family=self.os_family,
            plugin_version=self.plugin_version,
            state=self.state,
            system_tags=self.system_tags,
            time_last_seen=self.time_last_seen,
            time_registered=self.time_registered)


def get_jms_plugin(jms_plugin_id: Optional[builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJmsPluginResult:
    """
    This data source provides details about a specific Jms Plugin resource in Oracle Cloud Infrastructure Jms service.

    Returns the JmsPlugin.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_jms_plugin = oci.Jms.get_jms_plugin(jms_plugin_id=test_jms_plugin_oci_jms_jms_plugin["id"])
    ```


    :param builtins.str jms_plugin_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the JmsPlugin.
    """
    __args__ = dict()
    __args__['jmsPluginId'] = jms_plugin_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJmsPlugin:getJmsPlugin', __args__, opts=opts, typ=GetJmsPluginResult).value

    return AwaitableGetJmsPluginResult(
        agent_id=pulumi.get(__ret__, 'agent_id'),
        agent_type=pulumi.get(__ret__, 'agent_type'),
        availability_status=pulumi.get(__ret__, 'availability_status'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        hostname=pulumi.get(__ret__, 'hostname'),
        id=pulumi.get(__ret__, 'id'),
        jms_plugin_id=pulumi.get(__ret__, 'jms_plugin_id'),
        os_architecture=pulumi.get(__ret__, 'os_architecture'),
        os_distribution=pulumi.get(__ret__, 'os_distribution'),
        os_family=pulumi.get(__ret__, 'os_family'),
        plugin_version=pulumi.get(__ret__, 'plugin_version'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_last_seen=pulumi.get(__ret__, 'time_last_seen'),
        time_registered=pulumi.get(__ret__, 'time_registered'))
def get_jms_plugin_output(jms_plugin_id: Optional[pulumi.Input[builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetJmsPluginResult]:
    """
    This data source provides details about a specific Jms Plugin resource in Oracle Cloud Infrastructure Jms service.

    Returns the JmsPlugin.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_jms_plugin = oci.Jms.get_jms_plugin(jms_plugin_id=test_jms_plugin_oci_jms_jms_plugin["id"])
    ```


    :param builtins.str jms_plugin_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the JmsPlugin.
    """
    __args__ = dict()
    __args__['jmsPluginId'] = jms_plugin_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getJmsPlugin:getJmsPlugin', __args__, opts=opts, typ=GetJmsPluginResult)
    return __ret__.apply(lambda __response__: GetJmsPluginResult(
        agent_id=pulumi.get(__response__, 'agent_id'),
        agent_type=pulumi.get(__response__, 'agent_type'),
        availability_status=pulumi.get(__response__, 'availability_status'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        hostname=pulumi.get(__response__, 'hostname'),
        id=pulumi.get(__response__, 'id'),
        jms_plugin_id=pulumi.get(__response__, 'jms_plugin_id'),
        os_architecture=pulumi.get(__response__, 'os_architecture'),
        os_distribution=pulumi.get(__response__, 'os_distribution'),
        os_family=pulumi.get(__response__, 'os_family'),
        plugin_version=pulumi.get(__response__, 'plugin_version'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_last_seen=pulumi.get(__response__, 'time_last_seen'),
        time_registered=pulumi.get(__response__, 'time_registered')))
