# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ProductLicenseArgs', 'ProductLicense']

@pulumi.input_type
class ProductLicenseArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 is_vendor_oracle: pulumi.Input[builtins.bool],
                 license_unit: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['ProductLicenseImageArgs']]]] = None,
                 vendor_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a ProductLicense resource.
        :param pulumi.Input[builtins.str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where product licenses are created.
        :param pulumi.Input[builtins.str] display_name: Name of the product license.
        :param pulumi.Input[builtins.bool] is_vendor_oracle: Specifies if the product license vendor is Oracle or a third party.
        :param pulumi.Input[builtins.str] license_unit: The product license unit.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['ProductLicenseImageArgs']]] images: (Updatable) The image details associated with the product license.
        :param pulumi.Input[builtins.str] vendor_name: The product license vendor name, for example: Microsoft, RHEL, and so on. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_vendor_oracle", is_vendor_oracle)
        pulumi.set(__self__, "license_unit", license_unit)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if vendor_name is not None:
            pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where product licenses are created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Name of the product license.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="isVendorOracle")
    def is_vendor_oracle(self) -> pulumi.Input[builtins.bool]:
        """
        Specifies if the product license vendor is Oracle or a third party.
        """
        return pulumi.get(self, "is_vendor_oracle")

    @is_vendor_oracle.setter
    def is_vendor_oracle(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_vendor_oracle", value)

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> pulumi.Input[builtins.str]:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @license_unit.setter
    def license_unit(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "license_unit", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProductLicenseImageArgs']]]]:
        """
        (Updatable) The image details associated with the product license.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProductLicenseImageArgs']]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The product license vendor name, for example: Microsoft, RHEL, and so on. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vendor_name", value)


@pulumi.input_type
class _ProductLicenseState:
    def __init__(__self__, *,
                 active_license_record_count: Optional[pulumi.Input[builtins.int]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input['ProductLicenseImageArgs']]]] = None,
                 is_over_subscribed: Optional[pulumi.Input[builtins.bool]] = None,
                 is_unlimited: Optional[pulumi.Input[builtins.bool]] = None,
                 is_vendor_oracle: Optional[pulumi.Input[builtins.bool]] = None,
                 license_unit: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 status_description: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 total_active_license_unit_count: Optional[pulumi.Input[builtins.int]] = None,
                 total_license_record_count: Optional[pulumi.Input[builtins.int]] = None,
                 total_license_units_consumed: Optional[pulumi.Input[builtins.float]] = None,
                 vendor_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ProductLicense resources.
        :param pulumi.Input[builtins.int] active_license_record_count: The number of active license records associated with the product license.
        :param pulumi.Input[builtins.str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where product licenses are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: Name of the product license.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['ProductLicenseImageArgs']]] images: (Updatable) The image details associated with the product license.
        :param pulumi.Input[builtins.bool] is_over_subscribed: Specifies whether or not the product license is oversubscribed.
        :param pulumi.Input[builtins.bool] is_unlimited: Specifies if the license unit count is unlimited.
        :param pulumi.Input[builtins.bool] is_vendor_oracle: Specifies if the product license vendor is Oracle or a third party.
        :param pulumi.Input[builtins.str] license_unit: The product license unit.
        :param pulumi.Input[builtins.str] state: The current product license state.
        :param pulumi.Input[builtins.str] status: The current product license status.
        :param pulumi.Input[builtins.str] status_description: Status description for the current product license status.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param pulumi.Input[builtins.int] total_active_license_unit_count: The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        :param pulumi.Input[builtins.int] total_license_record_count: The number of license records associated with the product license.
        :param pulumi.Input[builtins.float] total_license_units_consumed: The number of license units consumed. Updated after each allocation run.
        :param pulumi.Input[builtins.str] vendor_name: The product license vendor name, for example: Microsoft, RHEL, and so on. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if active_license_record_count is not None:
            pulumi.set(__self__, "active_license_record_count", active_license_record_count)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if images is not None:
            pulumi.set(__self__, "images", images)
        if is_over_subscribed is not None:
            pulumi.set(__self__, "is_over_subscribed", is_over_subscribed)
        if is_unlimited is not None:
            pulumi.set(__self__, "is_unlimited", is_unlimited)
        if is_vendor_oracle is not None:
            pulumi.set(__self__, "is_vendor_oracle", is_vendor_oracle)
        if license_unit is not None:
            pulumi.set(__self__, "license_unit", license_unit)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_description is not None:
            pulumi.set(__self__, "status_description", status_description)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_active_license_unit_count is not None:
            pulumi.set(__self__, "total_active_license_unit_count", total_active_license_unit_count)
        if total_license_record_count is not None:
            pulumi.set(__self__, "total_license_record_count", total_license_record_count)
        if total_license_units_consumed is not None:
            pulumi.set(__self__, "total_license_units_consumed", total_license_units_consumed)
        if vendor_name is not None:
            pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="activeLicenseRecordCount")
    def active_license_record_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of active license records associated with the product license.
        """
        return pulumi.get(self, "active_license_record_count")

    @active_license_record_count.setter
    def active_license_record_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "active_license_record_count", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where product licenses are created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name of the product license.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def images(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProductLicenseImageArgs']]]]:
        """
        (Updatable) The image details associated with the product license.
        """
        return pulumi.get(self, "images")

    @images.setter
    def images(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProductLicenseImageArgs']]]]):
        pulumi.set(self, "images", value)

    @property
    @pulumi.getter(name="isOverSubscribed")
    def is_over_subscribed(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies whether or not the product license is oversubscribed.
        """
        return pulumi.get(self, "is_over_subscribed")

    @is_over_subscribed.setter
    def is_over_subscribed(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_over_subscribed", value)

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the license unit count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @is_unlimited.setter
    def is_unlimited(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_unlimited", value)

    @property
    @pulumi.getter(name="isVendorOracle")
    def is_vendor_oracle(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Specifies if the product license vendor is Oracle or a third party.
        """
        return pulumi.get(self, "is_vendor_oracle")

    @is_vendor_oracle.setter
    def is_vendor_oracle(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_vendor_oracle", value)

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @license_unit.setter
    def license_unit(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "license_unit", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current product license state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current product license status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusDescription")
    def status_description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Status description for the current product license status.
        """
        return pulumi.get(self, "status_description")

    @status_description.setter
    def status_description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status_description", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalActiveLicenseUnitCount")
    def total_active_license_unit_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        """
        return pulumi.get(self, "total_active_license_unit_count")

    @total_active_license_unit_count.setter
    def total_active_license_unit_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_active_license_unit_count", value)

    @property
    @pulumi.getter(name="totalLicenseRecordCount")
    def total_license_record_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of license records associated with the product license.
        """
        return pulumi.get(self, "total_license_record_count")

    @total_license_record_count.setter
    def total_license_record_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_license_record_count", value)

    @property
    @pulumi.getter(name="totalLicenseUnitsConsumed")
    def total_license_units_consumed(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The number of license units consumed. Updated after each allocation run.
        """
        return pulumi.get(self, "total_license_units_consumed")

    @total_license_units_consumed.setter
    def total_license_units_consumed(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "total_license_units_consumed", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The product license vendor name, for example: Microsoft, RHEL, and so on. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vendor_name", value)


class ProductLicense(pulumi.CustomResource):

    pulumi_type = "oci:LicenseManager/productLicense:ProductLicense"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProductLicenseImageArgs', 'ProductLicenseImageArgsDict']]]]] = None,
                 is_vendor_oracle: Optional[pulumi.Input[builtins.bool]] = None,
                 license_unit: Optional[pulumi.Input[builtins.str]] = None,
                 vendor_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Product License resource in Oracle Cloud Infrastructure License Manager service.

        Creates a new product license.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_product_license = oci.license_manager.ProductLicense("test_product_license",
            compartment_id=compartment_id,
            display_name=product_license_display_name,
            is_vendor_oracle=product_license_is_vendor_oracle,
            license_unit=product_license_license_unit,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            images=[{
                "listing_id": test_listing["id"],
                "package_version": product_license_images_package_version,
            }],
            vendor_name=product_license_vendor_name)
        ```

        ## Import

        ProductLicenses can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LicenseManager/productLicense:ProductLicense test_product_license "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where product licenses are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: Name of the product license.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProductLicenseImageArgs', 'ProductLicenseImageArgsDict']]]] images: (Updatable) The image details associated with the product license.
        :param pulumi.Input[builtins.bool] is_vendor_oracle: Specifies if the product license vendor is Oracle or a third party.
        :param pulumi.Input[builtins.str] license_unit: The product license unit.
        :param pulumi.Input[builtins.str] vendor_name: The product license vendor name, for example: Microsoft, RHEL, and so on. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProductLicenseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Product License resource in Oracle Cloud Infrastructure License Manager service.

        Creates a new product license.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_product_license = oci.license_manager.ProductLicense("test_product_license",
            compartment_id=compartment_id,
            display_name=product_license_display_name,
            is_vendor_oracle=product_license_is_vendor_oracle,
            license_unit=product_license_license_unit,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            images=[{
                "listing_id": test_listing["id"],
                "package_version": product_license_images_package_version,
            }],
            vendor_name=product_license_vendor_name)
        ```

        ## Import

        ProductLicenses can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LicenseManager/productLicense:ProductLicense test_product_license "id"
        ```

        :param str resource_name: The name of the resource.
        :param ProductLicenseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProductLicenseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProductLicenseImageArgs', 'ProductLicenseImageArgsDict']]]]] = None,
                 is_vendor_oracle: Optional[pulumi.Input[builtins.bool]] = None,
                 license_unit: Optional[pulumi.Input[builtins.str]] = None,
                 vendor_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProductLicenseArgs.__new__(ProductLicenseArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["images"] = images
            if is_vendor_oracle is None and not opts.urn:
                raise TypeError("Missing required property 'is_vendor_oracle'")
            __props__.__dict__["is_vendor_oracle"] = is_vendor_oracle
            if license_unit is None and not opts.urn:
                raise TypeError("Missing required property 'license_unit'")
            __props__.__dict__["license_unit"] = license_unit
            __props__.__dict__["vendor_name"] = vendor_name
            __props__.__dict__["active_license_record_count"] = None
            __props__.__dict__["is_over_subscribed"] = None
            __props__.__dict__["is_unlimited"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["status_description"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["total_active_license_unit_count"] = None
            __props__.__dict__["total_license_record_count"] = None
            __props__.__dict__["total_license_units_consumed"] = None
        super(ProductLicense, __self__).__init__(
            'oci:LicenseManager/productLicense:ProductLicense',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_license_record_count: Optional[pulumi.Input[builtins.int]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            images: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ProductLicenseImageArgs', 'ProductLicenseImageArgsDict']]]]] = None,
            is_over_subscribed: Optional[pulumi.Input[builtins.bool]] = None,
            is_unlimited: Optional[pulumi.Input[builtins.bool]] = None,
            is_vendor_oracle: Optional[pulumi.Input[builtins.bool]] = None,
            license_unit: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            status_description: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            total_active_license_unit_count: Optional[pulumi.Input[builtins.int]] = None,
            total_license_record_count: Optional[pulumi.Input[builtins.int]] = None,
            total_license_units_consumed: Optional[pulumi.Input[builtins.float]] = None,
            vendor_name: Optional[pulumi.Input[builtins.str]] = None) -> 'ProductLicense':
        """
        Get an existing ProductLicense resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] active_license_record_count: The number of active license records associated with the product license.
        :param pulumi.Input[builtins.str] compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where product licenses are created.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: Name of the product license.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['ProductLicenseImageArgs', 'ProductLicenseImageArgsDict']]]] images: (Updatable) The image details associated with the product license.
        :param pulumi.Input[builtins.bool] is_over_subscribed: Specifies whether or not the product license is oversubscribed.
        :param pulumi.Input[builtins.bool] is_unlimited: Specifies if the license unit count is unlimited.
        :param pulumi.Input[builtins.bool] is_vendor_oracle: Specifies if the product license vendor is Oracle or a third party.
        :param pulumi.Input[builtins.str] license_unit: The product license unit.
        :param pulumi.Input[builtins.str] state: The current product license state.
        :param pulumi.Input[builtins.str] status: The current product license status.
        :param pulumi.Input[builtins.str] status_description: Status description for the current product license status.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param pulumi.Input[builtins.str] time_updated: The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        :param pulumi.Input[builtins.int] total_active_license_unit_count: The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        :param pulumi.Input[builtins.int] total_license_record_count: The number of license records associated with the product license.
        :param pulumi.Input[builtins.float] total_license_units_consumed: The number of license units consumed. Updated after each allocation run.
        :param pulumi.Input[builtins.str] vendor_name: The product license vendor name, for example: Microsoft, RHEL, and so on. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProductLicenseState.__new__(_ProductLicenseState)

        __props__.__dict__["active_license_record_count"] = active_license_record_count
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["images"] = images
        __props__.__dict__["is_over_subscribed"] = is_over_subscribed
        __props__.__dict__["is_unlimited"] = is_unlimited
        __props__.__dict__["is_vendor_oracle"] = is_vendor_oracle
        __props__.__dict__["license_unit"] = license_unit
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["status_description"] = status_description
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_active_license_unit_count"] = total_active_license_unit_count
        __props__.__dict__["total_license_record_count"] = total_license_record_count
        __props__.__dict__["total_license_units_consumed"] = total_license_units_consumed
        __props__.__dict__["vendor_name"] = vendor_name
        return ProductLicense(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeLicenseRecordCount")
    def active_license_record_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of active license records associated with the product license.
        """
        return pulumi.get(self, "active_license_record_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) where product licenses are created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Name of the product license.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def images(self) -> pulumi.Output[Sequence['outputs.ProductLicenseImage']]:
        """
        (Updatable) The image details associated with the product license.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="isOverSubscribed")
    def is_over_subscribed(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies whether or not the product license is oversubscribed.
        """
        return pulumi.get(self, "is_over_subscribed")

    @property
    @pulumi.getter(name="isUnlimited")
    def is_unlimited(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies if the license unit count is unlimited.
        """
        return pulumi.get(self, "is_unlimited")

    @property
    @pulumi.getter(name="isVendorOracle")
    def is_vendor_oracle(self) -> pulumi.Output[builtins.bool]:
        """
        Specifies if the product license vendor is Oracle or a third party.
        """
        return pulumi.get(self, "is_vendor_oracle")

    @property
    @pulumi.getter(name="licenseUnit")
    def license_unit(self) -> pulumi.Output[builtins.str]:
        """
        The product license unit.
        """
        return pulumi.get(self, "license_unit")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current product license state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The current product license status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDescription")
    def status_description(self) -> pulumi.Output[builtins.str]:
        """
        Status description for the current product license status.
        """
        return pulumi.get(self, "status_description")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the product license was created. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the product license was updated. An [RFC 3339](https://tools.ietf.org/html/rfc3339)-formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalActiveLicenseUnitCount")
    def total_active_license_unit_count(self) -> pulumi.Output[builtins.int]:
        """
        The total number of licenses available for the product license, calculated by adding up all the license counts for active license records associated with the product license.
        """
        return pulumi.get(self, "total_active_license_unit_count")

    @property
    @pulumi.getter(name="totalLicenseRecordCount")
    def total_license_record_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of license records associated with the product license.
        """
        return pulumi.get(self, "total_license_record_count")

    @property
    @pulumi.getter(name="totalLicenseUnitsConsumed")
    def total_license_units_consumed(self) -> pulumi.Output[builtins.float]:
        """
        The number of license units consumed. Updated after each allocation run.
        """
        return pulumi.get(self, "total_license_units_consumed")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> pulumi.Output[builtins.str]:
        """
        The product license vendor name, for example: Microsoft, RHEL, and so on. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

