# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetLogAnalyticsEntitiesSummaryResult',
    'AwaitableGetLogAnalyticsEntitiesSummaryResult',
    'get_log_analytics_entities_summary',
    'get_log_analytics_entities_summary_output',
]

@pulumi.output_type
class GetLogAnalyticsEntitiesSummaryResult:
    """
    A collection of values returned by getLogAnalyticsEntitiesSummary.
    """
    def __init__(__self__, active_entities_count=None, compartment_id=None, entities_with_has_logs_collected_count=None, entities_with_management_agent_count=None, id=None, namespace=None):
        if active_entities_count and not isinstance(active_entities_count, int):
            raise TypeError("Expected argument 'active_entities_count' to be a int")
        pulumi.set(__self__, "active_entities_count", active_entities_count)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if entities_with_has_logs_collected_count and not isinstance(entities_with_has_logs_collected_count, int):
            raise TypeError("Expected argument 'entities_with_has_logs_collected_count' to be a int")
        pulumi.set(__self__, "entities_with_has_logs_collected_count", entities_with_has_logs_collected_count)
        if entities_with_management_agent_count and not isinstance(entities_with_management_agent_count, int):
            raise TypeError("Expected argument 'entities_with_management_agent_count' to be a int")
        pulumi.set(__self__, "entities_with_management_agent_count", entities_with_management_agent_count)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="activeEntitiesCount")
    def active_entities_count(self) -> builtins.int:
        """
        Total number of ACTIVE entities
        """
        return pulumi.get(self, "active_entities_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment Identifier [OCID] (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="entitiesWithHasLogsCollectedCount")
    def entities_with_has_logs_collected_count(self) -> builtins.int:
        """
        Entities with log collection enabled
        """
        return pulumi.get(self, "entities_with_has_logs_collected_count")

    @property
    @pulumi.getter(name="entitiesWithManagementAgentCount")
    def entities_with_management_agent_count(self) -> builtins.int:
        """
        Entities with management agent
        """
        return pulumi.get(self, "entities_with_management_agent_count")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def namespace(self) -> builtins.str:
        return pulumi.get(self, "namespace")


class AwaitableGetLogAnalyticsEntitiesSummaryResult(GetLogAnalyticsEntitiesSummaryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLogAnalyticsEntitiesSummaryResult(
            active_entities_count=self.active_entities_count,
            compartment_id=self.compartment_id,
            entities_with_has_logs_collected_count=self.entities_with_has_logs_collected_count,
            entities_with_management_agent_count=self.entities_with_management_agent_count,
            id=self.id,
            namespace=self.namespace)


def get_log_analytics_entities_summary(compartment_id: Optional[builtins.str] = None,
                                       namespace: Optional[builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLogAnalyticsEntitiesSummaryResult:
    """
    This data source provides details about a specific Log Analytics Entities Summary resource in Oracle Cloud Infrastructure Log Analytics service.

    Returns log analytics entities count summary report.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entities_summary = oci.LogAnalytics.get_log_analytics_entities_summary(compartment_id=compartment_id,
        namespace=log_analytics_entities_summary_namespace)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LogAnalytics/getLogAnalyticsEntitiesSummary:getLogAnalyticsEntitiesSummary', __args__, opts=opts, typ=GetLogAnalyticsEntitiesSummaryResult).value

    return AwaitableGetLogAnalyticsEntitiesSummaryResult(
        active_entities_count=pulumi.get(__ret__, 'active_entities_count'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        entities_with_has_logs_collected_count=pulumi.get(__ret__, 'entities_with_has_logs_collected_count'),
        entities_with_management_agent_count=pulumi.get(__ret__, 'entities_with_management_agent_count'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'))
def get_log_analytics_entities_summary_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                              namespace: Optional[pulumi.Input[builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLogAnalyticsEntitiesSummaryResult]:
    """
    This data source provides details about a specific Log Analytics Entities Summary resource in Oracle Cloud Infrastructure Log Analytics service.

    Returns log analytics entities count summary report.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_log_analytics_entities_summary = oci.LogAnalytics.get_log_analytics_entities_summary(compartment_id=compartment_id,
        namespace=log_analytics_entities_summary_namespace)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str namespace: The Logging Analytics namespace used for the request.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:LogAnalytics/getLogAnalyticsEntitiesSummary:getLogAnalyticsEntitiesSummary', __args__, opts=opts, typ=GetLogAnalyticsEntitiesSummaryResult)
    return __ret__.apply(lambda __response__: GetLogAnalyticsEntitiesSummaryResult(
        active_entities_count=pulumi.get(__response__, 'active_entities_count'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        entities_with_has_logs_collected_count=pulumi.get(__response__, 'entities_with_has_logs_collected_count'),
        entities_with_management_agent_count=pulumi.get(__response__, 'entities_with_management_agent_count'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace')))
