# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HeatWaveClusterArgs', 'HeatWaveCluster']

@pulumi.input_type
class HeatWaveClusterArgs:
    def __init__(__self__, *,
                 cluster_size: pulumi.Input[builtins.int],
                 db_system_id: pulumi.Input[builtins.str],
                 shape_name: pulumi.Input[builtins.str],
                 is_lakehouse_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a HeatWaveCluster resource.
        :param pulumi.Input[builtins.int] cluster_size: (Updatable) A change to the number of nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with the new cluster of nodes. This may result in a significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        :param pulumi.Input[builtins.str] db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.str] shape_name: (Updatable) A change to the shape of the nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with Compute instances of the new Shape. This may result in significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        :param pulumi.Input[builtins.bool] is_lakehouse_enabled: (Updatable) Enable/disable Lakehouse for the HeatWave cluster.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "cluster_size", cluster_size)
        pulumi.set(__self__, "db_system_id", db_system_id)
        pulumi.set(__self__, "shape_name", shape_name)
        if is_lakehouse_enabled is not None:
            pulumi.set(__self__, "is_lakehouse_enabled", is_lakehouse_enabled)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Input[builtins.int]:
        """
        (Updatable) A change to the number of nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with the new cluster of nodes. This may result in a significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Input[builtins.str]:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A change to the shape of the nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with Compute instances of the new Shape. This may result in significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Enable/disable Lakehouse for the HeatWave cluster.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @is_lakehouse_enabled.setter
    def is_lakehouse_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_lakehouse_enabled", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _HeatWaveClusterState:
    def __init__(__self__, *,
                 cluster_nodes: Optional[pulumi.Input[Sequence[pulumi.Input['HeatWaveClusterClusterNodeArgs']]]] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_lakehouse_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering HeatWaveCluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['HeatWaveClusterClusterNodeArgs']]] cluster_nodes: A HeatWave node is a compute host that is part of a HeatWave cluster.
        :param pulumi.Input[builtins.int] cluster_size: (Updatable) A change to the number of nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with the new cluster of nodes. This may result in a significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        :param pulumi.Input[builtins.str] db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.bool] is_lakehouse_enabled: (Updatable) Enable/disable Lakehouse for the HeatWave cluster.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycleState.
        :param pulumi.Input[builtins.str] shape_name: (Updatable) A change to the shape of the nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with Compute instances of the new Shape. This may result in significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        if cluster_nodes is not None:
            pulumi.set(__self__, "cluster_nodes", cluster_nodes)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if is_lakehouse_enabled is not None:
            pulumi.set(__self__, "is_lakehouse_enabled", is_lakehouse_enabled)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if shape_name is not None:
            pulumi.set(__self__, "shape_name", shape_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="clusterNodes")
    def cluster_nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HeatWaveClusterClusterNodeArgs']]]]:
        """
        A HeatWave node is a compute host that is part of a HeatWave cluster.
        """
        return pulumi.get(self, "cluster_nodes")

    @cluster_nodes.setter
    def cluster_nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HeatWaveClusterClusterNodeArgs']]]]):
        pulumi.set(self, "cluster_nodes", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) A change to the number of nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with the new cluster of nodes. This may result in a significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Enable/disable Lakehouse for the HeatWave cluster.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @is_lakehouse_enabled.setter
    def is_lakehouse_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_lakehouse_enabled", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A change to the shape of the nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with Compute instances of the new Shape. This may result in significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        """
        return pulumi.get(self, "shape_name")

    @shape_name.setter
    def shape_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "shape_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class HeatWaveCluster(pulumi.CustomResource):

    pulumi_type = "oci:Mysql/heatWaveCluster:HeatWaveCluster"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_lakehouse_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the HeatWave cluster resource in Oracle Cloud Infrastructure MySQL Database service.

        Updates the HeatWave cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_heat_wave_cluster = oci.mysql.HeatWaveCluster("test_heat_wave_cluster",
            db_system_id=test_db_system["id"],
            cluster_size=heat_wave_cluster_cluster_size,
            is_lakehouse_enabled=heat_wave_cluster_is_lakehouse_enabled,
            shape_name=test_shape["name"])
        ```

        ## Import

        HeatWaveCluster can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Mysql/heatWaveCluster:HeatWaveCluster test_heat_wave_cluster "dbSystem/{dbSystemId}/heatWaveCluster"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.int] cluster_size: (Updatable) A change to the number of nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with the new cluster of nodes. This may result in a significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        :param pulumi.Input[builtins.str] db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.bool] is_lakehouse_enabled: (Updatable) Enable/disable Lakehouse for the HeatWave cluster.
        :param pulumi.Input[builtins.str] shape_name: (Updatable) A change to the shape of the nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with Compute instances of the new Shape. This may result in significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HeatWaveClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the HeatWave cluster resource in Oracle Cloud Infrastructure MySQL Database service.

        Updates the HeatWave cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_heat_wave_cluster = oci.mysql.HeatWaveCluster("test_heat_wave_cluster",
            db_system_id=test_db_system["id"],
            cluster_size=heat_wave_cluster_cluster_size,
            is_lakehouse_enabled=heat_wave_cluster_is_lakehouse_enabled,
            shape_name=test_shape["name"])
        ```

        ## Import

        HeatWaveCluster can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Mysql/heatWaveCluster:HeatWaveCluster test_heat_wave_cluster "dbSystem/{dbSystemId}/heatWaveCluster"
        ```

        :param str resource_name: The name of the resource.
        :param HeatWaveClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HeatWaveClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_size: Optional[pulumi.Input[builtins.int]] = None,
                 db_system_id: Optional[pulumi.Input[builtins.str]] = None,
                 is_lakehouse_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HeatWaveClusterArgs.__new__(HeatWaveClusterArgs)

            if cluster_size is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_size'")
            __props__.__dict__["cluster_size"] = cluster_size
            if db_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_system_id'")
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["is_lakehouse_enabled"] = is_lakehouse_enabled
            if shape_name is None and not opts.urn:
                raise TypeError("Missing required property 'shape_name'")
            __props__.__dict__["shape_name"] = shape_name
            __props__.__dict__["state"] = state
            __props__.__dict__["cluster_nodes"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(HeatWaveCluster, __self__).__init__(
            'oci:Mysql/heatWaveCluster:HeatWaveCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['HeatWaveClusterClusterNodeArgs', 'HeatWaveClusterClusterNodeArgsDict']]]]] = None,
            cluster_size: Optional[pulumi.Input[builtins.int]] = None,
            db_system_id: Optional[pulumi.Input[builtins.str]] = None,
            is_lakehouse_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            lifecycle_details: Optional[pulumi.Input[builtins.str]] = None,
            shape_name: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'HeatWaveCluster':
        """
        Get an existing HeatWaveCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['HeatWaveClusterClusterNodeArgs', 'HeatWaveClusterClusterNodeArgsDict']]]] cluster_nodes: A HeatWave node is a compute host that is part of a HeatWave cluster.
        :param pulumi.Input[builtins.int] cluster_size: (Updatable) A change to the number of nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with the new cluster of nodes. This may result in a significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        :param pulumi.Input[builtins.str] db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[builtins.bool] is_lakehouse_enabled: (Updatable) Enable/disable Lakehouse for the HeatWave cluster.
        :param pulumi.Input[builtins.str] lifecycle_details: Additional information about the current lifecycleState.
        :param pulumi.Input[builtins.str] shape_name: (Updatable) A change to the shape of the nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with Compute instances of the new Shape. This may result in significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        :param pulumi.Input[builtins.str] state: (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[builtins.str] time_updated: The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HeatWaveClusterState.__new__(_HeatWaveClusterState)

        __props__.__dict__["cluster_nodes"] = cluster_nodes
        __props__.__dict__["cluster_size"] = cluster_size
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["is_lakehouse_enabled"] = is_lakehouse_enabled
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["shape_name"] = shape_name
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return HeatWaveCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterNodes")
    def cluster_nodes(self) -> pulumi.Output[Sequence['outputs.HeatWaveClusterClusterNode']]:
        """
        A HeatWave node is a compute host that is part of a HeatWave cluster.
        """
        return pulumi.get(self, "cluster_nodes")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) A change to the number of nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with the new cluster of nodes. This may result in a significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[builtins.str]:
        """
        The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="isLakehouseEnabled")
    def is_lakehouse_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Enable/disable Lakehouse for the HeatWave cluster.
        """
        return pulumi.get(self, "is_lakehouse_enabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[builtins.str]:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A change to the shape of the nodes in the HeatWave cluster will result in the entire cluster being torn down and re-created with Compute instances of the new Shape. This may result in significant downtime for the analytics capability while the HeatWave cluster is re-provisioned.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The target state for the HeatWave cluster. Could be set to `ACTIVE` or `INACTIVE`.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the HeatWave cluster was created, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the HeatWave cluster was last updated, as described by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

