# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetworkFirewallPolicyAddressListArgs', 'NetworkFirewallPolicyAddressList']

@pulumi.input_type
class NetworkFirewallPolicyAddressListArgs:
    def __init__(__self__, *,
                 addresses: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 network_firewall_policy_id: pulumi.Input[builtins.str],
                 type: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyAddressList resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: (Updatable) List of addresses.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] type: Type of address List. The accepted values are - * FQDN * IP
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] name: Unique name to identify the group of addresses to be used in the policy rules.
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        pulumi.set(__self__, "type", type)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) List of addresses.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[builtins.str]:
        """
        Type of address List. The accepted values are - * FQDN * IP


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name to identify the group of addresses to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkFirewallPolicyAddressListState:
    def __init__(__self__, *,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 parent_resource_id: Optional[pulumi.Input[builtins.str]] = None,
                 total_addresses: Optional[pulumi.Input[builtins.int]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyAddressList resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: (Updatable) List of addresses.
        :param pulumi.Input[builtins.str] name: Unique name to identify the group of addresses to be used in the policy rules.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] parent_resource_id: OCID of the Network Firewall Policy this Address List belongs to.
        :param pulumi.Input[builtins.int] total_addresses: Count of total addresses in the AddressList
        :param pulumi.Input[builtins.str] type: Type of address List. The accepted values are - * FQDN * IP
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if total_addresses is not None:
            pulumi.set(__self__, "total_addresses", total_addresses)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of addresses.
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique name to identify the group of addresses to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        OCID of the Network Firewall Policy this Address List belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "parent_resource_id", value)

    @property
    @pulumi.getter(name="totalAddresses")
    def total_addresses(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Count of total addresses in the AddressList
        """
        return pulumi.get(self, "total_addresses")

    @total_addresses.setter
    def total_addresses(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "total_addresses", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Type of address List. The accepted values are - * FQDN * IP


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "type", value)


class NetworkFirewallPolicyAddressList(pulumi.CustomResource):

    pulumi_type = "oci:NetworkFirewall/networkFirewallPolicyAddressList:NetworkFirewallPolicyAddressList"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy Address List resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Address List for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_address_list = oci.network_firewall.NetworkFirewallPolicyAddressList("test_network_firewall_policy_address_list",
            name=network_firewall_policy_address_list_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            type=network_firewall_policy_address_list_type,
            addresses=network_firewall_policy_address_list_addresses)
        ```

        ## Import

        NetworkFirewallPolicyAddressLists can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyAddressList:NetworkFirewallPolicyAddressList test_network_firewall_policy_address_list "networkFirewallPolicies/{networkFirewallPolicyId}/addressLists/{addressListName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: (Updatable) List of addresses.
        :param pulumi.Input[builtins.str] name: Unique name to identify the group of addresses to be used in the policy rules.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] type: Type of address List. The accepted values are - * FQDN * IP
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyAddressListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy Address List resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Address List for the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_address_list = oci.network_firewall.NetworkFirewallPolicyAddressList("test_network_firewall_policy_address_list",
            name=network_firewall_policy_address_list_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            type=network_firewall_policy_address_list_type,
            addresses=network_firewall_policy_address_list_addresses)
        ```

        ## Import

        NetworkFirewallPolicyAddressLists can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyAddressList:NetworkFirewallPolicyAddressList test_network_firewall_policy_address_list "networkFirewallPolicies/{networkFirewallPolicyId}/addressLists/{addressListName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyAddressListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyAddressListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
                 type: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyAddressListArgs.__new__(NetworkFirewallPolicyAddressListArgs)

            if addresses is None and not opts.urn:
                raise TypeError("Missing required property 'addresses'")
            __props__.__dict__["addresses"] = addresses
            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["parent_resource_id"] = None
            __props__.__dict__["total_addresses"] = None
        super(NetworkFirewallPolicyAddressList, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyAddressList:NetworkFirewallPolicyAddressList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[builtins.str]] = None,
            parent_resource_id: Optional[pulumi.Input[builtins.str]] = None,
            total_addresses: Optional[pulumi.Input[builtins.int]] = None,
            type: Optional[pulumi.Input[builtins.str]] = None) -> 'NetworkFirewallPolicyAddressList':
        """
        Get an existing NetworkFirewallPolicyAddressList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] addresses: (Updatable) List of addresses.
        :param pulumi.Input[builtins.str] name: Unique name to identify the group of addresses to be used in the policy rules.
        :param pulumi.Input[builtins.str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[builtins.str] parent_resource_id: OCID of the Network Firewall Policy this Address List belongs to.
        :param pulumi.Input[builtins.int] total_addresses: Count of total addresses in the AddressList
        :param pulumi.Input[builtins.str] type: Type of address List. The accepted values are - * FQDN * IP
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyAddressListState.__new__(_NetworkFirewallPolicyAddressListState)

        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["total_addresses"] = total_addresses
        __props__.__dict__["type"] = type
        return NetworkFirewallPolicyAddressList(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) List of addresses.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Unique name to identify the group of addresses to be used in the policy rules.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[builtins.str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[builtins.str]:
        """
        OCID of the Network Firewall Policy this Address List belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter(name="totalAddresses")
    def total_addresses(self) -> pulumi.Output[builtins.int]:
        """
        Count of total addresses in the AddressList
        """
        return pulumi.get(self, "total_addresses")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[builtins.str]:
        """
        Type of address List. The accepted values are - * FQDN * IP


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

