# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 compute_availability_domain: pulumi.Input[builtins.str],
                 esxi_hosts_count: pulumi.Input[builtins.int],
                 network_configuration: pulumi.Input['ClusterNetworkConfigurationArgs'],
                 sddc_id: pulumi.Input[builtins.str],
                 capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDatastoreArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 esxi_software_version: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 initial_commitment: Optional[pulumi.Input[builtins.str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[builtins.float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 vmware_software_version: Optional[pulumi.Input[builtins.str]] = None,
                 workload_network_cidr: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[builtins.str] compute_availability_domain: The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        :param pulumi.Input[builtins.int] esxi_hosts_count: The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). 
               
               **Note:** If you later delete EXSi hosts from a production Cluster to make SDDC total host count less than 3, you are still billed for the 3 minimum recommended  ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until the  SDDC again has at least 3 ESXi hosts.
        :param pulumi.Input['ClusterNetworkConfigurationArgs'] network_configuration: (Updatable) The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        :param pulumi.Input[builtins.str] sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        :param pulumi.Input[builtins.str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterDatastoreArgs']]] datastores: A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] esxi_software_version: (Updatable) The ESXi software bundle to install on the ESXi hosts in the Cluster.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] initial_commitment: The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[builtins.float] initial_host_ocpu_count: The initial OCPU count of the Cluster's ESXi hosts.
        :param pulumi.Input[builtins.str] initial_host_shape_name: The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[builtins.str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
               
               For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        :param pulumi.Input[builtins.bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this Cluster.
        :param pulumi.Input[builtins.str] vmware_software_version: (Updatable) The VMware software bundle to install on the ESXi hosts in the Cluster. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[builtins.str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        pulumi.set(__self__, "network_configuration", network_configuration)
        pulumi.set(__self__, "sddc_id", sddc_id)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if datastores is not None:
            pulumi.set(__self__, "datastores", datastores)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if esxi_software_version is not None:
            pulumi.set(__self__, "esxi_software_version", esxi_software_version)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if initial_commitment is not None:
            pulumi.set(__self__, "initial_commitment", initial_commitment)
        if initial_host_ocpu_count is not None:
            pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        if initial_host_shape_name is not None:
            pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        if instance_display_name_prefix is not None:
            pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        if is_shielded_instance_enabled is not None:
            pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        if vmware_software_version is not None:
            pulumi.set(__self__, "vmware_software_version", vmware_software_version)
        if workload_network_cidr is not None:
            pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> pulumi.Input[builtins.str]:
        """
        The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @compute_availability_domain.setter
    def compute_availability_domain(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compute_availability_domain", value)

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> pulumi.Input[builtins.int]:
        """
        The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). 

        **Note:** If you later delete EXSi hosts from a production Cluster to make SDDC total host count less than 3, you are still billed for the 3 minimum recommended  ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until the  SDDC again has at least 3 ESXi hosts.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @esxi_hosts_count.setter
    def esxi_hosts_count(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "esxi_hosts_count", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Input['ClusterNetworkConfigurationArgs']:
        """
        (Updatable) The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: pulumi.Input['ClusterNetworkConfigurationArgs']):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        """
        return pulumi.get(self, "sddc_id")

    @sddc_id.setter
    def sddc_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "sddc_id", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter
    def datastores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDatastoreArgs']]]]:
        """
        A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @datastores.setter
    def datastores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDatastoreArgs']]]]):
        pulumi.set(self, "datastores", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The ESXi software bundle to install on the ESXi hosts in the Cluster.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "esxi_software_version")

    @esxi_software_version.setter
    def esxi_software_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "esxi_software_version", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "initial_commitment")

    @initial_commitment.setter
    def initial_commitment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_commitment", value)

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The initial OCPU count of the Cluster's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @initial_host_ocpu_count.setter
    def initial_host_ocpu_count(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "initial_host_ocpu_count", value)

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @initial_host_shape_name.setter
    def initial_host_shape_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_host_shape_name", value)

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.

        For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @instance_display_name_prefix.setter
    def instance_display_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_display_name_prefix", value)

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether shielded instance is enabled for this Cluster.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @is_shielded_instance_enabled.setter
    def is_shielded_instance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_shielded_instance_enabled", value)

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The VMware software bundle to install on the ESXi hosts in the Cluster. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "vmware_software_version")

    @vmware_software_version.setter
    def vmware_software_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vmware_software_version", value)

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workload_network_cidr")

    @workload_network_cidr.setter
    def workload_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_network_cidr", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 actual_esxi_hosts_count: Optional[pulumi.Input[builtins.int]] = None,
                 capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDatastoreArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 esxi_hosts_count: Optional[pulumi.Input[builtins.int]] = None,
                 esxi_software_version: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 initial_commitment: Optional[pulumi.Input[builtins.str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[builtins.float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_configuration: Optional[pulumi.Input['ClusterNetworkConfigurationArgs']] = None,
                 sddc_id: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 upgrade_licenses: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUpgradeLicenseArgs']]]] = None,
                 vmware_software_version: Optional[pulumi.Input[builtins.str]] = None,
                 vsphere_type: Optional[pulumi.Input[builtins.str]] = None,
                 vsphere_upgrade_objects: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterVsphereUpgradeObjectArgs']]]] = None,
                 workload_network_cidr: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[builtins.str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        :param pulumi.Input[builtins.str] compute_availability_domain: The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterDatastoreArgs']]] datastores: A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[builtins.int] esxi_hosts_count: The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). 
               
               **Note:** If you later delete EXSi hosts from a production Cluster to make SDDC total host count less than 3, you are still billed for the 3 minimum recommended  ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until the  SDDC again has at least 3 ESXi hosts.
        :param pulumi.Input[builtins.str] esxi_software_version: (Updatable) The ESXi software bundle to install on the ESXi hosts in the Cluster.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] initial_commitment: The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[builtins.float] initial_host_ocpu_count: The initial OCPU count of the Cluster's ESXi hosts.
        :param pulumi.Input[builtins.str] initial_host_shape_name: The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[builtins.str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
               
               For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        :param pulumi.Input[builtins.bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this Cluster.
        :param pulumi.Input['ClusterNetworkConfigurationArgs'] network_configuration: (Updatable) The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        :param pulumi.Input[builtins.str] sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        :param pulumi.Input[builtins.str] state: The current state of the Cluster.
        :param pulumi.Input[builtins.str] time_created: The date and time the Cluster was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the Cluster was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input['ClusterUpgradeLicenseArgs']]] upgrade_licenses: The vSphere licenses to use when upgrading the Cluster.
        :param pulumi.Input[builtins.str] vmware_software_version: (Updatable) The VMware software bundle to install on the ESXi hosts in the Cluster. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[builtins.str] vsphere_type: vSphere Cluster types.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterVsphereUpgradeObjectArgs']]] vsphere_upgrade_objects: The links to binary objects needed to upgrade vSphere.
        :param pulumi.Input[builtins.str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if actual_esxi_hosts_count is not None:
            pulumi.set(__self__, "actual_esxi_hosts_count", actual_esxi_hosts_count)
        if capacity_reservation_id is not None:
            pulumi.set(__self__, "capacity_reservation_id", capacity_reservation_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_availability_domain is not None:
            pulumi.set(__self__, "compute_availability_domain", compute_availability_domain)
        if datastores is not None:
            pulumi.set(__self__, "datastores", datastores)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if esxi_hosts_count is not None:
            pulumi.set(__self__, "esxi_hosts_count", esxi_hosts_count)
        if esxi_software_version is not None:
            pulumi.set(__self__, "esxi_software_version", esxi_software_version)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if initial_commitment is not None:
            pulumi.set(__self__, "initial_commitment", initial_commitment)
        if initial_host_ocpu_count is not None:
            pulumi.set(__self__, "initial_host_ocpu_count", initial_host_ocpu_count)
        if initial_host_shape_name is not None:
            pulumi.set(__self__, "initial_host_shape_name", initial_host_shape_name)
        if instance_display_name_prefix is not None:
            pulumi.set(__self__, "instance_display_name_prefix", instance_display_name_prefix)
        if is_shielded_instance_enabled is not None:
            pulumi.set(__self__, "is_shielded_instance_enabled", is_shielded_instance_enabled)
        if network_configuration is not None:
            pulumi.set(__self__, "network_configuration", network_configuration)
        if sddc_id is not None:
            pulumi.set(__self__, "sddc_id", sddc_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if upgrade_licenses is not None:
            pulumi.set(__self__, "upgrade_licenses", upgrade_licenses)
        if vmware_software_version is not None:
            pulumi.set(__self__, "vmware_software_version", vmware_software_version)
        if vsphere_type is not None:
            pulumi.set(__self__, "vsphere_type", vsphere_type)
        if vsphere_upgrade_objects is not None:
            pulumi.set(__self__, "vsphere_upgrade_objects", vsphere_upgrade_objects)
        if workload_network_cidr is not None:
            pulumi.set(__self__, "workload_network_cidr", workload_network_cidr)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> Optional[pulumi.Input[builtins.int]]:
        return pulumi.get(self, "actual_esxi_hosts_count")

    @actual_esxi_hosts_count.setter
    def actual_esxi_hosts_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "actual_esxi_hosts_count", value)

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @capacity_reservation_id.setter
    def capacity_reservation_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "capacity_reservation_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @compute_availability_domain.setter
    def compute_availability_domain(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compute_availability_domain", value)

    @property
    @pulumi.getter
    def datastores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDatastoreArgs']]]]:
        """
        A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @datastores.setter
    def datastores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterDatastoreArgs']]]]):
        pulumi.set(self, "datastores", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). 

        **Note:** If you later delete EXSi hosts from a production Cluster to make SDDC total host count less than 3, you are still billed for the 3 minimum recommended  ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until the  SDDC again has at least 3 ESXi hosts.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @esxi_hosts_count.setter
    def esxi_hosts_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "esxi_hosts_count", value)

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The ESXi software bundle to install on the ESXi hosts in the Cluster.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "esxi_software_version")

    @esxi_software_version.setter
    def esxi_software_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "esxi_software_version", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "initial_commitment")

    @initial_commitment.setter
    def initial_commitment(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_commitment", value)

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        The initial OCPU count of the Cluster's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @initial_host_ocpu_count.setter
    def initial_host_ocpu_count(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "initial_host_ocpu_count", value)

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @initial_host_shape_name.setter
    def initial_host_shape_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "initial_host_shape_name", value)

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.

        For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @instance_display_name_prefix.setter
    def instance_display_name_prefix(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "instance_display_name_prefix", value)

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether shielded instance is enabled for this Cluster.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @is_shielded_instance_enabled.setter
    def is_shielded_instance_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_shielded_instance_enabled", value)

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> Optional[pulumi.Input['ClusterNetworkConfigurationArgs']]:
        """
        (Updatable) The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        """
        return pulumi.get(self, "network_configuration")

    @network_configuration.setter
    def network_configuration(self, value: Optional[pulumi.Input['ClusterNetworkConfigurationArgs']]):
        pulumi.set(self, "network_configuration", value)

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        """
        return pulumi.get(self, "sddc_id")

    @sddc_id.setter
    def sddc_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "sddc_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the Cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Cluster was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the Cluster was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="upgradeLicenses")
    def upgrade_licenses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUpgradeLicenseArgs']]]]:
        """
        The vSphere licenses to use when upgrading the Cluster.
        """
        return pulumi.get(self, "upgrade_licenses")

    @upgrade_licenses.setter
    def upgrade_licenses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterUpgradeLicenseArgs']]]]):
        pulumi.set(self, "upgrade_licenses", value)

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The VMware software bundle to install on the ESXi hosts in the Cluster. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "vmware_software_version")

    @vmware_software_version.setter
    def vmware_software_version(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vmware_software_version", value)

    @property
    @pulumi.getter(name="vsphereType")
    def vsphere_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        vSphere Cluster types.
        """
        return pulumi.get(self, "vsphere_type")

    @vsphere_type.setter
    def vsphere_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vsphere_type", value)

    @property
    @pulumi.getter(name="vsphereUpgradeObjects")
    def vsphere_upgrade_objects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterVsphereUpgradeObjectArgs']]]]:
        """
        The links to binary objects needed to upgrade vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_objects")

    @vsphere_upgrade_objects.setter
    def vsphere_upgrade_objects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterVsphereUpgradeObjectArgs']]]]):
        pulumi.set(self, "vsphere_upgrade_objects", value)

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workload_network_cidr")

    @workload_network_cidr.setter
    def workload_network_cidr(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "workload_network_cidr", value)


class Cluster(pulumi.CustomResource):

    pulumi_type = "oci:Ocvp/cluster:Cluster"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterDatastoreArgs', 'ClusterDatastoreArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 esxi_hosts_count: Optional[pulumi.Input[builtins.int]] = None,
                 esxi_software_version: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 initial_commitment: Optional[pulumi.Input[builtins.str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[builtins.float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_configuration: Optional[pulumi.Input[Union['ClusterNetworkConfigurationArgs', 'ClusterNetworkConfigurationArgsDict']]] = None,
                 sddc_id: Optional[pulumi.Input[builtins.str]] = None,
                 vmware_software_version: Optional[pulumi.Input[builtins.str]] = None,
                 workload_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Cluster resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

        Create a vSphere Cluster in software-defined data center (SDDC).

        Use the [WorkRequest](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/WorkRequest/) operations to track the
        creation of the Cluster.

        **Important:** You must configure the Cluster's networking resources with the security rules detailed in [Security Rules for Oracle Cloud VMware Solution SDDCs](https://docs.cloud.oracle.com/iaas/Content/VMware/Reference/ocvssecurityrules.htm). Otherwise, provisioning the SDDC will fail. The rules are based on the requirements set by VMware.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cluster = oci.ocvp.Cluster("test_cluster",
            compute_availability_domain=cluster_compute_availability_domain,
            esxi_hosts_count=cluster_esxi_hosts_count,
            network_configuration={
                "nsx_edge_vtep_vlan_id": test_vlan["id"],
                "nsx_vtep_vlan_id": test_vlan["id"],
                "provisioning_subnet_id": test_subnet["id"],
                "vmotion_vlan_id": test_vlan["id"],
                "vsan_vlan_id": test_vlan["id"],
                "hcx_vlan_id": test_vlan["id"],
                "nsx_edge_uplink1vlan_id": test_nsx_edge_uplink1vlan["id"],
                "nsx_edge_uplink2vlan_id": test_nsx_edge_uplink2vlan["id"],
                "provisioning_vlan_id": test_vlan["id"],
                "replication_vlan_id": test_vlan["id"],
                "vsphere_vlan_id": test_vlan["id"],
            },
            sddc_id=test_sddc["id"],
            capacity_reservation_id=test_capacity_reservation["id"],
            datastores=[{
                "block_volume_ids": cluster_datastores_block_volume_ids,
                "datastore_type": cluster_datastores_datastore_type,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=cluster_display_name,
            esxi_software_version=cluster_esxi_software_version,
            freeform_tags={
                "Department": "Finance",
            },
            initial_commitment=cluster_initial_commitment,
            initial_host_ocpu_count=cluster_initial_host_ocpu_count,
            initial_host_shape_name=test_shape["name"],
            instance_display_name_prefix=cluster_instance_display_name_prefix,
            is_shielded_instance_enabled=cluster_is_shielded_instance_enabled,
            vmware_software_version=cluster_vmware_software_version,
            workload_network_cidr=cluster_workload_network_cidr)
        ```

        ## Import

        Clusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Ocvp/cluster:Cluster test_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[builtins.str] compute_availability_domain: The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterDatastoreArgs', 'ClusterDatastoreArgsDict']]]] datastores: A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[builtins.int] esxi_hosts_count: The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). 
               
               **Note:** If you later delete EXSi hosts from a production Cluster to make SDDC total host count less than 3, you are still billed for the 3 minimum recommended  ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until the  SDDC again has at least 3 ESXi hosts.
        :param pulumi.Input[builtins.str] esxi_software_version: (Updatable) The ESXi software bundle to install on the ESXi hosts in the Cluster.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] initial_commitment: The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[builtins.float] initial_host_ocpu_count: The initial OCPU count of the Cluster's ESXi hosts.
        :param pulumi.Input[builtins.str] initial_host_shape_name: The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[builtins.str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
               
               For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        :param pulumi.Input[builtins.bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this Cluster.
        :param pulumi.Input[Union['ClusterNetworkConfigurationArgs', 'ClusterNetworkConfigurationArgsDict']] network_configuration: (Updatable) The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        :param pulumi.Input[builtins.str] sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        :param pulumi.Input[builtins.str] vmware_software_version: (Updatable) The VMware software bundle to install on the ESXi hosts in the Cluster. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[builtins.str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cluster resource in Oracle Cloud Infrastructure Oracle Cloud VMware Solution service.

        Create a vSphere Cluster in software-defined data center (SDDC).

        Use the [WorkRequest](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/WorkRequest/) operations to track the
        creation of the Cluster.

        **Important:** You must configure the Cluster's networking resources with the security rules detailed in [Security Rules for Oracle Cloud VMware Solution SDDCs](https://docs.cloud.oracle.com/iaas/Content/VMware/Reference/ocvssecurityrules.htm). Otherwise, provisioning the SDDC will fail. The rules are based on the requirements set by VMware.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cluster = oci.ocvp.Cluster("test_cluster",
            compute_availability_domain=cluster_compute_availability_domain,
            esxi_hosts_count=cluster_esxi_hosts_count,
            network_configuration={
                "nsx_edge_vtep_vlan_id": test_vlan["id"],
                "nsx_vtep_vlan_id": test_vlan["id"],
                "provisioning_subnet_id": test_subnet["id"],
                "vmotion_vlan_id": test_vlan["id"],
                "vsan_vlan_id": test_vlan["id"],
                "hcx_vlan_id": test_vlan["id"],
                "nsx_edge_uplink1vlan_id": test_nsx_edge_uplink1vlan["id"],
                "nsx_edge_uplink2vlan_id": test_nsx_edge_uplink2vlan["id"],
                "provisioning_vlan_id": test_vlan["id"],
                "replication_vlan_id": test_vlan["id"],
                "vsphere_vlan_id": test_vlan["id"],
            },
            sddc_id=test_sddc["id"],
            capacity_reservation_id=test_capacity_reservation["id"],
            datastores=[{
                "block_volume_ids": cluster_datastores_block_volume_ids,
                "datastore_type": cluster_datastores_datastore_type,
            }],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=cluster_display_name,
            esxi_software_version=cluster_esxi_software_version,
            freeform_tags={
                "Department": "Finance",
            },
            initial_commitment=cluster_initial_commitment,
            initial_host_ocpu_count=cluster_initial_host_ocpu_count,
            initial_host_shape_name=test_shape["name"],
            instance_display_name_prefix=cluster_instance_display_name_prefix,
            is_shielded_instance_enabled=cluster_is_shielded_instance_enabled,
            vmware_software_version=cluster_vmware_software_version,
            workload_network_cidr=cluster_workload_network_cidr)
        ```

        ## Import

        Clusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Ocvp/cluster:Cluster test_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
                 compute_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
                 datastores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterDatastoreArgs', 'ClusterDatastoreArgsDict']]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 esxi_hosts_count: Optional[pulumi.Input[builtins.int]] = None,
                 esxi_software_version: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 initial_commitment: Optional[pulumi.Input[builtins.str]] = None,
                 initial_host_ocpu_count: Optional[pulumi.Input[builtins.float]] = None,
                 initial_host_shape_name: Optional[pulumi.Input[builtins.str]] = None,
                 instance_display_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
                 is_shielded_instance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 network_configuration: Optional[pulumi.Input[Union['ClusterNetworkConfigurationArgs', 'ClusterNetworkConfigurationArgsDict']]] = None,
                 sddc_id: Optional[pulumi.Input[builtins.str]] = None,
                 vmware_software_version: Optional[pulumi.Input[builtins.str]] = None,
                 workload_network_cidr: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
            if compute_availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'compute_availability_domain'")
            __props__.__dict__["compute_availability_domain"] = compute_availability_domain
            __props__.__dict__["datastores"] = datastores
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            if esxi_hosts_count is None and not opts.urn:
                raise TypeError("Missing required property 'esxi_hosts_count'")
            __props__.__dict__["esxi_hosts_count"] = esxi_hosts_count
            __props__.__dict__["esxi_software_version"] = esxi_software_version
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["initial_commitment"] = initial_commitment
            __props__.__dict__["initial_host_ocpu_count"] = initial_host_ocpu_count
            __props__.__dict__["initial_host_shape_name"] = initial_host_shape_name
            __props__.__dict__["instance_display_name_prefix"] = instance_display_name_prefix
            __props__.__dict__["is_shielded_instance_enabled"] = is_shielded_instance_enabled
            if network_configuration is None and not opts.urn:
                raise TypeError("Missing required property 'network_configuration'")
            __props__.__dict__["network_configuration"] = network_configuration
            if sddc_id is None and not opts.urn:
                raise TypeError("Missing required property 'sddc_id'")
            __props__.__dict__["sddc_id"] = sddc_id
            __props__.__dict__["vmware_software_version"] = vmware_software_version
            __props__.__dict__["workload_network_cidr"] = workload_network_cidr
            __props__.__dict__["actual_esxi_hosts_count"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["upgrade_licenses"] = None
            __props__.__dict__["vsphere_type"] = None
            __props__.__dict__["vsphere_upgrade_objects"] = None
        super(Cluster, __self__).__init__(
            'oci:Ocvp/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            actual_esxi_hosts_count: Optional[pulumi.Input[builtins.int]] = None,
            capacity_reservation_id: Optional[pulumi.Input[builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            compute_availability_domain: Optional[pulumi.Input[builtins.str]] = None,
            datastores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterDatastoreArgs', 'ClusterDatastoreArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            esxi_hosts_count: Optional[pulumi.Input[builtins.int]] = None,
            esxi_software_version: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            initial_commitment: Optional[pulumi.Input[builtins.str]] = None,
            initial_host_ocpu_count: Optional[pulumi.Input[builtins.float]] = None,
            initial_host_shape_name: Optional[pulumi.Input[builtins.str]] = None,
            instance_display_name_prefix: Optional[pulumi.Input[builtins.str]] = None,
            is_shielded_instance_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            network_configuration: Optional[pulumi.Input[Union['ClusterNetworkConfigurationArgs', 'ClusterNetworkConfigurationArgsDict']]] = None,
            sddc_id: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            upgrade_licenses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterUpgradeLicenseArgs', 'ClusterUpgradeLicenseArgsDict']]]]] = None,
            vmware_software_version: Optional[pulumi.Input[builtins.str]] = None,
            vsphere_type: Optional[pulumi.Input[builtins.str]] = None,
            vsphere_upgrade_objects: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterVsphereUpgradeObjectArgs', 'ClusterVsphereUpgradeObjectArgsDict']]]]] = None,
            workload_network_cidr: Optional[pulumi.Input[builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] capacity_reservation_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        :param pulumi.Input[builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        :param pulumi.Input[builtins.str] compute_availability_domain: The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterDatastoreArgs', 'ClusterDatastoreArgsDict']]]] datastores: A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] display_name: (Updatable) A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        :param pulumi.Input[builtins.int] esxi_hosts_count: The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). 
               
               **Note:** If you later delete EXSi hosts from a production Cluster to make SDDC total host count less than 3, you are still billed for the 3 minimum recommended  ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until the  SDDC again has at least 3 ESXi hosts.
        :param pulumi.Input[builtins.str] esxi_software_version: (Updatable) The ESXi software bundle to install on the ESXi hosts in the Cluster.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] initial_commitment: The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        :param pulumi.Input[builtins.float] initial_host_ocpu_count: The initial OCPU count of the Cluster's ESXi hosts.
        :param pulumi.Input[builtins.str] initial_host_shape_name: The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        :param pulumi.Input[builtins.str] instance_display_name_prefix: A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.
               
               For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        :param pulumi.Input[builtins.bool] is_shielded_instance_enabled: Indicates whether shielded instance is enabled for this Cluster.
        :param pulumi.Input[Union['ClusterNetworkConfigurationArgs', 'ClusterNetworkConfigurationArgsDict']] network_configuration: (Updatable) The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        :param pulumi.Input[builtins.str] sddc_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        :param pulumi.Input[builtins.str] state: The current state of the Cluster.
        :param pulumi.Input[builtins.str] time_created: The date and time the Cluster was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[builtins.str] time_updated: The date and time the Cluster was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterUpgradeLicenseArgs', 'ClusterUpgradeLicenseArgsDict']]]] upgrade_licenses: The vSphere licenses to use when upgrading the Cluster.
        :param pulumi.Input[builtins.str] vmware_software_version: (Updatable) The VMware software bundle to install on the ESXi hosts in the Cluster. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        :param pulumi.Input[builtins.str] vsphere_type: vSphere Cluster types.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterVsphereUpgradeObjectArgs', 'ClusterVsphereUpgradeObjectArgsDict']]]] vsphere_upgrade_objects: The links to binary objects needed to upgrade vSphere.
        :param pulumi.Input[builtins.str] workload_network_cidr: The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["actual_esxi_hosts_count"] = actual_esxi_hosts_count
        __props__.__dict__["capacity_reservation_id"] = capacity_reservation_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_availability_domain"] = compute_availability_domain
        __props__.__dict__["datastores"] = datastores
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["esxi_hosts_count"] = esxi_hosts_count
        __props__.__dict__["esxi_software_version"] = esxi_software_version
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["initial_commitment"] = initial_commitment
        __props__.__dict__["initial_host_ocpu_count"] = initial_host_ocpu_count
        __props__.__dict__["initial_host_shape_name"] = initial_host_shape_name
        __props__.__dict__["instance_display_name_prefix"] = instance_display_name_prefix
        __props__.__dict__["is_shielded_instance_enabled"] = is_shielded_instance_enabled
        __props__.__dict__["network_configuration"] = network_configuration
        __props__.__dict__["sddc_id"] = sddc_id
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["upgrade_licenses"] = upgrade_licenses
        __props__.__dict__["vmware_software_version"] = vmware_software_version
        __props__.__dict__["vsphere_type"] = vsphere_type
        __props__.__dict__["vsphere_upgrade_objects"] = vsphere_upgrade_objects
        __props__.__dict__["workload_network_cidr"] = workload_network_cidr
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="actualEsxiHostsCount")
    def actual_esxi_hosts_count(self) -> pulumi.Output[builtins.int]:
        return pulumi.get(self, "actual_esxi_hosts_count")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Capacity Reservation.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the Cluster.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeAvailabilityDomain")
    def compute_availability_domain(self) -> pulumi.Output[builtins.str]:
        """
        The availability domain to create the Cluster's ESXi hosts in. For multi-AD Cluster deployment, set to `multi-AD`.
        """
        return pulumi.get(self, "compute_availability_domain")

    @property
    @pulumi.getter
    def datastores(self) -> pulumi.Output[Sequence['outputs.ClusterDatastore']]:
        """
        A list of datastore info for the Cluster. This value is required only when `initialHostShapeName` is a standard shape.
        """
        return pulumi.get(self, "datastores")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A descriptive name for the Cluster. Cluster name requirements are 1-16 character length limit, Must start with a letter, Must be English letters, numbers, - only, No repeating hyphens, Must be unique within the region. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="esxiHostsCount")
    def esxi_hosts_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of ESXi hosts to create in the Cluster. You can add more hosts later (see [CreateEsxiHost](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/EsxiHost/CreateEsxiHost)). 

        **Note:** If you later delete EXSi hosts from a production Cluster to make SDDC total host count less than 3, you are still billed for the 3 minimum recommended  ESXi hosts. Also, you cannot add more VMware workloads to the Cluster until the  SDDC again has at least 3 ESXi hosts.
        """
        return pulumi.get(self, "esxi_hosts_count")

    @property
    @pulumi.getter(name="esxiSoftwareVersion")
    def esxi_software_version(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The ESXi software bundle to install on the ESXi hosts in the Cluster.  Only versions under the same vmwareSoftwareVersion and have been validate by Oracle Cloud VMware Solution will be accepted. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "esxi_software_version")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="initialCommitment")
    def initial_commitment(self) -> pulumi.Output[builtins.str]:
        """
        The billing option selected during Cluster creation. [ListSupportedCommitments](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedCommitmentSummary/ListSupportedCommitments).
        """
        return pulumi.get(self, "initial_commitment")

    @property
    @pulumi.getter(name="initialHostOcpuCount")
    def initial_host_ocpu_count(self) -> pulumi.Output[builtins.float]:
        """
        The initial OCPU count of the Cluster's ESXi hosts.
        """
        return pulumi.get(self, "initial_host_ocpu_count")

    @property
    @pulumi.getter(name="initialHostShapeName")
    def initial_host_shape_name(self) -> pulumi.Output[builtins.str]:
        """
        The initial compute shape of the Cluster's ESXi hosts. [ListSupportedHostShapes](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20200501/SupportedHostShapes/ListSupportedHostShapes).
        """
        return pulumi.get(self, "initial_host_shape_name")

    @property
    @pulumi.getter(name="instanceDisplayNamePrefix")
    def instance_display_name_prefix(self) -> pulumi.Output[builtins.str]:
        """
        A prefix used in the name of each ESXi host and Compute instance in the Cluster. If this isn't set, the Cluster's `displayName` is used as the prefix.

        For example, if the value is `myCluster`, the ESXi hosts are named `myCluster-1`, `myCluster-2`, and so on.
        """
        return pulumi.get(self, "instance_display_name_prefix")

    @property
    @pulumi.getter(name="isShieldedInstanceEnabled")
    def is_shielded_instance_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether shielded instance is enabled for this Cluster.
        """
        return pulumi.get(self, "is_shielded_instance_enabled")

    @property
    @pulumi.getter(name="networkConfiguration")
    def network_configuration(self) -> pulumi.Output['outputs.ClusterNetworkConfiguration']:
        """
        (Updatable) The network configurations used by Cluster, including [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the management subnet and VLANs.
        """
        return pulumi.get(self, "network_configuration")

    @property
    @pulumi.getter(name="sddcId")
    def sddc_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the SDDC that the Cluster belongs to.
        """
        return pulumi.get(self, "sddc_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the Cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Cluster was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the Cluster was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="upgradeLicenses")
    def upgrade_licenses(self) -> pulumi.Output[Sequence['outputs.ClusterUpgradeLicense']]:
        """
        The vSphere licenses to use when upgrading the Cluster.
        """
        return pulumi.get(self, "upgrade_licenses")

    @property
    @pulumi.getter(name="vmwareSoftwareVersion")
    def vmware_software_version(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The VMware software bundle to install on the ESXi hosts in the Cluster. To get a list of the available versions, use [ListSupportedVmwareSoftwareVersions](https://docs.cloud.oracle.com/iaas/api/#/en/vmware/20230701/SupportedVmwareSoftwareVersionSummary/ListSupportedVmwareSoftwareVersions).
        """
        return pulumi.get(self, "vmware_software_version")

    @property
    @pulumi.getter(name="vsphereType")
    def vsphere_type(self) -> pulumi.Output[builtins.str]:
        """
        vSphere Cluster types.
        """
        return pulumi.get(self, "vsphere_type")

    @property
    @pulumi.getter(name="vsphereUpgradeObjects")
    def vsphere_upgrade_objects(self) -> pulumi.Output[Sequence['outputs.ClusterVsphereUpgradeObject']]:
        """
        The links to binary objects needed to upgrade vSphere.
        """
        return pulumi.get(self, "vsphere_upgrade_objects")

    @property
    @pulumi.getter(name="workloadNetworkCidr")
    def workload_network_cidr(self) -> pulumi.Output[builtins.str]:
        """
        The CIDR block for the IP addresses that VMware VMs in the Cluster use to run application workloads. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "workload_network_cidr")

