# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OperatorControlArgs', 'OperatorControl']

@pulumi.input_type
class OperatorControlArgs:
    def __init__(__self__, *,
                 approver_groups_lists: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 compartment_id: pulumi.Input[builtins.str],
                 is_fully_pre_approved: pulumi.Input[builtins.bool],
                 operator_control_name: pulumi.Input[builtins.str],
                 resource_type: pulumi.Input[builtins.str],
                 approvers_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 number_of_approvers: Optional[pulumi.Input[builtins.int]] = None,
                 pre_approved_op_action_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 system_message: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a OperatorControl resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approver_groups_lists: (Updatable) List of user groups who can approve an access request associated with a resource governed by this operator control.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains this operator control.
        :param pulumi.Input[builtins.bool] is_fully_pre_approved: (Updatable) Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        :param pulumi.Input[builtins.str] operator_control_name: (Updatable) Name of the operator control.
        :param pulumi.Input[builtins.str] resource_type: resourceType for which the OperatorControl is applicable
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approvers_lists: (Updatable) List of users who can approve an access request associated with a resource governed by this operator control.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[builtins.str] description: (Updatable) Description of the operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] email_id_lists: (Updatable) List of emailId.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param pulumi.Input[builtins.int] number_of_approvers: (Updatable) Number of approvers required to approve an access request.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pre_approved_op_action_lists: (Updatable) List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be auto-approved if the access request only contain operator actions in the pre-approved list.
        :param pulumi.Input[builtins.str] system_message: (Updatable) This is the message that will be displayed to the operator users while accessing the system.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "approver_groups_lists", approver_groups_lists)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "is_fully_pre_approved", is_fully_pre_approved)
        pulumi.set(__self__, "operator_control_name", operator_control_name)
        pulumi.set(__self__, "resource_type", resource_type)
        if approvers_lists is not None:
            pulumi.set(__self__, "approvers_lists", approvers_lists)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email_id_lists is not None:
            pulumi.set(__self__, "email_id_lists", email_id_lists)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if number_of_approvers is not None:
            pulumi.set(__self__, "number_of_approvers", number_of_approvers)
        if pre_approved_op_action_lists is not None:
            pulumi.set(__self__, "pre_approved_op_action_lists", pre_approved_op_action_lists)
        if system_message is not None:
            pulumi.set(__self__, "system_message", system_message)

    @property
    @pulumi.getter(name="approverGroupsLists")
    def approver_groups_lists(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) List of user groups who can approve an access request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approver_groups_lists")

    @approver_groups_lists.setter
    def approver_groups_lists(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "approver_groups_lists", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains this operator control.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isFullyPreApproved")
    def is_fully_pre_approved(self) -> pulumi.Input[builtins.bool]:
        """
        (Updatable) Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        """
        return pulumi.get(self, "is_fully_pre_approved")

    @is_fully_pre_approved.setter
    def is_fully_pre_approved(self, value: pulumi.Input[builtins.bool]):
        pulumi.set(self, "is_fully_pre_approved", value)

    @property
    @pulumi.getter(name="operatorControlName")
    def operator_control_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Name of the operator control.
        """
        return pulumi.get(self, "operator_control_name")

    @operator_control_name.setter
    def operator_control_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "operator_control_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[builtins.str]:
        """
        resourceType for which the OperatorControl is applicable
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="approversLists")
    def approvers_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of users who can approve an access request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approvers_lists")

    @approvers_lists.setter
    def approvers_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "approvers_lists", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Description of the operator control.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailIdLists")
    def email_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of emailId.
        """
        return pulumi.get(self, "email_id_lists")

    @email_id_lists.setter
    def email_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "email_id_lists", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Number of approvers required to approve an access request.
        """
        return pulumi.get(self, "number_of_approvers")

    @number_of_approvers.setter
    def number_of_approvers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_approvers", value)

    @property
    @pulumi.getter(name="preApprovedOpActionLists")
    def pre_approved_op_action_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be auto-approved if the access request only contain operator actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_op_action_lists")

    @pre_approved_op_action_lists.setter
    def pre_approved_op_action_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pre_approved_op_action_lists", value)

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) This is the message that will be displayed to the operator users while accessing the system.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_message")

    @system_message.setter
    def system_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "system_message", value)


@pulumi.input_type
class _OperatorControlState:
    def __init__(__self__, *,
                 approval_required_op_action_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 approver_groups_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 approvers_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_default_operator_control: Optional[pulumi.Input[builtins.bool]] = None,
                 is_fully_pre_approved: Optional[pulumi.Input[builtins.bool]] = None,
                 last_modified_info: Optional[pulumi.Input[builtins.str]] = None,
                 number_of_approvers: Optional[pulumi.Input[builtins.int]] = None,
                 operator_control_name: Optional[pulumi.Input[builtins.str]] = None,
                 pre_approved_op_action_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_message: Optional[pulumi.Input[builtins.str]] = None,
                 time_of_creation: Optional[pulumi.Input[builtins.str]] = None,
                 time_of_deletion: Optional[pulumi.Input[builtins.str]] = None,
                 time_of_modification: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering OperatorControl resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approval_required_op_action_lists: List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approver_groups_lists: (Updatable) List of user groups who can approve an access request associated with a resource governed by this operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approvers_lists: (Updatable) List of users who can approve an access request associated with a resource governed by this operator control.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains this operator control.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[builtins.str] description: (Updatable) Description of the operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] email_id_lists: (Updatable) List of emailId.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param pulumi.Input[builtins.bool] is_default_operator_control: Whether the operator control is a default Operator Control.
        :param pulumi.Input[builtins.bool] is_fully_pre_approved: (Updatable) Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        :param pulumi.Input[builtins.str] last_modified_info: Description associated with the latest modification of the operator control.
        :param pulumi.Input[builtins.int] number_of_approvers: (Updatable) Number of approvers required to approve an access request.
        :param pulumi.Input[builtins.str] operator_control_name: (Updatable) Name of the operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pre_approved_op_action_lists: (Updatable) List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be auto-approved if the access request only contain operator actions in the pre-approved list.
        :param pulumi.Input[builtins.str] resource_type: resourceType for which the OperatorControl is applicable
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the operator control.
        :param pulumi.Input[builtins.str] system_message: (Updatable) This is the message that will be displayed to the operator users while accessing the system.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_of_creation: Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[builtins.str] time_of_deletion: Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        :param pulumi.Input[builtins.str] time_of_modification: Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        if approval_required_op_action_lists is not None:
            pulumi.set(__self__, "approval_required_op_action_lists", approval_required_op_action_lists)
        if approver_groups_lists is not None:
            pulumi.set(__self__, "approver_groups_lists", approver_groups_lists)
        if approvers_lists is not None:
            pulumi.set(__self__, "approvers_lists", approvers_lists)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email_id_lists is not None:
            pulumi.set(__self__, "email_id_lists", email_id_lists)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_default_operator_control is not None:
            pulumi.set(__self__, "is_default_operator_control", is_default_operator_control)
        if is_fully_pre_approved is not None:
            pulumi.set(__self__, "is_fully_pre_approved", is_fully_pre_approved)
        if last_modified_info is not None:
            pulumi.set(__self__, "last_modified_info", last_modified_info)
        if number_of_approvers is not None:
            pulumi.set(__self__, "number_of_approvers", number_of_approvers)
        if operator_control_name is not None:
            pulumi.set(__self__, "operator_control_name", operator_control_name)
        if pre_approved_op_action_lists is not None:
            pulumi.set(__self__, "pre_approved_op_action_lists", pre_approved_op_action_lists)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_message is not None:
            pulumi.set(__self__, "system_message", system_message)
        if time_of_creation is not None:
            pulumi.set(__self__, "time_of_creation", time_of_creation)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if time_of_modification is not None:
            pulumi.set(__self__, "time_of_modification", time_of_modification)

    @property
    @pulumi.getter(name="approvalRequiredOpActionLists")
    def approval_required_op_action_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        """
        return pulumi.get(self, "approval_required_op_action_lists")

    @approval_required_op_action_lists.setter
    def approval_required_op_action_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "approval_required_op_action_lists", value)

    @property
    @pulumi.getter(name="approverGroupsLists")
    def approver_groups_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of user groups who can approve an access request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approver_groups_lists")

    @approver_groups_lists.setter
    def approver_groups_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "approver_groups_lists", value)

    @property
    @pulumi.getter(name="approversLists")
    def approvers_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of users who can approve an access request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approvers_lists")

    @approvers_lists.setter
    def approvers_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "approvers_lists", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The OCID of the compartment that contains this operator control.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Description of the operator control.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailIdLists")
    def email_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of emailId.
        """
        return pulumi.get(self, "email_id_lists")

    @email_id_lists.setter
    def email_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "email_id_lists", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isDefaultOperatorControl")
    def is_default_operator_control(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether the operator control is a default Operator Control.
        """
        return pulumi.get(self, "is_default_operator_control")

    @is_default_operator_control.setter
    def is_default_operator_control(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_default_operator_control", value)

    @property
    @pulumi.getter(name="isFullyPreApproved")
    def is_fully_pre_approved(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        """
        return pulumi.get(self, "is_fully_pre_approved")

    @is_fully_pre_approved.setter
    def is_fully_pre_approved(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_fully_pre_approved", value)

    @property
    @pulumi.getter(name="lastModifiedInfo")
    def last_modified_info(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Description associated with the latest modification of the operator control.
        """
        return pulumi.get(self, "last_modified_info")

    @last_modified_info.setter
    def last_modified_info(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "last_modified_info", value)

    @property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        (Updatable) Number of approvers required to approve an access request.
        """
        return pulumi.get(self, "number_of_approvers")

    @number_of_approvers.setter
    def number_of_approvers(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "number_of_approvers", value)

    @property
    @pulumi.getter(name="operatorControlName")
    def operator_control_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the operator control.
        """
        return pulumi.get(self, "operator_control_name")

    @operator_control_name.setter
    def operator_control_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "operator_control_name", value)

    @property
    @pulumi.getter(name="preApprovedOpActionLists")
    def pre_approved_op_action_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be auto-approved if the access request only contain operator actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_op_action_lists")

    @pre_approved_op_action_lists.setter
    def pre_approved_op_action_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "pre_approved_op_action_lists", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        resourceType for which the OperatorControl is applicable
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the operator control.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) This is the message that will be displayed to the operator users while accessing the system.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_message")

    @system_message.setter
    def system_message(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "system_message", value)

    @property
    @pulumi.getter(name="timeOfCreation")
    def time_of_creation(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_creation")

    @time_of_creation.setter
    def time_of_creation(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_of_creation", value)

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_of_deletion", value)

    @property
    @pulumi.getter(name="timeOfModification")
    def time_of_modification(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_modification")

    @time_of_modification.setter
    def time_of_modification(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_of_modification", value)


class OperatorControl(pulumi.CustomResource):

    pulumi_type = "oci:OperatorAccessControl/operatorControl:OperatorControl"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approver_groups_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 approvers_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_fully_pre_approved: Optional[pulumi.Input[builtins.bool]] = None,
                 number_of_approvers: Optional[pulumi.Input[builtins.int]] = None,
                 operator_control_name: Optional[pulumi.Input[builtins.str]] = None,
                 pre_approved_op_action_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 system_message: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Operator Control resource in Oracle Cloud Infrastructure Operator Access Control service.

        Creates an Operator Control.

        ## Import

        OperatorControls can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OperatorAccessControl/operatorControl:OperatorControl test_operator_control "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approver_groups_lists: (Updatable) List of user groups who can approve an access request associated with a resource governed by this operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approvers_lists: (Updatable) List of users who can approve an access request associated with a resource governed by this operator control.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains this operator control.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[builtins.str] description: (Updatable) Description of the operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] email_id_lists: (Updatable) List of emailId.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param pulumi.Input[builtins.bool] is_fully_pre_approved: (Updatable) Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        :param pulumi.Input[builtins.int] number_of_approvers: (Updatable) Number of approvers required to approve an access request.
        :param pulumi.Input[builtins.str] operator_control_name: (Updatable) Name of the operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pre_approved_op_action_lists: (Updatable) List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be auto-approved if the access request only contain operator actions in the pre-approved list.
        :param pulumi.Input[builtins.str] resource_type: resourceType for which the OperatorControl is applicable
        :param pulumi.Input[builtins.str] system_message: (Updatable) This is the message that will be displayed to the operator users while accessing the system.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OperatorControlArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Operator Control resource in Oracle Cloud Infrastructure Operator Access Control service.

        Creates an Operator Control.

        ## Import

        OperatorControls can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OperatorAccessControl/operatorControl:OperatorControl test_operator_control "id"
        ```

        :param str resource_name: The name of the resource.
        :param OperatorControlArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OperatorControlArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 approver_groups_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 approvers_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 email_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_fully_pre_approved: Optional[pulumi.Input[builtins.bool]] = None,
                 number_of_approvers: Optional[pulumi.Input[builtins.int]] = None,
                 operator_control_name: Optional[pulumi.Input[builtins.str]] = None,
                 pre_approved_op_action_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 resource_type: Optional[pulumi.Input[builtins.str]] = None,
                 system_message: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OperatorControlArgs.__new__(OperatorControlArgs)

            if approver_groups_lists is None and not opts.urn:
                raise TypeError("Missing required property 'approver_groups_lists'")
            __props__.__dict__["approver_groups_lists"] = approver_groups_lists
            __props__.__dict__["approvers_lists"] = approvers_lists
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["email_id_lists"] = email_id_lists
            __props__.__dict__["freeform_tags"] = freeform_tags
            if is_fully_pre_approved is None and not opts.urn:
                raise TypeError("Missing required property 'is_fully_pre_approved'")
            __props__.__dict__["is_fully_pre_approved"] = is_fully_pre_approved
            __props__.__dict__["number_of_approvers"] = number_of_approvers
            if operator_control_name is None and not opts.urn:
                raise TypeError("Missing required property 'operator_control_name'")
            __props__.__dict__["operator_control_name"] = operator_control_name
            __props__.__dict__["pre_approved_op_action_lists"] = pre_approved_op_action_lists
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["system_message"] = system_message
            __props__.__dict__["approval_required_op_action_lists"] = None
            __props__.__dict__["is_default_operator_control"] = None
            __props__.__dict__["last_modified_info"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_of_creation"] = None
            __props__.__dict__["time_of_deletion"] = None
            __props__.__dict__["time_of_modification"] = None
        super(OperatorControl, __self__).__init__(
            'oci:OperatorAccessControl/operatorControl:OperatorControl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            approval_required_op_action_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            approver_groups_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            approvers_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            email_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_default_operator_control: Optional[pulumi.Input[builtins.bool]] = None,
            is_fully_pre_approved: Optional[pulumi.Input[builtins.bool]] = None,
            last_modified_info: Optional[pulumi.Input[builtins.str]] = None,
            number_of_approvers: Optional[pulumi.Input[builtins.int]] = None,
            operator_control_name: Optional[pulumi.Input[builtins.str]] = None,
            pre_approved_op_action_lists: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            resource_type: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_message: Optional[pulumi.Input[builtins.str]] = None,
            time_of_creation: Optional[pulumi.Input[builtins.str]] = None,
            time_of_deletion: Optional[pulumi.Input[builtins.str]] = None,
            time_of_modification: Optional[pulumi.Input[builtins.str]] = None) -> 'OperatorControl':
        """
        Get an existing OperatorControl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approval_required_op_action_lists: List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approver_groups_lists: (Updatable) List of user groups who can approve an access request associated with a resource governed by this operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] approvers_lists: (Updatable) List of users who can approve an access request associated with a resource governed by this operator control.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The OCID of the compartment that contains this operator control.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[builtins.str] description: (Updatable) Description of the operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] email_id_lists: (Updatable) List of emailId.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param pulumi.Input[builtins.bool] is_default_operator_control: Whether the operator control is a default Operator Control.
        :param pulumi.Input[builtins.bool] is_fully_pre_approved: (Updatable) Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        :param pulumi.Input[builtins.str] last_modified_info: Description associated with the latest modification of the operator control.
        :param pulumi.Input[builtins.int] number_of_approvers: (Updatable) Number of approvers required to approve an access request.
        :param pulumi.Input[builtins.str] operator_control_name: (Updatable) Name of the operator control.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] pre_approved_op_action_lists: (Updatable) List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be auto-approved if the access request only contain operator actions in the pre-approved list.
        :param pulumi.Input[builtins.str] resource_type: resourceType for which the OperatorControl is applicable
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the operator control.
        :param pulumi.Input[builtins.str] system_message: (Updatable) This is the message that will be displayed to the operator users while accessing the system.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_of_creation: Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[builtins.str] time_of_deletion: Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        :param pulumi.Input[builtins.str] time_of_modification: Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OperatorControlState.__new__(_OperatorControlState)

        __props__.__dict__["approval_required_op_action_lists"] = approval_required_op_action_lists
        __props__.__dict__["approver_groups_lists"] = approver_groups_lists
        __props__.__dict__["approvers_lists"] = approvers_lists
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["email_id_lists"] = email_id_lists
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_default_operator_control"] = is_default_operator_control
        __props__.__dict__["is_fully_pre_approved"] = is_fully_pre_approved
        __props__.__dict__["last_modified_info"] = last_modified_info
        __props__.__dict__["number_of_approvers"] = number_of_approvers
        __props__.__dict__["operator_control_name"] = operator_control_name
        __props__.__dict__["pre_approved_op_action_lists"] = pre_approved_op_action_lists
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_message"] = system_message
        __props__.__dict__["time_of_creation"] = time_of_creation
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        __props__.__dict__["time_of_modification"] = time_of_modification
        return OperatorControl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="approvalRequiredOpActionLists")
    def approval_required_op_action_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of operator actions that need explicit approval. Any operator action not in the pre-approved list will require explicit approval. Access requests associated with a resource governed by this operator control will be require explicit approval if the access request contains any operator action in this list.
        """
        return pulumi.get(self, "approval_required_op_action_lists")

    @property
    @pulumi.getter(name="approverGroupsLists")
    def approver_groups_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) List of user groups who can approve an access request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approver_groups_lists")

    @property
    @pulumi.getter(name="approversLists")
    def approvers_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) List of users who can approve an access request associated with a resource governed by this operator control.
        """
        return pulumi.get(self, "approvers_lists")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The OCID of the compartment that contains this operator control.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Description of the operator control.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailIdLists")
    def email_id_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) List of emailId.
        """
        return pulumi.get(self, "email_id_lists")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isDefaultOperatorControl")
    def is_default_operator_control(self) -> pulumi.Output[builtins.bool]:
        """
        Whether the operator control is a default Operator Control.
        """
        return pulumi.get(self, "is_default_operator_control")

    @property
    @pulumi.getter(name="isFullyPreApproved")
    def is_fully_pre_approved(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether all the operator actions have been pre-approved. If yes, all access requests associated with a resource governed by this operator control  will be auto-approved.
        """
        return pulumi.get(self, "is_fully_pre_approved")

    @property
    @pulumi.getter(name="lastModifiedInfo")
    def last_modified_info(self) -> pulumi.Output[builtins.str]:
        """
        Description associated with the latest modification of the operator control.
        """
        return pulumi.get(self, "last_modified_info")

    @property
    @pulumi.getter(name="numberOfApprovers")
    def number_of_approvers(self) -> pulumi.Output[builtins.int]:
        """
        (Updatable) Number of approvers required to approve an access request.
        """
        return pulumi.get(self, "number_of_approvers")

    @property
    @pulumi.getter(name="operatorControlName")
    def operator_control_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Name of the operator control.
        """
        return pulumi.get(self, "operator_control_name")

    @property
    @pulumi.getter(name="preApprovedOpActionLists")
    def pre_approved_op_action_lists(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) List of pre-approved operator actions. Access requests associated with a resource governed by this operator control will be auto-approved if the access request only contain operator actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_op_action_lists")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[builtins.str]:
        """
        resourceType for which the OperatorControl is applicable
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the operator control.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemMessage")
    def system_message(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) This is the message that will be displayed to the operator users while accessing the system.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "system_message")

    @property
    @pulumi.getter(name="timeOfCreation")
    def time_of_creation(self) -> pulumi.Output[builtins.str]:
        """
        Time when the operator control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_creation")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[builtins.str]:
        """
        Time when deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format. Example: '2020-05-22T21:10:29.600Z'. Note a deleted operator control still stays in the system, so that you can still audit operator actions associated with access requests raised on target resources governed by the deleted operator control.
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="timeOfModification")
    def time_of_modification(self) -> pulumi.Output[builtins.str]:
        """
        Time when the operator control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_modification")

