# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedInstanceGroupArgs', 'ManagedInstanceGroup']

@pulumi.input_type
class ManagedInstanceGroupArgs:
    def __init__(__self__, *,
                 arch_type: pulumi.Input[builtins.str],
                 compartment_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 os_family: pulumi.Input[builtins.str],
                 vendor_name: pulumi.Input[builtins.str],
                 autonomous_settings: Optional[pulumi.Input['ManagedInstanceGroupAutonomousSettingsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        The set of arguments for constructing a ManagedInstanceGroup resource.
        :param pulumi.Input[builtins.str] arch_type: The CPU architecture type of the managed instances that will be attached to this group.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance group.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the managed instance group. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] os_family: The operating system type of the managed instances that will be attached to this group.
        :param pulumi.Input[builtins.str] vendor_name: The vendor of the operating system that will be used by the managed instances in the group. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input['ManagedInstanceGroupAutonomousSettingsArgs'] autonomous_settings: (Updatable) Updatable settings for the Autonomous Linux service.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the managed instance group. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] location: The location of managed instances attached to the group. If no location is provided, the default is on premises.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The list of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to be added to the group.
        :param pulumi.Input[builtins.str] notification_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] software_source_ids: The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) available to the managed instances in the group.
        """
        pulumi.set(__self__, "arch_type", arch_type)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "os_family", os_family)
        pulumi.set(__self__, "vendor_name", vendor_name)
        if autonomous_settings is not None:
            pulumi.set(__self__, "autonomous_settings", autonomous_settings)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_instance_ids is not None:
            pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if notification_topic_id is not None:
            pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if software_source_ids is not None:
            pulumi.set(__self__, "software_source_ids", software_source_ids)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Input[builtins.str]:
        """
        The CPU architecture type of the managed instances that will be attached to this group.
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A user-friendly name for the managed instance group. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Input[builtins.str]:
        """
        The operating system type of the managed instances that will be attached to this group.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> pulumi.Input[builtins.str]:
        """
        The vendor of the operating system that will be used by the managed instances in the group. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "vendor_name", value)

    @property
    @pulumi.getter(name="autonomousSettings")
    def autonomous_settings(self) -> Optional[pulumi.Input['ManagedInstanceGroupAutonomousSettingsArgs']]:
        """
        (Updatable) Updatable settings for the Autonomous Linux service.
        """
        return pulumi.get(self, "autonomous_settings")

    @autonomous_settings.setter
    def autonomous_settings(self, value: Optional[pulumi.Input['ManagedInstanceGroupAutonomousSettingsArgs']]):
        pulumi.set(self, "autonomous_settings", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-specified description of the managed instance group. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of managed instances attached to the group. If no location is provided, the default is on premises.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to be added to the group.
        """
        return pulumi.get(self, "managed_instance_ids")

    @managed_instance_ids.setter
    def managed_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instance_ids", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="softwareSourceIds")
    def software_source_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) available to the managed instances in the group.
        """
        return pulumi.get(self, "software_source_ids")

    @software_source_ids.setter
    def software_source_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "software_source_ids", value)


@pulumi.input_type
class _ManagedInstanceGroupState:
    def __init__(__self__, *,
                 arch_type: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_settings: Optional[pulumi.Input['ManagedInstanceGroupAutonomousSettingsArgs']] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_count: Optional[pulumi.Input[builtins.int]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None,
                 pending_job_count: Optional[pulumi.Input[builtins.int]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 software_sources: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupSoftwareSourceArgs']]]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_modified: Optional[pulumi.Input[builtins.str]] = None,
                 vendor_name: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroup resources.
        :param pulumi.Input[builtins.str] arch_type: The CPU architecture type of the managed instances that will be attached to this group.
        :param pulumi.Input['ManagedInstanceGroupAutonomousSettingsArgs'] autonomous_settings: (Updatable) Updatable settings for the Autonomous Linux service.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the managed instance group. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the managed instance group. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_managed_by_autonomous_linux: Indicates whether the Autonomous Linux service manages the group.
        :param pulumi.Input[builtins.str] location: The location of managed instances attached to the group. If no location is provided, the default is on premises.
        :param pulumi.Input[builtins.int] managed_instance_count: The number of managed instances in the group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The list of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to be added to the group.
        :param pulumi.Input[builtins.str] notification_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        :param pulumi.Input[builtins.str] os_family: The operating system type of the managed instances that will be attached to this group.
        :param pulumi.Input[builtins.int] pending_job_count: The number of scheduled jobs pending against the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] software_source_ids: The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) available to the managed instances in the group.
        :param pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupSoftwareSourceArgs']]] software_sources: The list of software sources that the managed instance group will use.
        :param pulumi.Input[builtins.str] state: The current state of the managed instance group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the managed instance group was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_modified: The time the managed instance group was last modified (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] vendor_name: The vendor of the operating system that will be used by the managed instances in the group. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if autonomous_settings is not None:
            pulumi.set(__self__, "autonomous_settings", autonomous_settings)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_managed_by_autonomous_linux is not None:
            pulumi.set(__self__, "is_managed_by_autonomous_linux", is_managed_by_autonomous_linux)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_instance_count is not None:
            pulumi.set(__self__, "managed_instance_count", managed_instance_count)
        if managed_instance_ids is not None:
            pulumi.set(__self__, "managed_instance_ids", managed_instance_ids)
        if notification_topic_id is not None:
            pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        if os_family is not None:
            pulumi.set(__self__, "os_family", os_family)
        if pending_job_count is not None:
            pulumi.set(__self__, "pending_job_count", pending_job_count)
        if software_source_ids is not None:
            pulumi.set(__self__, "software_source_ids", software_source_ids)
        if software_sources is not None:
            pulumi.set(__self__, "software_sources", software_sources)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_modified is not None:
            pulumi.set(__self__, "time_modified", time_modified)
        if vendor_name is not None:
            pulumi.set(__self__, "vendor_name", vendor_name)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The CPU architecture type of the managed instances that will be attached to this group.
        """
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "arch_type", value)

    @property
    @pulumi.getter(name="autonomousSettings")
    def autonomous_settings(self) -> Optional[pulumi.Input['ManagedInstanceGroupAutonomousSettingsArgs']]:
        """
        (Updatable) Updatable settings for the Autonomous Linux service.
        """
        return pulumi.get(self, "autonomous_settings")

    @autonomous_settings.setter
    def autonomous_settings(self, value: Optional[pulumi.Input['ManagedInstanceGroupAutonomousSettingsArgs']]):
        pulumi.set(self, "autonomous_settings", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance group.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) User-specified description of the managed instance group. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name for the managed instance group. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Indicates whether the Autonomous Linux service manages the group.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @is_managed_by_autonomous_linux.setter
    def is_managed_by_autonomous_linux(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_managed_by_autonomous_linux", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The location of managed instances attached to the group. If no location is provided, the default is on premises.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="managedInstanceCount")
    def managed_instance_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of managed instances in the group.
        """
        return pulumi.get(self, "managed_instance_count")

    @managed_instance_count.setter
    def managed_instance_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "managed_instance_count", value)

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to be added to the group.
        """
        return pulumi.get(self, "managed_instance_ids")

    @managed_instance_ids.setter
    def managed_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instance_ids", value)

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        """
        return pulumi.get(self, "notification_topic_id")

    @notification_topic_id.setter
    def notification_topic_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "notification_topic_id", value)

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The operating system type of the managed instances that will be attached to this group.
        """
        return pulumi.get(self, "os_family")

    @os_family.setter
    def os_family(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "os_family", value)

    @property
    @pulumi.getter(name="pendingJobCount")
    def pending_job_count(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The number of scheduled jobs pending against the managed instance group.
        """
        return pulumi.get(self, "pending_job_count")

    @pending_job_count.setter
    def pending_job_count(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "pending_job_count", value)

    @property
    @pulumi.getter(name="softwareSourceIds")
    def software_source_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) available to the managed instances in the group.
        """
        return pulumi.get(self, "software_source_ids")

    @software_source_ids.setter
    def software_source_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "software_source_ids", value)

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupSoftwareSourceArgs']]]]:
        """
        The list of software sources that the managed instance group will use.
        """
        return pulumi.get(self, "software_sources")

    @software_sources.setter
    def software_sources(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagedInstanceGroupSoftwareSourceArgs']]]]):
        pulumi.set(self, "software_sources", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current state of the managed instance group.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the managed instance group was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the managed instance group was last modified (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_modified")

    @time_modified.setter
    def time_modified(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_modified", value)

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The vendor of the operating system that will be used by the managed instances in the group. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

    @vendor_name.setter
    def vendor_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "vendor_name", value)


class ManagedInstanceGroup(pulumi.CustomResource):

    pulumi_type = "oci:OsManagementHub/managedInstanceGroup:ManagedInstanceGroup"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arch_type: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_settings: Optional[pulumi.Input[Union['ManagedInstanceGroupAutonomousSettingsArgs', 'ManagedInstanceGroupAutonomousSettingsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vendor_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a new managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group = oci.os_management_hub.ManagedInstanceGroup("test_managed_instance_group",
            software_source_ids=[{}],
            arch_type=managed_instance_group_arch_type,
            compartment_id=compartment_id,
            display_name=managed_instance_group_display_name,
            os_family=managed_instance_group_os_family,
            vendor_name=managed_instance_group_vendor_name,
            autonomous_settings={
                "is_data_collection_authorized": managed_instance_group_autonomous_settings_is_data_collection_authorized,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=managed_instance_group_description,
            freeform_tags={
                "Department": "Finance",
            },
            location=managed_instance_group_location,
            managed_instance_ids=managed_instance_group_managed_instance_ids,
            notification_topic_id=test_notification_topic["id"])
        ```

        ## Import

        ManagedInstanceGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroup:ManagedInstanceGroup test_managed_instance_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arch_type: The CPU architecture type of the managed instances that will be attached to this group.
        :param pulumi.Input[Union['ManagedInstanceGroupAutonomousSettingsArgs', 'ManagedInstanceGroupAutonomousSettingsArgsDict']] autonomous_settings: (Updatable) Updatable settings for the Autonomous Linux service.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the managed instance group. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the managed instance group. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.str] location: The location of managed instances attached to the group. If no location is provided, the default is on premises.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The list of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to be added to the group.
        :param pulumi.Input[builtins.str] notification_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        :param pulumi.Input[builtins.str] os_family: The operating system type of the managed instances that will be attached to this group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] software_source_ids: The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) available to the managed instances in the group.
        :param pulumi.Input[builtins.str] vendor_name: The vendor of the operating system that will be used by the managed instances in the group. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a new managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group = oci.os_management_hub.ManagedInstanceGroup("test_managed_instance_group",
            software_source_ids=[{}],
            arch_type=managed_instance_group_arch_type,
            compartment_id=compartment_id,
            display_name=managed_instance_group_display_name,
            os_family=managed_instance_group_os_family,
            vendor_name=managed_instance_group_vendor_name,
            autonomous_settings={
                "is_data_collection_authorized": managed_instance_group_autonomous_settings_is_data_collection_authorized,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=managed_instance_group_description,
            freeform_tags={
                "Department": "Finance",
            },
            location=managed_instance_group_location,
            managed_instance_ids=managed_instance_group_managed_instance_ids,
            notification_topic_id=test_notification_topic["id"])
        ```

        ## Import

        ManagedInstanceGroups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroup:ManagedInstanceGroup test_managed_instance_group "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arch_type: Optional[pulumi.Input[builtins.str]] = None,
                 autonomous_settings: Optional[pulumi.Input[Union['ManagedInstanceGroupAutonomousSettingsArgs', 'ManagedInstanceGroupAutonomousSettingsArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 location: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
                 os_family: Optional[pulumi.Input[builtins.str]] = None,
                 software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 vendor_name: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupArgs.__new__(ManagedInstanceGroupArgs)

            if arch_type is None and not opts.urn:
                raise TypeError("Missing required property 'arch_type'")
            __props__.__dict__["arch_type"] = arch_type
            __props__.__dict__["autonomous_settings"] = autonomous_settings
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_instance_ids"] = managed_instance_ids
            __props__.__dict__["notification_topic_id"] = notification_topic_id
            if os_family is None and not opts.urn:
                raise TypeError("Missing required property 'os_family'")
            __props__.__dict__["os_family"] = os_family
            __props__.__dict__["software_source_ids"] = software_source_ids
            if vendor_name is None and not opts.urn:
                raise TypeError("Missing required property 'vendor_name'")
            __props__.__dict__["vendor_name"] = vendor_name
            __props__.__dict__["is_managed_by_autonomous_linux"] = None
            __props__.__dict__["managed_instance_count"] = None
            __props__.__dict__["pending_job_count"] = None
            __props__.__dict__["software_sources"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_modified"] = None
        super(ManagedInstanceGroup, __self__).__init__(
            'oci:OsManagementHub/managedInstanceGroup:ManagedInstanceGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            arch_type: Optional[pulumi.Input[builtins.str]] = None,
            autonomous_settings: Optional[pulumi.Input[Union['ManagedInstanceGroupAutonomousSettingsArgs', 'ManagedInstanceGroupAutonomousSettingsArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_managed_by_autonomous_linux: Optional[pulumi.Input[builtins.bool]] = None,
            location: Optional[pulumi.Input[builtins.str]] = None,
            managed_instance_count: Optional[pulumi.Input[builtins.int]] = None,
            managed_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            notification_topic_id: Optional[pulumi.Input[builtins.str]] = None,
            os_family: Optional[pulumi.Input[builtins.str]] = None,
            pending_job_count: Optional[pulumi.Input[builtins.int]] = None,
            software_source_ids: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            software_sources: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupSoftwareSourceArgs', 'ManagedInstanceGroupSoftwareSourceArgsDict']]]]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_modified: Optional[pulumi.Input[builtins.str]] = None,
            vendor_name: Optional[pulumi.Input[builtins.str]] = None) -> 'ManagedInstanceGroup':
        """
        Get an existing ManagedInstanceGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] arch_type: The CPU architecture type of the managed instances that will be attached to this group.
        :param pulumi.Input[Union['ManagedInstanceGroupAutonomousSettingsArgs', 'ManagedInstanceGroupAutonomousSettingsArgsDict']] autonomous_settings: (Updatable) Updatable settings for the Autonomous Linux service.
        :param pulumi.Input[builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[builtins.str] description: (Updatable) User-specified description of the managed instance group. Avoid entering confidential information.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the managed instance group. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[builtins.bool] is_managed_by_autonomous_linux: Indicates whether the Autonomous Linux service manages the group.
        :param pulumi.Input[builtins.str] location: The location of managed instances attached to the group. If no location is provided, the default is on premises.
        :param pulumi.Input[builtins.int] managed_instance_count: The number of managed instances in the group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instance_ids: The list of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to be added to the group.
        :param pulumi.Input[builtins.str] notification_topic_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        :param pulumi.Input[builtins.str] os_family: The operating system type of the managed instances that will be attached to this group.
        :param pulumi.Input[builtins.int] pending_job_count: The number of scheduled jobs pending against the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] software_source_ids: The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) available to the managed instances in the group.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ManagedInstanceGroupSoftwareSourceArgs', 'ManagedInstanceGroupSoftwareSourceArgsDict']]]] software_sources: The list of software sources that the managed instance group will use.
        :param pulumi.Input[builtins.str] state: The current state of the managed instance group.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] time_created: The time the managed instance group was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] time_modified: The time the managed instance group was last modified (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        :param pulumi.Input[builtins.str] vendor_name: The vendor of the operating system that will be used by the managed instances in the group. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupState.__new__(_ManagedInstanceGroupState)

        __props__.__dict__["arch_type"] = arch_type
        __props__.__dict__["autonomous_settings"] = autonomous_settings
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_managed_by_autonomous_linux"] = is_managed_by_autonomous_linux
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_instance_count"] = managed_instance_count
        __props__.__dict__["managed_instance_ids"] = managed_instance_ids
        __props__.__dict__["notification_topic_id"] = notification_topic_id
        __props__.__dict__["os_family"] = os_family
        __props__.__dict__["pending_job_count"] = pending_job_count
        __props__.__dict__["software_source_ids"] = software_source_ids
        __props__.__dict__["software_sources"] = software_sources
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_modified"] = time_modified
        __props__.__dict__["vendor_name"] = vendor_name
        return ManagedInstanceGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Output[builtins.str]:
        """
        The CPU architecture type of the managed instances that will be attached to this group.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter(name="autonomousSettings")
    def autonomous_settings(self) -> pulumi.Output['outputs.ManagedInstanceGroupAutonomousSettings']:
        """
        (Updatable) Updatable settings for the Autonomous Linux service.
        """
        return pulumi.get(self, "autonomous_settings")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the managed instance group.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) User-specified description of the managed instance group. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name for the managed instance group. Does not have to be unique and you can change the name later. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isManagedByAutonomousLinux")
    def is_managed_by_autonomous_linux(self) -> pulumi.Output[builtins.bool]:
        """
        Indicates whether the Autonomous Linux service manages the group.
        """
        return pulumi.get(self, "is_managed_by_autonomous_linux")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[builtins.str]:
        """
        The location of managed instances attached to the group. If no location is provided, the default is on premises.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="managedInstanceCount")
    def managed_instance_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of managed instances in the group.
        """
        return pulumi.get(self, "managed_instance_count")

    @property
    @pulumi.getter(name="managedInstanceIds")
    def managed_instance_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to be added to the group.
        """
        return pulumi.get(self, "managed_instance_ids")

    @property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the Oracle Notifications service (ONS) topic. ONS is the channel used to send notifications to the customer.
        """
        return pulumi.get(self, "notification_topic_id")

    @property
    @pulumi.getter(name="osFamily")
    def os_family(self) -> pulumi.Output[builtins.str]:
        """
        The operating system type of the managed instances that will be attached to this group.
        """
        return pulumi.get(self, "os_family")

    @property
    @pulumi.getter(name="pendingJobCount")
    def pending_job_count(self) -> pulumi.Output[builtins.int]:
        """
        The number of scheduled jobs pending against the managed instance group.
        """
        return pulumi.get(self, "pending_job_count")

    @property
    @pulumi.getter(name="softwareSourceIds")
    def software_source_ids(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        The list of software source [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) available to the managed instances in the group.
        """
        return pulumi.get(self, "software_source_ids")

    @property
    @pulumi.getter(name="softwareSources")
    def software_sources(self) -> pulumi.Output[Sequence['outputs.ManagedInstanceGroupSoftwareSource']]:
        """
        The list of software sources that the managed instance group will use.
        """
        return pulumi.get(self, "software_sources")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current state of the managed instance group.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the managed instance group was created (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeModified")
    def time_modified(self) -> pulumi.Output[builtins.str]:
        """
        The time the managed instance group was last modified (in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) format).
        """
        return pulumi.get(self, "time_modified")

    @property
    @pulumi.getter(name="vendorName")
    def vendor_name(self) -> pulumi.Output[builtins.str]:
        """
        The vendor of the operating system that will be used by the managed instances in the group. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "vendor_name")

