# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedInstanceGroupDetachManagedInstancesManagementArgs', 'ManagedInstanceGroupDetachManagedInstancesManagement']

@pulumi.input_type
class ManagedInstanceGroupDetachManagedInstancesManagementArgs:
    def __init__(__self__, *,
                 managed_instance_group_id: pulumi.Input[builtins.str],
                 managed_instances: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        """
        The set of arguments for constructing a ManagedInstanceGroupDetachManagedInstancesManagement resource.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        pulumi.set(__self__, "managed_instances", managed_instances)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_instances")

    @managed_instances.setter
    def managed_instances(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "managed_instances", value)


@pulumi.input_type
class _ManagedInstanceGroupDetachManagedInstancesManagementState:
    def __init__(__self__, *,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ManagedInstanceGroupDetachManagedInstancesManagement resources.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if managed_instance_group_id is not None:
            pulumi.set(__self__, "managed_instance_group_id", managed_instance_group_id)
        if managed_instances is not None:
            pulumi.set(__self__, "managed_instances", managed_instances)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @managed_instance_group_id.setter
    def managed_instance_group_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "managed_instance_group_id", value)

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_instances")

    @managed_instances.setter
    def managed_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instances", value)


class ManagedInstanceGroupDetachManagedInstancesManagement(pulumi.CustomResource):

    pulumi_type = "oci:OsManagementHub/managedInstanceGroupDetachManagedInstancesManagement:ManagedInstanceGroupDetachManagedInstancesManagement"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        """
        This resource provides the Managed Instance Group Detach Managed Instances Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Removes a managed instance from the specified managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_detach_managed_instances_management = oci.os_management_hub.ManagedInstanceGroupDetachManagedInstancesManagement("test_managed_instance_group_detach_managed_instances_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            managed_instances=managed_instance_group_detach_managed_instances_management_managed_instances)
        ```

        ## Import

        ManagedInstanceGroupDetachManagedInstancesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupDetachManagedInstancesManagement:ManagedInstanceGroupDetachManagedInstancesManagement test_managed_instance_group_detach_managed_instances_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedInstanceGroupDetachManagedInstancesManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Managed Instance Group Detach Managed Instances Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Removes a managed instance from the specified managed instance group.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_managed_instance_group_detach_managed_instances_management = oci.os_management_hub.ManagedInstanceGroupDetachManagedInstancesManagement("test_managed_instance_group_detach_managed_instances_management",
            managed_instance_group_id=test_managed_instance_group["id"],
            managed_instances=managed_instance_group_detach_managed_instances_management_managed_instances)
        ```

        ## Import

        ManagedInstanceGroupDetachManagedInstancesManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/managedInstanceGroupDetachManagedInstancesManagement:ManagedInstanceGroupDetachManagedInstancesManagement test_managed_instance_group_detach_managed_instances_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagedInstanceGroupDetachManagedInstancesManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedInstanceGroupDetachManagedInstancesManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedInstanceGroupDetachManagedInstancesManagementArgs.__new__(ManagedInstanceGroupDetachManagedInstancesManagementArgs)

            if managed_instance_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instance_group_id'")
            __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
            if managed_instances is None and not opts.urn:
                raise TypeError("Missing required property 'managed_instances'")
            __props__.__dict__["managed_instances"] = managed_instances
        super(ManagedInstanceGroupDetachManagedInstancesManagement, __self__).__init__(
            'oci:OsManagementHub/managedInstanceGroupDetachManagedInstancesManagement:ManagedInstanceGroupDetachManagedInstancesManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_instance_group_id: Optional[pulumi.Input[builtins.str]] = None,
            managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None) -> 'ManagedInstanceGroupDetachManagedInstancesManagement':
        """
        Get an existing ManagedInstanceGroupDetachManagedInstancesManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] managed_instance_group_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedInstanceGroupDetachManagedInstancesManagementState.__new__(_ManagedInstanceGroupDetachManagedInstancesManagementState)

        __props__.__dict__["managed_instance_group_id"] = managed_instance_group_id
        __props__.__dict__["managed_instances"] = managed_instances
        return ManagedInstanceGroupDetachManagedInstancesManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managedInstanceGroupId")
    def managed_instance_group_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance group.
        """
        return pulumi.get(self, "managed_instance_group_id")

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to detach from the group.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "managed_instances")

