# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkRequestRerunManagementArgs', 'WorkRequestRerunManagement']

@pulumi.input_type
class WorkRequestRerunManagementArgs:
    def __init__(__self__, *,
                 work_request_id: pulumi.Input[builtins.str],
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input['WorkRequestRerunManagementWorkRequestDetailsArgs']] = None):
        """
        The set of arguments for constructing a WorkRequestRerunManagement resource.
        :param pulumi.Input[builtins.str] work_request_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the work request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to affected by the rerun of the work request.
        :param pulumi.Input['WorkRequestRerunManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        """
        pulumi.set(__self__, "work_request_id", work_request_id)
        if managed_instances is not None:
            pulumi.set(__self__, "managed_instances", managed_instances)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> pulumi.Input[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the work request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_id")

    @work_request_id.setter
    def work_request_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "work_request_id", value)

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to affected by the rerun of the work request.
        """
        return pulumi.get(self, "managed_instances")

    @managed_instances.setter
    def managed_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instances", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['WorkRequestRerunManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['WorkRequestRerunManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)


@pulumi.input_type
class _WorkRequestRerunManagementState:
    def __init__(__self__, *,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input['WorkRequestRerunManagementWorkRequestDetailsArgs']] = None,
                 work_request_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering WorkRequestRerunManagement resources.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to affected by the rerun of the work request.
        :param pulumi.Input['WorkRequestRerunManagementWorkRequestDetailsArgs'] work_request_details: Provides the name and description of the job.
        :param pulumi.Input[builtins.str] work_request_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the work request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if managed_instances is not None:
            pulumi.set(__self__, "managed_instances", managed_instances)
        if work_request_details is not None:
            pulumi.set(__self__, "work_request_details", work_request_details)
        if work_request_id is not None:
            pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to affected by the rerun of the work request.
        """
        return pulumi.get(self, "managed_instances")

    @managed_instances.setter
    def managed_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "managed_instances", value)

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> Optional[pulumi.Input['WorkRequestRerunManagementWorkRequestDetailsArgs']]:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @work_request_details.setter
    def work_request_details(self, value: Optional[pulumi.Input['WorkRequestRerunManagementWorkRequestDetailsArgs']]):
        pulumi.set(self, "work_request_details", value)

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the work request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_id")

    @work_request_id.setter
    def work_request_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "work_request_id", value)


class WorkRequestRerunManagement(pulumi.CustomResource):

    pulumi_type = "oci:OsManagementHub/workRequestRerunManagement:WorkRequestRerunManagement"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['WorkRequestRerunManagementWorkRequestDetailsArgs', 'WorkRequestRerunManagementWorkRequestDetailsArgsDict']]] = None,
                 work_request_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Work Request Rerun Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Reruns a failed work for the specified work request [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Rerunning restarts the work on failed targets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_work_request_rerun_management = oci.os_management_hub.WorkRequestRerunManagement("test_work_request_rerun_management",
            work_request_id=test_work_request["id"],
            managed_instances=work_request_rerun_management_managed_instances,
            work_request_details={
                "description": work_request_rerun_management_work_request_details_description,
                "display_name": work_request_rerun_management_work_request_details_display_name,
            })
        ```

        ## Import

        WorkRequestRerunManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/workRequestRerunManagement:WorkRequestRerunManagement test_work_request_rerun_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to affected by the rerun of the work request.
        :param pulumi.Input[Union['WorkRequestRerunManagementWorkRequestDetailsArgs', 'WorkRequestRerunManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        :param pulumi.Input[builtins.str] work_request_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the work request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkRequestRerunManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Work Request Rerun Management resource in Oracle Cloud Infrastructure Os Management Hub service.

        Reruns a failed work for the specified work request [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Rerunning restarts the work on failed targets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_work_request_rerun_management = oci.os_management_hub.WorkRequestRerunManagement("test_work_request_rerun_management",
            work_request_id=test_work_request["id"],
            managed_instances=work_request_rerun_management_managed_instances,
            work_request_details={
                "description": work_request_rerun_management_work_request_details_description,
                "display_name": work_request_rerun_management_work_request_details_display_name,
            })
        ```

        ## Import

        WorkRequestRerunManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:OsManagementHub/workRequestRerunManagement:WorkRequestRerunManagement test_work_request_rerun_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param WorkRequestRerunManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkRequestRerunManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 work_request_details: Optional[pulumi.Input[Union['WorkRequestRerunManagementWorkRequestDetailsArgs', 'WorkRequestRerunManagementWorkRequestDetailsArgsDict']]] = None,
                 work_request_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkRequestRerunManagementArgs.__new__(WorkRequestRerunManagementArgs)

            __props__.__dict__["managed_instances"] = managed_instances
            __props__.__dict__["work_request_details"] = work_request_details
            if work_request_id is None and not opts.urn:
                raise TypeError("Missing required property 'work_request_id'")
            __props__.__dict__["work_request_id"] = work_request_id
        super(WorkRequestRerunManagement, __self__).__init__(
            'oci:OsManagementHub/workRequestRerunManagement:WorkRequestRerunManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            managed_instances: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            work_request_details: Optional[pulumi.Input[Union['WorkRequestRerunManagementWorkRequestDetailsArgs', 'WorkRequestRerunManagementWorkRequestDetailsArgsDict']]] = None,
            work_request_id: Optional[pulumi.Input[builtins.str]] = None) -> 'WorkRequestRerunManagement':
        """
        Get an existing WorkRequestRerunManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] managed_instances: List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to affected by the rerun of the work request.
        :param pulumi.Input[Union['WorkRequestRerunManagementWorkRequestDetailsArgs', 'WorkRequestRerunManagementWorkRequestDetailsArgsDict']] work_request_details: Provides the name and description of the job.
        :param pulumi.Input[builtins.str] work_request_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the work request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkRequestRerunManagementState.__new__(_WorkRequestRerunManagementState)

        __props__.__dict__["managed_instances"] = managed_instances
        __props__.__dict__["work_request_details"] = work_request_details
        __props__.__dict__["work_request_id"] = work_request_id
        return WorkRequestRerunManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="managedInstances")
    def managed_instances(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        List of managed instance [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) to affected by the rerun of the work request.
        """
        return pulumi.get(self, "managed_instances")

    @property
    @pulumi.getter(name="workRequestDetails")
    def work_request_details(self) -> pulumi.Output['outputs.WorkRequestRerunManagementWorkRequestDetails']:
        """
        Provides the name and description of the job.
        """
        return pulumi.get(self, "work_request_details")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> pulumi.Output[builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the work request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "work_request_id")

