# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoringTemplateArgs', 'MonitoringTemplate']

@pulumi.input_type
class MonitoringTemplateArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[builtins.str],
                 destinations: pulumi.Input[Sequence[pulumi.Input[builtins.str]]],
                 display_name: pulumi.Input[builtins.str],
                 members: pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateMemberArgs']]],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_alarms_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_split_notification_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 message_format: Optional[pulumi.Input[builtins.str]] = None,
                 repeat_notification_duration: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a MonitoringTemplate resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment containing the monitoringTemplate.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destinations: (Updatable) A list of destinations for alarm notifications. Each destination is represented by the OCID of a related resource, such as a topic.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the monitoring template. It is unique and mutable in nature. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateMemberArgs']]] members: (Updatable) List of members of this monitoring template
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description for the monitoring template. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_alarms_enabled: (Updatable) Whether the alarm is enabled or disabled, it will be Enabled by default.
        :param pulumi.Input[builtins.bool] is_split_notification_enabled: (Updatable) Whether the alarm notification is enabled or disabled, it will be Enabled by default.
        :param pulumi.Input[builtins.str] message_format: (Updatable) The format to use for alarm notifications.
        :param pulumi.Input[builtins.str] repeat_notification_duration: (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, PT4H indicates four hours. Minimum- PT1M. Maximum - P30D.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "destinations", destinations)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "members", members)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_alarms_enabled is not None:
            pulumi.set(__self__, "is_alarms_enabled", is_alarms_enabled)
        if is_split_notification_enabled is not None:
            pulumi.set(__self__, "is_split_notification_enabled", is_split_notification_enabled)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if repeat_notification_duration is not None:
            pulumi.set(__self__, "repeat_notification_duration", repeat_notification_duration)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[builtins.str]:
        """
        The OCID of the compartment containing the monitoringTemplate.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.str]]]:
        """
        (Updatable) A list of destinations for alarm notifications. Each destination is represented by the OCID of a related resource, such as a topic.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.str]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) A user-friendly name for the monitoring template. It is unique and mutable in nature. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def members(self) -> pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateMemberArgs']]]:
        """
        (Updatable) List of members of this monitoring template
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateMemberArgs']]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description for the monitoring template. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAlarmsEnabled")
    def is_alarms_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the alarm is enabled or disabled, it will be Enabled by default.
        """
        return pulumi.get(self, "is_alarms_enabled")

    @is_alarms_enabled.setter
    def is_alarms_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_alarms_enabled", value)

    @property
    @pulumi.getter(name="isSplitNotificationEnabled")
    def is_split_notification_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the alarm notification is enabled or disabled, it will be Enabled by default.
        """
        return pulumi.get(self, "is_split_notification_enabled")

    @is_split_notification_enabled.setter
    def is_split_notification_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_split_notification_enabled", value)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The format to use for alarm notifications.
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, PT4H indicates four hours. Minimum- PT1M. Maximum - P30D.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repeat_notification_duration")

    @repeat_notification_duration.setter
    def repeat_notification_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repeat_notification_duration", value)


@pulumi.input_type
class _MonitoringTemplateState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_alarms_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_split_notification_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateMemberArgs']]]] = None,
                 message_format: Optional[pulumi.Input[builtins.str]] = None,
                 repeat_notification_duration: Optional[pulumi.Input[builtins.str]] = None,
                 state: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None,
                 total_alarm_conditions: Optional[pulumi.Input[builtins.float]] = None,
                 total_applied_alarm_conditions: Optional[pulumi.Input[builtins.float]] = None):
        """
        Input properties used for looking up and filtering MonitoringTemplate resources.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment containing the monitoringTemplate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description for the monitoring template. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destinations: (Updatable) A list of destinations for alarm notifications. Each destination is represented by the OCID of a related resource, such as a topic.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the monitoring template. It is unique and mutable in nature. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_alarms_enabled: (Updatable) Whether the alarm is enabled or disabled, it will be Enabled by default.
        :param pulumi.Input[builtins.bool] is_split_notification_enabled: (Updatable) Whether the alarm notification is enabled or disabled, it will be Enabled by default.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateMemberArgs']]] members: (Updatable) List of members of this monitoring template
        :param pulumi.Input[builtins.str] message_format: (Updatable) The format to use for alarm notifications.
        :param pulumi.Input[builtins.str] repeat_notification_duration: (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, PT4H indicates four hours. Minimum- PT1M. Maximum - P30D.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the monitoring template.
        :param pulumi.Input[builtins.str] status: The current status of the monitoring template i.e. whether it is Applied or NotApplied.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] tenant_id: Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[builtins.str] time_created: The date and time the monitoringTemplate was created. Format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the monitoringTemplate was last updated. Format defined by RFC3339.
        :param pulumi.Input[builtins.float] total_alarm_conditions: Total Alarm Conditions
        :param pulumi.Input[builtins.float] total_applied_alarm_conditions: Total Applied Alarm Conditions
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destinations is not None:
            pulumi.set(__self__, "destinations", destinations)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_alarms_enabled is not None:
            pulumi.set(__self__, "is_alarms_enabled", is_alarms_enabled)
        if is_split_notification_enabled is not None:
            pulumi.set(__self__, "is_split_notification_enabled", is_split_notification_enabled)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if message_format is not None:
            pulumi.set(__self__, "message_format", message_format)
        if repeat_notification_duration is not None:
            pulumi.set(__self__, "repeat_notification_duration", repeat_notification_duration)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_alarm_conditions is not None:
            pulumi.set(__self__, "total_alarm_conditions", total_alarm_conditions)
        if total_applied_alarm_conditions is not None:
            pulumi.set(__self__, "total_applied_alarm_conditions", total_applied_alarm_conditions)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The OCID of the compartment containing the monitoringTemplate.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly description for the monitoring template. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]:
        """
        (Updatable) A list of destinations for alarm notifications. Each destination is represented by the OCID of a related resource, such as a topic.
        """
        return pulumi.get(self, "destinations")

    @destinations.setter
    def destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "destinations", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) A user-friendly name for the monitoring template. It is unique and mutable in nature. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAlarmsEnabled")
    def is_alarms_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the alarm is enabled or disabled, it will be Enabled by default.
        """
        return pulumi.get(self, "is_alarms_enabled")

    @is_alarms_enabled.setter
    def is_alarms_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_alarms_enabled", value)

    @property
    @pulumi.getter(name="isSplitNotificationEnabled")
    def is_split_notification_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        (Updatable) Whether the alarm notification is enabled or disabled, it will be Enabled by default.
        """
        return pulumi.get(self, "is_split_notification_enabled")

    @is_split_notification_enabled.setter
    def is_split_notification_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "is_split_notification_enabled", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateMemberArgs']]]]:
        """
        (Updatable) List of members of this monitoring template
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringTemplateMemberArgs']]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The format to use for alarm notifications.
        """
        return pulumi.get(self, "message_format")

    @message_format.setter
    def message_format(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "message_format", value)

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, PT4H indicates four hours. Minimum- PT1M. Maximum - P30D.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repeat_notification_duration")

    @repeat_notification_duration.setter
    def repeat_notification_duration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "repeat_notification_duration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current lifecycle state of the monitoring template.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The current status of the monitoring template i.e. whether it is Applied or NotApplied.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the monitoringTemplate was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The date and time the monitoringTemplate was last updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalAlarmConditions")
    def total_alarm_conditions(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Total Alarm Conditions
        """
        return pulumi.get(self, "total_alarm_conditions")

    @total_alarm_conditions.setter
    def total_alarm_conditions(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "total_alarm_conditions", value)

    @property
    @pulumi.getter(name="totalAppliedAlarmConditions")
    def total_applied_alarm_conditions(self) -> Optional[pulumi.Input[builtins.float]]:
        """
        Total Applied Alarm Conditions
        """
        return pulumi.get(self, "total_applied_alarm_conditions")

    @total_applied_alarm_conditions.setter
    def total_applied_alarm_conditions(self, value: Optional[pulumi.Input[builtins.float]]):
        pulumi.set(self, "total_applied_alarm_conditions", value)


class MonitoringTemplate(pulumi.CustomResource):

    pulumi_type = "oci:StackMonitoring/monitoringTemplate:MonitoringTemplate"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_alarms_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_split_notification_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateMemberArgs', 'MonitoringTemplateMemberArgsDict']]]]] = None,
                 message_format: Optional[pulumi.Input[builtins.str]] = None,
                 repeat_notification_duration: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Monitoring Template resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new monitoring template for a given compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitoring_template = oci.stack_monitoring.MonitoringTemplate("test_monitoring_template",
            compartment_id=compartment_id,
            destinations=monitoring_template_destinations,
            display_name=monitoring_template_display_name,
            members=[{
                "id": monitoring_template_members_id,
                "type": monitoring_template_members_type,
                "composite_type": monitoring_template_members_composite_type,
            }],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=monitoring_template_description,
            freeform_tags={
                "bar-key": "value",
            },
            is_alarms_enabled=monitoring_template_is_alarms_enabled,
            is_split_notification_enabled=monitoring_template_is_split_notification_enabled,
            message_format=monitoring_template_message_format,
            repeat_notification_duration=monitoring_template_repeat_notification_duration)
        ```

        ## Import

        MonitoringTemplates can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoringTemplate:MonitoringTemplate test_monitoring_template "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment containing the monitoringTemplate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description for the monitoring template. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destinations: (Updatable) A list of destinations for alarm notifications. Each destination is represented by the OCID of a related resource, such as a topic.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the monitoring template. It is unique and mutable in nature. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_alarms_enabled: (Updatable) Whether the alarm is enabled or disabled, it will be Enabled by default.
        :param pulumi.Input[builtins.bool] is_split_notification_enabled: (Updatable) Whether the alarm notification is enabled or disabled, it will be Enabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateMemberArgs', 'MonitoringTemplateMemberArgsDict']]]] members: (Updatable) List of members of this monitoring template
        :param pulumi.Input[builtins.str] message_format: (Updatable) The format to use for alarm notifications.
        :param pulumi.Input[builtins.str] repeat_notification_duration: (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, PT4H indicates four hours. Minimum- PT1M. Maximum - P30D.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoringTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitoring Template resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new monitoring template for a given compartment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitoring_template = oci.stack_monitoring.MonitoringTemplate("test_monitoring_template",
            compartment_id=compartment_id,
            destinations=monitoring_template_destinations,
            display_name=monitoring_template_display_name,
            members=[{
                "id": monitoring_template_members_id,
                "type": monitoring_template_members_type,
                "composite_type": monitoring_template_members_composite_type,
            }],
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            description=monitoring_template_description,
            freeform_tags={
                "bar-key": "value",
            },
            is_alarms_enabled=monitoring_template_is_alarms_enabled,
            is_split_notification_enabled=monitoring_template_is_split_notification_enabled,
            message_format=monitoring_template_message_format,
            repeat_notification_duration=monitoring_template_repeat_notification_duration)
        ```

        ## Import

        MonitoringTemplates can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoringTemplate:MonitoringTemplate test_monitoring_template "id"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoringTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoringTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 description: Optional[pulumi.Input[builtins.str]] = None,
                 destinations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 is_alarms_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 is_split_notification_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateMemberArgs', 'MonitoringTemplateMemberArgsDict']]]]] = None,
                 message_format: Optional[pulumi.Input[builtins.str]] = None,
                 repeat_notification_duration: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoringTemplateArgs.__new__(MonitoringTemplateArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if destinations is None and not opts.urn:
                raise TypeError("Missing required property 'destinations'")
            __props__.__dict__["destinations"] = destinations
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_alarms_enabled"] = is_alarms_enabled
            __props__.__dict__["is_split_notification_enabled"] = is_split_notification_enabled
            if members is None and not opts.urn:
                raise TypeError("Missing required property 'members'")
            __props__.__dict__["members"] = members
            __props__.__dict__["message_format"] = message_format
            __props__.__dict__["repeat_notification_duration"] = repeat_notification_duration
            __props__.__dict__["state"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
            __props__.__dict__["total_alarm_conditions"] = None
            __props__.__dict__["total_applied_alarm_conditions"] = None
        super(MonitoringTemplate, __self__).__init__(
            'oci:StackMonitoring/monitoringTemplate:MonitoringTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            description: Optional[pulumi.Input[builtins.str]] = None,
            destinations: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            is_alarms_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            is_split_notification_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            members: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateMemberArgs', 'MonitoringTemplateMemberArgsDict']]]]] = None,
            message_format: Optional[pulumi.Input[builtins.str]] = None,
            repeat_notification_duration: Optional[pulumi.Input[builtins.str]] = None,
            state: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None,
            total_alarm_conditions: Optional[pulumi.Input[builtins.float]] = None,
            total_applied_alarm_conditions: Optional[pulumi.Input[builtins.float]] = None) -> 'MonitoringTemplate':
        """
        Get an existing MonitoringTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] compartment_id: The OCID of the compartment containing the monitoringTemplate.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] description: (Updatable) A user-friendly description for the monitoring template. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.str]]] destinations: (Updatable) A list of destinations for alarm notifications. Each destination is represented by the OCID of a related resource, such as a topic.
        :param pulumi.Input[builtins.str] display_name: (Updatable) A user-friendly name for the monitoring template. It is unique and mutable in nature. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.bool] is_alarms_enabled: (Updatable) Whether the alarm is enabled or disabled, it will be Enabled by default.
        :param pulumi.Input[builtins.bool] is_split_notification_enabled: (Updatable) Whether the alarm notification is enabled or disabled, it will be Enabled by default.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoringTemplateMemberArgs', 'MonitoringTemplateMemberArgsDict']]]] members: (Updatable) List of members of this monitoring template
        :param pulumi.Input[builtins.str] message_format: (Updatable) The format to use for alarm notifications.
        :param pulumi.Input[builtins.str] repeat_notification_duration: (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, PT4H indicates four hours. Minimum- PT1M. Maximum - P30D.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] state: The current lifecycle state of the monitoring template.
        :param pulumi.Input[builtins.str] status: The current status of the monitoring template i.e. whether it is Applied or NotApplied.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[builtins.str] tenant_id: Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        :param pulumi.Input[builtins.str] time_created: The date and time the monitoringTemplate was created. Format defined by RFC3339.
        :param pulumi.Input[builtins.str] time_updated: The date and time the monitoringTemplate was last updated. Format defined by RFC3339.
        :param pulumi.Input[builtins.float] total_alarm_conditions: Total Alarm Conditions
        :param pulumi.Input[builtins.float] total_applied_alarm_conditions: Total Applied Alarm Conditions
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoringTemplateState.__new__(_MonitoringTemplateState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["destinations"] = destinations
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_alarms_enabled"] = is_alarms_enabled
        __props__.__dict__["is_split_notification_enabled"] = is_split_notification_enabled
        __props__.__dict__["members"] = members
        __props__.__dict__["message_format"] = message_format
        __props__.__dict__["repeat_notification_duration"] = repeat_notification_duration
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_alarm_conditions"] = total_alarm_conditions
        __props__.__dict__["total_applied_alarm_conditions"] = total_applied_alarm_conditions
        return MonitoringTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[builtins.str]:
        """
        The OCID of the compartment containing the monitoringTemplate.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly description for the monitoring template. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def destinations(self) -> pulumi.Output[Sequence[builtins.str]]:
        """
        (Updatable) A list of destinations for alarm notifications. Each destination is represented by the OCID of a related resource, such as a topic.
        """
        return pulumi.get(self, "destinations")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) A user-friendly name for the monitoring template. It is unique and mutable in nature. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAlarmsEnabled")
    def is_alarms_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether the alarm is enabled or disabled, it will be Enabled by default.
        """
        return pulumi.get(self, "is_alarms_enabled")

    @property
    @pulumi.getter(name="isSplitNotificationEnabled")
    def is_split_notification_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        (Updatable) Whether the alarm notification is enabled or disabled, it will be Enabled by default.
        """
        return pulumi.get(self, "is_split_notification_enabled")

    @property
    @pulumi.getter
    def members(self) -> pulumi.Output[Sequence['outputs.MonitoringTemplateMember']]:
        """
        (Updatable) List of members of this monitoring template
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter(name="messageFormat")
    def message_format(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The format to use for alarm notifications.
        """
        return pulumi.get(self, "message_format")

    @property
    @pulumi.getter(name="repeatNotificationDuration")
    def repeat_notification_duration(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The frequency for re-submitting alarm notifications, if the alarm keeps firing without interruption. Format defined by ISO 8601. For example, PT4H indicates four hours. Minimum- PT1M. Maximum - P30D.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "repeat_notification_duration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[builtins.str]:
        """
        The current lifecycle state of the monitoring template.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        The current status of the monitoring template i.e. whether it is Applied or NotApplied.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[builtins.str]:
        """
        Tenant Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the monitoringTemplate was created. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The date and time the monitoringTemplate was last updated. Format defined by RFC3339.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalAlarmConditions")
    def total_alarm_conditions(self) -> pulumi.Output[builtins.float]:
        """
        Total Alarm Conditions
        """
        return pulumi.get(self, "total_alarm_conditions")

    @property
    @pulumi.getter(name="totalAppliedAlarmConditions")
    def total_applied_alarm_conditions(self) -> pulumi.Output[builtins.float]:
        """
        Total Applied Alarm Conditions
        """
        return pulumi.get(self, "total_applied_alarm_conditions")

