# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetInstVbsInstancesResult',
    'AwaitableGetInstVbsInstancesResult',
    'get_inst_vbs_instances',
    'get_inst_vbs_instances_output',
]

@pulumi.output_type
class GetInstVbsInstancesResult:
    """
    A collection of values returned by getInstVbsInstances.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, name=None, state=None, vbs_instance_summary_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vbs_instance_summary_collections and not isinstance(vbs_instance_summary_collections, list):
            raise TypeError("Expected argument 'vbs_instance_summary_collections' to be a list")
        pulumi.set(__self__, "vbs_instance_summary_collections", vbs_instance_summary_collections)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        Compartment of the service instance
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetInstVbsInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Unique identifier that is immutable on creation
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Service instance name (unique identifier)
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[builtins.str]:
        """
        The current state of the VbsInstance.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vbsInstanceSummaryCollections")
    def vbs_instance_summary_collections(self) -> Sequence['outputs.GetInstVbsInstancesVbsInstanceSummaryCollectionResult']:
        """
        The list of vbs_instance_summary_collection.
        """
        return pulumi.get(self, "vbs_instance_summary_collections")


class AwaitableGetInstVbsInstancesResult(GetInstVbsInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstVbsInstancesResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state,
            vbs_instance_summary_collections=self.vbs_instance_summary_collections)


def get_inst_vbs_instances(compartment_id: Optional[builtins.str] = None,
                           filters: Optional[Sequence[Union['GetInstVbsInstancesFilterArgs', 'GetInstVbsInstancesFilterArgsDict']]] = None,
                           id: Optional[builtins.str] = None,
                           name: Optional[builtins.str] = None,
                           state: Optional[builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstVbsInstancesResult:
    """
    This data source provides the list of Vbs Instances in Oracle Cloud Infrastructure Vbs Inst service.

    Returns a list of VbsInstances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vbs_instances = oci.Vbs.get_inst_vbs_instances(compartment_id=compartment_id,
        id=vbs_instance_id,
        name=vbs_instance_name,
        state=vbs_instance_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str id: unique VbsInstance identifier
    :param builtins.str name: A filter to return only resources that match the entire name given.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Vbs/getInstVbsInstances:getInstVbsInstances', __args__, opts=opts, typ=GetInstVbsInstancesResult).value

    return AwaitableGetInstVbsInstancesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'),
        vbs_instance_summary_collections=pulumi.get(__ret__, 'vbs_instance_summary_collections'))
def get_inst_vbs_instances_output(compartment_id: Optional[pulumi.Input[builtins.str]] = None,
                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetInstVbsInstancesFilterArgs', 'GetInstVbsInstancesFilterArgsDict']]]]] = None,
                                  id: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  name: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  state: Optional[pulumi.Input[Optional[builtins.str]]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstVbsInstancesResult]:
    """
    This data source provides the list of Vbs Instances in Oracle Cloud Infrastructure Vbs Inst service.

    Returns a list of VbsInstances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vbs_instances = oci.Vbs.get_inst_vbs_instances(compartment_id=compartment_id,
        id=vbs_instance_id,
        name=vbs_instance_name,
        state=vbs_instance_state)
    ```


    :param builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param builtins.str id: unique VbsInstance identifier
    :param builtins.str name: A filter to return only resources that match the entire name given.
    :param builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Vbs/getInstVbsInstances:getInstVbsInstances', __args__, opts=opts, typ=GetInstVbsInstancesResult)
    return __ret__.apply(lambda __response__: GetInstVbsInstancesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state'),
        vbs_instance_summary_collections=pulumi.get(__response__, 'vbs_instance_summary_collections')))
