/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The url of the Azure blob storage container to write audit logs to if `audit_logging_enabled` is `true`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#audit_log_storage_container_url Cluster#audit_log_storage_container_url}
    */
    readonly auditLogStorageContainerUrl?: string;
    /**
    * Enables Consul audit logging for the cluster resource. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#audit_logging_enabled Cluster#audit_logging_enabled}
    */
    readonly auditLoggingEnabled?: boolean | cdktf.IResolvable;
    /**
    * The mode of the cluster ('Development' or 'Production'). Development clusters only have a single Consul server. Production clusters are fully supported, full featured, and deploy with a minimum of three hosts.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#cluster_mode Cluster#cluster_mode}
    */
    readonly clusterMode: string;
    /**
    * The name of the cluster Managed Resource. If not specified, it is defaulted to the value of `managed_application_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#cluster_name Cluster#cluster_name}
    */
    readonly clusterName?: string;
    /**
    * The Consul data center name of the cluster. If not specified, it is defaulted to the value of `managed_application_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#consul_datacenter Cluster#consul_datacenter}
    */
    readonly consulDatacenter?: string;
    /**
    * Denotes that the cluster has an external endpoint for the Consul UI. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#consul_external_endpoint Cluster#consul_external_endpoint}
    */
    readonly consulExternalEndpoint?: boolean | cdktf.IResolvable;
    /**
    * The token used to join a federation of Consul clusters. If the cluster is not part of a federation, this field will be empty.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#consul_federation_token Cluster#consul_federation_token}
    */
    readonly consulFederationToken?: string;
    /**
    * The contact email for the primary owner of the cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#email Cluster#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#id Cluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The Azure region that the cluster is deployed to. If not specified, it is defaulted to the region of the Resource Group the Managed Application belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#location Cluster#location}
    */
    readonly location?: string;
    /**
    * The name of the HCS Azure Managed Application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#managed_application_name Cluster#managed_application_name}
    */
    readonly managedApplicationName: string;
    /**
    * The name of the Managed Resource Group in which the cluster resources belong. If not specified, it is defaulted to the value of `managed_application_name` with 'mrg-' prepended.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#managed_resource_group_name Cluster#managed_resource_group_name}
    */
    readonly managedResourceGroupName?: string;
    /**
    * The minimum Consul version of the cluster. If not specified, it is defaulted to the version that is currently recommended by HCS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#min_consul_version Cluster#min_consul_version}
    */
    readonly minConsulVersion?: string;
    /**
    * The name of the Azure Marketplace HCS plan for the cluster. If not specified, it will default to the current HCS default plan (see the `hcs_plan_defaults` data source).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#plan_name Cluster#plan_name}
    */
    readonly planName?: string;
    /**
    * The name of the Resource Group in which the HCS Azure Managed Application belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#resource_group_name Cluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * A mapping of tags to assign to the HCS Azure Managed Application resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#tags Cluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * The VNET CIDR range of the Consul cluster. Defaults to `172.25.16.0/24`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#vnet_cidr Cluster#vnet_cidr}
    */
    readonly vnetCidr?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#timeouts Cluster#timeouts}
    */
    readonly timeouts?: ClusterTimeouts;
}
export interface ClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#create Cluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#default Cluster#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#delete Cluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#update Cluster#update}
    */
    readonly update?: string;
}
export declare function clusterTimeoutsToTerraform(struct?: ClusterTimeouts | cdktf.IResolvable): any;
export declare function clusterTimeoutsToHclTerraform(struct?: ClusterTimeouts | cdktf.IResolvable): any;
export declare class ClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster hcs_cluster}
*/
export declare class Cluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "hcs_cluster";
    /**
    * Generates CDKTF code for importing a Cluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Cluster to import
    * @param importFromId The id of the existing Cluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Cluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/resources/cluster hcs_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ClusterConfig
    */
    constructor(scope: Construct, id: string, config: ClusterConfig);
    private _auditLogStorageContainerUrl?;
    get auditLogStorageContainerUrl(): string;
    set auditLogStorageContainerUrl(value: string);
    resetAuditLogStorageContainerUrl(): void;
    get auditLogStorageContainerUrlInput(): string | undefined;
    private _auditLoggingEnabled?;
    get auditLoggingEnabled(): boolean | cdktf.IResolvable;
    set auditLoggingEnabled(value: boolean | cdktf.IResolvable);
    resetAuditLoggingEnabled(): void;
    get auditLoggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get blobContainerName(): string;
    private _clusterMode?;
    get clusterMode(): string;
    set clusterMode(value: string);
    get clusterModeInput(): string | undefined;
    private _clusterName?;
    get clusterName(): string;
    set clusterName(value: string);
    resetClusterName(): void;
    get clusterNameInput(): string | undefined;
    get consulAutomaticUpgrades(): cdktf.IResolvable;
    get consulCaFile(): string;
    get consulClusterId(): string;
    get consulConfigFile(): string;
    get consulConnect(): cdktf.IResolvable;
    private _consulDatacenter?;
    get consulDatacenter(): string;
    set consulDatacenter(value: string);
    resetConsulDatacenter(): void;
    get consulDatacenterInput(): string | undefined;
    private _consulExternalEndpoint?;
    get consulExternalEndpoint(): boolean | cdktf.IResolvable;
    set consulExternalEndpoint(value: boolean | cdktf.IResolvable);
    resetConsulExternalEndpoint(): void;
    get consulExternalEndpointInput(): boolean | cdktf.IResolvable | undefined;
    get consulExternalEndpointUrl(): string;
    private _consulFederationToken?;
    get consulFederationToken(): string;
    set consulFederationToken(value: string);
    resetConsulFederationToken(): void;
    get consulFederationTokenInput(): string | undefined;
    get consulPrivateEndpointUrl(): string;
    get consulRootTokenAccessorId(): string;
    get consulRootTokenSecretId(): string;
    get consulSnapshotInterval(): string;
    get consulSnapshotRetention(): string;
    get consulVersion(): string;
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get managedApplicationId(): string;
    private _managedApplicationName?;
    get managedApplicationName(): string;
    set managedApplicationName(value: string);
    get managedApplicationNameInput(): string | undefined;
    get managedIdentityName(): string;
    private _managedResourceGroupName?;
    get managedResourceGroupName(): string;
    set managedResourceGroupName(value: string);
    resetManagedResourceGroupName(): void;
    get managedResourceGroupNameInput(): string | undefined;
    private _minConsulVersion?;
    get minConsulVersion(): string;
    set minConsulVersion(value: string);
    resetMinConsulVersion(): void;
    get minConsulVersionInput(): string | undefined;
    private _planName?;
    get planName(): string;
    set planName(value: string);
    resetPlanName(): void;
    get planNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get state(): string;
    get storageAccountName(): string;
    get storageAccountResourceGroup(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _vnetCidr?;
    get vnetCidr(): string;
    set vnetCidr(value: string);
    resetVnetCidr(): void;
    get vnetCidrInput(): string | undefined;
    get vnetId(): string;
    get vnetName(): string;
    get vnetResourceGroupName(): string;
    private _timeouts;
    get timeouts(): ClusterTimeoutsOutputReference;
    putTimeouts(value: ClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
