/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHcsAgentHelmConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the AKS cluster that will consume the Helm config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#aks_cluster_name DataHcsAgentHelmConfig#aks_cluster_name}
    */
    readonly aksClusterName: string;
    /**
    * The resource group name of the AKS cluster that will consume the Helm config. If not specified, it is defaulted to the value of `resource_group_name`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#aks_resource_group DataHcsAgentHelmConfig#aks_resource_group}
    */
    readonly aksResourceGroup?: string;
    /**
    * Denotes that the gossip ports should be exposed. Defaults to `false`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#expose_gossip_ports DataHcsAgentHelmConfig#expose_gossip_ports}
    */
    readonly exposeGossipPorts?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#id DataHcsAgentHelmConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the HCS Azure Managed Application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#managed_application_name DataHcsAgentHelmConfig#managed_application_name}
    */
    readonly managedApplicationName: string;
    /**
    * The name of the Resource Group in which the HCS Azure Managed Application belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#resource_group_name DataHcsAgentHelmConfig#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#timeouts DataHcsAgentHelmConfig#timeouts}
    */
    readonly timeouts?: DataHcsAgentHelmConfigTimeouts;
}
export interface DataHcsAgentHelmConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#default DataHcsAgentHelmConfig#default}
    */
    readonly default?: string;
}
export declare function dataHcsAgentHelmConfigTimeoutsToTerraform(struct?: DataHcsAgentHelmConfigTimeouts | cdktf.IResolvable): any;
export declare function dataHcsAgentHelmConfigTimeoutsToHclTerraform(struct?: DataHcsAgentHelmConfigTimeouts | cdktf.IResolvable): any;
export declare class DataHcsAgentHelmConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataHcsAgentHelmConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataHcsAgentHelmConfigTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config hcs_agent_helm_config}
*/
export declare class DataHcsAgentHelmConfig extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hcs_agent_helm_config";
    /**
    * Generates CDKTF code for importing a DataHcsAgentHelmConfig resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataHcsAgentHelmConfig to import
    * @param importFromId The id of the existing DataHcsAgentHelmConfig that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataHcsAgentHelmConfig to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_helm_config hcs_agent_helm_config} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHcsAgentHelmConfigConfig
    */
    constructor(scope: Construct, id: string, config: DataHcsAgentHelmConfigConfig);
    private _aksClusterName?;
    get aksClusterName(): string;
    set aksClusterName(value: string);
    get aksClusterNameInput(): string | undefined;
    private _aksResourceGroup?;
    get aksResourceGroup(): string;
    set aksResourceGroup(value: string);
    resetAksResourceGroup(): void;
    get aksResourceGroupInput(): string | undefined;
    get config(): string;
    private _exposeGossipPorts?;
    get exposeGossipPorts(): boolean | cdktf.IResolvable;
    set exposeGossipPorts(value: boolean | cdktf.IResolvable);
    resetExposeGossipPorts(): void;
    get exposeGossipPortsInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedApplicationName?;
    get managedApplicationName(): string;
    set managedApplicationName(value: string);
    get managedApplicationNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataHcsAgentHelmConfigTimeoutsOutputReference;
    putTimeouts(value: DataHcsAgentHelmConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataHcsAgentHelmConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
