/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHcsAgentKubernetesSecretConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_kubernetes_secret#id DataHcsAgentKubernetesSecret#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the HCS Azure Managed Application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_kubernetes_secret#managed_application_name DataHcsAgentKubernetesSecret#managed_application_name}
    */
    readonly managedApplicationName: string;
    /**
    * The name of the Resource Group in which the HCS Azure Managed Application belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_kubernetes_secret#resource_group_name DataHcsAgentKubernetesSecret#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_kubernetes_secret#timeouts DataHcsAgentKubernetesSecret#timeouts}
    */
    readonly timeouts?: DataHcsAgentKubernetesSecretTimeouts;
}
export interface DataHcsAgentKubernetesSecretTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_kubernetes_secret#default DataHcsAgentKubernetesSecret#default}
    */
    readonly default?: string;
}
export declare function dataHcsAgentKubernetesSecretTimeoutsToTerraform(struct?: DataHcsAgentKubernetesSecretTimeouts | cdktf.IResolvable): any;
export declare function dataHcsAgentKubernetesSecretTimeoutsToHclTerraform(struct?: DataHcsAgentKubernetesSecretTimeouts | cdktf.IResolvable): any;
export declare class DataHcsAgentKubernetesSecretTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataHcsAgentKubernetesSecretTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataHcsAgentKubernetesSecretTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_kubernetes_secret hcs_agent_kubernetes_secret}
*/
export declare class DataHcsAgentKubernetesSecret extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hcs_agent_kubernetes_secret";
    /**
    * Generates CDKTF code for importing a DataHcsAgentKubernetesSecret resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataHcsAgentKubernetesSecret to import
    * @param importFromId The id of the existing DataHcsAgentKubernetesSecret that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_kubernetes_secret#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataHcsAgentKubernetesSecret to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/agent_kubernetes_secret hcs_agent_kubernetes_secret} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHcsAgentKubernetesSecretConfig
    */
    constructor(scope: Construct, id: string, config: DataHcsAgentKubernetesSecretConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedApplicationName?;
    get managedApplicationName(): string;
    set managedApplicationName(value: string);
    get managedApplicationNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secret(): string;
    private _timeouts;
    get timeouts(): DataHcsAgentKubernetesSecretTimeoutsOutputReference;
    putTimeouts(value: DataHcsAgentKubernetesSecretTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataHcsAgentKubernetesSecretTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
