/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataHcsPlanDefaultsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/plan_defaults#id DataHcsPlanDefaults#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/plan_defaults#timeouts DataHcsPlanDefaults#timeouts}
    */
    readonly timeouts?: DataHcsPlanDefaultsTimeouts;
}
export interface DataHcsPlanDefaultsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/plan_defaults#default DataHcsPlanDefaults#default}
    */
    readonly default?: string;
}
export declare function dataHcsPlanDefaultsTimeoutsToTerraform(struct?: DataHcsPlanDefaultsTimeouts | cdktf.IResolvable): any;
export declare function dataHcsPlanDefaultsTimeoutsToHclTerraform(struct?: DataHcsPlanDefaultsTimeouts | cdktf.IResolvable): any;
export declare class DataHcsPlanDefaultsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataHcsPlanDefaultsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataHcsPlanDefaultsTimeouts | cdktf.IResolvable | undefined);
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/plan_defaults hcs_plan_defaults}
*/
export declare class DataHcsPlanDefaults extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "hcs_plan_defaults";
    /**
    * Generates CDKTF code for importing a DataHcsPlanDefaults resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataHcsPlanDefaults to import
    * @param importFromId The id of the existing DataHcsPlanDefaults that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/plan_defaults#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataHcsPlanDefaults to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs/data-sources/plan_defaults hcs_plan_defaults} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataHcsPlanDefaultsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataHcsPlanDefaultsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get offer(): string;
    get planName(): string;
    get planVersion(): string;
    get publisher(): string;
    private _timeouts;
    get timeouts(): DataHcsPlanDefaultsTimeoutsOutputReference;
    putTimeouts(value: DataHcsPlanDefaultsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataHcsPlanDefaultsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
