/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface HcsProviderConfig {
    /**
    * The password associated with the Azure Client Certificate. For use when authenticating as a Service Principal using a Client Certificate
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_client_certificate_password HcsProvider#azure_client_certificate_password}
    */
    readonly azureClientCertificatePassword?: string;
    /**
    * The path to the Azure Client Certificate associated with the Service Principal for use when authenticating as a Service Principal using a Client Certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_client_certificate_path HcsProvider#azure_client_certificate_path}
    */
    readonly azureClientCertificatePath?: string;
    /**
    * The Azure Client ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_client_id HcsProvider#azure_client_id}
    */
    readonly azureClientId?: string;
    /**
    * The Azure Client Secret which should be used. For use when authenticating as a Service Principal using a Client Secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_client_secret HcsProvider#azure_client_secret}
    */
    readonly azureClientSecret?: string;
    /**
    * The Azure Cloud Environment which should be used. Possible values are public, usgovernment, german, and china. Defaults to public.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_environment HcsProvider#azure_environment}
    */
    readonly azureEnvironment?: string;
    /**
    * The hostname which should be used for the Azure Metadata Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_metadata_host HcsProvider#azure_metadata_host}
    */
    readonly azureMetadataHost?: string;
    /**
    * The path to a custom endpoint for Azure Managed Service Identity - in most circumstances this should be detected automatically.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_msi_endpoint HcsProvider#azure_msi_endpoint}
    */
    readonly azureMsiEndpoint?: string;
    /**
    * The Azure Subscription ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_subscription_id HcsProvider#azure_subscription_id}
    */
    readonly azureSubscriptionId?: string;
    /**
    * The Azure Tenant ID which should be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_tenant_id HcsProvider#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * Allowed Azure Managed Service Identity be used for Authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#azure_use_msi HcsProvider#azure_use_msi}
    */
    readonly azureUseMsi?: boolean | cdktf.IResolvable;
    /**
    * The HashiCorp Cloud Platform API domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#hcp_api_domain HcsProvider#hcp_api_domain}
    */
    readonly hcpApiDomain?: string;
    /**
    * The HashiCorp Consul Service product name on the Azure marketplace.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#hcs_marketplace_product_name HcsProvider#hcs_marketplace_product_name}
    */
    readonly hcsMarketplaceProductName?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#alias HcsProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs hcs}
*/
export declare class HcsProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "hcs";
    /**
    * Generates CDKTF code for importing a HcsProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the HcsProvider to import
    * @param importFromId The id of the existing HcsProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the HcsProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/hcs/0.5.1/docs hcs} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options HcsProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: HcsProviderConfig);
    private _azureClientCertificatePassword?;
    get azureClientCertificatePassword(): string | undefined;
    set azureClientCertificatePassword(value: string | undefined);
    resetAzureClientCertificatePassword(): void;
    get azureClientCertificatePasswordInput(): string | undefined;
    private _azureClientCertificatePath?;
    get azureClientCertificatePath(): string | undefined;
    set azureClientCertificatePath(value: string | undefined);
    resetAzureClientCertificatePath(): void;
    get azureClientCertificatePathInput(): string | undefined;
    private _azureClientId?;
    get azureClientId(): string | undefined;
    set azureClientId(value: string | undefined);
    resetAzureClientId(): void;
    get azureClientIdInput(): string | undefined;
    private _azureClientSecret?;
    get azureClientSecret(): string | undefined;
    set azureClientSecret(value: string | undefined);
    resetAzureClientSecret(): void;
    get azureClientSecretInput(): string | undefined;
    private _azureEnvironment?;
    get azureEnvironment(): string | undefined;
    set azureEnvironment(value: string | undefined);
    resetAzureEnvironment(): void;
    get azureEnvironmentInput(): string | undefined;
    private _azureMetadataHost?;
    get azureMetadataHost(): string | undefined;
    set azureMetadataHost(value: string | undefined);
    resetAzureMetadataHost(): void;
    get azureMetadataHostInput(): string | undefined;
    private _azureMsiEndpoint?;
    get azureMsiEndpoint(): string | undefined;
    set azureMsiEndpoint(value: string | undefined);
    resetAzureMsiEndpoint(): void;
    get azureMsiEndpointInput(): string | undefined;
    private _azureSubscriptionId?;
    get azureSubscriptionId(): string | undefined;
    set azureSubscriptionId(value: string | undefined);
    resetAzureSubscriptionId(): void;
    get azureSubscriptionIdInput(): string | undefined;
    private _azureTenantId?;
    get azureTenantId(): string | undefined;
    set azureTenantId(value: string | undefined);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _azureUseMsi?;
    get azureUseMsi(): boolean | cdktf.IResolvable | undefined;
    set azureUseMsi(value: boolean | cdktf.IResolvable | undefined);
    resetAzureUseMsi(): void;
    get azureUseMsiInput(): boolean | cdktf.IResolvable | undefined;
    private _hcpApiDomain?;
    get hcpApiDomain(): string | undefined;
    set hcpApiDomain(value: string | undefined);
    resetHcpApiDomain(): void;
    get hcpApiDomainInput(): string | undefined;
    private _hcsMarketplaceProductName?;
    get hcsMarketplaceProductName(): string | undefined;
    set hcsMarketplaceProductName(value: string | undefined);
    resetHcsMarketplaceProductName(): void;
    get hcsMarketplaceProductNameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
