/*
 * Decompiled with CFR 0.152.
 */
package kco.forceatlas2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kco.forceatlas2.ForceAtlas2Builder;
import kco.forceatlas2.ForceAtlas2LayoutData;
import kco.forceatlas2.ForceAtlas2LayoutData2d;
import kco.forceatlas2.ForceAtlas2LayoutData3d;
import kco.forceatlas2.ForceFactory;
import kco.forceatlas2.NodesThread;
import kco.forceatlas2.Region;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.spi.LayoutData;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ForceAtlas2
implements Layout {
    private final ForceAtlas2Builder layoutBuilder;
    private double outboundAttCompensation = 1.0;
    private GraphModel graphModel;
    private Graph graph;
    private double edgeWeightInfluence;
    private double jitterTolerance;
    private double scalingRatio;
    private double gravity;
    private double speed;
    private double speedEfficiency;
    private boolean outboundAttractionDistribution;
    private boolean adjustSizes;
    private boolean barnesHutOptimize;
    private double barnesHutTheta;
    private boolean linLogMode;
    private boolean strongGravityMode;
    private int threadCount;
    private int currentThreadCount;
    private int stepCount;
    private int updateBarnesHutIter = 1;
    private Region rootRegion;
    private ExecutorService pool;
    private boolean updateCenter = true;
    private Node[] nodes;
    private Edge[] edges;
    private int barnesHutSplits = -1;
    private double distance;
    private final boolean is3d;
    private final boolean useAltSpeed;

    public ForceAtlas2(ForceAtlas2Builder forceAtlas2Builder, boolean bl, boolean bl2) {
        this.layoutBuilder = forceAtlas2Builder;
        this.is3d = bl;
        this.useAltSpeed = bl2;
        this.threadCount = Runtime.getRuntime().availableProcessors();
    }

    private static double getEdgeWeight(Edge edge, boolean bl, Interval interval) {
        if (bl) {
            return edge.getWeight(interval);
        }
        return edge.getWeight();
    }

    private static void waitForFutures(List<Future> list) {
        for (Future future : list) {
            try {
                future.get();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void initAlgo() {
        this.stepCount = 0;
        this.speed = 1.0;
        this.speedEfficiency = 1.0;
        this.graph = this.graphModel.getGraphVisible();
        this.nodes = this.graph.getNodes().toArray();
        this.edges = this.graph.getEdges().toArray();
        this.pool = Executors.newFixedThreadPool(this.threadCount);
        if (this.barnesHutSplits == -1) {
            this.barnesHutSplits = (int)Math.floor(Math.log(this.threadCount) / Math.log(this.is3d ? 8.0 : 4.0) + 0.02) + 1;
        }
        for (Node node : this.nodes) {
            ForceAtlas2LayoutData forceAtlas2LayoutData;
            if (node.getLayoutData() == null) {
                forceAtlas2LayoutData = this.is3d ? new ForceAtlas2LayoutData3d() : new ForceAtlas2LayoutData2d();
                node.setLayoutData((LayoutData)forceAtlas2LayoutData);
            }
            forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
            forceAtlas2LayoutData.setMass(1 + this.graph.getDegree(node));
            forceAtlas2LayoutData.setOld_dx(0.0);
            forceAtlas2LayoutData.setOld_dy(0.0);
            forceAtlas2LayoutData.setOld_dz(0.0);
            forceAtlas2LayoutData.setDx(0.0);
            forceAtlas2LayoutData.setDy(0.0);
            forceAtlas2LayoutData.setDz(0.0);
        }
        this.currentThreadCount = this.threadCount;
    }

    private void barnesHutRegions() {
        if (this.isBarnesHutOptimize().booleanValue()) {
            if (this.stepCount % this.updateBarnesHutIter == 0) {
                this.rootRegion = new Region(this.nodes, this.is3d);
                Object object = new ArrayList<Region>();
                object.add(this.rootRegion);
                for (int i = 0; i < this.barnesHutSplits; ++i) {
                    Object object2;
                    ArrayList<Future> arrayList = new ArrayList<Future>();
                    Object object3 = object.iterator();
                    while (object3.hasNext()) {
                        object2 = (Region)object3.next();
                        arrayList.add(this.pool.submit(new BarnesHutBuildSubRegionTask(Arrays.asList(object2), false)));
                    }
                    ForceAtlas2.waitForFutures(arrayList);
                    object3 = new ArrayList();
                    object2 = object.iterator();
                    while (object2.hasNext()) {
                        Region region = (Region)object2.next();
                        object3.addAll(region.getSubregions());
                    }
                    object = object3;
                }
                ArrayList<Future> arrayList = new ArrayList<Future>();
                for (int i = this.currentThreadCount; i > 0; --i) {
                    int n = (int)Math.floor(object.size() * (i - 1) / this.currentThreadCount);
                    int n2 = (int)Math.floor(object.size() * i / this.currentThreadCount);
                    arrayList.add(this.pool.submit(new BarnesHutBuildSubRegionTask(object.subList(n, n2), true)));
                }
                ForceAtlas2.waitForFutures(arrayList);
            } else if (this.updateCenter) {
                this.rootRegion = new Region(this.nodes, this.is3d);
                Object object = new ArrayList<Region>();
                object.add(this.rootRegion);
                for (int i = 0; i < this.barnesHutSplits; ++i) {
                    Object object4;
                    ArrayList<Future> arrayList = new ArrayList<Future>();
                    Object object5 = object.iterator();
                    while (object5.hasNext()) {
                        object4 = (Region)object5.next();
                        arrayList.add(this.pool.submit(new BarnesHutUpdateCenterTask(Arrays.asList(object4), false)));
                    }
                    ForceAtlas2.waitForFutures(arrayList);
                    object5 = new ArrayList();
                    object4 = object.iterator();
                    while (object4.hasNext()) {
                        Region region = (Region)object4.next();
                        object5.addAll(region.getSubregions());
                    }
                    object = object5;
                }
                ArrayList<Future> arrayList = new ArrayList<Future>();
                for (int i = this.currentThreadCount; i > 0; --i) {
                    int n = (int)Math.floor(object.size() * (i - 1) / this.currentThreadCount);
                    int n3 = (int)Math.floor(object.size() * i / this.currentThreadCount);
                    arrayList.add(this.pool.submit(new BarnesHutUpdateCenterTask(object.subList(n, n3), true)));
                }
                ForceAtlas2.waitForFutures(arrayList);
            }
        }
    }

    private void repulsionAndGravity() {
        ForceFactory.RepulsionForce repulsionForce = ForceFactory.builder.buildRepulsion(this.isAdjustSizes(), this.getScalingRatio());
        ArrayList<Future> arrayList = new ArrayList<Future>();
        for (int i = this.currentThreadCount; i > 0; --i) {
            int n = (int)Math.floor(this.nodes.length * (i - 1) / this.currentThreadCount);
            int n2 = (int)Math.floor(this.nodes.length * i / this.currentThreadCount);
            arrayList.add(this.pool.submit(new NodesThread(this.nodes, n, n2, this.isBarnesHutOptimize(), this.getBarnesHutTheta(), this.getGravity(), this.isStrongGravityMode() != false ? ForceFactory.builder.getStrongGravity(this.getScalingRatio()) : repulsionForce, this.getScalingRatio(), this.rootRegion, repulsionForce)));
        }
        ForceAtlas2.waitForFutures(arrayList);
    }

    private void outboundAttractionDistribution() {
        if (this.isOutboundAttractionDistribution().booleanValue()) {
            this.outboundAttCompensation = 0.0;
            for (Node node : this.nodes) {
                ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
                this.outboundAttCompensation += forceAtlas2LayoutData.getMass();
            }
            this.outboundAttCompensation /= (double)this.nodes.length;
        }
    }

    private double applyForces() {
        ArrayList<Future<Double>> arrayList = new ArrayList<Future<Double>>();
        boolean bl = this.isAdjustSizes();
        List<Node> list = Arrays.asList(this.nodes);
        for (int i = this.currentThreadCount; i > 0; --i) {
            int n = (int)Math.floor(this.nodes.length * (i - 1) / this.currentThreadCount);
            int n2 = (int)Math.floor(this.nodes.length * i / this.currentThreadCount);
            arrayList.add(this.pool.submit(new ApplyForcesTask(list.subList(n, n2), bl, this.speed, this.useAltSpeed)));
        }
        double d = 0.0;
        try {
            for (Future future : arrayList) {
                d += ((Double)future.get()).doubleValue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return d;
    }

    private void attraction(boolean bl, Interval interval) {
        ArrayList<Future> arrayList = new ArrayList<Future>();
        ForceFactory.AttractionForce attractionForce = ForceFactory.builder.buildAttraction(this.isLinLogMode(), this.isOutboundAttractionDistribution(), this.isAdjustSizes(), 1.0 * (this.isOutboundAttractionDistribution() != false ? this.outboundAttCompensation : 1.0));
        int n = this.currentThreadCount;
        List<Edge> list = Arrays.asList(this.edges);
        Double d = this.getEdgeWeightInfluence();
        for (int i = n; i > 0; --i) {
            int n2 = (int)Math.floor(this.edges.length * (i - 1) / n);
            int n3 = (int)Math.floor(this.edges.length * i / n);
            List<Edge> list2 = list.subList(n2, n3);
            AttractionTask attractionTask = new AttractionTask(list2, attractionForce, bl, interval, d);
            arrayList.add(this.pool.submit(attractionTask));
        }
        ForceAtlas2.waitForFutures(arrayList);
    }

    private void speed() {
        ArrayList<Future<Double[]>> arrayList = new ArrayList<Future<Double[]>>();
        List<Node> list = Arrays.asList(this.nodes);
        for (int i = this.currentThreadCount; i > 0; --i) {
            int n = (int)Math.floor(this.nodes.length * (i - 1) / this.currentThreadCount);
            int n2 = (int)Math.floor(this.nodes.length * i / this.currentThreadCount);
            arrayList.add(this.pool.submit(new SpeedTask(list.subList(n, n2))));
        }
        double d = 0.0;
        double d2 = 0.0;
        try {
            for (Future future : arrayList) {
                Double[] doubleArray = (Double[])future.get();
                d += doubleArray[0].doubleValue();
                d2 += doubleArray[1].doubleValue();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        double d3 = 0.05 * Math.sqrt(this.nodes.length);
        double d4 = Math.sqrt(d3);
        double d5 = 10.0;
        double d6 = this.jitterTolerance * Math.max(d4, Math.min(d5, d3 * d2 / Math.pow(this.nodes.length, 2.0)));
        double d7 = 0.05;
        if (d / d2 > 2.0) {
            if (this.speedEfficiency > d7) {
                this.speedEfficiency *= 0.5;
            }
            d6 = Math.max(d6, this.jitterTolerance);
        }
        double d8 = d6 * this.speedEfficiency * d2 / d;
        if (d > d6 * d2) {
            if (this.speedEfficiency > d7) {
                this.speedEfficiency *= 0.7;
            }
        } else if (this.speed < 1000.0) {
            this.speedEfficiency *= 1.3;
        }
        double d9 = 0.5;
        this.speed += Math.min(d8 - this.speed, d9 * this.speed);
    }

    private void initLayoutData() {
        ArrayList<Future> arrayList = new ArrayList<Future>();
        List<Node> list = Arrays.asList(this.nodes);
        for (int i = this.currentThreadCount; i > 0; --i) {
            int n = (int)Math.floor(this.nodes.length * (i - 1) / this.currentThreadCount);
            int n2 = (int)Math.floor(this.nodes.length * i / this.currentThreadCount);
            arrayList.add(this.pool.submit(new InitLayoutTask(list.subList(n, n2), this.graph)));
        }
        ForceAtlas2.waitForFutures(arrayList);
    }

    public void goAlgo() {
        boolean bl = this.graphModel.getEdgeTable().getColumn("weight").isDynamic();
        Interval interval = this.graph.getView().getTimeInterval();
        this.initLayoutData();
        this.barnesHutRegions();
        this.outboundAttractionDistribution();
        this.repulsionAndGravity();
        this.attraction(bl, interval);
        this.speed();
        this.distance = this.applyForces();
        ++this.stepCount;
    }

    public double getDistance() {
        return this.distance;
    }

    public boolean canAlgo() {
        return this.graphModel != null;
    }

    public void endAlgo() {
        this.pool.shutdown();
    }

    public void resetPropertiesValues() {
        int n = 0;
        if (this.graphModel != null) {
            n = this.graphModel.getGraphVisible().getNodeCount();
        }
        if (n >= 100) {
            this.setScalingRatio(2.0);
        } else {
            this.setScalingRatio(10.0);
        }
        this.setStrongGravityMode(false);
        this.setGravity(1.0);
        this.setOutboundAttractionDistribution(false);
        this.setLinLogMode(false);
        this.setAdjustSizes(false);
        this.setEdgeWeightInfluence(1.0);
        this.setJitterTolerance(1.0);
        if (n >= 1000) {
            this.setBarnesHutOptimize(true);
        } else {
            this.setBarnesHutOptimize(false);
        }
        this.setBarnesHutTheta(1.2);
        this.setThreadsCount(Runtime.getRuntime().availableProcessors());
    }

    public LayoutBuilder getBuilder() {
        return this.layoutBuilder;
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
        this.resetPropertiesValues();
    }

    public Double getBarnesHutTheta() {
        return this.barnesHutTheta;
    }

    public void setBarnesHutTheta(Double d) {
        this.barnesHutTheta = d;
    }

    public Double getEdgeWeightInfluence() {
        return this.edgeWeightInfluence;
    }

    public void setEdgeWeightInfluence(Double d) {
        this.edgeWeightInfluence = d;
    }

    public Double getJitterTolerance() {
        return this.jitterTolerance;
    }

    public void setJitterTolerance(Double d) {
        this.jitterTolerance = d;
    }

    public Boolean isLinLogMode() {
        return this.linLogMode;
    }

    public void setLinLogMode(Boolean bl) {
        this.linLogMode = bl;
    }

    public Double getScalingRatio() {
        return this.scalingRatio;
    }

    public void setScalingRatio(Double d) {
        this.scalingRatio = d;
    }

    public Boolean isStrongGravityMode() {
        return this.strongGravityMode;
    }

    public void setStrongGravityMode(Boolean bl) {
        this.strongGravityMode = bl;
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double d) {
        this.gravity = d;
    }

    public Integer getThreadsCount() {
        return this.threadCount;
    }

    public void setThreadsCount(Integer n) {
        this.threadCount = Math.max(1, n);
    }

    public Boolean isOutboundAttractionDistribution() {
        return this.outboundAttractionDistribution;
    }

    public void setOutboundAttractionDistribution(Boolean bl) {
        this.outboundAttractionDistribution = bl;
    }

    public Boolean isAdjustSizes() {
        return this.adjustSizes;
    }

    public void setAdjustSizes(Boolean bl) {
        this.adjustSizes = bl;
    }

    public Boolean isBarnesHutOptimize() {
        return this.barnesHutOptimize;
    }

    public void setBarnesHutOptimize(Boolean bl) {
        this.barnesHutOptimize = bl;
    }

    public int getUpdateBarnesHutIter() {
        return this.updateBarnesHutIter;
    }

    public void setUpdateBarnesHutIter(int n) {
        this.updateBarnesHutIter = n;
    }

    public void setUpdateCenter(boolean bl) {
        this.updateCenter = bl;
    }

    public void setBarnesHutSplits(int n) {
        this.barnesHutSplits = n;
    }

    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> arrayList = new ArrayList<LayoutProperty>();
        String string = NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.tuning");
        String string2 = NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.behavior");
        String string3 = NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.performance");
        String string4 = NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.threads");
        try {
            arrayList.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.scalingRatio.name"), (String)string, (String)"ForceAtlas2.scalingRatio.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.scalingRatio.desc"), (String)"getScalingRatio", (String)"setScalingRatio"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.strongGravityMode.name"), (String)string, (String)"ForceAtlas2.strongGravityMode.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.strongGravityMode.desc"), (String)"isStrongGravityMode", (String)"setStrongGravityMode"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.gravity.name"), (String)string, (String)"ForceAtlas2.gravity.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.gravity.desc"), (String)"getGravity", (String)"setGravity"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.distributedAttraction.name"), (String)string2, (String)"ForceAtlas2.distributedAttraction.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.distributedAttraction.desc"), (String)"isOutboundAttractionDistribution", (String)"setOutboundAttractionDistribution"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.linLogMode.name"), (String)string2, (String)"ForceAtlas2.linLogMode.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.linLogMode.desc"), (String)"isLinLogMode", (String)"setLinLogMode"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.adjustSizes.name"), (String)string2, (String)"ForceAtlas2.adjustSizes.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.adjustSizes.desc"), (String)"isAdjustSizes", (String)"setAdjustSizes"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.edgeWeightInfluence.name"), (String)string2, (String)"ForceAtlas2.edgeWeightInfluence.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.edgeWeightInfluence.desc"), (String)"getEdgeWeightInfluence", (String)"setEdgeWeightInfluence"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.jitterTolerance.name"), (String)string3, (String)"ForceAtlas2.jitterTolerance.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.jitterTolerance.desc"), (String)"getJitterTolerance", (String)"setJitterTolerance"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Boolean.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.barnesHutOptimization.name"), (String)string3, (String)"ForceAtlas2.barnesHutOptimization.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.barnesHutOptimization.desc"), (String)"isBarnesHutOptimize", (String)"setBarnesHutOptimize"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Double.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.barnesHutTheta.name"), (String)string3, (String)"ForceAtlas2.barnesHutTheta.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.barnesHutTheta.desc"), (String)"getBarnesHutTheta", (String)"setBarnesHutTheta"));
            arrayList.add(LayoutProperty.createProperty((Layout)this, Integer.class, (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.threads.name"), (String)string4, (String)"ForceAtlas2.threads.name", (String)NbBundle.getMessage(this.getClass(), (String)"ForceAtlas2.threads.desc"), (String)"getThreadsCount", (String)"setThreadsCount"));
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return arrayList.toArray(new LayoutProperty[0]);
    }

    public String toString() {
        return "ForceAtlas2{outboundAttCompensation=" + this.outboundAttCompensation + ", edgeWeightInfluence=" + this.edgeWeightInfluence + ", jitterTolerance=" + this.jitterTolerance + ", scalingRatio=" + this.scalingRatio + ", gravity=" + this.gravity + ", speed=" + this.speed + ", speedEfficiency=" + this.speedEfficiency + ", outboundAttractionDistribution=" + this.outboundAttractionDistribution + ", adjustSizes=" + this.adjustSizes + ", barnesHutOptimize=" + this.barnesHutOptimize + ", barnesHutTheta=" + this.barnesHutTheta + ", linLogMode=" + this.linLogMode + ", strongGravityMode=" + this.strongGravityMode + ", threadCount=" + this.threadCount + ", currentThreadCount=" + this.currentThreadCount + ", updateBarnesHutIter=" + this.updateBarnesHutIter + ", updateCenter=" + this.updateCenter + ", barnesHutSplits=" + this.barnesHutSplits + '}';
    }

    private static class AttractionTask
    implements Runnable {
        private Collection<Edge> edges;
        private ForceFactory.AttractionForce Attraction;
        private boolean isDynamicWeight;
        private Interval interval;
        private double edgeWeightInfluence;

        private AttractionTask(Collection<Edge> collection, ForceFactory.AttractionForce attractionForce, boolean bl, Interval interval, double d) {
            this.edges = collection;
            this.Attraction = attractionForce;
            this.isDynamicWeight = bl;
            this.interval = interval;
            this.edgeWeightInfluence = d;
        }

        @Override
        public void run() {
            if (this.edgeWeightInfluence == 0.0) {
                for (Edge edge : this.edges) {
                    this.Attraction.apply(edge.getSource(), edge.getTarget(), 1.0);
                }
            } else if (this.edgeWeightInfluence == 1.0) {
                for (Edge edge : this.edges) {
                    this.Attraction.apply(edge.getSource(), edge.getTarget(), ForceAtlas2.getEdgeWeight(edge, this.isDynamicWeight, this.interval));
                }
            } else {
                for (Edge edge : this.edges) {
                    this.Attraction.apply(edge.getSource(), edge.getTarget(), Math.pow(ForceAtlas2.getEdgeWeight(edge, this.isDynamicWeight, this.interval), this.edgeWeightInfluence));
                }
            }
        }
    }

    private static class BarnesHutBuildSubRegionTask
    implements Runnable {
        private Collection<Region> regions;
        private boolean recursive;

        private BarnesHutBuildSubRegionTask(Collection<Region> collection, boolean bl) {
            this.regions = collection;
            this.recursive = bl;
        }

        @Override
        public void run() {
            for (Region region : this.regions) {
                region.buildSubRegions(this.recursive);
            }
        }
    }

    private static class BarnesHutUpdateCenterTask
    implements Runnable {
        private Collection<Region> regions;
        private boolean recursive;

        private BarnesHutUpdateCenterTask(Collection<Region> collection, boolean bl) {
            this.regions = collection;
            this.recursive = bl;
        }

        @Override
        public void run() {
            for (Region region : this.regions) {
                region.updateAllMassAndGeometry(this.recursive);
            }
        }
    }

    private static class ApplyForcesTask
    implements Callable<Double> {
        private Collection<Node> nodes;
        private boolean adjustSizes;
        private double speed;
        private boolean useAltSpeed;

        private ApplyForcesTask(List<Node> list, boolean bl, double d, boolean bl2) {
            this.nodes = list;
            this.adjustSizes = bl;
            this.speed = d;
            this.useAltSpeed = bl2;
        }

        @Override
        public Double call() {
            double d = 0.0;
            if (this.adjustSizes) {
                for (Node node : this.nodes) {
                    ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
                    if (node.isFixed()) continue;
                    double d2 = forceAtlas2LayoutData.getMass() * Math.sqrt((forceAtlas2LayoutData.getOld_dx() - forceAtlas2LayoutData.getDx()) * (forceAtlas2LayoutData.getOld_dx() - forceAtlas2LayoutData.getDx()) + (forceAtlas2LayoutData.getOld_dy() - forceAtlas2LayoutData.getDy()) * (forceAtlas2LayoutData.getOld_dy() - forceAtlas2LayoutData.getDy()) + (forceAtlas2LayoutData.getOld_dz() - forceAtlas2LayoutData.getDz()) * (forceAtlas2LayoutData.getOld_dz() - forceAtlas2LayoutData.getDz()));
                    double d3 = 0.1 * this.speed / (1.0 + Math.sqrt(this.speed * d2));
                    double d4 = Math.sqrt(Math.pow(forceAtlas2LayoutData.getDx(), 2.0) + Math.pow(forceAtlas2LayoutData.getDy(), 2.0) + Math.pow(forceAtlas2LayoutData.getDz(), 2.0));
                    d3 = Math.min(d3 * d4, 10.0) / d4;
                    double d5 = (double)node.x() + forceAtlas2LayoutData.getDx() * d3;
                    double d6 = (double)node.y() + forceAtlas2LayoutData.getDy() * d3;
                    double d7 = (double)node.z() + forceAtlas2LayoutData.getDz() * d3;
                    d += Math.sqrt(Math.pow((double)node.x() - d5, 2.0) + Math.pow((double)node.y() - d6, 2.0) + Math.pow((double)node.z() - d7, 2.0));
                    node.setX((float)d5);
                    node.setY((float)d6);
                    node.setZ((float)d7);
                }
            } else {
                for (Node node : this.nodes) {
                    ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
                    if (node.isFixed()) continue;
                    double d8 = forceAtlas2LayoutData.getMass() * Math.sqrt((forceAtlas2LayoutData.getOld_dx() - forceAtlas2LayoutData.getDx()) * (forceAtlas2LayoutData.getOld_dx() - forceAtlas2LayoutData.getDx()) + (forceAtlas2LayoutData.getOld_dy() - forceAtlas2LayoutData.getDy()) * (forceAtlas2LayoutData.getOld_dy() - forceAtlas2LayoutData.getDy()) + (forceAtlas2LayoutData.getOld_dz() - forceAtlas2LayoutData.getDz()) * (forceAtlas2LayoutData.getOld_dz() - forceAtlas2LayoutData.getDz()));
                    double d9 = this.speed / (1.0 + Math.sqrt(this.speed * d8));
                    if (this.useAltSpeed) {
                        d9 = Math.min(0.1 * d9, 10.0 / Math.sqrt(Math.pow(forceAtlas2LayoutData.getDx(), 2.0) + Math.pow(forceAtlas2LayoutData.getDy(), 2.0) + Math.pow(forceAtlas2LayoutData.getDz(), 2.0)));
                    }
                    double d10 = (double)node.x() + forceAtlas2LayoutData.getDx() * d9;
                    double d11 = (double)node.y() + forceAtlas2LayoutData.getDy() * d9;
                    double d12 = (double)node.z() + forceAtlas2LayoutData.getDz() * d9;
                    d += Math.sqrt(Math.pow((double)node.x() - d10, 2.0) + Math.pow((double)node.y() - d11, 2.0) + Math.pow((double)node.z() - d12, 2.0));
                    node.setX((float)d10);
                    node.setY((float)d11);
                    node.setZ((float)d12);
                }
            }
            return d;
        }
    }

    private static class InitLayoutTask
    implements Runnable {
        private Collection<Node> nodes;
        private Graph graph;

        public InitLayoutTask(Collection<Node> collection, Graph graph) {
            this.nodes = collection;
            this.graph = graph;
        }

        @Override
        public void run() {
            for (Node node : this.nodes) {
                ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
                forceAtlas2LayoutData.setOld_dx(forceAtlas2LayoutData.getDx());
                forceAtlas2LayoutData.setOld_dy(forceAtlas2LayoutData.getDy());
                forceAtlas2LayoutData.setOld_dz(forceAtlas2LayoutData.getDz());
                forceAtlas2LayoutData.setDx(0.0);
                forceAtlas2LayoutData.setDy(0.0);
                forceAtlas2LayoutData.setDz(0.0);
            }
        }
    }

    private static class SpeedTask
    implements Callable<Double[]> {
        private Collection<Node> nodes;

        private SpeedTask(Collection<Node> collection) {
            this.nodes = collection;
        }

        @Override
        public Double[] call() {
            double d = 0.0;
            double d2 = 0.0;
            for (Node node : this.nodes) {
                ForceAtlas2LayoutData forceAtlas2LayoutData = (ForceAtlas2LayoutData)node.getLayoutData();
                if (node.isFixed()) continue;
                double d3 = Math.sqrt(Math.pow(forceAtlas2LayoutData.getOld_dx() - forceAtlas2LayoutData.getDx(), 2.0) + Math.pow(forceAtlas2LayoutData.getOld_dy() - forceAtlas2LayoutData.getDy(), 2.0) + Math.pow(forceAtlas2LayoutData.getOld_dz() - forceAtlas2LayoutData.getDz(), 2.0));
                d += forceAtlas2LayoutData.getMass() * d3;
                d2 += forceAtlas2LayoutData.getMass() * 0.5 * Math.sqrt(Math.pow(forceAtlas2LayoutData.getOld_dx() + forceAtlas2LayoutData.getDx(), 2.0) + Math.pow(forceAtlas2LayoutData.getOld_dy() + forceAtlas2LayoutData.getDy(), 2.0) + Math.pow(forceAtlas2LayoutData.getOld_dz() + forceAtlas2LayoutData.getDz(), 2.0));
            }
            return new Double[]{d, d2};
        }
    }
}

