# -*- coding: utf-8 -*-

"""
cypresstestapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import dateutil.parser

from cypresstestapi.api_helper import APIHelper
from cypresstestapi.models.message import Message


class Item(object):

    """Implementation of the 'Item' model.

    Attributes:
        id (uuid|str): The model property of type uuid|str.
        name (str): The model property of type str.
        date (date): The model property of type date.
        date_time (datetime): The model property of type datetime.
        decimal (float): The model property of type float.
        long (int): The model property of type int.
        bool (bool): The model property of type bool.
        custom_enum (CustomEnum): The model property of type CustomEnum.
        status (StatusEnum): The model property of type StatusEnum.
        json_object (Any): A generic JSON object
        animal (Any): The model property of type Any.
        map (Dict[str, Message]): The model property of type Dict[str,
            Message].

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "name": 'name',
        "date": 'date',
        "date_time": 'dateTime',
        "decimal": 'decimal',
        "long": 'long',
        "bool": 'bool',
        "custom_enum": 'CustomEnum',
        "json_object": 'jsonObject',
        "animal": 'Animal',
        "map": 'Map',
        "status": 'status'
    }

    _optionals = [
        'status',
    ]

    def __init__(self,
                 id=None,
                 name=None,
                 date=None,
                 date_time=None,
                 decimal=None,
                 long=None,
                 bool=None,
                 custom_enum=None,
                 json_object=None,
                 animal=None,
                 map=None,
                 status=APIHelper.SKIP):
        """Constructor for the Item class"""

        # Initialize members of the class
        self.id = id 
        self.name = name 
        self.date = date 
        self.date_time = APIHelper.apply_datetime_converter(date_time, APIHelper.RFC3339DateTime) if date_time else None 
        self.decimal = decimal 
        self.long = long 
        self.bool = bool 
        self.custom_enum = custom_enum 
        if status is not APIHelper.SKIP:
            self.status = status 
        self.json_object = json_object 
        self.animal = animal 
        self.map = map 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else None
        name = dictionary.get("name") if dictionary.get("name") else None
        date = dateutil.parser.parse(dictionary.get('date')).date() if dictionary.get('date') else None
        date_time = APIHelper.RFC3339DateTime.from_value(dictionary.get("dateTime")).datetime if dictionary.get("dateTime") else None
        decimal = dictionary.get("decimal") if dictionary.get("decimal") else None
        long = dictionary.get("long") if dictionary.get("long") else None
        bool = dictionary.get("bool") if "bool" in dictionary.keys() else None
        custom_enum = dictionary.get("CustomEnum") if dictionary.get("CustomEnum") else None
        json_object = dictionary.get("jsonObject") if dictionary.get("jsonObject") else None
        animal = dictionary.get("Animal") if dictionary.get("Animal") else None
        map = Message.from_dictionary(dictionary.get('Map')) if dictionary.get('Map') else None
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   name,
                   date,
                   date_time,
                   decimal,
                   long,
                   bool,
                   custom_enum,
                   json_object,
                   animal,
                   map,
                   status)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'id={self.id!r}, '
                f'name={self.name!r}, '
                f'date={self.date!r}, '
                f'date_time={self.date_time!r}, '
                f'decimal={self.decimal!r}, '
                f'long={self.long!r}, '
                f'bool={self.bool!r}, '
                f'custom_enum={self.custom_enum!r}, '
                f'status={(self.status if hasattr(self, "status") else None)!r}, '
                f'json_object={self.json_object!r}, '
                f'animal={self.animal!r}, '
                f'map={self.map!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'id={self.id!s}, '
                f'name={self.name!s}, '
                f'date={self.date!s}, '
                f'date_time={self.date_time!s}, '
                f'decimal={self.decimal!s}, '
                f'long={self.long!s}, '
                f'bool={self.bool!s}, '
                f'custom_enum={self.custom_enum!s}, '
                f'status={(self.status if hasattr(self, "status") else None)!s}, '
                f'json_object={self.json_object!s}, '
                f'animal={self.animal!s}, '
                f'map={self.map!s})')
