# -*- coding: utf-8 -*-

"""
cypresstestapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from cypresstestapi.api_helper import APIHelper


class MultipleArraysRequest(object):

    """Implementation of the 'MultipleArraysRequest' model.

    Attributes:
        array_1 (List[str]): An array containing items of type string
        array_2 (List[int]): An array containing items of type integer

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "array_1": 'Array1',
        "array_2": 'Array2'
    }

    _optionals = [
        'array_2',
    ]

    def __init__(self,
                 array_1=None,
                 array_2=APIHelper.SKIP):
        """Constructor for the MultipleArraysRequest class"""

        # Initialize members of the class
        self.array_1 = array_1 
        if array_2 is not APIHelper.SKIP:
            self.array_2 = array_2 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        array_1 = dictionary.get("Array1") if dictionary.get("Array1") else None
        array_2 = dictionary.get("Array2") if dictionary.get("Array2") else APIHelper.SKIP
        # Return an object of this model
        return cls(array_1,
                   array_2)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'array_1={self.array_1!r}, '
                f'array_2={(self.array_2 if hasattr(self, "array_2") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'array_1={self.array_1!s}, '
                f'array_2={(self.array_2 if hasattr(self, "array_2") else None)!s})')
