# -*- coding: utf-8 -*-

"""
cypresstestapi

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from cypresstestapi.api_helper import APIHelper


class NacTag(object):

    """Implementation of the 'nac_tag' model.

    Attributes:
        allow_usermac_override (bool): can be set to true to allow the
            override by usermac result
        created_time (float): The model property of type float.
        egress_vlan_names (List[str]): if `type`==`egress_vlan_names`, list of
            egress vlans to return
        gbp_tag (int): if `type`==`gbp_tag`
        id (uuid|str): The model property of type uuid|str.
        match (NacTag): The model property of type NacTag.
        match_all (bool): This field is applicable only when `type`==`match`  
            * `false`: means it is sufficient to match any of the values
            (i.e., match-any behavior)   * `true`: means all values should be
            matched (i.e., match-all behavior)   Currently it makes sense to
            set this field to `true` only if the `match`==`idp_role` or
            `match`==`usermac_label`'
        modified_time (float): The model property of type float.
        name (str): The model property of type str.
        org_id (uuid|str): The model property of type uuid|str.
        radius_attrs (List[str]): if `type`==`radius_attrs`, user can specify
            a list of one or more standard attributes in the field
            "radius_attrs".  It is the responsibility of the user to provide a
            syntactically correct string, otherwise it may not work as
            expected. Note that it is allowed to have more than one
            radius_attrs in the result of a given rule.
        radius_group (str): if `type`==`radius_group`
        radius_vendor_attrs (List[str]): if `type`==`radius_vendor_attrs`,
            user can specify a list of one or more vendor-specific attributes
            in the field "radius_vendor_attrs".  It is the responsibility of
            the user to provide a syntactically correct string, otherwise it
            may not work as expected. Note that it is allowed to have more
            than one radius_vendor_attrs in the result of a given rule.
        session_timeout (int): if `type`==`session_timeout, in seconds
        mtype (NacTag): The model property of type NacTag.
        username_attr (NacTag): The model property of type NacTag.
        values (List[str]): if `type`==`match`
        vlan (str): if `type`==`vlan`

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "mtype": 'type',
        "allow_usermac_override": 'allow_usermac_override',
        "created_time": 'created_time',
        "egress_vlan_names": 'egress_vlan_names',
        "gbp_tag": 'gbp_tag',
        "id": 'id',
        "match": 'match',
        "match_all": 'match_all',
        "modified_time": 'modified_time',
        "org_id": 'org_id',
        "radius_attrs": 'radius_attrs',
        "radius_group": 'radius_group',
        "radius_vendor_attrs": 'radius_vendor_attrs',
        "session_timeout": 'session_timeout',
        "username_attr": 'username_attr',
        "values": 'values',
        "vlan": 'vlan'
    }

    _optionals = [
        'allow_usermac_override',
        'created_time',
        'egress_vlan_names',
        'gbp_tag',
        'id',
        'match',
        'match_all',
        'modified_time',
        'org_id',
        'radius_attrs',
        'radius_group',
        'radius_vendor_attrs',
        'session_timeout',
        'username_attr',
        'values',
        'vlan',
    ]

    def __init__(self,
                 name=None,
                 mtype=None,
                 allow_usermac_override=False,
                 created_time=APIHelper.SKIP,
                 egress_vlan_names=APIHelper.SKIP,
                 gbp_tag=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 match=APIHelper.SKIP,
                 match_all=False,
                 modified_time=APIHelper.SKIP,
                 org_id=APIHelper.SKIP,
                 radius_attrs=APIHelper.SKIP,
                 radius_group=APIHelper.SKIP,
                 radius_vendor_attrs=APIHelper.SKIP,
                 session_timeout=APIHelper.SKIP,
                 username_attr=APIHelper.SKIP,
                 values=APIHelper.SKIP,
                 vlan=APIHelper.SKIP):
        """Constructor for the NacTag class"""

        # Initialize members of the class
        self.allow_usermac_override = allow_usermac_override 
        if created_time is not APIHelper.SKIP:
            self.created_time = created_time 
        if egress_vlan_names is not APIHelper.SKIP:
            self.egress_vlan_names = egress_vlan_names 
        if gbp_tag is not APIHelper.SKIP:
            self.gbp_tag = gbp_tag 
        if id is not APIHelper.SKIP:
            self.id = id 
        if match is not APIHelper.SKIP:
            self.match = match 
        self.match_all = match_all 
        if modified_time is not APIHelper.SKIP:
            self.modified_time = modified_time 
        self.name = name 
        if org_id is not APIHelper.SKIP:
            self.org_id = org_id 
        if radius_attrs is not APIHelper.SKIP:
            self.radius_attrs = radius_attrs 
        if radius_group is not APIHelper.SKIP:
            self.radius_group = radius_group 
        if radius_vendor_attrs is not APIHelper.SKIP:
            self.radius_vendor_attrs = radius_vendor_attrs 
        if session_timeout is not APIHelper.SKIP:
            self.session_timeout = session_timeout 
        self.mtype = mtype 
        if username_attr is not APIHelper.SKIP:
            self.username_attr = username_attr 
        if values is not APIHelper.SKIP:
            self.values = values 
        if vlan is not APIHelper.SKIP:
            self.vlan = vlan 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if not isinstance(dictionary, dict) or dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else None
        mtype = NacTag.from_dictionary(dictionary.get('type')) if dictionary.get('type') else None
        allow_usermac_override = dictionary.get("allow_usermac_override") if dictionary.get("allow_usermac_override") else False
        created_time = dictionary.get("created_time") if dictionary.get("created_time") else APIHelper.SKIP
        egress_vlan_names = dictionary.get("egress_vlan_names") if dictionary.get("egress_vlan_names") else APIHelper.SKIP
        gbp_tag = dictionary.get("gbp_tag") if dictionary.get("gbp_tag") else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        match = NacTag.from_dictionary(dictionary.get('match')) if 'match' in dictionary.keys() else APIHelper.SKIP
        match_all = dictionary.get("match_all") if dictionary.get("match_all") else False
        modified_time = dictionary.get("modified_time") if dictionary.get("modified_time") else APIHelper.SKIP
        org_id = dictionary.get("org_id") if dictionary.get("org_id") else APIHelper.SKIP
        radius_attrs = dictionary.get("radius_attrs") if dictionary.get("radius_attrs") else APIHelper.SKIP
        radius_group = dictionary.get("radius_group") if dictionary.get("radius_group") else APIHelper.SKIP
        radius_vendor_attrs = dictionary.get("radius_vendor_attrs") if dictionary.get("radius_vendor_attrs") else APIHelper.SKIP
        session_timeout = dictionary.get("session_timeout") if dictionary.get("session_timeout") else APIHelper.SKIP
        username_attr = NacTag.from_dictionary(dictionary.get('username_attr')) if 'username_attr' in dictionary.keys() else APIHelper.SKIP
        values = dictionary.get("values") if dictionary.get("values") else APIHelper.SKIP
        vlan = dictionary.get("vlan") if dictionary.get("vlan") else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   mtype,
                   allow_usermac_override,
                   created_time,
                   egress_vlan_names,
                   gbp_tag,
                   id,
                   match,
                   match_all,
                   modified_time,
                   org_id,
                   radius_attrs,
                   radius_group,
                   radius_vendor_attrs,
                   session_timeout,
                   username_attr,
                   values,
                   vlan)

    def __repr__(self):
        return (f'{self.__class__.__name__}('
                f'allow_usermac_override={(self.allow_usermac_override if hasattr(self, "allow_usermac_override") else None)!r}, '
                f'created_time={(self.created_time if hasattr(self, "created_time") else None)!r}, '
                f'egress_vlan_names={(self.egress_vlan_names if hasattr(self, "egress_vlan_names") else None)!r}, '
                f'gbp_tag={(self.gbp_tag if hasattr(self, "gbp_tag") else None)!r}, '
                f'id={(self.id if hasattr(self, "id") else None)!r}, '
                f'match={(self.match if hasattr(self, "match") else None)!r}, '
                f'match_all={(self.match_all if hasattr(self, "match_all") else None)!r}, '
                f'modified_time={(self.modified_time if hasattr(self, "modified_time") else None)!r}, '
                f'name={self.name!r}, '
                f'org_id={(self.org_id if hasattr(self, "org_id") else None)!r}, '
                f'radius_attrs={(self.radius_attrs if hasattr(self, "radius_attrs") else None)!r}, '
                f'radius_group={(self.radius_group if hasattr(self, "radius_group") else None)!r}, '
                f'radius_vendor_attrs={(self.radius_vendor_attrs if hasattr(self, "radius_vendor_attrs") else None)!r}, '
                f'session_timeout={(self.session_timeout if hasattr(self, "session_timeout") else None)!r}, '
                f'mtype={self.mtype!r}, '
                f'username_attr={(self.username_attr if hasattr(self, "username_attr") else None)!r}, '
                f'values={(self.values if hasattr(self, "values") else None)!r}, '
                f'vlan={(self.vlan if hasattr(self, "vlan") else None)!r})')

    def __str__(self):
        return (f'{self.__class__.__name__}('
                f'allow_usermac_override={(self.allow_usermac_override if hasattr(self, "allow_usermac_override") else None)!s}, '
                f'created_time={(self.created_time if hasattr(self, "created_time") else None)!s}, '
                f'egress_vlan_names={(self.egress_vlan_names if hasattr(self, "egress_vlan_names") else None)!s}, '
                f'gbp_tag={(self.gbp_tag if hasattr(self, "gbp_tag") else None)!s}, '
                f'id={(self.id if hasattr(self, "id") else None)!s}, '
                f'match={(self.match if hasattr(self, "match") else None)!s}, '
                f'match_all={(self.match_all if hasattr(self, "match_all") else None)!s}, '
                f'modified_time={(self.modified_time if hasattr(self, "modified_time") else None)!s}, '
                f'name={self.name!s}, '
                f'org_id={(self.org_id if hasattr(self, "org_id") else None)!s}, '
                f'radius_attrs={(self.radius_attrs if hasattr(self, "radius_attrs") else None)!s}, '
                f'radius_group={(self.radius_group if hasattr(self, "radius_group") else None)!s}, '
                f'radius_vendor_attrs={(self.radius_vendor_attrs if hasattr(self, "radius_vendor_attrs") else None)!s}, '
                f'session_timeout={(self.session_timeout if hasattr(self, "session_timeout") else None)!s}, '
                f'mtype={self.mtype!s}, '
                f'username_attr={(self.username_attr if hasattr(self, "username_attr") else None)!s}, '
                f'values={(self.values if hasattr(self, "values") else None)!s}, '
                f'vlan={(self.vlan if hasattr(self, "vlan") else None)!s})')
