import numpy
from typing import ClassVar, Iterable, Iterator, overload

URX_VERSION_MAJOR: int
URX_VERSION_MINOR: int
URX_VERSION_PATCH: int

class Acquisition:
    authors: str
    country_code: str
    description: str
    excitations: VecExcitationPtr
    groups: VecGroupPtr
    groups_data: VecGroupData
    local_time: str
    probes: VecProbePtr
    system: str
    timestamp: UrxDoubleNan
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxAcquisition) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: str, arg2: str, arg3: str, arg4: str, arg5: UrxDoubleNan, arg6: VecProbePtr, arg7: VecExcitationPtr, arg8: VecGroupPtr, arg9: VecGroupData) -> None: ...
    def __eq__(self, arg0: UrxAcquisition) -> bool: ...
    def __ne__(self, arg0: UrxAcquisition) -> bool: ...

class DataType:
    __members__: ClassVar[dict] = ...  # read-only
    DOUBLE: ClassVar[UrxDataType] = ...
    FLOAT: ClassVar[UrxDataType] = ...
    INT16: ClassVar[UrxDataType] = ...
    INT32: ClassVar[UrxDataType] = ...
    UNDEFINED: ClassVar[UrxDataType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Dataset:
    acquisition: UrxAcquisition
    version: UrxVersion
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxDataset) -> None: ...
    @overload
    def __init__(self, arg0: UrxAcquisition, arg1: UrxVersion) -> None: ...
    def __eq__(self, arg0: UrxDataset) -> bool: ...
    def __ne__(self, arg0: UrxDataset) -> bool: ...

class DoubleNan:
    value: float
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: UrxDoubleNan) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __add__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __add__(self, arg0: float) -> UrxDoubleNan: ...
    def __array__(self) -> numpy.ndarray[numpy.float64]: ...
    @overload
    def __eq__(self, arg0: UrxDoubleNan) -> bool: ...
    @overload
    def __eq__(self, arg0: float) -> bool: ...
    def __float__(self) -> float: ...
    @overload
    def __iadd__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __iadd__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __imul__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __imul__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __isub__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __isub__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __itruediv__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __itruediv__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __mul__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __mul__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __ne__(self, arg0: UrxDoubleNan) -> bool: ...
    @overload
    def __ne__(self, arg0: float) -> bool: ...
    def __neg__(self) -> float: ...
    def __pos__(self) -> float: ...
    def __radd__(self, arg0: float) -> UrxDoubleNan: ...
    def __rmul__(self, arg0: float) -> UrxDoubleNan: ...
    def __rsub__(self, arg0: float) -> UrxDoubleNan: ...
    def __rtruediv__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __sub__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __sub__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __truediv__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __truediv__(self, arg0: float) -> UrxDoubleNan: ...

class Element:
    element_geometry: UrxElementGeometry
    impulse_response: UrxImpulseResponse
    transform: UrxTransform
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxElement) -> None: ...
    @overload
    def __init__(self, arg0: UrxTransform, arg1: UrxElementGeometry, arg2: UrxImpulseResponse) -> None: ...
    def __eq__(self, arg0: UrxElement) -> bool: ...
    def __ne__(self, arg0: UrxElement) -> bool: ...

class ElementGeometry:
    perimeter: VecVector3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxElementGeometry) -> None: ...
    @overload
    def __init__(self, arg0: VecVector3D) -> None: ...
    def __eq__(self, arg0: UrxElementGeometry) -> bool: ...
    def __ne__(self, arg0: UrxElementGeometry) -> bool: ...

class Event:
    receive_setup: UrxReceiveSetup
    transmit_setup: UrxTransmitSetup
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxEvent) -> None: ...
    @overload
    def __init__(self, arg0: UrxTransmitSetup, arg1: UrxReceiveSetup) -> None: ...
    def __eq__(self, arg0: UrxEvent) -> bool: ...
    def __ne__(self, arg0: UrxEvent) -> bool: ...

class Excitation:
    pulse_shape: str
    sampling_frequency: UrxDoubleNan
    transmit_frequency: UrxDoubleNan
    waveform: VecFloat64
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxExcitation) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: UrxDoubleNan, arg2: UrxDoubleNan, arg3: VecFloat64) -> None: ...
    def __eq__(self, arg0: UrxExcitation) -> bool: ...
    def __ne__(self, arg0: UrxExcitation) -> bool: ...

class Group:
    data_type: UrxDataType
    description: str
    sampling_type: UrxSamplingType
    sequence: VecEvent
    sound_speed: UrxDoubleNan
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxGroup) -> None: ...
    @overload
    def __init__(self, arg0: UrxSamplingType, arg1: UrxDataType, arg2: str, arg3: UrxDoubleNan, arg4: VecEvent) -> None: ...
    def __eq__(self, arg0: UrxGroup) -> bool: ...
    def __ne__(self, arg0: UrxGroup) -> bool: ...

class GroupData:
    event_timestamps: VecVecFloat64
    group: UrxGroup
    group_timestamp: UrxDoubleNan
    raw_data: numpy.ndarray
    sequence_timestamps: VecFloat64
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxGroupData) -> None: ...
    @overload
    def __init__(self, arg0: UrxGroup, arg1: numpy.ndarray, arg2: UrxDoubleNan, arg3: VecFloat64, arg4: VecVecFloat64) -> None: ...
    def __eq__(self, arg0: UrxGroupData) -> bool: ...
    def __ne__(self, arg0: UrxGroupData) -> bool: ...

class GroupDataReader:
    def __init__(self, arg0: UrxGroupData, arg1: int) -> None: ...
    def channelsCount(self, arg0: int) -> int: ...
    def eventsCount(self) -> int: ...
    def offset(self, arg0: int, arg1: int, arg2: int, arg3: int) -> int: ...
    def sampleByteSize(self) -> int: ...
    def samplesCount(self, arg0: int) -> int: ...
    def sequencesCount(self) -> int: ...

class ImpulseResponse:
    data: VecFloat64
    sampling_frequency: UrxDoubleNan
    time_offset: UrxDoubleNan
    units: str
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxImpulseResponse) -> None: ...
    @overload
    def __init__(self, arg0: UrxDoubleNan, arg1: UrxDoubleNan, arg2: str, arg3: VecFloat64) -> None: ...
    def __eq__(self, arg0: UrxImpulseResponse) -> bool: ...
    def __ne__(self, arg0: UrxImpulseResponse) -> bool: ...

class Probe:
    description: str
    element_geometries: VecElementGeometryPtr
    elements: VecElement
    impulse_responses: VecImpulseResponsePtr
    transform: UrxTransform
    type: UrxProbeType
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxProbe) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: UrxProbeType, arg2: UrxTransform, arg3: VecElementGeometryPtr, arg4: VecImpulseResponsePtr, arg5: VecElement) -> None: ...
    def __eq__(self, arg0: UrxProbe) -> bool: ...
    def __ne__(self, arg0: UrxProbe) -> bool: ...

class ProbeType:
    __members__: ClassVar[dict] = ...  # read-only
    CURVILINEAR: ClassVar[UrxProbeType] = ...
    LINEAR: ClassVar[UrxProbeType] = ...
    MATRIX: ClassVar[UrxProbeType] = ...
    RCA: ClassVar[UrxProbeType] = ...
    SPARSE: ClassVar[UrxProbeType] = ...
    UNDEFINED: ClassVar[UrxProbeType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ReadFileException(RuntimeError): ...

class ReceiveSetup:
    active_elements: VecVecUInt32
    modulation_frequency: UrxDoubleNan
    number_samples: int
    probe: UrxProbe
    probe_transform: UrxTransform
    sampling_frequency: UrxDoubleNan
    tgc_profile: VecFloat64
    tgc_sampling_frequency: UrxDoubleNan
    time_offset: UrxDoubleNan
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxReceiveSetup) -> None: ...
    @overload
    def __init__(self, arg0: UrxProbe, arg1: UrxTransform, arg2: UrxDoubleNan, arg3: int, arg4: VecVecUInt32, arg5: VecFloat64, arg6: UrxDoubleNan, arg7: UrxDoubleNan, arg8: UrxDoubleNan) -> None: ...
    def __eq__(self, arg0: UrxReceiveSetup) -> bool: ...
    def __ne__(self, arg0: UrxReceiveSetup) -> bool: ...

class SamplingType:
    __members__: ClassVar[dict] = ...  # read-only
    IQ: ClassVar[UrxSamplingType] = ...
    RF: ClassVar[UrxSamplingType] = ...
    UNDEFINED: ClassVar[UrxSamplingType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Transform:
    rotation: UrxVector3D
    translation: UrxVector3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxTransform) -> None: ...
    @overload
    def __init__(self, arg0: UrxVector3D, arg1: UrxVector3D) -> None: ...
    def __eq__(self, arg0: UrxTransform) -> bool: ...
    def __ne__(self, arg0: UrxTransform) -> bool: ...

class TransmitSetup:
    active_elements: VecVecUInt32
    delays: VecFloat64
    excitations: VecExcitationPtr
    probe: UrxProbe
    probe_transform: UrxTransform
    time_offset: UrxDoubleNan
    wave: UrxWave
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxTransmitSetup) -> None: ...
    @overload
    def __init__(self, arg0: UrxProbe, arg1: UrxWave, arg2: VecVecUInt32, arg3: VecExcitationPtr, arg4: VecFloat64, arg5: UrxTransform, arg6: UrxDoubleNan) -> None: ...
    def __eq__(self, arg0: UrxTransmitSetup) -> bool: ...
    def __ne__(self, arg0: UrxTransmitSetup) -> bool: ...

class UrxAcquisition:
    authors: str
    country_code: str
    description: str
    excitations: VecExcitationPtr
    groups: VecGroupPtr
    groups_data: VecGroupData
    local_time: str
    probes: VecProbePtr
    system: str
    timestamp: UrxDoubleNan
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxAcquisition) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: str, arg2: str, arg3: str, arg4: str, arg5: UrxDoubleNan, arg6: VecProbePtr, arg7: VecExcitationPtr, arg8: VecGroupPtr, arg9: VecGroupData) -> None: ...
    def __eq__(self, arg0: UrxAcquisition) -> bool: ...
    def __ne__(self, arg0: UrxAcquisition) -> bool: ...

class UrxDataType:
    __members__: ClassVar[dict] = ...  # read-only
    DOUBLE: ClassVar[UrxDataType] = ...
    FLOAT: ClassVar[UrxDataType] = ...
    INT16: ClassVar[UrxDataType] = ...
    INT32: ClassVar[UrxDataType] = ...
    UNDEFINED: ClassVar[UrxDataType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class UrxDataset:
    acquisition: UrxAcquisition
    version: UrxVersion
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxDataset) -> None: ...
    @overload
    def __init__(self, arg0: UrxAcquisition, arg1: UrxVersion) -> None: ...
    def __eq__(self, arg0: UrxDataset) -> bool: ...
    def __ne__(self, arg0: UrxDataset) -> bool: ...

class UrxDoubleNan:
    value: float
    @overload
    def __init__(self, arg0: float) -> None: ...
    @overload
    def __init__(self, arg0: UrxDoubleNan) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __add__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __add__(self, arg0: float) -> UrxDoubleNan: ...
    def __array__(self) -> numpy.ndarray[numpy.float64]: ...
    @overload
    def __eq__(self, arg0: UrxDoubleNan) -> bool: ...
    @overload
    def __eq__(self, arg0: float) -> bool: ...
    def __float__(self) -> float: ...
    @overload
    def __iadd__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __iadd__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __imul__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __imul__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __isub__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __isub__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __itruediv__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __itruediv__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __mul__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __mul__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __ne__(self, arg0: UrxDoubleNan) -> bool: ...
    @overload
    def __ne__(self, arg0: float) -> bool: ...
    def __neg__(self) -> float: ...
    def __pos__(self) -> float: ...
    def __radd__(self, arg0: float) -> UrxDoubleNan: ...
    def __rmul__(self, arg0: float) -> UrxDoubleNan: ...
    def __rsub__(self, arg0: float) -> UrxDoubleNan: ...
    def __rtruediv__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __sub__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __sub__(self, arg0: float) -> UrxDoubleNan: ...
    @overload
    def __truediv__(self, arg0: UrxDoubleNan) -> UrxDoubleNan: ...
    @overload
    def __truediv__(self, arg0: float) -> UrxDoubleNan: ...

class UrxElement:
    element_geometry: UrxElementGeometry
    impulse_response: UrxImpulseResponse
    transform: UrxTransform
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxElement) -> None: ...
    @overload
    def __init__(self, arg0: UrxTransform, arg1: UrxElementGeometry, arg2: UrxImpulseResponse) -> None: ...
    def __eq__(self, arg0: UrxElement) -> bool: ...
    def __ne__(self, arg0: UrxElement) -> bool: ...

class UrxElementGeometry:
    perimeter: VecVector3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxElementGeometry) -> None: ...
    @overload
    def __init__(self, arg0: VecVector3D) -> None: ...
    def __eq__(self, arg0: UrxElementGeometry) -> bool: ...
    def __ne__(self, arg0: UrxElementGeometry) -> bool: ...

class UrxEvent:
    receive_setup: UrxReceiveSetup
    transmit_setup: UrxTransmitSetup
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxEvent) -> None: ...
    @overload
    def __init__(self, arg0: UrxTransmitSetup, arg1: UrxReceiveSetup) -> None: ...
    def __eq__(self, arg0: UrxEvent) -> bool: ...
    def __ne__(self, arg0: UrxEvent) -> bool: ...

class UrxExcitation:
    pulse_shape: str
    sampling_frequency: UrxDoubleNan
    transmit_frequency: UrxDoubleNan
    waveform: VecFloat64
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxExcitation) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: UrxDoubleNan, arg2: UrxDoubleNan, arg3: VecFloat64) -> None: ...
    def __eq__(self, arg0: UrxExcitation) -> bool: ...
    def __ne__(self, arg0: UrxExcitation) -> bool: ...

class UrxGroup:
    data_type: UrxDataType
    description: str
    sampling_type: UrxSamplingType
    sequence: VecEvent
    sound_speed: UrxDoubleNan
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxGroup) -> None: ...
    @overload
    def __init__(self, arg0: UrxSamplingType, arg1: UrxDataType, arg2: str, arg3: UrxDoubleNan, arg4: VecEvent) -> None: ...
    def __eq__(self, arg0: UrxGroup) -> bool: ...
    def __ne__(self, arg0: UrxGroup) -> bool: ...

class UrxGroupData:
    event_timestamps: VecVecFloat64
    group: UrxGroup
    group_timestamp: UrxDoubleNan
    raw_data: numpy.ndarray
    sequence_timestamps: VecFloat64
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxGroupData) -> None: ...
    @overload
    def __init__(self, arg0: UrxGroup, arg1: numpy.ndarray, arg2: UrxDoubleNan, arg3: VecFloat64, arg4: VecVecFloat64) -> None: ...
    def __eq__(self, arg0: UrxGroupData) -> bool: ...
    def __ne__(self, arg0: UrxGroupData) -> bool: ...

class UrxImpulseResponse:
    data: VecFloat64
    sampling_frequency: UrxDoubleNan
    time_offset: UrxDoubleNan
    units: str
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxImpulseResponse) -> None: ...
    @overload
    def __init__(self, arg0: UrxDoubleNan, arg1: UrxDoubleNan, arg2: str, arg3: VecFloat64) -> None: ...
    def __eq__(self, arg0: UrxImpulseResponse) -> bool: ...
    def __ne__(self, arg0: UrxImpulseResponse) -> bool: ...

class UrxProbe:
    description: str
    element_geometries: VecElementGeometryPtr
    elements: VecElement
    impulse_responses: VecImpulseResponsePtr
    transform: UrxTransform
    type: UrxProbeType
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxProbe) -> None: ...
    @overload
    def __init__(self, arg0: str, arg1: UrxProbeType, arg2: UrxTransform, arg3: VecElementGeometryPtr, arg4: VecImpulseResponsePtr, arg5: VecElement) -> None: ...
    def __eq__(self, arg0: UrxProbe) -> bool: ...
    def __ne__(self, arg0: UrxProbe) -> bool: ...

class UrxProbeType:
    __members__: ClassVar[dict] = ...  # read-only
    CURVILINEAR: ClassVar[UrxProbeType] = ...
    LINEAR: ClassVar[UrxProbeType] = ...
    MATRIX: ClassVar[UrxProbeType] = ...
    RCA: ClassVar[UrxProbeType] = ...
    SPARSE: ClassVar[UrxProbeType] = ...
    UNDEFINED: ClassVar[UrxProbeType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class UrxReceiveSetup:
    active_elements: VecVecUInt32
    modulation_frequency: UrxDoubleNan
    number_samples: int
    probe: UrxProbe
    probe_transform: UrxTransform
    sampling_frequency: UrxDoubleNan
    tgc_profile: VecFloat64
    tgc_sampling_frequency: UrxDoubleNan
    time_offset: UrxDoubleNan
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxReceiveSetup) -> None: ...
    @overload
    def __init__(self, arg0: UrxProbe, arg1: UrxTransform, arg2: UrxDoubleNan, arg3: int, arg4: VecVecUInt32, arg5: VecFloat64, arg6: UrxDoubleNan, arg7: UrxDoubleNan, arg8: UrxDoubleNan) -> None: ...
    def __eq__(self, arg0: UrxReceiveSetup) -> bool: ...
    def __ne__(self, arg0: UrxReceiveSetup) -> bool: ...

class UrxSamplingType:
    __members__: ClassVar[dict] = ...  # read-only
    IQ: ClassVar[UrxSamplingType] = ...
    RF: ClassVar[UrxSamplingType] = ...
    UNDEFINED: ClassVar[UrxSamplingType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class UrxTransform:
    rotation: UrxVector3D
    translation: UrxVector3D
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxTransform) -> None: ...
    @overload
    def __init__(self, arg0: UrxVector3D, arg1: UrxVector3D) -> None: ...
    def __eq__(self, arg0: UrxTransform) -> bool: ...
    def __ne__(self, arg0: UrxTransform) -> bool: ...

class UrxTransmitSetup:
    active_elements: VecVecUInt32
    delays: VecFloat64
    excitations: VecExcitationPtr
    probe: UrxProbe
    probe_transform: UrxTransform
    time_offset: UrxDoubleNan
    wave: UrxWave
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxTransmitSetup) -> None: ...
    @overload
    def __init__(self, arg0: UrxProbe, arg1: UrxWave, arg2: VecVecUInt32, arg3: VecExcitationPtr, arg4: VecFloat64, arg5: UrxTransform, arg6: UrxDoubleNan) -> None: ...
    def __eq__(self, arg0: UrxTransmitSetup) -> bool: ...
    def __ne__(self, arg0: UrxTransmitSetup) -> bool: ...

class UrxVector2D:
    x: float
    y: float
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: UrxVector2D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[numpy.float64]) -> None: ...
    @overload
    def __init__(self, arg0: VecFloat64) -> None: ...
    def __array__(self) -> numpy.ndarray[numpy.float64]: ...
    def __eq__(self, arg0: UrxVector2D) -> bool: ...
    def __ne__(self, arg0: UrxVector2D) -> bool: ...

class UrxVector3D:
    x: float
    y: float
    z: float
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: UrxVector3D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[numpy.float64]) -> None: ...
    @overload
    def __init__(self, arg0: VecFloat64) -> None: ...
    def __array__(self) -> numpy.ndarray[numpy.float64]: ...
    def __eq__(self, arg0: UrxVector3D) -> bool: ...
    def __ne__(self, arg0: UrxVector3D) -> bool: ...

class UrxVersion:
    major: int
    minor: int
    patch: int
    @overload
    def __init__(self, arg0: int, arg1: int, arg2: int) -> None: ...
    @overload
    def __init__(self, arg0: UrxVersion) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __eq__(self, arg0: UrxVersion) -> bool: ...
    def __ne__(self, arg0: UrxVersion) -> bool: ...

class UrxWave:
    parameters: VecFloat64
    time_zero: UrxDoubleNan
    time_zero_reference_point: UrxVector3D
    type: UrxWaveType
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxWave) -> None: ...
    @overload
    def __init__(self, arg0: UrxWaveType, arg1: UrxDoubleNan, arg2: UrxVector3D, arg3: VecFloat64) -> None: ...
    def __eq__(self, arg0: UrxWave) -> bool: ...
    def __ne__(self, arg0: UrxWave) -> bool: ...

class UrxWaveType:
    __members__: ClassVar[dict] = ...  # read-only
    CONVERGING_WAVE: ClassVar[UrxWaveType] = ...
    CYLINDRICAL_WAVE: ClassVar[UrxWaveType] = ...
    DIVERGING_WAVE: ClassVar[UrxWaveType] = ...
    PLANE_WAVE: ClassVar[UrxWaveType] = ...
    UNDEFINED: ClassVar[UrxWaveType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class VecElement:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecElement) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxElement) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxElement) -> int: ...
    @overload
    def extend(self, L: VecElement) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxElement) -> None: ...
    @overload
    def pop(self) -> UrxElement: ...
    @overload
    def pop(self, i: int) -> UrxElement: ...
    def remove(self, x: UrxElement) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxElement) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecElement) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecElement: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxElement: ...
    def __iter__(self) -> Iterator[UrxElement]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecElement) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxElement) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecElement) -> None: ...

class VecElementGeometryPtr:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecElementGeometryPtr) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxElementGeometry) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxElementGeometry) -> int: ...
    @overload
    def extend(self, L: VecElementGeometryPtr) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxElementGeometry) -> None: ...
    @overload
    def pop(self) -> UrxElementGeometry: ...
    @overload
    def pop(self, i: int) -> UrxElementGeometry: ...
    def remove(self, x: UrxElementGeometry) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxElementGeometry) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecElementGeometryPtr) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecElementGeometryPtr: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxElementGeometry: ...
    def __iter__(self) -> Iterator[UrxElementGeometry]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecElementGeometryPtr) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxElementGeometry) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecElementGeometryPtr) -> None: ...

class VecEvent:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecEvent) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxEvent) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxEvent) -> int: ...
    @overload
    def extend(self, L: VecEvent) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxEvent) -> None: ...
    @overload
    def pop(self) -> UrxEvent: ...
    @overload
    def pop(self, i: int) -> UrxEvent: ...
    def remove(self, x: UrxEvent) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxEvent) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecEvent) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecEvent: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxEvent: ...
    def __iter__(self) -> Iterator[UrxEvent]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecEvent) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxEvent) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecEvent) -> None: ...

class VecExcitationPtr:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecExcitationPtr) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxExcitation) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxExcitation) -> int: ...
    @overload
    def extend(self, L: VecExcitationPtr) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxExcitation) -> None: ...
    @overload
    def pop(self) -> UrxExcitation: ...
    @overload
    def pop(self, i: int) -> UrxExcitation: ...
    def remove(self, x: UrxExcitation) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxExcitation) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecExcitationPtr) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecExcitationPtr: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxExcitation: ...
    def __iter__(self) -> Iterator[UrxExcitation]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecExcitationPtr) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxExcitation) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecExcitationPtr) -> None: ...

class VecFloat32:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecFloat32) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: float) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: float) -> int: ...
    @overload
    def extend(self, L: VecFloat32) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: float) -> None: ...
    @overload
    def pop(self) -> float: ...
    @overload
    def pop(self, i: int) -> float: ...
    def remove(self, x: float) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: float) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecFloat32) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecFloat32: ...
    @overload
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> Iterator[float]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecFloat32) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: float) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecFloat32) -> None: ...

class VecFloat64:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecFloat64) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: float) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: float) -> int: ...
    @overload
    def extend(self, L: VecFloat64) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: float) -> None: ...
    @overload
    def pop(self) -> float: ...
    @overload
    def pop(self, i: int) -> float: ...
    def remove(self, x: float) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: float) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecFloat64) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecFloat64: ...
    @overload
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> Iterator[float]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecFloat64) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: float) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecFloat64) -> None: ...

class VecGroupData:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecGroupData) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxGroupData) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxGroupData) -> int: ...
    @overload
    def extend(self, L: VecGroupData) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxGroupData) -> None: ...
    @overload
    def pop(self) -> UrxGroupData: ...
    @overload
    def pop(self, i: int) -> UrxGroupData: ...
    def remove(self, x: UrxGroupData) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxGroupData) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecGroupData) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecGroupData: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxGroupData: ...
    def __iter__(self) -> Iterator[UrxGroupData]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecGroupData) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxGroupData) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecGroupData) -> None: ...

class VecGroupPtr:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecGroupPtr) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxGroup) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxGroup) -> int: ...
    @overload
    def extend(self, L: VecGroupPtr) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxGroup) -> None: ...
    @overload
    def pop(self) -> UrxGroup: ...
    @overload
    def pop(self, i: int) -> UrxGroup: ...
    def remove(self, x: UrxGroup) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxGroup) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecGroupPtr) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecGroupPtr: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxGroup: ...
    def __iter__(self) -> Iterator[UrxGroup]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecGroupPtr) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxGroup) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecGroupPtr) -> None: ...

class VecImpulseResponsePtr:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecImpulseResponsePtr) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxImpulseResponse) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxImpulseResponse) -> int: ...
    @overload
    def extend(self, L: VecImpulseResponsePtr) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxImpulseResponse) -> None: ...
    @overload
    def pop(self) -> UrxImpulseResponse: ...
    @overload
    def pop(self, i: int) -> UrxImpulseResponse: ...
    def remove(self, x: UrxImpulseResponse) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxImpulseResponse) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecImpulseResponsePtr) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecImpulseResponsePtr: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxImpulseResponse: ...
    def __iter__(self) -> Iterator[UrxImpulseResponse]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecImpulseResponsePtr) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxImpulseResponse) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecImpulseResponsePtr) -> None: ...

class VecInt16:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecInt16) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: VecInt16) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecInt16) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecInt16: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecInt16) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecInt16) -> None: ...

class VecInt32:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecInt32) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: VecInt32) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecInt32) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecInt32: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecInt32) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecInt32) -> None: ...

class VecInt64:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecInt64) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: VecInt64) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecInt64) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecInt64: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecInt64) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecInt64) -> None: ...

class VecInt8:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecInt8) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: VecInt8) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecInt8) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecInt8: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecInt8) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecInt8) -> None: ...

class VecProbePtr:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecProbePtr) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxProbe) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxProbe) -> int: ...
    @overload
    def extend(self, L: VecProbePtr) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxProbe) -> None: ...
    @overload
    def pop(self) -> UrxProbe: ...
    @overload
    def pop(self, i: int) -> UrxProbe: ...
    def remove(self, x: UrxProbe) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxProbe) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecProbePtr) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecProbePtr: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxProbe: ...
    def __iter__(self) -> Iterator[UrxProbe]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecProbePtr) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxProbe) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecProbePtr) -> None: ...

class VecString:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecString) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: str) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: str) -> int: ...
    @overload
    def extend(self, L: VecString) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: str) -> None: ...
    @overload
    def pop(self) -> str: ...
    @overload
    def pop(self, i: int) -> str: ...
    def remove(self, x: str) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: str) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecString) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecString: ...
    @overload
    def __getitem__(self, arg0: int) -> str: ...
    def __iter__(self) -> Iterator[str]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecString) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: str) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecString) -> None: ...

class VecUInt16:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecUInt16) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: VecUInt16) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecUInt16) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecUInt16: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecUInt16) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecUInt16) -> None: ...

class VecUInt32:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecUInt32) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: VecUInt32) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecUInt32) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecUInt32: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecUInt32) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecUInt32) -> None: ...

class VecUInt64:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecUInt64) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: VecUInt64) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecUInt64) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecUInt64: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecUInt64) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecUInt64) -> None: ...

class VecUInt8:
    @overload
    def __init__(self, arg0: Buffer) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecUInt8) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: int) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: int) -> int: ...
    @overload
    def extend(self, L: VecUInt8) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: int) -> None: ...
    @overload
    def pop(self) -> int: ...
    @overload
    def pop(self, i: int) -> int: ...
    def remove(self, x: int) -> None: ...
    def __bool__(self) -> bool: ...
    def __buffer__(self, *args, **kwargs): ...
    def __contains__(self, x: int) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecUInt8) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecUInt8: ...
    @overload
    def __getitem__(self, arg0: int) -> int: ...
    def __iter__(self) -> Iterator[int]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecUInt8) -> bool: ...
    def __release_buffer__(self, *args, **kwargs): ...
    @overload
    def __setitem__(self, arg0: int, arg1: int) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecUInt8) -> None: ...

class VecVecFloat32:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecFloat32) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecFloat32) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecFloat32) -> int: ...
    @overload
    def extend(self, L: VecVecFloat32) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecFloat32) -> None: ...
    @overload
    def pop(self) -> VecFloat32: ...
    @overload
    def pop(self, i: int) -> VecFloat32: ...
    def remove(self, x: VecFloat32) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecFloat32) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecFloat32) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecFloat32: ...
    @overload
    def __getitem__(self, arg0: int) -> VecFloat32: ...
    def __iter__(self) -> Iterator[VecFloat32]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecFloat32) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecFloat32) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecFloat32) -> None: ...

class VecVecFloat64:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecFloat64) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecFloat64) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecFloat64) -> int: ...
    @overload
    def extend(self, L: VecVecFloat64) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecFloat64) -> None: ...
    @overload
    def pop(self) -> VecFloat64: ...
    @overload
    def pop(self, i: int) -> VecFloat64: ...
    def remove(self, x: VecFloat64) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecFloat64) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecFloat64) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecFloat64: ...
    @overload
    def __getitem__(self, arg0: int) -> VecFloat64: ...
    def __iter__(self) -> Iterator[VecFloat64]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecFloat64) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecFloat64) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecFloat64) -> None: ...

class VecVecInt16:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecInt16) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecInt16) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecInt16) -> int: ...
    @overload
    def extend(self, L: VecVecInt16) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecInt16) -> None: ...
    @overload
    def pop(self) -> VecInt16: ...
    @overload
    def pop(self, i: int) -> VecInt16: ...
    def remove(self, x: VecInt16) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecInt16) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecInt16) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecInt16: ...
    @overload
    def __getitem__(self, arg0: int) -> VecInt16: ...
    def __iter__(self) -> Iterator[VecInt16]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecInt16) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecInt16) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecInt16) -> None: ...

class VecVecInt32:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecInt32) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecInt32) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecInt32) -> int: ...
    @overload
    def extend(self, L: VecVecInt32) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecInt32) -> None: ...
    @overload
    def pop(self) -> VecInt32: ...
    @overload
    def pop(self, i: int) -> VecInt32: ...
    def remove(self, x: VecInt32) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecInt32) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecInt32) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecInt32: ...
    @overload
    def __getitem__(self, arg0: int) -> VecInt32: ...
    def __iter__(self) -> Iterator[VecInt32]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecInt32) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecInt32) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecInt32) -> None: ...

class VecVecInt64:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecInt64) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecInt64) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecInt64) -> int: ...
    @overload
    def extend(self, L: VecVecInt64) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecInt64) -> None: ...
    @overload
    def pop(self) -> VecInt64: ...
    @overload
    def pop(self, i: int) -> VecInt64: ...
    def remove(self, x: VecInt64) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecInt64) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecInt64) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecInt64: ...
    @overload
    def __getitem__(self, arg0: int) -> VecInt64: ...
    def __iter__(self) -> Iterator[VecInt64]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecInt64) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecInt64) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecInt64) -> None: ...

class VecVecInt8:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecInt8) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecInt8) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecInt8) -> int: ...
    @overload
    def extend(self, L: VecVecInt8) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecInt8) -> None: ...
    @overload
    def pop(self) -> VecInt8: ...
    @overload
    def pop(self, i: int) -> VecInt8: ...
    def remove(self, x: VecInt8) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecInt8) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecInt8) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecInt8: ...
    @overload
    def __getitem__(self, arg0: int) -> VecInt8: ...
    def __iter__(self) -> Iterator[VecInt8]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecInt8) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecInt8) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecInt8) -> None: ...

class VecVecString:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecString) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecString) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecString) -> int: ...
    @overload
    def extend(self, L: VecVecString) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecString) -> None: ...
    @overload
    def pop(self) -> VecString: ...
    @overload
    def pop(self, i: int) -> VecString: ...
    def remove(self, x: VecString) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecString) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecString) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecString: ...
    @overload
    def __getitem__(self, arg0: int) -> VecString: ...
    def __iter__(self) -> Iterator[VecString]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecString) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecString) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecString) -> None: ...

class VecVecUInt16:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecUInt16) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecUInt16) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecUInt16) -> int: ...
    @overload
    def extend(self, L: VecVecUInt16) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecUInt16) -> None: ...
    @overload
    def pop(self) -> VecUInt16: ...
    @overload
    def pop(self, i: int) -> VecUInt16: ...
    def remove(self, x: VecUInt16) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecUInt16) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecUInt16) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecUInt16: ...
    @overload
    def __getitem__(self, arg0: int) -> VecUInt16: ...
    def __iter__(self) -> Iterator[VecUInt16]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecUInt16) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecUInt16) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecUInt16) -> None: ...

class VecVecUInt32:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecUInt32) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecUInt32) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecUInt32) -> int: ...
    @overload
    def extend(self, L: VecVecUInt32) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecUInt32) -> None: ...
    @overload
    def pop(self) -> VecUInt32: ...
    @overload
    def pop(self, i: int) -> VecUInt32: ...
    def remove(self, x: VecUInt32) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecUInt32) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecUInt32) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecUInt32: ...
    @overload
    def __getitem__(self, arg0: int) -> VecUInt32: ...
    def __iter__(self) -> Iterator[VecUInt32]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecUInt32) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecUInt32) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecUInt32) -> None: ...

class VecVecUInt64:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecUInt64) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecUInt64) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecUInt64) -> int: ...
    @overload
    def extend(self, L: VecVecUInt64) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecUInt64) -> None: ...
    @overload
    def pop(self) -> VecUInt64: ...
    @overload
    def pop(self, i: int) -> VecUInt64: ...
    def remove(self, x: VecUInt64) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecUInt64) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecUInt64) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecUInt64: ...
    @overload
    def __getitem__(self, arg0: int) -> VecUInt64: ...
    def __iter__(self) -> Iterator[VecUInt64]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecUInt64) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecUInt64) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecUInt64) -> None: ...

class VecVecUInt8:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVecUInt8) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: VecUInt8) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: VecUInt8) -> int: ...
    @overload
    def extend(self, L: VecVecUInt8) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: VecUInt8) -> None: ...
    @overload
    def pop(self) -> VecUInt8: ...
    @overload
    def pop(self, i: int) -> VecUInt8: ...
    def remove(self, x: VecUInt8) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: VecUInt8) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVecUInt8) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVecUInt8: ...
    @overload
    def __getitem__(self, arg0: int) -> VecUInt8: ...
    def __iter__(self) -> Iterator[VecUInt8]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVecUInt8) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: VecUInt8) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVecUInt8) -> None: ...

class VecVector2D:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVector2D) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxVector2D) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxVector2D) -> int: ...
    @overload
    def extend(self, L: VecVector2D) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxVector2D) -> None: ...
    @overload
    def pop(self) -> UrxVector2D: ...
    @overload
    def pop(self, i: int) -> UrxVector2D: ...
    def remove(self, x: UrxVector2D) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxVector2D) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVector2D) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVector2D: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxVector2D: ...
    def __iter__(self) -> Iterator[UrxVector2D]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVector2D) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxVector2D) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVector2D) -> None: ...

class VecVector3D:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: VecVector3D) -> None: ...
    @overload
    def __init__(self, arg0: Iterable) -> None: ...
    def append(self, x: UrxVector3D) -> None: ...
    def clear(self) -> None: ...
    def count(self, x: UrxVector3D) -> int: ...
    @overload
    def extend(self, L: VecVector3D) -> None: ...
    @overload
    def extend(self, L: Iterable) -> None: ...
    def insert(self, i: int, x: UrxVector3D) -> None: ...
    @overload
    def pop(self) -> UrxVector3D: ...
    @overload
    def pop(self, i: int) -> UrxVector3D: ...
    def remove(self, x: UrxVector3D) -> None: ...
    def __bool__(self) -> bool: ...
    def __contains__(self, x: UrxVector3D) -> bool: ...
    @overload
    def __delitem__(self, arg0: int) -> None: ...
    @overload
    def __delitem__(self, arg0: slice) -> None: ...
    def __eq__(self, arg0: VecVector3D) -> bool: ...
    @overload
    def __getitem__(self, s: slice) -> VecVector3D: ...
    @overload
    def __getitem__(self, arg0: int) -> UrxVector3D: ...
    def __iter__(self) -> Iterator[UrxVector3D]: ...
    def __len__(self) -> int: ...
    def __ne__(self, arg0: VecVector3D) -> bool: ...
    @overload
    def __setitem__(self, arg0: int, arg1: UrxVector3D) -> None: ...
    @overload
    def __setitem__(self, arg0: slice, arg1: VecVector3D) -> None: ...

class Vector2D:
    x: float
    y: float
    @overload
    def __init__(self, arg0: float, arg1: float) -> None: ...
    @overload
    def __init__(self, arg0: UrxVector2D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[numpy.float64]) -> None: ...
    @overload
    def __init__(self, arg0: VecFloat64) -> None: ...
    def __array__(self) -> numpy.ndarray[numpy.float64]: ...
    def __eq__(self, arg0: UrxVector2D) -> bool: ...
    def __ne__(self, arg0: UrxVector2D) -> bool: ...

class Vector3D:
    x: float
    y: float
    z: float
    @overload
    def __init__(self, arg0: float, arg1: float, arg2: float) -> None: ...
    @overload
    def __init__(self, arg0: UrxVector3D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[numpy.float64]) -> None: ...
    @overload
    def __init__(self, arg0: VecFloat64) -> None: ...
    def __array__(self) -> numpy.ndarray[numpy.float64]: ...
    def __eq__(self, arg0: UrxVector3D) -> bool: ...
    def __ne__(self, arg0: UrxVector3D) -> bool: ...

class Version:
    major: int
    minor: int
    patch: int
    @overload
    def __init__(self, arg0: int, arg1: int, arg2: int) -> None: ...
    @overload
    def __init__(self, arg0: UrxVersion) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def __eq__(self, arg0: UrxVersion) -> bool: ...
    def __ne__(self, arg0: UrxVersion) -> bool: ...

class Wave:
    parameters: VecFloat64
    time_zero: UrxDoubleNan
    time_zero_reference_point: UrxVector3D
    type: UrxWaveType
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: UrxWave) -> None: ...
    @overload
    def __init__(self, arg0: UrxWaveType, arg1: UrxDoubleNan, arg2: UrxVector3D, arg3: VecFloat64) -> None: ...
    def __eq__(self, arg0: UrxWave) -> bool: ...
    def __ne__(self, arg0: UrxWave) -> bool: ...

class WaveType:
    __members__: ClassVar[dict] = ...  # read-only
    CONVERGING_WAVE: ClassVar[UrxWaveType] = ...
    CYLINDRICAL_WAVE: ClassVar[UrxWaveType] = ...
    DIVERGING_WAVE: ClassVar[UrxWaveType] = ...
    PLANE_WAVE: ClassVar[UrxWaveType] = ...
    UNDEFINED: ClassVar[UrxWaveType] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class WriteFileException(RuntimeError): ...

def isIso3166(arg0: str) -> bool: ...
def isIso8601(arg0: str) -> bool: ...
def loadFromFile(arg0: str) -> UrxDataset: ...
def pyGetFormat(arg0: UrxDataType) -> str: ...
def saveToFile(arg0: str, arg1: UrxDataset) -> None: ...
def sizeofDataType(arg0: UrxDataType) -> int: ...
def sizeofSample(arg0: UrxSamplingType, arg1: UrxDataType) -> int: ...
