# https://wiki.selfhtml.org/wiki/MIME-Type/%C3%9Cbersicht
SUFFIX_MEDIA_TYPE_MAPPING = {
    # A
    ".dwg": "application/acad",
    ".asd": "application/astound",
    ".asn": "application/astound",
    ".tsp": "application/dsptype",
    ".dxf": "application/dxf",
    ".reg": "application/force-download",
    ".spl": "application/futuresplash",
    ".gz": "application/gzip",
    ".json": "application/json",
    ".ptlk": "application/listenup",
    ".hqx": "application/mac-binhex40",
    ".mbd": "application/mbedlet",
    ".xls": "application/msexcel",
    ".xla": "application/msexcel",
    ".hlp": "application/mshelp",
    ".chm": "application/mshelp",
    ".ppt": "application/mspowerpoint",
    ".ppz": "application/mspowerpoint",
    ".pps": "application/mspowerpoint",
    ".pot": "application/mspowerpoint",
    ".doc": "application/msword",
    ".dot": "application/msword",
    ".bin": "application/octet-stream",
    ".file": "application/octet-stream",
    ".com": "application/octet-stream",
    ".class": "application/octet-stream",
    ".ini": "application/octet-stream",
    ".oda": "application/oda",
    ".pdf": "application/pdf",
    ".ai": "application/postscript",
    ".eps": "application/postscript",
    ".ps": "application/postscript",
    ".rtc": "application/rtc",
    ".rtf": "application/rtf",
    ".smp": "application/studiom",
    # image
    ".png": "image/png",
    ".gif": "image/gif",
    ".ief": "image/ief",
    ".jpeg": "image/jpeg",
    ".jpg": "image/jpeg",
    ".jpe": "image/jpeg",
    ".svg": "image/svg+xml",
    ".tif": "image/tif",
    ".tiff": "image/tif",
    ".vasa": "image/mcf",
    ".bmp": "image/bmp",
    ".cod": "image/cis-cod",
    ".ras": "image/cmu-raster",
    ".fif": "image/fif",
    ".wbmp": "image/vnd.wap.wbmp",
    ".fh4": "image/x-freehand",
    ".fh5": "image/x-freehand",
    ".fhc": "image/x-freehand",
    ".ico": "image/x-icon",
    ".pnm": "image/x-portable-anymap",
    ".pbm": "image/x-portable-bitmap",
    ".pgm": "image/x-portable-graymap",
    ".ppm": "image/x-portable-pixmap",
    ".rgb": "image/x-rgb",
    ".xwd": "image/x-windowdump",
    ".xbm": "image/x-xbitmap",
    ".xpm": "image/x-xpixmap",
    # text
    ".html": "text/html",
    ".css": "text/css",
    ".txt": "text/plain",
    ".csv": "text/comma-separated-values",
    ".js": "text/javascript",
    ".rtx": "text/richtext",
    ".xml": "text/xml",
    ".tsv": "text/tab-separated-values",
    ".ics": "text/calendar",
}
