# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SxpDomainFilterArgs', 'SxpDomainFilter']

@pulumi.input_type
class SxpDomainFilterArgs:
    def __init__(__self__, *,
                 domains: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sgt: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SxpDomainFilter resource.
        :param pulumi.Input[_builtins.str] domains: List of SXP Domains, separated with comma
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] name: Resource name
        :param pulumi.Input[_builtins.str] sgt: SGT name or ID. At least one of subnet or sgt or vn should be defined
        :param pulumi.Input[_builtins.str] subnet: Subnet for filter policy (hostname is not supported). At least one of subnet or sgt or vn should be defined
        :param pulumi.Input[_builtins.str] vn: Virtual Network. At least one of subnet or sgt or vn should be defined
        """
        pulumi.set(__self__, "domains", domains)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sgt is not None:
            pulumi.set(__self__, "sgt", sgt)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vn is not None:
            pulumi.set(__self__, "vn", vn)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> pulumi.Input[_builtins.str]:
        """
        List of SXP Domains, separated with comma
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def sgt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SGT name or ID. At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "sgt")

    @sgt.setter
    def sgt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgt", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet for filter policy (hostname is not supported). At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter
    def vn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Virtual Network. At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "vn")

    @vn.setter
    def vn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vn", value)


@pulumi.input_type
class _SxpDomainFilterState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sgt: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SxpDomainFilter resources.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] domains: List of SXP Domains, separated with comma
        :param pulumi.Input[_builtins.str] name: Resource name
        :param pulumi.Input[_builtins.str] sgt: SGT name or ID. At least one of subnet or sgt or vn should be defined
        :param pulumi.Input[_builtins.str] subnet: Subnet for filter policy (hostname is not supported). At least one of subnet or sgt or vn should be defined
        :param pulumi.Input[_builtins.str] vn: Virtual Network. At least one of subnet or sgt or vn should be defined
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sgt is not None:
            pulumi.set(__self__, "sgt", sgt)
        if subnet is not None:
            pulumi.set(__self__, "subnet", subnet)
        if vn is not None:
            pulumi.set(__self__, "vn", vn)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of SXP Domains, separated with comma
        """
        return pulumi.get(self, "domains")

    @domains.setter
    def domains(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domains", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def sgt(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SGT name or ID. At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "sgt")

    @sgt.setter
    def sgt(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sgt", value)

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Subnet for filter policy (hostname is not supported). At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "subnet")

    @subnet.setter
    def subnet(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet", value)

    @_builtins.property
    @pulumi.getter
    def vn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Virtual Network. At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "vn")

    @vn.setter
    def vn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vn", value)


@pulumi.type_token("ise:trustsec/sxpDomainFilter:SxpDomainFilter")
class SxpDomainFilter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sgt: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource can manage a SXP Domain Filter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.SxpDomainFilter("example",
            subnet="1.0.0.0/24",
            vn="VN1",
            domains="default")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:trustsec/sxpDomainFilter:SxpDomainFilter example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] domains: List of SXP Domains, separated with comma
        :param pulumi.Input[_builtins.str] name: Resource name
        :param pulumi.Input[_builtins.str] sgt: SGT name or ID. At least one of subnet or sgt or vn should be defined
        :param pulumi.Input[_builtins.str] subnet: Subnet for filter policy (hostname is not supported). At least one of subnet or sgt or vn should be defined
        :param pulumi.Input[_builtins.str] vn: Virtual Network. At least one of subnet or sgt or vn should be defined
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SxpDomainFilterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a SXP Domain Filter.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.SxpDomainFilter("example",
            subnet="1.0.0.0/24",
            vn="VN1",
            domains="default")
        ```

        ## Import

        The `pulumi import` command can be used, for example:

        ```sh
        $ pulumi import ise:trustsec/sxpDomainFilter:SxpDomainFilter example "76d24097-41c4-4558-a4d0-a8c07ac08470"
        ```

        :param str resource_name: The name of the resource.
        :param SxpDomainFilterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SxpDomainFilterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 domains: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sgt: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet: Optional[pulumi.Input[_builtins.str]] = None,
                 vn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SxpDomainFilterArgs.__new__(SxpDomainFilterArgs)

            __props__.__dict__["description"] = description
            if domains is None and not opts.urn:
                raise TypeError("Missing required property 'domains'")
            __props__.__dict__["domains"] = domains
            __props__.__dict__["name"] = name
            __props__.__dict__["sgt"] = sgt
            __props__.__dict__["subnet"] = subnet
            __props__.__dict__["vn"] = vn
        super(SxpDomainFilter, __self__).__init__(
            'ise:trustsec/sxpDomainFilter:SxpDomainFilter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            domains: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            sgt: Optional[pulumi.Input[_builtins.str]] = None,
            subnet: Optional[pulumi.Input[_builtins.str]] = None,
            vn: Optional[pulumi.Input[_builtins.str]] = None) -> 'SxpDomainFilter':
        """
        Get an existing SxpDomainFilter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Description
        :param pulumi.Input[_builtins.str] domains: List of SXP Domains, separated with comma
        :param pulumi.Input[_builtins.str] name: Resource name
        :param pulumi.Input[_builtins.str] sgt: SGT name or ID. At least one of subnet or sgt or vn should be defined
        :param pulumi.Input[_builtins.str] subnet: Subnet for filter policy (hostname is not supported). At least one of subnet or sgt or vn should be defined
        :param pulumi.Input[_builtins.str] vn: Virtual Network. At least one of subnet or sgt or vn should be defined
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SxpDomainFilterState.__new__(_SxpDomainFilterState)

        __props__.__dict__["description"] = description
        __props__.__dict__["domains"] = domains
        __props__.__dict__["name"] = name
        __props__.__dict__["sgt"] = sgt
        __props__.__dict__["subnet"] = subnet
        __props__.__dict__["vn"] = vn
        return SxpDomainFilter(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> pulumi.Output[_builtins.str]:
        """
        List of SXP Domains, separated with comma
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Resource name
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def sgt(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SGT name or ID. At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "sgt")

    @_builtins.property
    @pulumi.getter
    def subnet(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Subnet for filter policy (hostname is not supported). At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "subnet")

    @_builtins.property
    @pulumi.getter
    def vn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Virtual Network. At least one of subnet or sgt or vn should be defined
        """
        return pulumi.get(self, "vn")

