/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.providers;

import java.text.DecimalFormat;
import java.util.Collection;
import java.util.UUID;
import mcjty.theoneprobe.Tools;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.config.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;

public class DefaultProbeInfoEntityProvider
implements IProbeInfoEntityProvider {
    private static DecimalFormat dfCommas = new DecimalFormat("##.#");

    @Override
    public String getID() {
        return "theoneprobe:entity.default";
    }

    @Override
    public void addProbeEntityInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        IProbeConfig config = Config.getRealConfig();
        DefaultProbeInfoEntityProvider.showStandardInfo(mode, probeInfo, entity, config);
        if (entity instanceof EntityLivingBase) {
            Collection effects;
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            if (Tools.show(mode, config.getShowMobHealth())) {
                int health = (int)livingBase.func_110143_aJ();
                int maxHealth = (int)livingBase.func_110138_aP();
                probeInfo.progress(health, maxHealth, probeInfo.defaultProgressStyle().lifeBar(true).showText(false).width(150).height(10));
                if (mode == ProbeMode.EXTENDED) {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Health: " + (Object)((Object)TextStyleClass.INFOIMP) + health + " / " + maxHealth);
                }
            }
            if (Tools.show(mode, config.getShowMobPotionEffects()) && !(effects = livingBase.func_70651_bq()).isEmpty()) {
                IProbeInfo vertical = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(-1));
                float durationFactor = 1.0f;
                for (PotionEffect effect : effects) {
                    String s1 = I18n.func_74838_a((String)effect.func_76453_d()).trim();
                    Potion potion = effect.func_188419_a();
                    if (effect.func_76458_c() > 0) {
                        s1 = s1 + " " + I18n.func_74838_a((String)("potion.potency." + effect.func_76458_c())).trim();
                    }
                    if (effect.func_76459_b() > 20) {
                        s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)effect, (float)durationFactor) + ")";
                    }
                    if (potion.func_76398_f()) {
                        vertical.text((Object)((Object)TextStyleClass.ERROR) + s1);
                        continue;
                    }
                    vertical.text((Object)((Object)TextStyleClass.OK) + s1);
                }
            }
        }
        if (Tools.show(mode, config.getAnimalOwnerSetting())) {
            UUID ownerId = null;
            if (entity instanceof IEntityOwnable) {
                ownerId = ((IEntityOwnable)entity).func_184753_b();
            } else if (entity instanceof EntityHorse) {
                ownerId = ((EntityHorse)entity).func_184780_dh();
            }
            if (ownerId != null) {
                String username = UsernameCache.getLastKnownUsername((UUID)ownerId);
                if (username == null) {
                    probeInfo.text((Object)((Object)TextStyleClass.WARNING) + "Unknown owner");
                } else {
                    probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Owned by: " + (Object)((Object)TextStyleClass.INFO) + username);
                }
            }
        }
        if (Tools.show(mode, config.getHorseStatSetting()) && entity instanceof EntityHorse) {
            double jumpStrength = ((EntityHorse)entity).func_110215_cj();
            double jumpHeight = -0.1817584952 * jumpStrength * jumpStrength * jumpStrength + 3.689713992 * jumpStrength * jumpStrength + 2.128599134 * jumpStrength - 0.343930367;
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Jump height: " + (Object)((Object)TextStyleClass.INFO) + dfCommas.format(jumpHeight));
            IAttributeInstance iattributeinstance = ((EntityHorse)entity).func_110148_a(SharedMonsterAttributes.field_111263_d);
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Speed: " + (Object)((Object)TextStyleClass.INFO) + dfCommas.format(iattributeinstance.func_111126_e()));
        }
        if (entity instanceof EntityWolf && Config.showCollarColor) {
            EnumDyeColor collarColor = ((EntityWolf)entity).func_175546_cu();
            probeInfo.text((Object)((Object)TextStyleClass.LABEL) + "Collar: " + (Object)((Object)TextStyleClass.INFO) + collarColor.func_176610_l());
        }
    }

    public static void showStandardInfo(ProbeMode mode, IProbeInfo probeInfo, Entity entity, IProbeConfig config) {
        String modid = Tools.getModName(entity);
        if (Tools.show(mode, config.getShowModName())) {
            probeInfo.horizontal().entity(entity).vertical().text((Object)((Object)TextStyleClass.NAME) + entity.func_145748_c_().func_150254_d()).text((Object)((Object)TextStyleClass.MODNAME) + modid);
        } else {
            probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).entity(entity).text((Object)((Object)TextStyleClass.NAME) + entity.func_145748_c_().func_150254_d());
        }
    }
}

